/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ElasticCloudElasticsearchConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#elastic_cloud_email_address ElasticCloudElasticsearch#elastic_cloud_email_address}
    */
    readonly elasticCloudEmailAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#id ElasticCloudElasticsearch#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#location ElasticCloudElasticsearch#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#monitoring_enabled ElasticCloudElasticsearch#monitoring_enabled}
    */
    readonly monitoringEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#name ElasticCloudElasticsearch#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#resource_group_name ElasticCloudElasticsearch#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#sku_name ElasticCloudElasticsearch#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#tags ElasticCloudElasticsearch#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#logs ElasticCloudElasticsearch#logs}
    */
    readonly logs?: ElasticCloudElasticsearchLogs;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#timeouts ElasticCloudElasticsearch#timeouts}
    */
    readonly timeouts?: ElasticCloudElasticsearchTimeouts;
}
export interface ElasticCloudElasticsearchLogsFilteringTag {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#action ElasticCloudElasticsearch#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#name ElasticCloudElasticsearch#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#value ElasticCloudElasticsearch#value}
    */
    readonly value: string;
}
export declare function elasticCloudElasticsearchLogsFilteringTagToTerraform(struct?: ElasticCloudElasticsearchLogsFilteringTag | cdktf.IResolvable): any;
export declare class ElasticCloudElasticsearchLogsFilteringTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElasticCloudElasticsearchLogsFilteringTag | cdktf.IResolvable | undefined;
    set internalValue(value: ElasticCloudElasticsearchLogsFilteringTag | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ElasticCloudElasticsearchLogsFilteringTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElasticCloudElasticsearchLogsFilteringTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElasticCloudElasticsearchLogsFilteringTagOutputReference;
}
export interface ElasticCloudElasticsearchLogs {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#send_activity_logs ElasticCloudElasticsearch#send_activity_logs}
    */
    readonly sendActivityLogs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#send_azuread_logs ElasticCloudElasticsearch#send_azuread_logs}
    */
    readonly sendAzureadLogs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#send_subscription_logs ElasticCloudElasticsearch#send_subscription_logs}
    */
    readonly sendSubscriptionLogs?: boolean | cdktf.IResolvable;
    /**
    * filtering_tag block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#filtering_tag ElasticCloudElasticsearch#filtering_tag}
    */
    readonly filteringTag?: ElasticCloudElasticsearchLogsFilteringTag[] | cdktf.IResolvable;
}
export declare function elasticCloudElasticsearchLogsToTerraform(struct?: ElasticCloudElasticsearchLogsOutputReference | ElasticCloudElasticsearchLogs): any;
export declare class ElasticCloudElasticsearchLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElasticCloudElasticsearchLogs | undefined;
    set internalValue(value: ElasticCloudElasticsearchLogs | undefined);
    private _sendActivityLogs?;
    get sendActivityLogs(): boolean | cdktf.IResolvable;
    set sendActivityLogs(value: boolean | cdktf.IResolvable);
    resetSendActivityLogs(): void;
    get sendActivityLogsInput(): boolean | cdktf.IResolvable | undefined;
    private _sendAzureadLogs?;
    get sendAzureadLogs(): boolean | cdktf.IResolvable;
    set sendAzureadLogs(value: boolean | cdktf.IResolvable);
    resetSendAzureadLogs(): void;
    get sendAzureadLogsInput(): boolean | cdktf.IResolvable | undefined;
    private _sendSubscriptionLogs?;
    get sendSubscriptionLogs(): boolean | cdktf.IResolvable;
    set sendSubscriptionLogs(value: boolean | cdktf.IResolvable);
    resetSendSubscriptionLogs(): void;
    get sendSubscriptionLogsInput(): boolean | cdktf.IResolvable | undefined;
    private _filteringTag;
    get filteringTag(): ElasticCloudElasticsearchLogsFilteringTagList;
    putFilteringTag(value: ElasticCloudElasticsearchLogsFilteringTag[] | cdktf.IResolvable): void;
    resetFilteringTag(): void;
    get filteringTagInput(): cdktf.IResolvable | ElasticCloudElasticsearchLogsFilteringTag[] | undefined;
}
export interface ElasticCloudElasticsearchTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#create ElasticCloudElasticsearch#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#delete ElasticCloudElasticsearch#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#read ElasticCloudElasticsearch#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#update ElasticCloudElasticsearch#update}
    */
    readonly update?: string;
}
export declare function elasticCloudElasticsearchTimeoutsToTerraform(struct?: ElasticCloudElasticsearchTimeouts | cdktf.IResolvable): any;
export declare class ElasticCloudElasticsearchTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElasticCloudElasticsearchTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ElasticCloudElasticsearchTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch azurerm_elastic_cloud_elasticsearch}
*/
export declare class ElasticCloudElasticsearch extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_elastic_cloud_elasticsearch";
    /**
    * Generates CDKTF code for importing a ElasticCloudElasticsearch resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ElasticCloudElasticsearch to import
    * @param importFromId The id of the existing ElasticCloudElasticsearch that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ElasticCloudElasticsearch to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/elastic_cloud_elasticsearch azurerm_elastic_cloud_elasticsearch} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElasticCloudElasticsearchConfig
    */
    constructor(scope: Construct, id: string, config: ElasticCloudElasticsearchConfig);
    get elasticCloudDeploymentId(): string;
    private _elasticCloudEmailAddress?;
    get elasticCloudEmailAddress(): string;
    set elasticCloudEmailAddress(value: string);
    get elasticCloudEmailAddressInput(): string | undefined;
    get elasticCloudSsoDefaultUrl(): string;
    get elasticCloudUserId(): string;
    get elasticsearchServiceUrl(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kibanaServiceUrl(): string;
    get kibanaSsoUri(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _monitoringEnabled?;
    get monitoringEnabled(): boolean | cdktf.IResolvable;
    set monitoringEnabled(value: boolean | cdktf.IResolvable);
    resetMonitoringEnabled(): void;
    get monitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _logs;
    get logs(): ElasticCloudElasticsearchLogsOutputReference;
    putLogs(value: ElasticCloudElasticsearchLogs): void;
    resetLogs(): void;
    get logsInput(): ElasticCloudElasticsearchLogs | undefined;
    private _timeouts;
    get timeouts(): ElasticCloudElasticsearchTimeoutsOutputReference;
    putTimeouts(value: ElasticCloudElasticsearchTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ElasticCloudElasticsearchTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
