/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KeyVaultCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#id KeyVaultCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#key_vault_id KeyVaultCertificate#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#name KeyVaultCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#tags KeyVaultCertificate#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#certificate KeyVaultCertificate#certificate}
    */
    readonly certificate?: KeyVaultCertificateCertificate;
    /**
    * certificate_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#certificate_policy KeyVaultCertificate#certificate_policy}
    */
    readonly certificatePolicy?: KeyVaultCertificateCertificatePolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#timeouts KeyVaultCertificate#timeouts}
    */
    readonly timeouts?: KeyVaultCertificateTimeouts;
}
export interface KeyVaultCertificateCertificateAttribute {
}
export declare function keyVaultCertificateCertificateAttributeToTerraform(struct?: KeyVaultCertificateCertificateAttribute): any;
export declare class KeyVaultCertificateCertificateAttributeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KeyVaultCertificateCertificateAttribute | undefined;
    set internalValue(value: KeyVaultCertificateCertificateAttribute | undefined);
    get created(): string;
    get enabled(): cdktf.IResolvable;
    get expires(): string;
    get notBefore(): string;
    get recoveryLevel(): string;
    get updated(): string;
}
export declare class KeyVaultCertificateCertificateAttributeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KeyVaultCertificateCertificateAttributeOutputReference;
}
export interface KeyVaultCertificateCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#contents KeyVaultCertificate#contents}
    */
    readonly contents: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#password KeyVaultCertificate#password}
    */
    readonly password?: string;
}
export declare function keyVaultCertificateCertificateToTerraform(struct?: KeyVaultCertificateCertificateOutputReference | KeyVaultCertificateCertificate): any;
export declare class KeyVaultCertificateCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultCertificateCertificate | undefined;
    set internalValue(value: KeyVaultCertificateCertificate | undefined);
    private _contents?;
    get contents(): string;
    set contents(value: string);
    get contentsInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
}
export interface KeyVaultCertificateCertificatePolicyIssuerParameters {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#name KeyVaultCertificate#name}
    */
    readonly name: string;
}
export declare function keyVaultCertificateCertificatePolicyIssuerParametersToTerraform(struct?: KeyVaultCertificateCertificatePolicyIssuerParametersOutputReference | KeyVaultCertificateCertificatePolicyIssuerParameters): any;
export declare class KeyVaultCertificateCertificatePolicyIssuerParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultCertificateCertificatePolicyIssuerParameters | undefined;
    set internalValue(value: KeyVaultCertificateCertificatePolicyIssuerParameters | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface KeyVaultCertificateCertificatePolicyKeyProperties {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#curve KeyVaultCertificate#curve}
    */
    readonly curve?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#exportable KeyVaultCertificate#exportable}
    */
    readonly exportable: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#key_size KeyVaultCertificate#key_size}
    */
    readonly keySize?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#key_type KeyVaultCertificate#key_type}
    */
    readonly keyType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#reuse_key KeyVaultCertificate#reuse_key}
    */
    readonly reuseKey: boolean | cdktf.IResolvable;
}
export declare function keyVaultCertificateCertificatePolicyKeyPropertiesToTerraform(struct?: KeyVaultCertificateCertificatePolicyKeyPropertiesOutputReference | KeyVaultCertificateCertificatePolicyKeyProperties): any;
export declare class KeyVaultCertificateCertificatePolicyKeyPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultCertificateCertificatePolicyKeyProperties | undefined;
    set internalValue(value: KeyVaultCertificateCertificatePolicyKeyProperties | undefined);
    private _curve?;
    get curve(): string;
    set curve(value: string);
    resetCurve(): void;
    get curveInput(): string | undefined;
    private _exportable?;
    get exportable(): boolean | cdktf.IResolvable;
    set exportable(value: boolean | cdktf.IResolvable);
    get exportableInput(): boolean | cdktf.IResolvable | undefined;
    private _keySize?;
    get keySize(): number;
    set keySize(value: number);
    resetKeySize(): void;
    get keySizeInput(): number | undefined;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    get keyTypeInput(): string | undefined;
    private _reuseKey?;
    get reuseKey(): boolean | cdktf.IResolvable;
    set reuseKey(value: boolean | cdktf.IResolvable);
    get reuseKeyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface KeyVaultCertificateCertificatePolicyLifetimeActionAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#action_type KeyVaultCertificate#action_type}
    */
    readonly actionType: string;
}
export declare function keyVaultCertificateCertificatePolicyLifetimeActionActionToTerraform(struct?: KeyVaultCertificateCertificatePolicyLifetimeActionActionOutputReference | KeyVaultCertificateCertificatePolicyLifetimeActionAction): any;
export declare class KeyVaultCertificateCertificatePolicyLifetimeActionActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultCertificateCertificatePolicyLifetimeActionAction | undefined;
    set internalValue(value: KeyVaultCertificateCertificatePolicyLifetimeActionAction | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    get actionTypeInput(): string | undefined;
}
export interface KeyVaultCertificateCertificatePolicyLifetimeActionTrigger {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#days_before_expiry KeyVaultCertificate#days_before_expiry}
    */
    readonly daysBeforeExpiry?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#lifetime_percentage KeyVaultCertificate#lifetime_percentage}
    */
    readonly lifetimePercentage?: number;
}
export declare function keyVaultCertificateCertificatePolicyLifetimeActionTriggerToTerraform(struct?: KeyVaultCertificateCertificatePolicyLifetimeActionTriggerOutputReference | KeyVaultCertificateCertificatePolicyLifetimeActionTrigger): any;
export declare class KeyVaultCertificateCertificatePolicyLifetimeActionTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultCertificateCertificatePolicyLifetimeActionTrigger | undefined;
    set internalValue(value: KeyVaultCertificateCertificatePolicyLifetimeActionTrigger | undefined);
    private _daysBeforeExpiry?;
    get daysBeforeExpiry(): number;
    set daysBeforeExpiry(value: number);
    resetDaysBeforeExpiry(): void;
    get daysBeforeExpiryInput(): number | undefined;
    private _lifetimePercentage?;
    get lifetimePercentage(): number;
    set lifetimePercentage(value: number);
    resetLifetimePercentage(): void;
    get lifetimePercentageInput(): number | undefined;
}
export interface KeyVaultCertificateCertificatePolicyLifetimeAction {
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#action KeyVaultCertificate#action}
    */
    readonly action: KeyVaultCertificateCertificatePolicyLifetimeActionAction;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#trigger KeyVaultCertificate#trigger}
    */
    readonly trigger: KeyVaultCertificateCertificatePolicyLifetimeActionTrigger;
}
export declare function keyVaultCertificateCertificatePolicyLifetimeActionToTerraform(struct?: KeyVaultCertificateCertificatePolicyLifetimeAction | cdktf.IResolvable): any;
export declare class KeyVaultCertificateCertificatePolicyLifetimeActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KeyVaultCertificateCertificatePolicyLifetimeAction | cdktf.IResolvable | undefined;
    set internalValue(value: KeyVaultCertificateCertificatePolicyLifetimeAction | cdktf.IResolvable | undefined);
    private _action;
    get action(): KeyVaultCertificateCertificatePolicyLifetimeActionActionOutputReference;
    putAction(value: KeyVaultCertificateCertificatePolicyLifetimeActionAction): void;
    get actionInput(): KeyVaultCertificateCertificatePolicyLifetimeActionAction | undefined;
    private _trigger;
    get trigger(): KeyVaultCertificateCertificatePolicyLifetimeActionTriggerOutputReference;
    putTrigger(value: KeyVaultCertificateCertificatePolicyLifetimeActionTrigger): void;
    get triggerInput(): KeyVaultCertificateCertificatePolicyLifetimeActionTrigger | undefined;
}
export declare class KeyVaultCertificateCertificatePolicyLifetimeActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KeyVaultCertificateCertificatePolicyLifetimeAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KeyVaultCertificateCertificatePolicyLifetimeActionOutputReference;
}
export interface KeyVaultCertificateCertificatePolicySecretProperties {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#content_type KeyVaultCertificate#content_type}
    */
    readonly contentType: string;
}
export declare function keyVaultCertificateCertificatePolicySecretPropertiesToTerraform(struct?: KeyVaultCertificateCertificatePolicySecretPropertiesOutputReference | KeyVaultCertificateCertificatePolicySecretProperties): any;
export declare class KeyVaultCertificateCertificatePolicySecretPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultCertificateCertificatePolicySecretProperties | undefined;
    set internalValue(value: KeyVaultCertificateCertificatePolicySecretProperties | undefined);
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    get contentTypeInput(): string | undefined;
}
export interface KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#dns_names KeyVaultCertificate#dns_names}
    */
    readonly dnsNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#emails KeyVaultCertificate#emails}
    */
    readonly emails?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#upns KeyVaultCertificate#upns}
    */
    readonly upns?: string[];
}
export declare function keyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesToTerraform(struct?: KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesOutputReference | KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames): any;
export declare class KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames | undefined;
    set internalValue(value: KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames | undefined);
    private _dnsNames?;
    get dnsNames(): string[];
    set dnsNames(value: string[]);
    resetDnsNames(): void;
    get dnsNamesInput(): string[] | undefined;
    private _emails?;
    get emails(): string[];
    set emails(value: string[]);
    resetEmails(): void;
    get emailsInput(): string[] | undefined;
    private _upns?;
    get upns(): string[];
    set upns(value: string[]);
    resetUpns(): void;
    get upnsInput(): string[] | undefined;
}
export interface KeyVaultCertificateCertificatePolicyX509CertificateProperties {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#extended_key_usage KeyVaultCertificate#extended_key_usage}
    */
    readonly extendedKeyUsage?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#key_usage KeyVaultCertificate#key_usage}
    */
    readonly keyUsage: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#subject KeyVaultCertificate#subject}
    */
    readonly subject: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#validity_in_months KeyVaultCertificate#validity_in_months}
    */
    readonly validityInMonths: number;
    /**
    * subject_alternative_names block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#subject_alternative_names KeyVaultCertificate#subject_alternative_names}
    */
    readonly subjectAlternativeNames?: KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames;
}
export declare function keyVaultCertificateCertificatePolicyX509CertificatePropertiesToTerraform(struct?: KeyVaultCertificateCertificatePolicyX509CertificatePropertiesOutputReference | KeyVaultCertificateCertificatePolicyX509CertificateProperties): any;
export declare class KeyVaultCertificateCertificatePolicyX509CertificatePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultCertificateCertificatePolicyX509CertificateProperties | undefined;
    set internalValue(value: KeyVaultCertificateCertificatePolicyX509CertificateProperties | undefined);
    private _extendedKeyUsage?;
    get extendedKeyUsage(): string[];
    set extendedKeyUsage(value: string[]);
    resetExtendedKeyUsage(): void;
    get extendedKeyUsageInput(): string[] | undefined;
    private _keyUsage?;
    get keyUsage(): string[];
    set keyUsage(value: string[]);
    get keyUsageInput(): string[] | undefined;
    private _subject?;
    get subject(): string;
    set subject(value: string);
    get subjectInput(): string | undefined;
    private _validityInMonths?;
    get validityInMonths(): number;
    set validityInMonths(value: number);
    get validityInMonthsInput(): number | undefined;
    private _subjectAlternativeNames;
    get subjectAlternativeNames(): KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesOutputReference;
    putSubjectAlternativeNames(value: KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames): void;
    resetSubjectAlternativeNames(): void;
    get subjectAlternativeNamesInput(): KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames | undefined;
}
export interface KeyVaultCertificateCertificatePolicy {
    /**
    * issuer_parameters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#issuer_parameters KeyVaultCertificate#issuer_parameters}
    */
    readonly issuerParameters: KeyVaultCertificateCertificatePolicyIssuerParameters;
    /**
    * key_properties block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#key_properties KeyVaultCertificate#key_properties}
    */
    readonly keyProperties: KeyVaultCertificateCertificatePolicyKeyProperties;
    /**
    * lifetime_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#lifetime_action KeyVaultCertificate#lifetime_action}
    */
    readonly lifetimeAction?: KeyVaultCertificateCertificatePolicyLifetimeAction[] | cdktf.IResolvable;
    /**
    * secret_properties block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#secret_properties KeyVaultCertificate#secret_properties}
    */
    readonly secretProperties: KeyVaultCertificateCertificatePolicySecretProperties;
    /**
    * x509_certificate_properties block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#x509_certificate_properties KeyVaultCertificate#x509_certificate_properties}
    */
    readonly x509CertificateProperties?: KeyVaultCertificateCertificatePolicyX509CertificateProperties;
}
export declare function keyVaultCertificateCertificatePolicyToTerraform(struct?: KeyVaultCertificateCertificatePolicyOutputReference | KeyVaultCertificateCertificatePolicy): any;
export declare class KeyVaultCertificateCertificatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultCertificateCertificatePolicy | undefined;
    set internalValue(value: KeyVaultCertificateCertificatePolicy | undefined);
    private _issuerParameters;
    get issuerParameters(): KeyVaultCertificateCertificatePolicyIssuerParametersOutputReference;
    putIssuerParameters(value: KeyVaultCertificateCertificatePolicyIssuerParameters): void;
    get issuerParametersInput(): KeyVaultCertificateCertificatePolicyIssuerParameters | undefined;
    private _keyProperties;
    get keyProperties(): KeyVaultCertificateCertificatePolicyKeyPropertiesOutputReference;
    putKeyProperties(value: KeyVaultCertificateCertificatePolicyKeyProperties): void;
    get keyPropertiesInput(): KeyVaultCertificateCertificatePolicyKeyProperties | undefined;
    private _lifetimeAction;
    get lifetimeAction(): KeyVaultCertificateCertificatePolicyLifetimeActionList;
    putLifetimeAction(value: KeyVaultCertificateCertificatePolicyLifetimeAction[] | cdktf.IResolvable): void;
    resetLifetimeAction(): void;
    get lifetimeActionInput(): cdktf.IResolvable | KeyVaultCertificateCertificatePolicyLifetimeAction[] | undefined;
    private _secretProperties;
    get secretProperties(): KeyVaultCertificateCertificatePolicySecretPropertiesOutputReference;
    putSecretProperties(value: KeyVaultCertificateCertificatePolicySecretProperties): void;
    get secretPropertiesInput(): KeyVaultCertificateCertificatePolicySecretProperties | undefined;
    private _x509CertificateProperties;
    get x509CertificateProperties(): KeyVaultCertificateCertificatePolicyX509CertificatePropertiesOutputReference;
    putX509CertificateProperties(value: KeyVaultCertificateCertificatePolicyX509CertificateProperties): void;
    resetX509CertificateProperties(): void;
    get x509CertificatePropertiesInput(): KeyVaultCertificateCertificatePolicyX509CertificateProperties | undefined;
}
export interface KeyVaultCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#create KeyVaultCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#delete KeyVaultCertificate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#read KeyVaultCertificate#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#update KeyVaultCertificate#update}
    */
    readonly update?: string;
}
export declare function keyVaultCertificateTimeoutsToTerraform(struct?: KeyVaultCertificateTimeouts | cdktf.IResolvable): any;
export declare class KeyVaultCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultCertificateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KeyVaultCertificateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate azurerm_key_vault_certificate}
*/
export declare class KeyVaultCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_key_vault_certificate";
    /**
    * Generates CDKTF code for importing a KeyVaultCertificate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KeyVaultCertificate to import
    * @param importFromId The id of the existing KeyVaultCertificate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KeyVaultCertificate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/key_vault_certificate azurerm_key_vault_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KeyVaultCertificateConfig
    */
    constructor(scope: Construct, id: string, config: KeyVaultCertificateConfig);
    private _certificateAttribute;
    get certificateAttribute(): KeyVaultCertificateCertificateAttributeList;
    get certificateData(): string;
    get certificateDataBase64(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get resourceManagerId(): string;
    get resourceManagerVersionlessId(): string;
    get secretId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get thumbprint(): string;
    get version(): string;
    get versionlessId(): string;
    get versionlessSecretId(): string;
    private _certificate;
    get certificate(): KeyVaultCertificateCertificateOutputReference;
    putCertificate(value: KeyVaultCertificateCertificate): void;
    resetCertificate(): void;
    get certificateInput(): KeyVaultCertificateCertificate | undefined;
    private _certificatePolicy;
    get certificatePolicy(): KeyVaultCertificateCertificatePolicyOutputReference;
    putCertificatePolicy(value: KeyVaultCertificateCertificatePolicy): void;
    resetCertificatePolicy(): void;
    get certificatePolicyInput(): KeyVaultCertificateCertificatePolicy | undefined;
    private _timeouts;
    get timeouts(): KeyVaultCertificateTimeoutsOutputReference;
    putTimeouts(value: KeyVaultCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KeyVaultCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
