/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LabServicePlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#allowed_regions LabServicePlan#allowed_regions}
    */
    readonly allowedRegions: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#default_network_subnet_id LabServicePlan#default_network_subnet_id}
    */
    readonly defaultNetworkSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#id LabServicePlan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#location LabServicePlan#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#name LabServicePlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#resource_group_name LabServicePlan#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#shared_gallery_id LabServicePlan#shared_gallery_id}
    */
    readonly sharedGalleryId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#tags LabServicePlan#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * default_auto_shutdown block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#default_auto_shutdown LabServicePlan#default_auto_shutdown}
    */
    readonly defaultAutoShutdown?: LabServicePlanDefaultAutoShutdown;
    /**
    * default_connection block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#default_connection LabServicePlan#default_connection}
    */
    readonly defaultConnection?: LabServicePlanDefaultConnection;
    /**
    * support block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#support LabServicePlan#support}
    */
    readonly support?: LabServicePlanSupport;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#timeouts LabServicePlan#timeouts}
    */
    readonly timeouts?: LabServicePlanTimeouts;
}
export interface LabServicePlanDefaultAutoShutdown {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#disconnect_delay LabServicePlan#disconnect_delay}
    */
    readonly disconnectDelay?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#idle_delay LabServicePlan#idle_delay}
    */
    readonly idleDelay?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#no_connect_delay LabServicePlan#no_connect_delay}
    */
    readonly noConnectDelay?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#shutdown_on_idle LabServicePlan#shutdown_on_idle}
    */
    readonly shutdownOnIdle?: string;
}
export declare function labServicePlanDefaultAutoShutdownToTerraform(struct?: LabServicePlanDefaultAutoShutdownOutputReference | LabServicePlanDefaultAutoShutdown): any;
export declare class LabServicePlanDefaultAutoShutdownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServicePlanDefaultAutoShutdown | undefined;
    set internalValue(value: LabServicePlanDefaultAutoShutdown | undefined);
    private _disconnectDelay?;
    get disconnectDelay(): string;
    set disconnectDelay(value: string);
    resetDisconnectDelay(): void;
    get disconnectDelayInput(): string | undefined;
    private _idleDelay?;
    get idleDelay(): string;
    set idleDelay(value: string);
    resetIdleDelay(): void;
    get idleDelayInput(): string | undefined;
    private _noConnectDelay?;
    get noConnectDelay(): string;
    set noConnectDelay(value: string);
    resetNoConnectDelay(): void;
    get noConnectDelayInput(): string | undefined;
    private _shutdownOnIdle?;
    get shutdownOnIdle(): string;
    set shutdownOnIdle(value: string);
    resetShutdownOnIdle(): void;
    get shutdownOnIdleInput(): string | undefined;
}
export interface LabServicePlanDefaultConnection {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#client_rdp_access LabServicePlan#client_rdp_access}
    */
    readonly clientRdpAccess?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#client_ssh_access LabServicePlan#client_ssh_access}
    */
    readonly clientSshAccess?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#web_rdp_access LabServicePlan#web_rdp_access}
    */
    readonly webRdpAccess?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#web_ssh_access LabServicePlan#web_ssh_access}
    */
    readonly webSshAccess?: string;
}
export declare function labServicePlanDefaultConnectionToTerraform(struct?: LabServicePlanDefaultConnectionOutputReference | LabServicePlanDefaultConnection): any;
export declare class LabServicePlanDefaultConnectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServicePlanDefaultConnection | undefined;
    set internalValue(value: LabServicePlanDefaultConnection | undefined);
    private _clientRdpAccess?;
    get clientRdpAccess(): string;
    set clientRdpAccess(value: string);
    resetClientRdpAccess(): void;
    get clientRdpAccessInput(): string | undefined;
    private _clientSshAccess?;
    get clientSshAccess(): string;
    set clientSshAccess(value: string);
    resetClientSshAccess(): void;
    get clientSshAccessInput(): string | undefined;
    private _webRdpAccess?;
    get webRdpAccess(): string;
    set webRdpAccess(value: string);
    resetWebRdpAccess(): void;
    get webRdpAccessInput(): string | undefined;
    private _webSshAccess?;
    get webSshAccess(): string;
    set webSshAccess(value: string);
    resetWebSshAccess(): void;
    get webSshAccessInput(): string | undefined;
}
export interface LabServicePlanSupport {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#email LabServicePlan#email}
    */
    readonly email?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#instructions LabServicePlan#instructions}
    */
    readonly instructions?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#phone LabServicePlan#phone}
    */
    readonly phone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#url LabServicePlan#url}
    */
    readonly url?: string;
}
export declare function labServicePlanSupportToTerraform(struct?: LabServicePlanSupportOutputReference | LabServicePlanSupport): any;
export declare class LabServicePlanSupportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServicePlanSupport | undefined;
    set internalValue(value: LabServicePlanSupport | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _instructions?;
    get instructions(): string;
    set instructions(value: string);
    resetInstructions(): void;
    get instructionsInput(): string | undefined;
    private _phone?;
    get phone(): string;
    set phone(value: string);
    resetPhone(): void;
    get phoneInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
}
export interface LabServicePlanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#create LabServicePlan#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#delete LabServicePlan#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#read LabServicePlan#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#update LabServicePlan#update}
    */
    readonly update?: string;
}
export declare function labServicePlanTimeoutsToTerraform(struct?: LabServicePlanTimeouts | cdktf.IResolvable): any;
export declare class LabServicePlanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServicePlanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LabServicePlanTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan azurerm_lab_service_plan}
*/
export declare class LabServicePlan extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_lab_service_plan";
    /**
    * Generates CDKTF code for importing a LabServicePlan resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LabServicePlan to import
    * @param importFromId The id of the existing LabServicePlan that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LabServicePlan to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/lab_service_plan azurerm_lab_service_plan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LabServicePlanConfig
    */
    constructor(scope: Construct, id: string, config: LabServicePlanConfig);
    private _allowedRegions?;
    get allowedRegions(): string[];
    set allowedRegions(value: string[]);
    get allowedRegionsInput(): string[] | undefined;
    private _defaultNetworkSubnetId?;
    get defaultNetworkSubnetId(): string;
    set defaultNetworkSubnetId(value: string);
    resetDefaultNetworkSubnetId(): void;
    get defaultNetworkSubnetIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sharedGalleryId?;
    get sharedGalleryId(): string;
    set sharedGalleryId(value: string);
    resetSharedGalleryId(): void;
    get sharedGalleryIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _defaultAutoShutdown;
    get defaultAutoShutdown(): LabServicePlanDefaultAutoShutdownOutputReference;
    putDefaultAutoShutdown(value: LabServicePlanDefaultAutoShutdown): void;
    resetDefaultAutoShutdown(): void;
    get defaultAutoShutdownInput(): LabServicePlanDefaultAutoShutdown | undefined;
    private _defaultConnection;
    get defaultConnection(): LabServicePlanDefaultConnectionOutputReference;
    putDefaultConnection(value: LabServicePlanDefaultConnection): void;
    resetDefaultConnection(): void;
    get defaultConnectionInput(): LabServicePlanDefaultConnection | undefined;
    private _support;
    get support(): LabServicePlanSupportOutputReference;
    putSupport(value: LabServicePlanSupport): void;
    resetSupport(): void;
    get supportInput(): LabServicePlanSupport | undefined;
    private _timeouts;
    get timeouts(): LabServicePlanTimeoutsOutputReference;
    putTimeouts(value: LabServicePlanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LabServicePlanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
