/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LinuxFunctionAppSlotConfig extends cdktf.TerraformMetaArguments {
    /**
    * A map of key-value pairs for [App Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#app_settings LinuxFunctionAppSlot#app_settings}
    */
    readonly appSettings?: {
        [key: string]: string;
    };
    /**
    * Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#builtin_logging_enabled LinuxFunctionAppSlot#builtin_logging_enabled}
    */
    readonly builtinLoggingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Should the Function App Slot use Client Certificates.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_certificate_enabled LinuxFunctionAppSlot#client_certificate_enabled}
    */
    readonly clientCertificateEnabled?: boolean | cdktf.IResolvable;
    /**
    * Paths to exclude when using client certificates, separated by ;
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_certificate_exclusion_paths LinuxFunctionAppSlot#client_certificate_exclusion_paths}
    */
    readonly clientCertificateExclusionPaths?: string;
    /**
    * The mode of the Function App Slot's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_certificate_mode LinuxFunctionAppSlot#client_certificate_mode}
    */
    readonly clientCertificateMode?: string;
    /**
    * Force disable the content share settings.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#content_share_force_disabled LinuxFunctionAppSlot#content_share_force_disabled}
    */
    readonly contentShareForceDisabled?: boolean | cdktf.IResolvable;
    /**
    * The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps in Consumption Plans.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#daily_memory_time_quota LinuxFunctionAppSlot#daily_memory_time_quota}
    */
    readonly dailyMemoryTimeQuota?: number;
    /**
    * Is the Linux Function App Slot enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#enabled LinuxFunctionAppSlot#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The ID of the Linux Function App this Slot is a member of.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#function_app_id LinuxFunctionAppSlot#function_app_id}
    */
    readonly functionAppId: string;
    /**
    * The runtime version associated with the Function App Slot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#functions_extension_version LinuxFunctionAppSlot#functions_extension_version}
    */
    readonly functionsExtensionVersion?: string;
    /**
    * Can the Function App Slot only be accessed via HTTPS?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#https_only LinuxFunctionAppSlot#https_only}
    */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#id LinuxFunctionAppSlot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The User Assigned Identity to use for Key Vault access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#key_vault_reference_identity_id LinuxFunctionAppSlot#key_vault_reference_identity_id}
    */
    readonly keyVaultReferenceIdentityId?: string;
    /**
    * Specifies the name of the Function App Slot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#name LinuxFunctionAppSlot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#public_network_access_enabled LinuxFunctionAppSlot#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#service_plan_id LinuxFunctionAppSlot#service_plan_id}
    */
    readonly servicePlanId?: string;
    /**
    * The access key which will be used to access the storage account for the Function App Slot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#storage_account_access_key LinuxFunctionAppSlot#storage_account_access_key}
    */
    readonly storageAccountAccessKey?: string;
    /**
    * The backend storage account name which will be used by this Function App Slot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#storage_account_name LinuxFunctionAppSlot#storage_account_name}
    */
    readonly storageAccountName?: string;
    /**
    * The Key Vault Secret ID, including version, that contains the Connection String to connect to the storage account for this Function App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#storage_key_vault_secret_id LinuxFunctionAppSlot#storage_key_vault_secret_id}
    */
    readonly storageKeyVaultSecretId?: string;
    /**
    * Should the Function App Slot use its Managed Identity to access storage?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#storage_uses_managed_identity LinuxFunctionAppSlot#storage_uses_managed_identity}
    */
    readonly storageUsesManagedIdentity?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#tags LinuxFunctionAppSlot#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#virtual_network_subnet_id LinuxFunctionAppSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
    /**
    * auth_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#auth_settings LinuxFunctionAppSlot#auth_settings}
    */
    readonly authSettings?: LinuxFunctionAppSlotAuthSettings;
    /**
    * auth_settings_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#auth_settings_v2 LinuxFunctionAppSlot#auth_settings_v2}
    */
    readonly authSettingsV2?: LinuxFunctionAppSlotAuthSettingsV2;
    /**
    * backup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#backup LinuxFunctionAppSlot#backup}
    */
    readonly backup?: LinuxFunctionAppSlotBackup;
    /**
    * connection_string block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#connection_string LinuxFunctionAppSlot#connection_string}
    */
    readonly connectionString?: LinuxFunctionAppSlotConnectionString[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#identity LinuxFunctionAppSlot#identity}
    */
    readonly identity?: LinuxFunctionAppSlotIdentity;
    /**
    * site_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#site_config LinuxFunctionAppSlot#site_config}
    */
    readonly siteConfig: LinuxFunctionAppSlotSiteConfig;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#storage_account LinuxFunctionAppSlot#storage_account}
    */
    readonly storageAccount?: LinuxFunctionAppSlotStorageAccount[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#timeouts LinuxFunctionAppSlot#timeouts}
    */
    readonly timeouts?: LinuxFunctionAppSlotTimeouts;
}
export interface LinuxFunctionAppSlotSiteCredential {
}
export declare function linuxFunctionAppSlotSiteCredentialToTerraform(struct?: LinuxFunctionAppSlotSiteCredential): any;
export declare class LinuxFunctionAppSlotSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxFunctionAppSlotSiteCredential | undefined;
    set internalValue(value: LinuxFunctionAppSlotSiteCredential | undefined);
    get name(): string;
    get password(): string;
}
export declare class LinuxFunctionAppSlotSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxFunctionAppSlotSiteCredentialOutputReference;
}
export interface LinuxFunctionAppSlotAuthSettingsActiveDirectory {
    /**
    * Specifies a list of Allowed audience values to consider when validating JWTs issued by Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#allowed_audiences LinuxFunctionAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The ID of the Client to use to authenticate with Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_id LinuxFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The Client Secret for the Client ID. Cannot be used with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_secret LinuxFunctionAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The App Setting name that contains the client secret of the Client. Cannot be used with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_secret_setting_name LinuxFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
}
export declare function linuxFunctionAppSlotAuthSettingsActiveDirectoryToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsActiveDirectoryOutputReference | LinuxFunctionAppSlotAuthSettingsActiveDirectory): any;
export declare class LinuxFunctionAppSlotAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsActiveDirectory | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsActiveDirectory | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
}
export interface LinuxFunctionAppSlotAuthSettingsFacebook {
    /**
    * The App ID of the Facebook app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#app_id LinuxFunctionAppSlot#app_id}
    */
    readonly appId: string;
    /**
    * The App Secret of the Facebook app used for Facebook Login. Cannot be specified with `app_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#app_secret LinuxFunctionAppSlot#app_secret}
    */
    readonly appSecret?: string;
    /**
    * The app setting name that contains the `app_secret` value used for Facebook Login. Cannot be specified with `app_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#app_secret_setting_name LinuxFunctionAppSlot#app_secret_setting_name}
    */
    readonly appSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes to be requested as part of Facebook Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#oauth_scopes LinuxFunctionAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function linuxFunctionAppSlotAuthSettingsFacebookToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsFacebookOutputReference | LinuxFunctionAppSlotAuthSettingsFacebook): any;
export declare class LinuxFunctionAppSlotAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsFacebook | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsFacebook | undefined);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecret?;
    get appSecret(): string;
    set appSecret(value: string);
    resetAppSecret(): void;
    get appSecretInput(): string | undefined;
    private _appSecretSettingName?;
    get appSecretSettingName(): string;
    set appSecretSettingName(value: string);
    resetAppSecretSettingName(): void;
    get appSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface LinuxFunctionAppSlotAuthSettingsGithub {
    /**
    * The ID of the GitHub app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_id LinuxFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The Client Secret of the GitHub app used for GitHub Login. Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_secret LinuxFunctionAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name that contains the `client_secret` value used for GitHub Login. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_secret_setting_name LinuxFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#oauth_scopes LinuxFunctionAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function linuxFunctionAppSlotAuthSettingsGithubToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsGithubOutputReference | LinuxFunctionAppSlotAuthSettingsGithub): any;
export declare class LinuxFunctionAppSlotAuthSettingsGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsGithub | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsGithub | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface LinuxFunctionAppSlotAuthSettingsGoogle {
    /**
    * The OpenID Connect Client ID for the Google web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_id LinuxFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The client secret associated with the Google web application.  Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_secret LinuxFunctionAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name that contains the `client_secret` value used for Google Login. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_secret_setting_name LinuxFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication. If not specified, "openid", "profile", and "email" are used as default scopes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#oauth_scopes LinuxFunctionAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function linuxFunctionAppSlotAuthSettingsGoogleToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsGoogleOutputReference | LinuxFunctionAppSlotAuthSettingsGoogle): any;
export declare class LinuxFunctionAppSlotAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsGoogle | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsGoogle | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface LinuxFunctionAppSlotAuthSettingsMicrosoft {
    /**
    * The OAuth 2.0 client ID that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_id LinuxFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The OAuth 2.0 client secret that was created for the app used for authentication. Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_secret LinuxFunctionAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name containing the OAuth 2.0 client secret that was created for the app used for authentication. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_secret_setting_name LinuxFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * The list of OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication. If not specified, `wl.basic` is used as the default scope.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#oauth_scopes LinuxFunctionAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function linuxFunctionAppSlotAuthSettingsMicrosoftToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsMicrosoftOutputReference | LinuxFunctionAppSlotAuthSettingsMicrosoft): any;
export declare class LinuxFunctionAppSlotAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsMicrosoft | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsMicrosoft | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface LinuxFunctionAppSlotAuthSettingsTwitter {
    /**
    * The OAuth 1.0a consumer key of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#consumer_key LinuxFunctionAppSlot#consumer_key}
    */
    readonly consumerKey: string;
    /**
    * The OAuth 1.0a consumer secret of the Twitter application used for sign-in. Cannot be specified with `consumer_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#consumer_secret LinuxFunctionAppSlot#consumer_secret}
    */
    readonly consumerSecret?: string;
    /**
    * The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in. Cannot be specified with `consumer_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#consumer_secret_setting_name LinuxFunctionAppSlot#consumer_secret_setting_name}
    */
    readonly consumerSecretSettingName?: string;
}
export declare function linuxFunctionAppSlotAuthSettingsTwitterToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsTwitterOutputReference | LinuxFunctionAppSlotAuthSettingsTwitter): any;
export declare class LinuxFunctionAppSlotAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsTwitter | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsTwitter | undefined);
    private _consumerKey?;
    get consumerKey(): string;
    set consumerKey(value: string);
    get consumerKeyInput(): string | undefined;
    private _consumerSecret?;
    get consumerSecret(): string;
    set consumerSecret(value: string);
    resetConsumerSecret(): void;
    get consumerSecretInput(): string | undefined;
    private _consumerSecretSettingName?;
    get consumerSecretSettingName(): string;
    set consumerSecretSettingName(value: string);
    resetConsumerSecretSettingName(): void;
    get consumerSecretSettingNameInput(): string | undefined;
}
export interface LinuxFunctionAppSlotAuthSettings {
    /**
    * Specifies a map of Login Parameters to send to the OpenID Connect authorization endpoint when a user logs in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#additional_login_parameters LinuxFunctionAppSlot#additional_login_parameters}
    */
    readonly additionalLoginParameters?: {
        [key: string]: string;
    };
    /**
    * Specifies a list of External URLs that can be redirected to as part of logging in or logging out of the Windows Web App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#allowed_external_redirect_urls LinuxFunctionAppSlot#allowed_external_redirect_urls}
    */
    readonly allowedExternalRedirectUrls?: string[];
    /**
    * The default authentication provider to use when multiple providers are configured. Possible values include: `AzureActiveDirectory`, `Facebook`, `Google`, `MicrosoftAccount`, `Twitter`, `Github`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#default_provider LinuxFunctionAppSlot#default_provider}
    */
    readonly defaultProvider?: string;
    /**
    * Should the Authentication / Authorization feature be enabled?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#enabled LinuxFunctionAppSlot#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The OpenID Connect Issuer URI that represents the entity which issues access tokens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#issuer LinuxFunctionAppSlot#issuer}
    */
    readonly issuer?: string;
    /**
    * The RuntimeVersion of the Authentication / Authorization feature in use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#runtime_version LinuxFunctionAppSlot#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * The number of hours after session token expiration that a session token can be used to call the token refresh API. Defaults to `72` hours.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#token_refresh_extension_hours LinuxFunctionAppSlot#token_refresh_extension_hours}
    */
    readonly tokenRefreshExtensionHours?: number;
    /**
    * Should the Windows Web App durably store platform-specific security tokens that are obtained during login flows? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#token_store_enabled LinuxFunctionAppSlot#token_store_enabled}
    */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * The action to take when an unauthenticated client attempts to access the app. Possible values include: `RedirectToLoginPage`, `AllowAnonymous`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#unauthenticated_client_action LinuxFunctionAppSlot#unauthenticated_client_action}
    */
    readonly unauthenticatedClientAction?: string;
    /**
    * active_directory block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#active_directory LinuxFunctionAppSlot#active_directory}
    */
    readonly activeDirectory?: LinuxFunctionAppSlotAuthSettingsActiveDirectory;
    /**
    * facebook block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#facebook LinuxFunctionAppSlot#facebook}
    */
    readonly facebook?: LinuxFunctionAppSlotAuthSettingsFacebook;
    /**
    * github block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#github LinuxFunctionAppSlot#github}
    */
    readonly github?: LinuxFunctionAppSlotAuthSettingsGithub;
    /**
    * google block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#google LinuxFunctionAppSlot#google}
    */
    readonly google?: LinuxFunctionAppSlotAuthSettingsGoogle;
    /**
    * microsoft block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#microsoft LinuxFunctionAppSlot#microsoft}
    */
    readonly microsoft?: LinuxFunctionAppSlotAuthSettingsMicrosoft;
    /**
    * twitter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#twitter LinuxFunctionAppSlot#twitter}
    */
    readonly twitter?: LinuxFunctionAppSlotAuthSettingsTwitter;
}
export declare function linuxFunctionAppSlotAuthSettingsToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsOutputReference | LinuxFunctionAppSlotAuthSettings): any;
export declare class LinuxFunctionAppSlotAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettings | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettings | undefined);
    private _additionalLoginParameters?;
    get additionalLoginParameters(): {
        [key: string]: string;
    };
    set additionalLoginParameters(value: {
        [key: string]: string;
    });
    resetAdditionalLoginParameters(): void;
    get additionalLoginParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _allowedExternalRedirectUrls?;
    get allowedExternalRedirectUrls(): string[];
    set allowedExternalRedirectUrls(value: string[]);
    resetAllowedExternalRedirectUrls(): void;
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _defaultProvider?;
    get defaultProvider(): string;
    set defaultProvider(value: string);
    resetDefaultProvider(): void;
    get defaultProviderInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _tokenRefreshExtensionHours?;
    get tokenRefreshExtensionHours(): number;
    set tokenRefreshExtensionHours(value: number);
    resetTokenRefreshExtensionHours(): void;
    get tokenRefreshExtensionHoursInput(): number | undefined;
    private _tokenStoreEnabled?;
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    resetTokenStoreEnabled(): void;
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _unauthenticatedClientAction?;
    get unauthenticatedClientAction(): string;
    set unauthenticatedClientAction(value: string);
    resetUnauthenticatedClientAction(): void;
    get unauthenticatedClientActionInput(): string | undefined;
    private _activeDirectory;
    get activeDirectory(): LinuxFunctionAppSlotAuthSettingsActiveDirectoryOutputReference;
    putActiveDirectory(value: LinuxFunctionAppSlotAuthSettingsActiveDirectory): void;
    resetActiveDirectory(): void;
    get activeDirectoryInput(): LinuxFunctionAppSlotAuthSettingsActiveDirectory | undefined;
    private _facebook;
    get facebook(): LinuxFunctionAppSlotAuthSettingsFacebookOutputReference;
    putFacebook(value: LinuxFunctionAppSlotAuthSettingsFacebook): void;
    resetFacebook(): void;
    get facebookInput(): LinuxFunctionAppSlotAuthSettingsFacebook | undefined;
    private _github;
    get github(): LinuxFunctionAppSlotAuthSettingsGithubOutputReference;
    putGithub(value: LinuxFunctionAppSlotAuthSettingsGithub): void;
    resetGithub(): void;
    get githubInput(): LinuxFunctionAppSlotAuthSettingsGithub | undefined;
    private _google;
    get google(): LinuxFunctionAppSlotAuthSettingsGoogleOutputReference;
    putGoogle(value: LinuxFunctionAppSlotAuthSettingsGoogle): void;
    resetGoogle(): void;
    get googleInput(): LinuxFunctionAppSlotAuthSettingsGoogle | undefined;
    private _microsoft;
    get microsoft(): LinuxFunctionAppSlotAuthSettingsMicrosoftOutputReference;
    putMicrosoft(value: LinuxFunctionAppSlotAuthSettingsMicrosoft): void;
    resetMicrosoft(): void;
    get microsoftInput(): LinuxFunctionAppSlotAuthSettingsMicrosoft | undefined;
    private _twitter;
    get twitter(): LinuxFunctionAppSlotAuthSettingsTwitterOutputReference;
    putTwitter(value: LinuxFunctionAppSlotAuthSettingsTwitter): void;
    resetTwitter(): void;
    get twitterInput(): LinuxFunctionAppSlotAuthSettingsTwitter | undefined;
}
export interface LinuxFunctionAppSlotAuthSettingsV2ActiveDirectoryV2 {
    /**
    * The list of allowed Applications for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#allowed_applications LinuxFunctionAppSlot#allowed_applications}
    */
    readonly allowedApplications?: string[];
    /**
    * Specifies a list of Allowed audience values to consider when validating JWTs issued by Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#allowed_audiences LinuxFunctionAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The list of allowed Group Names for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#allowed_groups LinuxFunctionAppSlot#allowed_groups}
    */
    readonly allowedGroups?: string[];
    /**
    * The list of allowed Identities for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#allowed_identities LinuxFunctionAppSlot#allowed_identities}
    */
    readonly allowedIdentities?: string[];
    /**
    * The ID of the Client to use to authenticate with Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_id LinuxFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The thumbprint of the certificate used for signing purposes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_secret_certificate_thumbprint LinuxFunctionAppSlot#client_secret_certificate_thumbprint}
    */
    readonly clientSecretCertificateThumbprint?: string;
    /**
    * The App Setting name that contains the client secret of the Client.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_secret_setting_name LinuxFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * A list of Allowed Client Applications in the JWT Claim.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#jwt_allowed_client_applications LinuxFunctionAppSlot#jwt_allowed_client_applications}
    */
    readonly jwtAllowedClientApplications?: string[];
    /**
    * A list of Allowed Groups in the JWT Claim.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#jwt_allowed_groups LinuxFunctionAppSlot#jwt_allowed_groups}
    */
    readonly jwtAllowedGroups?: string[];
    /**
    * A map of key-value pairs to send to the Authorisation Endpoint when a user logs in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#login_parameters LinuxFunctionAppSlot#login_parameters}
    */
    readonly loginParameters?: {
        [key: string]: string;
    };
    /**
    * The Azure Tenant Endpoint for the Authenticating Tenant. e.g. `https://login.microsoftonline.com/v2.0/{tenant-guid}/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#tenant_auth_endpoint LinuxFunctionAppSlot#tenant_auth_endpoint}
    */
    readonly tenantAuthEndpoint: string;
    /**
    * Should the www-authenticate provider should be omitted from the request? Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#www_authentication_disabled LinuxFunctionAppSlot#www_authentication_disabled}
    */
    readonly wwwAuthenticationDisabled?: boolean | cdktf.IResolvable;
}
export declare function linuxFunctionAppSlotAuthSettingsV2ActiveDirectoryV2ToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsV2ActiveDirectoryV2OutputReference | LinuxFunctionAppSlotAuthSettingsV2ActiveDirectoryV2): any;
export declare class LinuxFunctionAppSlotAuthSettingsV2ActiveDirectoryV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsV2ActiveDirectoryV2 | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsV2ActiveDirectoryV2 | undefined);
    private _allowedApplications?;
    get allowedApplications(): string[];
    set allowedApplications(value: string[]);
    resetAllowedApplications(): void;
    get allowedApplicationsInput(): string[] | undefined;
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _allowedGroups?;
    get allowedGroups(): string[];
    set allowedGroups(value: string[]);
    resetAllowedGroups(): void;
    get allowedGroupsInput(): string[] | undefined;
    private _allowedIdentities?;
    get allowedIdentities(): string[];
    set allowedIdentities(value: string[]);
    resetAllowedIdentities(): void;
    get allowedIdentitiesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretCertificateThumbprint?;
    get clientSecretCertificateThumbprint(): string;
    set clientSecretCertificateThumbprint(value: string);
    resetClientSecretCertificateThumbprint(): void;
    get clientSecretCertificateThumbprintInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _jwtAllowedClientApplications?;
    get jwtAllowedClientApplications(): string[];
    set jwtAllowedClientApplications(value: string[]);
    resetJwtAllowedClientApplications(): void;
    get jwtAllowedClientApplicationsInput(): string[] | undefined;
    private _jwtAllowedGroups?;
    get jwtAllowedGroups(): string[];
    set jwtAllowedGroups(value: string[]);
    resetJwtAllowedGroups(): void;
    get jwtAllowedGroupsInput(): string[] | undefined;
    private _loginParameters?;
    get loginParameters(): {
        [key: string]: string;
    };
    set loginParameters(value: {
        [key: string]: string;
    });
    resetLoginParameters(): void;
    get loginParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _tenantAuthEndpoint?;
    get tenantAuthEndpoint(): string;
    set tenantAuthEndpoint(value: string);
    get tenantAuthEndpointInput(): string | undefined;
    private _wwwAuthenticationDisabled?;
    get wwwAuthenticationDisabled(): boolean | cdktf.IResolvable;
    set wwwAuthenticationDisabled(value: boolean | cdktf.IResolvable);
    resetWwwAuthenticationDisabled(): void;
    get wwwAuthenticationDisabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface LinuxFunctionAppSlotAuthSettingsV2AppleV2 {
    /**
    * The OpenID Connect Client ID for the Apple web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_id LinuxFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for Apple Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_secret_setting_name LinuxFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
}
export declare function linuxFunctionAppSlotAuthSettingsV2AppleV2ToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsV2AppleV2OutputReference | LinuxFunctionAppSlotAuthSettingsV2AppleV2): any;
export declare class LinuxFunctionAppSlotAuthSettingsV2AppleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsV2AppleV2 | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsV2AppleV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    get loginScopes(): string[];
}
export interface LinuxFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2 {
    /**
    * The ID of the Client to use to authenticate with Azure Static Web App Authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_id LinuxFunctionAppSlot#client_id}
    */
    readonly clientId: string;
}
export declare function linuxFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2ToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2OutputReference | LinuxFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2): any;
export declare class LinuxFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2 | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
}
export interface LinuxFunctionAppSlotAuthSettingsV2CustomOidcV2 {
    /**
    * The ID of the Client to use to authenticate with this Custom OIDC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_id LinuxFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The name of the Custom OIDC Authentication Provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#name LinuxFunctionAppSlot#name}
    */
    readonly name: string;
    /**
    * The name of the claim that contains the users name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#name_claim_type LinuxFunctionAppSlot#name_claim_type}
    */
    readonly nameClaimType?: string;
    /**
    * The endpoint that contains all the configuration endpoints for this Custom OIDC provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#openid_configuration_endpoint LinuxFunctionAppSlot#openid_configuration_endpoint}
    */
    readonly openidConfigurationEndpoint: string;
    /**
    * The list of the scopes that should be requested while authenticating.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#scopes LinuxFunctionAppSlot#scopes}
    */
    readonly scopes?: string[];
}
export declare function linuxFunctionAppSlotAuthSettingsV2CustomOidcV2ToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsV2CustomOidcV2 | cdktf.IResolvable): any;
export declare class LinuxFunctionAppSlotAuthSettingsV2CustomOidcV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsV2CustomOidcV2 | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsV2CustomOidcV2 | cdktf.IResolvable | undefined);
    get authorisationEndpoint(): string;
    get certificationUri(): string;
    get clientCredentialMethod(): string;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    get clientSecretSettingName(): string;
    get issuerEndpoint(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nameClaimType?;
    get nameClaimType(): string;
    set nameClaimType(value: string);
    resetNameClaimType(): void;
    get nameClaimTypeInput(): string | undefined;
    private _openidConfigurationEndpoint?;
    get openidConfigurationEndpoint(): string;
    set openidConfigurationEndpoint(value: string);
    get openidConfigurationEndpointInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
    get tokenEndpoint(): string;
}
export declare class LinuxFunctionAppSlotAuthSettingsV2CustomOidcV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxFunctionAppSlotAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxFunctionAppSlotAuthSettingsV2CustomOidcV2OutputReference;
}
export interface LinuxFunctionAppSlotAuthSettingsV2FacebookV2 {
    /**
    * The App ID of the Facebook app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#app_id LinuxFunctionAppSlot#app_id}
    */
    readonly appId: string;
    /**
    * The app setting name that contains the `app_secret` value used for Facebook Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#app_secret_setting_name LinuxFunctionAppSlot#app_secret_setting_name}
    */
    readonly appSecretSettingName: string;
    /**
    * The version of the Facebook API to be used while logging in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#graph_api_version LinuxFunctionAppSlot#graph_api_version}
    */
    readonly graphApiVersion?: string;
    /**
    * Specifies a list of scopes to be requested as part of Facebook Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#login_scopes LinuxFunctionAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function linuxFunctionAppSlotAuthSettingsV2FacebookV2ToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsV2FacebookV2OutputReference | LinuxFunctionAppSlotAuthSettingsV2FacebookV2): any;
export declare class LinuxFunctionAppSlotAuthSettingsV2FacebookV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsV2FacebookV2 | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsV2FacebookV2 | undefined);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecretSettingName?;
    get appSecretSettingName(): string;
    set appSecretSettingName(value: string);
    get appSecretSettingNameInput(): string | undefined;
    private _graphApiVersion?;
    get graphApiVersion(): string;
    set graphApiVersion(value: string);
    resetGraphApiVersion(): void;
    get graphApiVersionInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface LinuxFunctionAppSlotAuthSettingsV2GithubV2 {
    /**
    * The ID of the GitHub app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_id LinuxFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for GitHub Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_secret_setting_name LinuxFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#login_scopes LinuxFunctionAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function linuxFunctionAppSlotAuthSettingsV2GithubV2ToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsV2GithubV2OutputReference | LinuxFunctionAppSlotAuthSettingsV2GithubV2): any;
export declare class LinuxFunctionAppSlotAuthSettingsV2GithubV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsV2GithubV2 | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsV2GithubV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface LinuxFunctionAppSlotAuthSettingsV2GoogleV2 {
    /**
    * Specifies a list of Allowed Audiences that will be requested as part of Google Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#allowed_audiences LinuxFunctionAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The OpenID Connect Client ID for the Google web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_id LinuxFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for Google Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_secret_setting_name LinuxFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * Specifies a list of Login scopes that will be requested as part of Google Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#login_scopes LinuxFunctionAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function linuxFunctionAppSlotAuthSettingsV2GoogleV2ToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsV2GoogleV2OutputReference | LinuxFunctionAppSlotAuthSettingsV2GoogleV2): any;
export declare class LinuxFunctionAppSlotAuthSettingsV2GoogleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsV2GoogleV2 | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsV2GoogleV2 | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface LinuxFunctionAppSlotAuthSettingsV2Login {
    /**
    * External URLs that can be redirected to as part of logging in or logging out of the app. This is an advanced setting typically only needed by Windows Store application backends. **Note:** URLs within the current domain are always implicitly allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#allowed_external_redirect_urls LinuxFunctionAppSlot#allowed_external_redirect_urls}
    */
    readonly allowedExternalRedirectUrls?: string[];
    /**
    * The method by which cookies expire. Possible values include: `FixedTime`, and `IdentityProviderDerived`. Defaults to `FixedTime`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#cookie_expiration_convention LinuxFunctionAppSlot#cookie_expiration_convention}
    */
    readonly cookieExpirationConvention?: string;
    /**
    * The time after the request is made when the session cookie should expire. Defaults to `08:00:00`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#cookie_expiration_time LinuxFunctionAppSlot#cookie_expiration_time}
    */
    readonly cookieExpirationTime?: string;
    /**
    * The endpoint to which logout requests should be made.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#logout_endpoint LinuxFunctionAppSlot#logout_endpoint}
    */
    readonly logoutEndpoint?: string;
    /**
    * The time after the request is made when the nonce should expire. Defaults to `00:05:00`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#nonce_expiration_time LinuxFunctionAppSlot#nonce_expiration_time}
    */
    readonly nonceExpirationTime?: string;
    /**
    * Should the fragments from the request be preserved after the login request is made. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#preserve_url_fragments_for_logins LinuxFunctionAppSlot#preserve_url_fragments_for_logins}
    */
    readonly preserveUrlFragmentsForLogins?: boolean | cdktf.IResolvable;
    /**
    * The number of hours after session token expiration that a session token can be used to call the token refresh API. Defaults to `72` hours.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#token_refresh_extension_time LinuxFunctionAppSlot#token_refresh_extension_time}
    */
    readonly tokenRefreshExtensionTime?: number;
    /**
    * Should the Token Store configuration Enabled. Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#token_store_enabled LinuxFunctionAppSlot#token_store_enabled}
    */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * The directory path in the App Filesystem in which the tokens will be stored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#token_store_path LinuxFunctionAppSlot#token_store_path}
    */
    readonly tokenStorePath?: string;
    /**
    * The name of the app setting which contains the SAS URL of the blob storage containing the tokens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#token_store_sas_setting_name LinuxFunctionAppSlot#token_store_sas_setting_name}
    */
    readonly tokenStoreSasSettingName?: string;
    /**
    * Should the nonce be validated while completing the login flow. Defaults to `true`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#validate_nonce LinuxFunctionAppSlot#validate_nonce}
    */
    readonly validateNonce?: boolean | cdktf.IResolvable;
}
export declare function linuxFunctionAppSlotAuthSettingsV2LoginToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsV2LoginOutputReference | LinuxFunctionAppSlotAuthSettingsV2Login): any;
export declare class LinuxFunctionAppSlotAuthSettingsV2LoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsV2Login | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsV2Login | undefined);
    private _allowedExternalRedirectUrls?;
    get allowedExternalRedirectUrls(): string[];
    set allowedExternalRedirectUrls(value: string[]);
    resetAllowedExternalRedirectUrls(): void;
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _cookieExpirationConvention?;
    get cookieExpirationConvention(): string;
    set cookieExpirationConvention(value: string);
    resetCookieExpirationConvention(): void;
    get cookieExpirationConventionInput(): string | undefined;
    private _cookieExpirationTime?;
    get cookieExpirationTime(): string;
    set cookieExpirationTime(value: string);
    resetCookieExpirationTime(): void;
    get cookieExpirationTimeInput(): string | undefined;
    private _logoutEndpoint?;
    get logoutEndpoint(): string;
    set logoutEndpoint(value: string);
    resetLogoutEndpoint(): void;
    get logoutEndpointInput(): string | undefined;
    private _nonceExpirationTime?;
    get nonceExpirationTime(): string;
    set nonceExpirationTime(value: string);
    resetNonceExpirationTime(): void;
    get nonceExpirationTimeInput(): string | undefined;
    private _preserveUrlFragmentsForLogins?;
    get preserveUrlFragmentsForLogins(): boolean | cdktf.IResolvable;
    set preserveUrlFragmentsForLogins(value: boolean | cdktf.IResolvable);
    resetPreserveUrlFragmentsForLogins(): void;
    get preserveUrlFragmentsForLoginsInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenRefreshExtensionTime?;
    get tokenRefreshExtensionTime(): number;
    set tokenRefreshExtensionTime(value: number);
    resetTokenRefreshExtensionTime(): void;
    get tokenRefreshExtensionTimeInput(): number | undefined;
    private _tokenStoreEnabled?;
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    resetTokenStoreEnabled(): void;
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenStorePath?;
    get tokenStorePath(): string;
    set tokenStorePath(value: string);
    resetTokenStorePath(): void;
    get tokenStorePathInput(): string | undefined;
    private _tokenStoreSasSettingName?;
    get tokenStoreSasSettingName(): string;
    set tokenStoreSasSettingName(value: string);
    resetTokenStoreSasSettingName(): void;
    get tokenStoreSasSettingNameInput(): string | undefined;
    private _validateNonce?;
    get validateNonce(): boolean | cdktf.IResolvable;
    set validateNonce(value: boolean | cdktf.IResolvable);
    resetValidateNonce(): void;
    get validateNonceInput(): boolean | cdktf.IResolvable | undefined;
}
export interface LinuxFunctionAppSlotAuthSettingsV2MicrosoftV2 {
    /**
    * Specifies a list of Allowed Audiences that will be requested as part of Microsoft Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#allowed_audiences LinuxFunctionAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The OAuth 2.0 client ID that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_id LinuxFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name containing the OAuth 2.0 client secret that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#client_secret_setting_name LinuxFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * The list of Login scopes that will be requested as part of Microsoft Account authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#login_scopes LinuxFunctionAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function linuxFunctionAppSlotAuthSettingsV2MicrosoftV2ToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsV2MicrosoftV2OutputReference | LinuxFunctionAppSlotAuthSettingsV2MicrosoftV2): any;
export declare class LinuxFunctionAppSlotAuthSettingsV2MicrosoftV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsV2MicrosoftV2 | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsV2MicrosoftV2 | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface LinuxFunctionAppSlotAuthSettingsV2TwitterV2 {
    /**
    * The OAuth 1.0a consumer key of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#consumer_key LinuxFunctionAppSlot#consumer_key}
    */
    readonly consumerKey: string;
    /**
    * The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#consumer_secret_setting_name LinuxFunctionAppSlot#consumer_secret_setting_name}
    */
    readonly consumerSecretSettingName: string;
}
export declare function linuxFunctionAppSlotAuthSettingsV2TwitterV2ToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsV2TwitterV2OutputReference | LinuxFunctionAppSlotAuthSettingsV2TwitterV2): any;
export declare class LinuxFunctionAppSlotAuthSettingsV2TwitterV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsV2TwitterV2 | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsV2TwitterV2 | undefined);
    private _consumerKey?;
    get consumerKey(): string;
    set consumerKey(value: string);
    get consumerKeyInput(): string | undefined;
    private _consumerSecretSettingName?;
    get consumerSecretSettingName(): string;
    set consumerSecretSettingName(value: string);
    get consumerSecretSettingNameInput(): string | undefined;
}
export interface LinuxFunctionAppSlotAuthSettingsV2 {
    /**
    * Should the AuthV2 Settings be enabled. Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#auth_enabled LinuxFunctionAppSlot#auth_enabled}
    */
    readonly authEnabled?: boolean | cdktf.IResolvable;
    /**
    * The path to the App Auth settings. **Note:** Relative Paths are evaluated from the Site Root directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#config_file_path LinuxFunctionAppSlot#config_file_path}
    */
    readonly configFilePath?: string;
    /**
    * The Default Authentication Provider to use when the `unauthenticated_action` is set to `RedirectToLoginPage`. Possible values include: `apple`, `azureactivedirectory`, `facebook`, `github`, `google`, `twitter` and the `name` of your `custom_oidc_v2` provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#default_provider LinuxFunctionAppSlot#default_provider}
    */
    readonly defaultProvider?: string;
    /**
    * The paths which should be excluded from the `unauthenticated_action` when it is set to `RedirectToLoginPage`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#excluded_paths LinuxFunctionAppSlot#excluded_paths}
    */
    readonly excludedPaths?: string[];
    /**
    * The convention used to determine the url of the request made. Possible values include `ForwardProxyConventionNoProxy`, `ForwardProxyConventionStandard`, `ForwardProxyConventionCustom`. Defaults to `ForwardProxyConventionNoProxy`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#forward_proxy_convention LinuxFunctionAppSlot#forward_proxy_convention}
    */
    readonly forwardProxyConvention?: string;
    /**
    * The name of the header containing the host of the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#forward_proxy_custom_host_header_name LinuxFunctionAppSlot#forward_proxy_custom_host_header_name}
    */
    readonly forwardProxyCustomHostHeaderName?: string;
    /**
    * The name of the header containing the scheme of the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#forward_proxy_custom_scheme_header_name LinuxFunctionAppSlot#forward_proxy_custom_scheme_header_name}
    */
    readonly forwardProxyCustomSchemeHeaderName?: string;
    /**
    * The prefix that should precede all the authentication and authorisation paths. Defaults to `/.auth`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#http_route_api_prefix LinuxFunctionAppSlot#http_route_api_prefix}
    */
    readonly httpRouteApiPrefix?: string;
    /**
    * Should the authentication flow be used for all requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#require_authentication LinuxFunctionAppSlot#require_authentication}
    */
    readonly requireAuthentication?: boolean | cdktf.IResolvable;
    /**
    * Should HTTPS be required on connections? Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#require_https LinuxFunctionAppSlot#require_https}
    */
    readonly requireHttps?: boolean | cdktf.IResolvable;
    /**
    * The Runtime Version of the Authentication and Authorisation feature of this App. Defaults to `~1`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#runtime_version LinuxFunctionAppSlot#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * The action to take for requests made without authentication. Possible values include `RedirectToLoginPage`, `AllowAnonymous`, `Return401`, and `Return403`. Defaults to `RedirectToLoginPage`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#unauthenticated_action LinuxFunctionAppSlot#unauthenticated_action}
    */
    readonly unauthenticatedAction?: string;
    /**
    * active_directory_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#active_directory_v2 LinuxFunctionAppSlot#active_directory_v2}
    */
    readonly activeDirectoryV2?: LinuxFunctionAppSlotAuthSettingsV2ActiveDirectoryV2;
    /**
    * apple_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#apple_v2 LinuxFunctionAppSlot#apple_v2}
    */
    readonly appleV2?: LinuxFunctionAppSlotAuthSettingsV2AppleV2;
    /**
    * azure_static_web_app_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#azure_static_web_app_v2 LinuxFunctionAppSlot#azure_static_web_app_v2}
    */
    readonly azureStaticWebAppV2?: LinuxFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2;
    /**
    * custom_oidc_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#custom_oidc_v2 LinuxFunctionAppSlot#custom_oidc_v2}
    */
    readonly customOidcV2?: LinuxFunctionAppSlotAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable;
    /**
    * facebook_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#facebook_v2 LinuxFunctionAppSlot#facebook_v2}
    */
    readonly facebookV2?: LinuxFunctionAppSlotAuthSettingsV2FacebookV2;
    /**
    * github_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#github_v2 LinuxFunctionAppSlot#github_v2}
    */
    readonly githubV2?: LinuxFunctionAppSlotAuthSettingsV2GithubV2;
    /**
    * google_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#google_v2 LinuxFunctionAppSlot#google_v2}
    */
    readonly googleV2?: LinuxFunctionAppSlotAuthSettingsV2GoogleV2;
    /**
    * login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#login LinuxFunctionAppSlot#login}
    */
    readonly login: LinuxFunctionAppSlotAuthSettingsV2Login;
    /**
    * microsoft_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#microsoft_v2 LinuxFunctionAppSlot#microsoft_v2}
    */
    readonly microsoftV2?: LinuxFunctionAppSlotAuthSettingsV2MicrosoftV2;
    /**
    * twitter_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#twitter_v2 LinuxFunctionAppSlot#twitter_v2}
    */
    readonly twitterV2?: LinuxFunctionAppSlotAuthSettingsV2TwitterV2;
}
export declare function linuxFunctionAppSlotAuthSettingsV2ToTerraform(struct?: LinuxFunctionAppSlotAuthSettingsV2OutputReference | LinuxFunctionAppSlotAuthSettingsV2): any;
export declare class LinuxFunctionAppSlotAuthSettingsV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotAuthSettingsV2 | undefined;
    set internalValue(value: LinuxFunctionAppSlotAuthSettingsV2 | undefined);
    private _authEnabled?;
    get authEnabled(): boolean | cdktf.IResolvable;
    set authEnabled(value: boolean | cdktf.IResolvable);
    resetAuthEnabled(): void;
    get authEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _configFilePath?;
    get configFilePath(): string;
    set configFilePath(value: string);
    resetConfigFilePath(): void;
    get configFilePathInput(): string | undefined;
    private _defaultProvider?;
    get defaultProvider(): string;
    set defaultProvider(value: string);
    resetDefaultProvider(): void;
    get defaultProviderInput(): string | undefined;
    private _excludedPaths?;
    get excludedPaths(): string[];
    set excludedPaths(value: string[]);
    resetExcludedPaths(): void;
    get excludedPathsInput(): string[] | undefined;
    private _forwardProxyConvention?;
    get forwardProxyConvention(): string;
    set forwardProxyConvention(value: string);
    resetForwardProxyConvention(): void;
    get forwardProxyConventionInput(): string | undefined;
    private _forwardProxyCustomHostHeaderName?;
    get forwardProxyCustomHostHeaderName(): string;
    set forwardProxyCustomHostHeaderName(value: string);
    resetForwardProxyCustomHostHeaderName(): void;
    get forwardProxyCustomHostHeaderNameInput(): string | undefined;
    private _forwardProxyCustomSchemeHeaderName?;
    get forwardProxyCustomSchemeHeaderName(): string;
    set forwardProxyCustomSchemeHeaderName(value: string);
    resetForwardProxyCustomSchemeHeaderName(): void;
    get forwardProxyCustomSchemeHeaderNameInput(): string | undefined;
    private _httpRouteApiPrefix?;
    get httpRouteApiPrefix(): string;
    set httpRouteApiPrefix(value: string);
    resetHttpRouteApiPrefix(): void;
    get httpRouteApiPrefixInput(): string | undefined;
    private _requireAuthentication?;
    get requireAuthentication(): boolean | cdktf.IResolvable;
    set requireAuthentication(value: boolean | cdktf.IResolvable);
    resetRequireAuthentication(): void;
    get requireAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _requireHttps?;
    get requireHttps(): boolean | cdktf.IResolvable;
    set requireHttps(value: boolean | cdktf.IResolvable);
    resetRequireHttps(): void;
    get requireHttpsInput(): boolean | cdktf.IResolvable | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _unauthenticatedAction?;
    get unauthenticatedAction(): string;
    set unauthenticatedAction(value: string);
    resetUnauthenticatedAction(): void;
    get unauthenticatedActionInput(): string | undefined;
    private _activeDirectoryV2;
    get activeDirectoryV2(): LinuxFunctionAppSlotAuthSettingsV2ActiveDirectoryV2OutputReference;
    putActiveDirectoryV2(value: LinuxFunctionAppSlotAuthSettingsV2ActiveDirectoryV2): void;
    resetActiveDirectoryV2(): void;
    get activeDirectoryV2Input(): LinuxFunctionAppSlotAuthSettingsV2ActiveDirectoryV2 | undefined;
    private _appleV2;
    get appleV2(): LinuxFunctionAppSlotAuthSettingsV2AppleV2OutputReference;
    putAppleV2(value: LinuxFunctionAppSlotAuthSettingsV2AppleV2): void;
    resetAppleV2(): void;
    get appleV2Input(): LinuxFunctionAppSlotAuthSettingsV2AppleV2 | undefined;
    private _azureStaticWebAppV2;
    get azureStaticWebAppV2(): LinuxFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2OutputReference;
    putAzureStaticWebAppV2(value: LinuxFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2): void;
    resetAzureStaticWebAppV2(): void;
    get azureStaticWebAppV2Input(): LinuxFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2 | undefined;
    private _customOidcV2;
    get customOidcV2(): LinuxFunctionAppSlotAuthSettingsV2CustomOidcV2List;
    putCustomOidcV2(value: LinuxFunctionAppSlotAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable): void;
    resetCustomOidcV2(): void;
    get customOidcV2Input(): cdktf.IResolvable | LinuxFunctionAppSlotAuthSettingsV2CustomOidcV2[] | undefined;
    private _facebookV2;
    get facebookV2(): LinuxFunctionAppSlotAuthSettingsV2FacebookV2OutputReference;
    putFacebookV2(value: LinuxFunctionAppSlotAuthSettingsV2FacebookV2): void;
    resetFacebookV2(): void;
    get facebookV2Input(): LinuxFunctionAppSlotAuthSettingsV2FacebookV2 | undefined;
    private _githubV2;
    get githubV2(): LinuxFunctionAppSlotAuthSettingsV2GithubV2OutputReference;
    putGithubV2(value: LinuxFunctionAppSlotAuthSettingsV2GithubV2): void;
    resetGithubV2(): void;
    get githubV2Input(): LinuxFunctionAppSlotAuthSettingsV2GithubV2 | undefined;
    private _googleV2;
    get googleV2(): LinuxFunctionAppSlotAuthSettingsV2GoogleV2OutputReference;
    putGoogleV2(value: LinuxFunctionAppSlotAuthSettingsV2GoogleV2): void;
    resetGoogleV2(): void;
    get googleV2Input(): LinuxFunctionAppSlotAuthSettingsV2GoogleV2 | undefined;
    private _login;
    get login(): LinuxFunctionAppSlotAuthSettingsV2LoginOutputReference;
    putLogin(value: LinuxFunctionAppSlotAuthSettingsV2Login): void;
    get loginInput(): LinuxFunctionAppSlotAuthSettingsV2Login | undefined;
    private _microsoftV2;
    get microsoftV2(): LinuxFunctionAppSlotAuthSettingsV2MicrosoftV2OutputReference;
    putMicrosoftV2(value: LinuxFunctionAppSlotAuthSettingsV2MicrosoftV2): void;
    resetMicrosoftV2(): void;
    get microsoftV2Input(): LinuxFunctionAppSlotAuthSettingsV2MicrosoftV2 | undefined;
    private _twitterV2;
    get twitterV2(): LinuxFunctionAppSlotAuthSettingsV2TwitterV2OutputReference;
    putTwitterV2(value: LinuxFunctionAppSlotAuthSettingsV2TwitterV2): void;
    resetTwitterV2(): void;
    get twitterV2Input(): LinuxFunctionAppSlotAuthSettingsV2TwitterV2 | undefined;
}
export interface LinuxFunctionAppSlotBackupSchedule {
    /**
    * How often the backup should be executed (e.g. for weekly backup, this should be set to `7` and `frequency_unit` should be set to `Day`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#frequency_interval LinuxFunctionAppSlot#frequency_interval}
    */
    readonly frequencyInterval: number;
    /**
    * The unit of time for how often the backup should take place. Possible values include: `Day` and `Hour`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#frequency_unit LinuxFunctionAppSlot#frequency_unit}
    */
    readonly frequencyUnit: string;
    /**
    * Should the service keep at least one backup, regardless of age of backup. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#keep_at_least_one_backup LinuxFunctionAppSlot#keep_at_least_one_backup}
    */
    readonly keepAtLeastOneBackup?: boolean | cdktf.IResolvable;
    /**
    * After how many days backups should be deleted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#retention_period_days LinuxFunctionAppSlot#retention_period_days}
    */
    readonly retentionPeriodDays?: number;
    /**
    * When the schedule should start working in RFC-3339 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#start_time LinuxFunctionAppSlot#start_time}
    */
    readonly startTime?: string;
}
export declare function linuxFunctionAppSlotBackupScheduleToTerraform(struct?: LinuxFunctionAppSlotBackupScheduleOutputReference | LinuxFunctionAppSlotBackupSchedule): any;
export declare class LinuxFunctionAppSlotBackupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotBackupSchedule | undefined;
    set internalValue(value: LinuxFunctionAppSlotBackupSchedule | undefined);
    private _frequencyInterval?;
    get frequencyInterval(): number;
    set frequencyInterval(value: number);
    get frequencyIntervalInput(): number | undefined;
    private _frequencyUnit?;
    get frequencyUnit(): string;
    set frequencyUnit(value: string);
    get frequencyUnitInput(): string | undefined;
    private _keepAtLeastOneBackup?;
    get keepAtLeastOneBackup(): boolean | cdktf.IResolvable;
    set keepAtLeastOneBackup(value: boolean | cdktf.IResolvable);
    resetKeepAtLeastOneBackup(): void;
    get keepAtLeastOneBackupInput(): boolean | cdktf.IResolvable | undefined;
    get lastExecutionTime(): string;
    private _retentionPeriodDays?;
    get retentionPeriodDays(): number;
    set retentionPeriodDays(value: number);
    resetRetentionPeriodDays(): void;
    get retentionPeriodDaysInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export interface LinuxFunctionAppSlotBackup {
    /**
    * Should this backup job be enabled?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#enabled LinuxFunctionAppSlot#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The name which should be used for this Backup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#name LinuxFunctionAppSlot#name}
    */
    readonly name: string;
    /**
    * The SAS URL to the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#storage_account_url LinuxFunctionAppSlot#storage_account_url}
    */
    readonly storageAccountUrl: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#schedule LinuxFunctionAppSlot#schedule}
    */
    readonly schedule: LinuxFunctionAppSlotBackupSchedule;
}
export declare function linuxFunctionAppSlotBackupToTerraform(struct?: LinuxFunctionAppSlotBackupOutputReference | LinuxFunctionAppSlotBackup): any;
export declare class LinuxFunctionAppSlotBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotBackup | undefined;
    set internalValue(value: LinuxFunctionAppSlotBackup | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountUrl?;
    get storageAccountUrl(): string;
    set storageAccountUrl(value: string);
    get storageAccountUrlInput(): string | undefined;
    private _schedule;
    get schedule(): LinuxFunctionAppSlotBackupScheduleOutputReference;
    putSchedule(value: LinuxFunctionAppSlotBackupSchedule): void;
    get scheduleInput(): LinuxFunctionAppSlotBackupSchedule | undefined;
}
export interface LinuxFunctionAppSlotConnectionString {
    /**
    * The name which should be used for this Connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#name LinuxFunctionAppSlot#name}
    */
    readonly name: string;
    /**
    * Type of database. Possible values include: `MySQL`, `SQLServer`, `SQLAzure`, `Custom`, `NotificationHub`, `ServiceBus`, `EventHub`, `APIHub`, `DocDb`, `RedisCache`, and `PostgreSQL`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#type LinuxFunctionAppSlot#type}
    */
    readonly type: string;
    /**
    * The connection string value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#value LinuxFunctionAppSlot#value}
    */
    readonly value: string;
}
export declare function linuxFunctionAppSlotConnectionStringToTerraform(struct?: LinuxFunctionAppSlotConnectionString | cdktf.IResolvable): any;
export declare class LinuxFunctionAppSlotConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxFunctionAppSlotConnectionString | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxFunctionAppSlotConnectionString | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class LinuxFunctionAppSlotConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxFunctionAppSlotConnectionString[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxFunctionAppSlotConnectionStringOutputReference;
}
export interface LinuxFunctionAppSlotIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#identity_ids LinuxFunctionAppSlot#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#type LinuxFunctionAppSlot#type}
    */
    readonly type: string;
}
export declare function linuxFunctionAppSlotIdentityToTerraform(struct?: LinuxFunctionAppSlotIdentityOutputReference | LinuxFunctionAppSlotIdentity): any;
export declare class LinuxFunctionAppSlotIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotIdentity | undefined;
    set internalValue(value: LinuxFunctionAppSlotIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface LinuxFunctionAppSlotSiteConfigAppServiceLogs {
    /**
    * The amount of disk space to use for logs. Valid values are between `25` and `100`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#disk_quota_mb LinuxFunctionAppSlot#disk_quota_mb}
    */
    readonly diskQuotaMb?: number;
    /**
    * The retention period for logs in days. Valid values are between `0` and `99999`. Defaults to `0` (never delete).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#retention_period_days LinuxFunctionAppSlot#retention_period_days}
    */
    readonly retentionPeriodDays?: number;
}
export declare function linuxFunctionAppSlotSiteConfigAppServiceLogsToTerraform(struct?: LinuxFunctionAppSlotSiteConfigAppServiceLogsOutputReference | LinuxFunctionAppSlotSiteConfigAppServiceLogs): any;
export declare class LinuxFunctionAppSlotSiteConfigAppServiceLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotSiteConfigAppServiceLogs | undefined;
    set internalValue(value: LinuxFunctionAppSlotSiteConfigAppServiceLogs | undefined);
    private _diskQuotaMb?;
    get diskQuotaMb(): number;
    set diskQuotaMb(value: number);
    resetDiskQuotaMb(): void;
    get diskQuotaMbInput(): number | undefined;
    private _retentionPeriodDays?;
    get retentionPeriodDays(): number;
    set retentionPeriodDays(value: number);
    resetRetentionPeriodDays(): void;
    get retentionPeriodDaysInput(): number | undefined;
}
export interface LinuxFunctionAppSlotSiteConfigApplicationStackDocker {
    /**
    * The name of the Docker image to use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#image_name LinuxFunctionAppSlot#image_name}
    */
    readonly imageName: string;
    /**
    * The image tag of the image to use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#image_tag LinuxFunctionAppSlot#image_tag}
    */
    readonly imageTag: string;
    /**
    * The password for the account to use to connect to the registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#registry_password LinuxFunctionAppSlot#registry_password}
    */
    readonly registryPassword?: string;
    /**
    * The URL of the docker registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#registry_url LinuxFunctionAppSlot#registry_url}
    */
    readonly registryUrl: string;
    /**
    * The username to use for connections to the registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#registry_username LinuxFunctionAppSlot#registry_username}
    */
    readonly registryUsername?: string;
}
export declare function linuxFunctionAppSlotSiteConfigApplicationStackDockerToTerraform(struct?: LinuxFunctionAppSlotSiteConfigApplicationStackDocker | cdktf.IResolvable): any;
export declare class LinuxFunctionAppSlotSiteConfigApplicationStackDockerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxFunctionAppSlotSiteConfigApplicationStackDocker | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxFunctionAppSlotSiteConfigApplicationStackDocker | cdktf.IResolvable | undefined);
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    get imageNameInput(): string | undefined;
    private _imageTag?;
    get imageTag(): string;
    set imageTag(value: string);
    get imageTagInput(): string | undefined;
    private _registryPassword?;
    get registryPassword(): string;
    set registryPassword(value: string);
    resetRegistryPassword(): void;
    get registryPasswordInput(): string | undefined;
    private _registryUrl?;
    get registryUrl(): string;
    set registryUrl(value: string);
    get registryUrlInput(): string | undefined;
    private _registryUsername?;
    get registryUsername(): string;
    set registryUsername(value: string);
    resetRegistryUsername(): void;
    get registryUsernameInput(): string | undefined;
}
export declare class LinuxFunctionAppSlotSiteConfigApplicationStackDockerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxFunctionAppSlotSiteConfigApplicationStackDocker[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxFunctionAppSlotSiteConfigApplicationStackDockerOutputReference;
}
export interface LinuxFunctionAppSlotSiteConfigApplicationStack {
    /**
    * The version of .Net. Possible values are `3.1`, `6.0` and `7.0`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#dotnet_version LinuxFunctionAppSlot#dotnet_version}
    */
    readonly dotnetVersion?: string;
    /**
    * The version of Java to use. Possible values are `8`, `11`, and `17`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#java_version LinuxFunctionAppSlot#java_version}
    */
    readonly javaVersion?: string;
    /**
    * The version of Node to use. Possible values include `12`, `14`, `16` and `18`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#node_version LinuxFunctionAppSlot#node_version}
    */
    readonly nodeVersion?: string;
    /**
    * The version of PowerShell Core to use. Possibles values are `7`, and `7.2`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#powershell_core_version LinuxFunctionAppSlot#powershell_core_version}
    */
    readonly powershellCoreVersion?: string;
    /**
    * The version of Python to use. Possible values include `3.11`, `3.10`, `3.9`, `3.8`, and `3.7`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#python_version LinuxFunctionAppSlot#python_version}
    */
    readonly pythonVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#use_custom_runtime LinuxFunctionAppSlot#use_custom_runtime}
    */
    readonly useCustomRuntime?: boolean | cdktf.IResolvable;
    /**
    * Should the DotNet process use an isolated runtime. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#use_dotnet_isolated_runtime LinuxFunctionAppSlot#use_dotnet_isolated_runtime}
    */
    readonly useDotnetIsolatedRuntime?: boolean | cdktf.IResolvable;
    /**
    * docker block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#docker LinuxFunctionAppSlot#docker}
    */
    readonly docker?: LinuxFunctionAppSlotSiteConfigApplicationStackDocker[] | cdktf.IResolvable;
}
export declare function linuxFunctionAppSlotSiteConfigApplicationStackToTerraform(struct?: LinuxFunctionAppSlotSiteConfigApplicationStackOutputReference | LinuxFunctionAppSlotSiteConfigApplicationStack): any;
export declare class LinuxFunctionAppSlotSiteConfigApplicationStackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotSiteConfigApplicationStack | undefined;
    set internalValue(value: LinuxFunctionAppSlotSiteConfigApplicationStack | undefined);
    private _dotnetVersion?;
    get dotnetVersion(): string;
    set dotnetVersion(value: string);
    resetDotnetVersion(): void;
    get dotnetVersionInput(): string | undefined;
    private _javaVersion?;
    get javaVersion(): string;
    set javaVersion(value: string);
    resetJavaVersion(): void;
    get javaVersionInput(): string | undefined;
    private _nodeVersion?;
    get nodeVersion(): string;
    set nodeVersion(value: string);
    resetNodeVersion(): void;
    get nodeVersionInput(): string | undefined;
    private _powershellCoreVersion?;
    get powershellCoreVersion(): string;
    set powershellCoreVersion(value: string);
    resetPowershellCoreVersion(): void;
    get powershellCoreVersionInput(): string | undefined;
    private _pythonVersion?;
    get pythonVersion(): string;
    set pythonVersion(value: string);
    resetPythonVersion(): void;
    get pythonVersionInput(): string | undefined;
    private _useCustomRuntime?;
    get useCustomRuntime(): boolean | cdktf.IResolvable;
    set useCustomRuntime(value: boolean | cdktf.IResolvable);
    resetUseCustomRuntime(): void;
    get useCustomRuntimeInput(): boolean | cdktf.IResolvable | undefined;
    private _useDotnetIsolatedRuntime?;
    get useDotnetIsolatedRuntime(): boolean | cdktf.IResolvable;
    set useDotnetIsolatedRuntime(value: boolean | cdktf.IResolvable);
    resetUseDotnetIsolatedRuntime(): void;
    get useDotnetIsolatedRuntimeInput(): boolean | cdktf.IResolvable | undefined;
    private _docker;
    get docker(): LinuxFunctionAppSlotSiteConfigApplicationStackDockerList;
    putDocker(value: LinuxFunctionAppSlotSiteConfigApplicationStackDocker[] | cdktf.IResolvable): void;
    resetDocker(): void;
    get dockerInput(): cdktf.IResolvable | LinuxFunctionAppSlotSiteConfigApplicationStackDocker[] | undefined;
}
export interface LinuxFunctionAppSlotSiteConfigCors {
    /**
    * Specifies a list of origins that should be allowed to make cross-origin calls.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#allowed_origins LinuxFunctionAppSlot#allowed_origins}
    */
    readonly allowedOrigins?: string[];
    /**
    * Are credentials allowed in CORS requests? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#support_credentials LinuxFunctionAppSlot#support_credentials}
    */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function linuxFunctionAppSlotSiteConfigCorsToTerraform(struct?: LinuxFunctionAppSlotSiteConfigCorsOutputReference | LinuxFunctionAppSlotSiteConfigCors): any;
export declare class LinuxFunctionAppSlotSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotSiteConfigCors | undefined;
    set internalValue(value: LinuxFunctionAppSlotSiteConfigCors | undefined);
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    resetAllowedOrigins(): void;
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    get supportCredentials(): boolean | cdktf.IResolvable;
    set supportCredentials(value: boolean | cdktf.IResolvable);
    resetSupportCredentials(): void;
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface LinuxFunctionAppSlotSiteConfigIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#x_azure_fdid LinuxFunctionAppSlot#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#x_fd_health_probe LinuxFunctionAppSlot#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#x_forwarded_for LinuxFunctionAppSlot#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#x_forwarded_host LinuxFunctionAppSlot#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function linuxFunctionAppSlotSiteConfigIpRestrictionHeadersToTerraform(struct?: LinuxFunctionAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class LinuxFunctionAppSlotSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxFunctionAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxFunctionAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class LinuxFunctionAppSlotSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxFunctionAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxFunctionAppSlotSiteConfigIpRestrictionHeadersOutputReference;
}
export interface LinuxFunctionAppSlotSiteConfigIpRestriction {
    /**
    * The action to take. Possible values are `Allow` or `Deny`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#action LinuxFunctionAppSlot#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#headers LinuxFunctionAppSlot#headers}
    */
    readonly headers?: LinuxFunctionAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * The CIDR notation of the IP or IP Range to match. For example: `10.0.0.0/24` or `192.168.10.1/32` or `fe80::/64` or `13.107.6.152/31,13.107.128.0/22`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#ip_address LinuxFunctionAppSlot#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The name which should be used for this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#name LinuxFunctionAppSlot#name}
    */
    readonly name?: string;
    /**
    * The priority value of this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#priority LinuxFunctionAppSlot#priority}
    */
    readonly priority?: number;
    /**
    * The Service Tag used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#service_tag LinuxFunctionAppSlot#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * The Virtual Network Subnet ID used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#virtual_network_subnet_id LinuxFunctionAppSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function linuxFunctionAppSlotSiteConfigIpRestrictionToTerraform(struct?: LinuxFunctionAppSlotSiteConfigIpRestriction | cdktf.IResolvable): any;
export declare class LinuxFunctionAppSlotSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxFunctionAppSlotSiteConfigIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxFunctionAppSlotSiteConfigIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _headers;
    get headers(): LinuxFunctionAppSlotSiteConfigIpRestrictionHeadersList;
    putHeaders(value: LinuxFunctionAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | LinuxFunctionAppSlotSiteConfigIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class LinuxFunctionAppSlotSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxFunctionAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxFunctionAppSlotSiteConfigIpRestrictionOutputReference;
}
export interface LinuxFunctionAppSlotSiteConfigScmIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#x_azure_fdid LinuxFunctionAppSlot#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#x_fd_health_probe LinuxFunctionAppSlot#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#x_forwarded_for LinuxFunctionAppSlot#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#x_forwarded_host LinuxFunctionAppSlot#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function linuxFunctionAppSlotSiteConfigScmIpRestrictionHeadersToTerraform(struct?: LinuxFunctionAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class LinuxFunctionAppSlotSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxFunctionAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxFunctionAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class LinuxFunctionAppSlotSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxFunctionAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxFunctionAppSlotSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface LinuxFunctionAppSlotSiteConfigScmIpRestriction {
    /**
    * The action to take. Possible values are `Allow` or `Deny`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#action LinuxFunctionAppSlot#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#headers LinuxFunctionAppSlot#headers}
    */
    readonly headers?: LinuxFunctionAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * The CIDR notation of the IP or IP Range to match. For example: `10.0.0.0/24` or `192.168.10.1/32` or `fe80::/64` or `13.107.6.152/31,13.107.128.0/22`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#ip_address LinuxFunctionAppSlot#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The name which should be used for this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#name LinuxFunctionAppSlot#name}
    */
    readonly name?: string;
    /**
    * The priority value of this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#priority LinuxFunctionAppSlot#priority}
    */
    readonly priority?: number;
    /**
    * The Service Tag used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#service_tag LinuxFunctionAppSlot#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * The Virtual Network Subnet ID used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#virtual_network_subnet_id LinuxFunctionAppSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function linuxFunctionAppSlotSiteConfigScmIpRestrictionToTerraform(struct?: LinuxFunctionAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable): any;
export declare class LinuxFunctionAppSlotSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxFunctionAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxFunctionAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _headers;
    get headers(): LinuxFunctionAppSlotSiteConfigScmIpRestrictionHeadersList;
    putHeaders(value: LinuxFunctionAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | LinuxFunctionAppSlotSiteConfigScmIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class LinuxFunctionAppSlotSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxFunctionAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxFunctionAppSlotSiteConfigScmIpRestrictionOutputReference;
}
export interface LinuxFunctionAppSlotSiteConfig {
    /**
    * If this Linux Web App is Always On enabled. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#always_on LinuxFunctionAppSlot#always_on}
    */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
    * The URL of the API definition that describes this Linux Function App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#api_definition_url LinuxFunctionAppSlot#api_definition_url}
    */
    readonly apiDefinitionUrl?: string;
    /**
    * The ID of the API Management API for this Linux Function App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#api_management_api_id LinuxFunctionAppSlot#api_management_api_id}
    */
    readonly apiManagementApiId?: string;
    /**
    * The program and any arguments used to launch this app via the command line. (Example `node myapp.js`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#app_command_line LinuxFunctionAppSlot#app_command_line}
    */
    readonly appCommandLine?: string;
    /**
    * The number of workers this function app can scale out to. Only applicable to apps on the Consumption and Premium plan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#app_scale_limit LinuxFunctionAppSlot#app_scale_limit}
    */
    readonly appScaleLimit?: number;
    /**
    * The Connection String for linking the Linux Function App to Application Insights.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#application_insights_connection_string LinuxFunctionAppSlot#application_insights_connection_string}
    */
    readonly applicationInsightsConnectionString?: string;
    /**
    * The Instrumentation Key for connecting the Linux Function App to Application Insights.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#application_insights_key LinuxFunctionAppSlot#application_insights_key}
    */
    readonly applicationInsightsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#auto_swap_slot_name LinuxFunctionAppSlot#auto_swap_slot_name}
    */
    readonly autoSwapSlotName?: string;
    /**
    * The Client ID of the Managed Service Identity to use for connections to the Azure Container Registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#container_registry_managed_identity_client_id LinuxFunctionAppSlot#container_registry_managed_identity_client_id}
    */
    readonly containerRegistryManagedIdentityClientId?: string;
    /**
    * Should connections for Azure Container Registry use Managed Identity.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#container_registry_use_managed_identity LinuxFunctionAppSlot#container_registry_use_managed_identity}
    */
    readonly containerRegistryUseManagedIdentity?: boolean | cdktf.IResolvable;
    /**
    * Specifies a list of Default Documents for the Linux Web App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#default_documents LinuxFunctionAppSlot#default_documents}
    */
    readonly defaultDocuments?: string[];
    /**
    * The number of minimum instances for this Linux Function App. Only affects apps on Elastic Premium plans.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#elastic_instance_minimum LinuxFunctionAppSlot#elastic_instance_minimum}
    */
    readonly elasticInstanceMinimum?: number;
    /**
    * State of FTP / FTPS service for this function app. Possible values include: `AllAllowed`, `FtpsOnly` and `Disabled`. Defaults to `Disabled`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#ftps_state LinuxFunctionAppSlot#ftps_state}
    */
    readonly ftpsState?: string;
    /**
    * The amount of time in minutes that a node is unhealthy before being removed from the load balancer. Possible values are between `2` and `10`. Defaults to `10`. Only valid in conjunction with `health_check_path`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#health_check_eviction_time_in_min LinuxFunctionAppSlot#health_check_eviction_time_in_min}
    */
    readonly healthCheckEvictionTimeInMin?: number;
    /**
    * The path to be checked for this function app health.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#health_check_path LinuxFunctionAppSlot#health_check_path}
    */
    readonly healthCheckPath?: string;
    /**
    * Specifies if the http2 protocol should be enabled. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#http2_enabled LinuxFunctionAppSlot#http2_enabled}
    */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
    * The Site load balancing mode. Possible values include: `WeightedRoundRobin`, `LeastRequests`, `LeastResponseTime`, `WeightedTotalTraffic`, `RequestHash`, `PerSiteRoundRobin`. Defaults to `LeastRequests` if omitted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#load_balancing_mode LinuxFunctionAppSlot#load_balancing_mode}
    */
    readonly loadBalancingMode?: string;
    /**
    * The Managed Pipeline mode. Possible values include: `Integrated`, `Classic`. Defaults to `Integrated`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#managed_pipeline_mode LinuxFunctionAppSlot#managed_pipeline_mode}
    */
    readonly managedPipelineMode?: string;
    /**
    * The configures the minimum version of TLS required for SSL requests. Possible values include: `1.0`, `1.1`, and  `1.2`. Defaults to `1.2`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#minimum_tls_version LinuxFunctionAppSlot#minimum_tls_version}
    */
    readonly minimumTlsVersion?: string;
    /**
    * The number of pre-warmed instances for this function app. Only affects apps on an Elastic Premium plan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#pre_warmed_instance_count LinuxFunctionAppSlot#pre_warmed_instance_count}
    */
    readonly preWarmedInstanceCount?: number;
    /**
    * Should Remote Debugging be enabled. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#remote_debugging_enabled LinuxFunctionAppSlot#remote_debugging_enabled}
    */
    readonly remoteDebuggingEnabled?: boolean | cdktf.IResolvable;
    /**
    * The Remote Debugging Version. Possible values include `VS2017`, `VS2019`, and `VS2022`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#remote_debugging_version LinuxFunctionAppSlot#remote_debugging_version}
    */
    readonly remoteDebuggingVersion?: string;
    /**
    * Should Functions Runtime Scale Monitoring be enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#runtime_scale_monitoring_enabled LinuxFunctionAppSlot#runtime_scale_monitoring_enabled}
    */
    readonly runtimeScaleMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
    * Configures the minimum version of TLS required for SSL requests to the SCM site Possible values include: `1.0`, `1.1`, and  `1.2`. Defaults to `1.2`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#scm_minimum_tls_version LinuxFunctionAppSlot#scm_minimum_tls_version}
    */
    readonly scmMinimumTlsVersion?: string;
    /**
    * Should the Linux Function App `ip_restriction` configuration be used for the SCM also.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#scm_use_main_ip_restriction LinuxFunctionAppSlot#scm_use_main_ip_restriction}
    */
    readonly scmUseMainIpRestriction?: boolean | cdktf.IResolvable;
    /**
    * Should the Linux Web App use a 32-bit worker.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#use_32_bit_worker LinuxFunctionAppSlot#use_32_bit_worker}
    */
    readonly use32BitWorker?: boolean | cdktf.IResolvable;
    /**
    * Should all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#vnet_route_all_enabled LinuxFunctionAppSlot#vnet_route_all_enabled}
    */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
    * Should Web Sockets be enabled. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#websockets_enabled LinuxFunctionAppSlot#websockets_enabled}
    */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
    * The number of Workers for this Linux Function App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#worker_count LinuxFunctionAppSlot#worker_count}
    */
    readonly workerCount?: number;
    /**
    * app_service_logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#app_service_logs LinuxFunctionAppSlot#app_service_logs}
    */
    readonly appServiceLogs?: LinuxFunctionAppSlotSiteConfigAppServiceLogs;
    /**
    * application_stack block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#application_stack LinuxFunctionAppSlot#application_stack}
    */
    readonly applicationStack?: LinuxFunctionAppSlotSiteConfigApplicationStack;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#cors LinuxFunctionAppSlot#cors}
    */
    readonly cors?: LinuxFunctionAppSlotSiteConfigCors;
    /**
    * ip_restriction block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#ip_restriction LinuxFunctionAppSlot#ip_restriction}
    */
    readonly ipRestriction?: LinuxFunctionAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * scm_ip_restriction block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#scm_ip_restriction LinuxFunctionAppSlot#scm_ip_restriction}
    */
    readonly scmIpRestriction?: LinuxFunctionAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable;
}
export declare function linuxFunctionAppSlotSiteConfigToTerraform(struct?: LinuxFunctionAppSlotSiteConfigOutputReference | LinuxFunctionAppSlotSiteConfig): any;
export declare class LinuxFunctionAppSlotSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotSiteConfig | undefined;
    set internalValue(value: LinuxFunctionAppSlotSiteConfig | undefined);
    private _alwaysOn?;
    get alwaysOn(): boolean | cdktf.IResolvable;
    set alwaysOn(value: boolean | cdktf.IResolvable);
    resetAlwaysOn(): void;
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _apiDefinitionUrl?;
    get apiDefinitionUrl(): string;
    set apiDefinitionUrl(value: string);
    resetApiDefinitionUrl(): void;
    get apiDefinitionUrlInput(): string | undefined;
    private _apiManagementApiId?;
    get apiManagementApiId(): string;
    set apiManagementApiId(value: string);
    resetApiManagementApiId(): void;
    get apiManagementApiIdInput(): string | undefined;
    private _appCommandLine?;
    get appCommandLine(): string;
    set appCommandLine(value: string);
    resetAppCommandLine(): void;
    get appCommandLineInput(): string | undefined;
    private _appScaleLimit?;
    get appScaleLimit(): number;
    set appScaleLimit(value: number);
    resetAppScaleLimit(): void;
    get appScaleLimitInput(): number | undefined;
    private _applicationInsightsConnectionString?;
    get applicationInsightsConnectionString(): string;
    set applicationInsightsConnectionString(value: string);
    resetApplicationInsightsConnectionString(): void;
    get applicationInsightsConnectionStringInput(): string | undefined;
    private _applicationInsightsKey?;
    get applicationInsightsKey(): string;
    set applicationInsightsKey(value: string);
    resetApplicationInsightsKey(): void;
    get applicationInsightsKeyInput(): string | undefined;
    private _autoSwapSlotName?;
    get autoSwapSlotName(): string;
    set autoSwapSlotName(value: string);
    resetAutoSwapSlotName(): void;
    get autoSwapSlotNameInput(): string | undefined;
    private _containerRegistryManagedIdentityClientId?;
    get containerRegistryManagedIdentityClientId(): string;
    set containerRegistryManagedIdentityClientId(value: string);
    resetContainerRegistryManagedIdentityClientId(): void;
    get containerRegistryManagedIdentityClientIdInput(): string | undefined;
    private _containerRegistryUseManagedIdentity?;
    get containerRegistryUseManagedIdentity(): boolean | cdktf.IResolvable;
    set containerRegistryUseManagedIdentity(value: boolean | cdktf.IResolvable);
    resetContainerRegistryUseManagedIdentity(): void;
    get containerRegistryUseManagedIdentityInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultDocuments?;
    get defaultDocuments(): string[];
    set defaultDocuments(value: string[]);
    resetDefaultDocuments(): void;
    get defaultDocumentsInput(): string[] | undefined;
    get detailedErrorLoggingEnabled(): cdktf.IResolvable;
    private _elasticInstanceMinimum?;
    get elasticInstanceMinimum(): number;
    set elasticInstanceMinimum(value: number);
    resetElasticInstanceMinimum(): void;
    get elasticInstanceMinimumInput(): number | undefined;
    private _ftpsState?;
    get ftpsState(): string;
    set ftpsState(value: string);
    resetFtpsState(): void;
    get ftpsStateInput(): string | undefined;
    private _healthCheckEvictionTimeInMin?;
    get healthCheckEvictionTimeInMin(): number;
    set healthCheckEvictionTimeInMin(value: number);
    resetHealthCheckEvictionTimeInMin(): void;
    get healthCheckEvictionTimeInMinInput(): number | undefined;
    private _healthCheckPath?;
    get healthCheckPath(): string;
    set healthCheckPath(value: string);
    resetHealthCheckPath(): void;
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    get http2Enabled(): boolean | cdktf.IResolvable;
    set http2Enabled(value: boolean | cdktf.IResolvable);
    resetHttp2Enabled(): void;
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    get linuxFxVersion(): string;
    private _loadBalancingMode?;
    get loadBalancingMode(): string;
    set loadBalancingMode(value: string);
    resetLoadBalancingMode(): void;
    get loadBalancingModeInput(): string | undefined;
    private _managedPipelineMode?;
    get managedPipelineMode(): string;
    set managedPipelineMode(value: string);
    resetManagedPipelineMode(): void;
    get managedPipelineModeInput(): string | undefined;
    private _minimumTlsVersion?;
    get minimumTlsVersion(): string;
    set minimumTlsVersion(value: string);
    resetMinimumTlsVersion(): void;
    get minimumTlsVersionInput(): string | undefined;
    private _preWarmedInstanceCount?;
    get preWarmedInstanceCount(): number;
    set preWarmedInstanceCount(value: number);
    resetPreWarmedInstanceCount(): void;
    get preWarmedInstanceCountInput(): number | undefined;
    private _remoteDebuggingEnabled?;
    get remoteDebuggingEnabled(): boolean | cdktf.IResolvable;
    set remoteDebuggingEnabled(value: boolean | cdktf.IResolvable);
    resetRemoteDebuggingEnabled(): void;
    get remoteDebuggingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _remoteDebuggingVersion?;
    get remoteDebuggingVersion(): string;
    set remoteDebuggingVersion(value: string);
    resetRemoteDebuggingVersion(): void;
    get remoteDebuggingVersionInput(): string | undefined;
    private _runtimeScaleMonitoringEnabled?;
    get runtimeScaleMonitoringEnabled(): boolean | cdktf.IResolvable;
    set runtimeScaleMonitoringEnabled(value: boolean | cdktf.IResolvable);
    resetRuntimeScaleMonitoringEnabled(): void;
    get runtimeScaleMonitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _scmMinimumTlsVersion?;
    get scmMinimumTlsVersion(): string;
    set scmMinimumTlsVersion(value: string);
    resetScmMinimumTlsVersion(): void;
    get scmMinimumTlsVersionInput(): string | undefined;
    get scmType(): string;
    private _scmUseMainIpRestriction?;
    get scmUseMainIpRestriction(): boolean | cdktf.IResolvable;
    set scmUseMainIpRestriction(value: boolean | cdktf.IResolvable);
    resetScmUseMainIpRestriction(): void;
    get scmUseMainIpRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorker?;
    get use32BitWorker(): boolean | cdktf.IResolvable;
    set use32BitWorker(value: boolean | cdktf.IResolvable);
    resetUse32BitWorker(): void;
    get use32BitWorkerInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    resetVnetRouteAllEnabled(): void;
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    resetWebsocketsEnabled(): void;
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _workerCount?;
    get workerCount(): number;
    set workerCount(value: number);
    resetWorkerCount(): void;
    get workerCountInput(): number | undefined;
    private _appServiceLogs;
    get appServiceLogs(): LinuxFunctionAppSlotSiteConfigAppServiceLogsOutputReference;
    putAppServiceLogs(value: LinuxFunctionAppSlotSiteConfigAppServiceLogs): void;
    resetAppServiceLogs(): void;
    get appServiceLogsInput(): LinuxFunctionAppSlotSiteConfigAppServiceLogs | undefined;
    private _applicationStack;
    get applicationStack(): LinuxFunctionAppSlotSiteConfigApplicationStackOutputReference;
    putApplicationStack(value: LinuxFunctionAppSlotSiteConfigApplicationStack): void;
    resetApplicationStack(): void;
    get applicationStackInput(): LinuxFunctionAppSlotSiteConfigApplicationStack | undefined;
    private _cors;
    get cors(): LinuxFunctionAppSlotSiteConfigCorsOutputReference;
    putCors(value: LinuxFunctionAppSlotSiteConfigCors): void;
    resetCors(): void;
    get corsInput(): LinuxFunctionAppSlotSiteConfigCors | undefined;
    private _ipRestriction;
    get ipRestriction(): LinuxFunctionAppSlotSiteConfigIpRestrictionList;
    putIpRestriction(value: LinuxFunctionAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable): void;
    resetIpRestriction(): void;
    get ipRestrictionInput(): cdktf.IResolvable | LinuxFunctionAppSlotSiteConfigIpRestriction[] | undefined;
    private _scmIpRestriction;
    get scmIpRestriction(): LinuxFunctionAppSlotSiteConfigScmIpRestrictionList;
    putScmIpRestriction(value: LinuxFunctionAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable): void;
    resetScmIpRestriction(): void;
    get scmIpRestrictionInput(): cdktf.IResolvable | LinuxFunctionAppSlotSiteConfigScmIpRestriction[] | undefined;
}
export interface LinuxFunctionAppSlotStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#access_key LinuxFunctionAppSlot#access_key}
    */
    readonly accessKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#account_name LinuxFunctionAppSlot#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#mount_path LinuxFunctionAppSlot#mount_path}
    */
    readonly mountPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#name LinuxFunctionAppSlot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#share_name LinuxFunctionAppSlot#share_name}
    */
    readonly shareName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#type LinuxFunctionAppSlot#type}
    */
    readonly type: string;
}
export declare function linuxFunctionAppSlotStorageAccountToTerraform(struct?: LinuxFunctionAppSlotStorageAccount | cdktf.IResolvable): any;
export declare class LinuxFunctionAppSlotStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxFunctionAppSlotStorageAccount | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxFunctionAppSlotStorageAccount | cdktf.IResolvable | undefined);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    get accessKeyInput(): string | undefined;
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    resetMountPath(): void;
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class LinuxFunctionAppSlotStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxFunctionAppSlotStorageAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxFunctionAppSlotStorageAccountOutputReference;
}
export interface LinuxFunctionAppSlotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#create LinuxFunctionAppSlot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#delete LinuxFunctionAppSlot#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#read LinuxFunctionAppSlot#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#update LinuxFunctionAppSlot#update}
    */
    readonly update?: string;
}
export declare function linuxFunctionAppSlotTimeoutsToTerraform(struct?: LinuxFunctionAppSlotTimeouts | cdktf.IResolvable): any;
export declare class LinuxFunctionAppSlotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxFunctionAppSlotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxFunctionAppSlotTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot azurerm_linux_function_app_slot}
*/
export declare class LinuxFunctionAppSlot extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_linux_function_app_slot";
    /**
    * Generates CDKTF code for importing a LinuxFunctionAppSlot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LinuxFunctionAppSlot to import
    * @param importFromId The id of the existing LinuxFunctionAppSlot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LinuxFunctionAppSlot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/linux_function_app_slot azurerm_linux_function_app_slot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LinuxFunctionAppSlotConfig
    */
    constructor(scope: Construct, id: string, config: LinuxFunctionAppSlotConfig);
    private _appSettings?;
    get appSettings(): {
        [key: string]: string;
    };
    set appSettings(value: {
        [key: string]: string;
    });
    resetAppSettings(): void;
    get appSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _builtinLoggingEnabled?;
    get builtinLoggingEnabled(): boolean | cdktf.IResolvable;
    set builtinLoggingEnabled(value: boolean | cdktf.IResolvable);
    resetBuiltinLoggingEnabled(): void;
    get builtinLoggingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertificateEnabled?;
    get clientCertificateEnabled(): boolean | cdktf.IResolvable;
    set clientCertificateEnabled(value: boolean | cdktf.IResolvable);
    resetClientCertificateEnabled(): void;
    get clientCertificateEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertificateExclusionPaths?;
    get clientCertificateExclusionPaths(): string;
    set clientCertificateExclusionPaths(value: string);
    resetClientCertificateExclusionPaths(): void;
    get clientCertificateExclusionPathsInput(): string | undefined;
    private _clientCertificateMode?;
    get clientCertificateMode(): string;
    set clientCertificateMode(value: string);
    resetClientCertificateMode(): void;
    get clientCertificateModeInput(): string | undefined;
    private _contentShareForceDisabled?;
    get contentShareForceDisabled(): boolean | cdktf.IResolvable;
    set contentShareForceDisabled(value: boolean | cdktf.IResolvable);
    resetContentShareForceDisabled(): void;
    get contentShareForceDisabledInput(): boolean | cdktf.IResolvable | undefined;
    get customDomainVerificationId(): string;
    private _dailyMemoryTimeQuota?;
    get dailyMemoryTimeQuota(): number;
    set dailyMemoryTimeQuota(value: number);
    resetDailyMemoryTimeQuota(): void;
    get dailyMemoryTimeQuotaInput(): number | undefined;
    get defaultHostname(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _functionAppId?;
    get functionAppId(): string;
    set functionAppId(value: string);
    get functionAppIdInput(): string | undefined;
    private _functionsExtensionVersion?;
    get functionsExtensionVersion(): string;
    set functionsExtensionVersion(value: string);
    resetFunctionsExtensionVersion(): void;
    get functionsExtensionVersionInput(): string | undefined;
    get hostingEnvironmentId(): string;
    private _httpsOnly?;
    get httpsOnly(): boolean | cdktf.IResolvable;
    set httpsOnly(value: boolean | cdktf.IResolvable);
    resetHttpsOnly(): void;
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultReferenceIdentityId?;
    get keyVaultReferenceIdentityId(): string;
    set keyVaultReferenceIdentityId(value: string);
    resetKeyVaultReferenceIdentityId(): void;
    get keyVaultReferenceIdentityIdInput(): string | undefined;
    get kind(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddressList(): string[];
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddressList(): string[];
    get possibleOutboundIpAddresses(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _servicePlanId?;
    get servicePlanId(): string;
    set servicePlanId(value: string);
    resetServicePlanId(): void;
    get servicePlanIdInput(): string | undefined;
    private _siteCredential;
    get siteCredential(): LinuxFunctionAppSlotSiteCredentialList;
    private _storageAccountAccessKey?;
    get storageAccountAccessKey(): string;
    set storageAccountAccessKey(value: string);
    resetStorageAccountAccessKey(): void;
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    resetStorageAccountName(): void;
    get storageAccountNameInput(): string | undefined;
    private _storageKeyVaultSecretId?;
    get storageKeyVaultSecretId(): string;
    set storageKeyVaultSecretId(value: string);
    resetStorageKeyVaultSecretId(): void;
    get storageKeyVaultSecretIdInput(): string | undefined;
    private _storageUsesManagedIdentity?;
    get storageUsesManagedIdentity(): boolean | cdktf.IResolvable;
    set storageUsesManagedIdentity(value: boolean | cdktf.IResolvable);
    resetStorageUsesManagedIdentity(): void;
    get storageUsesManagedIdentityInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
    private _authSettings;
    get authSettings(): LinuxFunctionAppSlotAuthSettingsOutputReference;
    putAuthSettings(value: LinuxFunctionAppSlotAuthSettings): void;
    resetAuthSettings(): void;
    get authSettingsInput(): LinuxFunctionAppSlotAuthSettings | undefined;
    private _authSettingsV2;
    get authSettingsV2(): LinuxFunctionAppSlotAuthSettingsV2OutputReference;
    putAuthSettingsV2(value: LinuxFunctionAppSlotAuthSettingsV2): void;
    resetAuthSettingsV2(): void;
    get authSettingsV2Input(): LinuxFunctionAppSlotAuthSettingsV2 | undefined;
    private _backup;
    get backup(): LinuxFunctionAppSlotBackupOutputReference;
    putBackup(value: LinuxFunctionAppSlotBackup): void;
    resetBackup(): void;
    get backupInput(): LinuxFunctionAppSlotBackup | undefined;
    private _connectionString;
    get connectionString(): LinuxFunctionAppSlotConnectionStringList;
    putConnectionString(value: LinuxFunctionAppSlotConnectionString[] | cdktf.IResolvable): void;
    resetConnectionString(): void;
    get connectionStringInput(): cdktf.IResolvable | LinuxFunctionAppSlotConnectionString[] | undefined;
    private _identity;
    get identity(): LinuxFunctionAppSlotIdentityOutputReference;
    putIdentity(value: LinuxFunctionAppSlotIdentity): void;
    resetIdentity(): void;
    get identityInput(): LinuxFunctionAppSlotIdentity | undefined;
    private _siteConfig;
    get siteConfig(): LinuxFunctionAppSlotSiteConfigOutputReference;
    putSiteConfig(value: LinuxFunctionAppSlotSiteConfig): void;
    get siteConfigInput(): LinuxFunctionAppSlotSiteConfig | undefined;
    private _storageAccount;
    get storageAccount(): LinuxFunctionAppSlotStorageAccountList;
    putStorageAccount(value: LinuxFunctionAppSlotStorageAccount[] | cdktf.IResolvable): void;
    resetStorageAccount(): void;
    get storageAccountInput(): cdktf.IResolvable | LinuxFunctionAppSlotStorageAccount[] | undefined;
    private _timeouts;
    get timeouts(): LinuxFunctionAppSlotTimeoutsOutputReference;
    putTimeouts(value: LinuxFunctionAppSlotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LinuxFunctionAppSlotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
