/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MediaStreamingEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#auto_start_enabled MediaStreamingEndpoint#auto_start_enabled}
    */
    readonly autoStartEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#cdn_enabled MediaStreamingEndpoint#cdn_enabled}
    */
    readonly cdnEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#cdn_profile MediaStreamingEndpoint#cdn_profile}
    */
    readonly cdnProfile?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#cdn_provider MediaStreamingEndpoint#cdn_provider}
    */
    readonly cdnProvider?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#custom_host_names MediaStreamingEndpoint#custom_host_names}
    */
    readonly customHostNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#description MediaStreamingEndpoint#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#id MediaStreamingEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#location MediaStreamingEndpoint#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#max_cache_age_seconds MediaStreamingEndpoint#max_cache_age_seconds}
    */
    readonly maxCacheAgeSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#media_services_account_name MediaStreamingEndpoint#media_services_account_name}
    */
    readonly mediaServicesAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#name MediaStreamingEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#resource_group_name MediaStreamingEndpoint#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#scale_units MediaStreamingEndpoint#scale_units}
    */
    readonly scaleUnits: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#tags MediaStreamingEndpoint#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * access_control block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#access_control MediaStreamingEndpoint#access_control}
    */
    readonly accessControl?: MediaStreamingEndpointAccessControl;
    /**
    * cross_site_access_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#cross_site_access_policy MediaStreamingEndpoint#cross_site_access_policy}
    */
    readonly crossSiteAccessPolicy?: MediaStreamingEndpointCrossSiteAccessPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#timeouts MediaStreamingEndpoint#timeouts}
    */
    readonly timeouts?: MediaStreamingEndpointTimeouts;
}
export interface MediaStreamingEndpointSku {
}
export declare function mediaStreamingEndpointSkuToTerraform(struct?: MediaStreamingEndpointSku): any;
export declare class MediaStreamingEndpointSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaStreamingEndpointSku | undefined;
    set internalValue(value: MediaStreamingEndpointSku | undefined);
    get capacity(): number;
    get name(): string;
}
export declare class MediaStreamingEndpointSkuList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaStreamingEndpointSkuOutputReference;
}
export interface MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#base64_key MediaStreamingEndpoint#base64_key}
    */
    readonly base64Key?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#expiration MediaStreamingEndpoint#expiration}
    */
    readonly expiration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#identifier MediaStreamingEndpoint#identifier}
    */
    readonly identifier?: string;
}
export declare function mediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKeyToTerraform(struct?: MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKey | cdktf.IResolvable): any;
export declare class MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKey | cdktf.IResolvable | undefined;
    set internalValue(value: MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKey | cdktf.IResolvable | undefined);
    private _base64Key?;
    get base64Key(): string;
    set base64Key(value: string);
    resetBase64Key(): void;
    get base64KeyInput(): string | undefined;
    private _expiration?;
    get expiration(): string;
    set expiration(value: string);
    resetExpiration(): void;
    get expirationInput(): string | undefined;
    private _identifier?;
    get identifier(): string;
    set identifier(value: string);
    resetIdentifier(): void;
    get identifierInput(): string | undefined;
}
export declare class MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKey[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKeyOutputReference;
}
export interface MediaStreamingEndpointAccessControlIpAllow {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#address MediaStreamingEndpoint#address}
    */
    readonly address?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#name MediaStreamingEndpoint#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#subnet_prefix_length MediaStreamingEndpoint#subnet_prefix_length}
    */
    readonly subnetPrefixLength?: number;
}
export declare function mediaStreamingEndpointAccessControlIpAllowToTerraform(struct?: MediaStreamingEndpointAccessControlIpAllow | cdktf.IResolvable): any;
export declare class MediaStreamingEndpointAccessControlIpAllowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaStreamingEndpointAccessControlIpAllow | cdktf.IResolvable | undefined;
    set internalValue(value: MediaStreamingEndpointAccessControlIpAllow | cdktf.IResolvable | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _subnetPrefixLength?;
    get subnetPrefixLength(): number;
    set subnetPrefixLength(value: number);
    resetSubnetPrefixLength(): void;
    get subnetPrefixLengthInput(): number | undefined;
}
export declare class MediaStreamingEndpointAccessControlIpAllowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaStreamingEndpointAccessControlIpAllow[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaStreamingEndpointAccessControlIpAllowOutputReference;
}
export interface MediaStreamingEndpointAccessControl {
    /**
    * akamai_signature_header_authentication_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#akamai_signature_header_authentication_key MediaStreamingEndpoint#akamai_signature_header_authentication_key}
    */
    readonly akamaiSignatureHeaderAuthenticationKey?: MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKey[] | cdktf.IResolvable;
    /**
    * ip_allow block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#ip_allow MediaStreamingEndpoint#ip_allow}
    */
    readonly ipAllow?: MediaStreamingEndpointAccessControlIpAllow[] | cdktf.IResolvable;
}
export declare function mediaStreamingEndpointAccessControlToTerraform(struct?: MediaStreamingEndpointAccessControlOutputReference | MediaStreamingEndpointAccessControl): any;
export declare class MediaStreamingEndpointAccessControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingEndpointAccessControl | undefined;
    set internalValue(value: MediaStreamingEndpointAccessControl | undefined);
    private _akamaiSignatureHeaderAuthenticationKey;
    get akamaiSignatureHeaderAuthenticationKey(): MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKeyList;
    putAkamaiSignatureHeaderAuthenticationKey(value: MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKey[] | cdktf.IResolvable): void;
    resetAkamaiSignatureHeaderAuthenticationKey(): void;
    get akamaiSignatureHeaderAuthenticationKeyInput(): cdktf.IResolvable | MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKey[] | undefined;
    private _ipAllow;
    get ipAllow(): MediaStreamingEndpointAccessControlIpAllowList;
    putIpAllow(value: MediaStreamingEndpointAccessControlIpAllow[] | cdktf.IResolvable): void;
    resetIpAllow(): void;
    get ipAllowInput(): cdktf.IResolvable | MediaStreamingEndpointAccessControlIpAllow[] | undefined;
}
export interface MediaStreamingEndpointCrossSiteAccessPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#client_access_policy MediaStreamingEndpoint#client_access_policy}
    */
    readonly clientAccessPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#cross_domain_policy MediaStreamingEndpoint#cross_domain_policy}
    */
    readonly crossDomainPolicy?: string;
}
export declare function mediaStreamingEndpointCrossSiteAccessPolicyToTerraform(struct?: MediaStreamingEndpointCrossSiteAccessPolicyOutputReference | MediaStreamingEndpointCrossSiteAccessPolicy): any;
export declare class MediaStreamingEndpointCrossSiteAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingEndpointCrossSiteAccessPolicy | undefined;
    set internalValue(value: MediaStreamingEndpointCrossSiteAccessPolicy | undefined);
    private _clientAccessPolicy?;
    get clientAccessPolicy(): string;
    set clientAccessPolicy(value: string);
    resetClientAccessPolicy(): void;
    get clientAccessPolicyInput(): string | undefined;
    private _crossDomainPolicy?;
    get crossDomainPolicy(): string;
    set crossDomainPolicy(value: string);
    resetCrossDomainPolicy(): void;
    get crossDomainPolicyInput(): string | undefined;
}
export interface MediaStreamingEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#create MediaStreamingEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#delete MediaStreamingEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#read MediaStreamingEndpoint#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#update MediaStreamingEndpoint#update}
    */
    readonly update?: string;
}
export declare function mediaStreamingEndpointTimeoutsToTerraform(struct?: MediaStreamingEndpointTimeouts | cdktf.IResolvable): any;
export declare class MediaStreamingEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MediaStreamingEndpointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint azurerm_media_streaming_endpoint}
*/
export declare class MediaStreamingEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_media_streaming_endpoint";
    /**
    * Generates CDKTF code for importing a MediaStreamingEndpoint resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MediaStreamingEndpoint to import
    * @param importFromId The id of the existing MediaStreamingEndpoint that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MediaStreamingEndpoint to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/media_streaming_endpoint azurerm_media_streaming_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MediaStreamingEndpointConfig
    */
    constructor(scope: Construct, id: string, config: MediaStreamingEndpointConfig);
    private _autoStartEnabled?;
    get autoStartEnabled(): boolean | cdktf.IResolvable;
    set autoStartEnabled(value: boolean | cdktf.IResolvable);
    resetAutoStartEnabled(): void;
    get autoStartEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cdnEnabled?;
    get cdnEnabled(): boolean | cdktf.IResolvable;
    set cdnEnabled(value: boolean | cdktf.IResolvable);
    resetCdnEnabled(): void;
    get cdnEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cdnProfile?;
    get cdnProfile(): string;
    set cdnProfile(value: string);
    resetCdnProfile(): void;
    get cdnProfileInput(): string | undefined;
    private _cdnProvider?;
    get cdnProvider(): string;
    set cdnProvider(value: string);
    resetCdnProvider(): void;
    get cdnProviderInput(): string | undefined;
    private _customHostNames?;
    get customHostNames(): string[];
    set customHostNames(value: string[]);
    resetCustomHostNames(): void;
    get customHostNamesInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get hostName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maxCacheAgeSeconds?;
    get maxCacheAgeSeconds(): number;
    set maxCacheAgeSeconds(value: number);
    resetMaxCacheAgeSeconds(): void;
    get maxCacheAgeSecondsInput(): number | undefined;
    private _mediaServicesAccountName?;
    get mediaServicesAccountName(): string;
    set mediaServicesAccountName(value: string);
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scaleUnits?;
    get scaleUnits(): number;
    set scaleUnits(value: number);
    get scaleUnitsInput(): number | undefined;
    private _sku;
    get sku(): MediaStreamingEndpointSkuList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _accessControl;
    get accessControl(): MediaStreamingEndpointAccessControlOutputReference;
    putAccessControl(value: MediaStreamingEndpointAccessControl): void;
    resetAccessControl(): void;
    get accessControlInput(): MediaStreamingEndpointAccessControl | undefined;
    private _crossSiteAccessPolicy;
    get crossSiteAccessPolicy(): MediaStreamingEndpointCrossSiteAccessPolicyOutputReference;
    putCrossSiteAccessPolicy(value: MediaStreamingEndpointCrossSiteAccessPolicy): void;
    resetCrossSiteAccessPolicy(): void;
    get crossSiteAccessPolicyInput(): MediaStreamingEndpointCrossSiteAccessPolicy | undefined;
    private _timeouts;
    get timeouts(): MediaStreamingEndpointTimeoutsOutputReference;
    putTimeouts(value: MediaStreamingEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MediaStreamingEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
