"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MobileNetworkAttachedDataNetwork = exports.MobileNetworkAttachedDataNetworkTimeoutsOutputReference = exports.mobileNetworkAttachedDataNetworkTimeoutsToTerraform = exports.MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference = exports.mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToTerraform = exports.MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference = exports.mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        maximum: cdktf.numberToTerraform(struct.maximum),
        minimum: cdktf.numberToTerraform(struct.minimum),
    };
}
exports.mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToTerraform = mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToTerraform;
class MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._maximum !== undefined) {
            hasAnyValues = true;
            internalValueResult.maximum = this._maximum;
        }
        if (this._minimum !== undefined) {
            hasAnyValues = true;
            internalValueResult.minimum = this._minimum;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._maximum = undefined;
            this._minimum = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._maximum = value.maximum;
            this._minimum = value.minimum;
        }
    }
    get maximum() {
        return this.getNumberAttribute('maximum');
    }
    set maximum(value) {
        this._maximum = value;
    }
    resetMaximum() {
        this._maximum = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maximumInput() {
        return this._maximum;
    }
    get minimum() {
        return this.getNumberAttribute('minimum');
    }
    set minimum(value) {
        this._minimum = value;
    }
    resetMinimum() {
        this._minimum = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minimumInput() {
        return this._minimum;
    }
}
exports.MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference = MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference;
_a = JSII_RTTI_SYMBOL_1;
MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.mobileNetworkAttachedDataNetwork.MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference", version: "11.0.1" };
function mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        icmp_pinhole_timeout_in_seconds: cdktf.numberToTerraform(struct.icmpPinholeTimeoutInSeconds),
        pinhole_maximum_number: cdktf.numberToTerraform(struct.pinholeMaximumNumber),
        tcp_pinhole_timeout_in_seconds: cdktf.numberToTerraform(struct.tcpPinholeTimeoutInSeconds),
        tcp_port_reuse_minimum_hold_time_in_seconds: cdktf.numberToTerraform(struct.tcpPortReuseMinimumHoldTimeInSeconds),
        udp_pinhole_timeout_in_seconds: cdktf.numberToTerraform(struct.udpPinholeTimeoutInSeconds),
        udp_port_reuse_minimum_hold_time_in_seconds: cdktf.numberToTerraform(struct.udpPortReuseMinimumHoldTimeInSeconds),
        port_range: mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToTerraform(struct.portRange),
    };
}
exports.mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToTerraform = mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToTerraform;
class MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // port_range - computed: false, optional: true, required: false
        this._portRange = new MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference(this, "port_range");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._icmpPinholeTimeoutInSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.icmpPinholeTimeoutInSeconds = this._icmpPinholeTimeoutInSeconds;
        }
        if (this._pinholeMaximumNumber !== undefined) {
            hasAnyValues = true;
            internalValueResult.pinholeMaximumNumber = this._pinholeMaximumNumber;
        }
        if (this._tcpPinholeTimeoutInSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.tcpPinholeTimeoutInSeconds = this._tcpPinholeTimeoutInSeconds;
        }
        if (this._tcpPortReuseMinimumHoldTimeInSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.tcpPortReuseMinimumHoldTimeInSeconds = this._tcpPortReuseMinimumHoldTimeInSeconds;
        }
        if (this._udpPinholeTimeoutInSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.udpPinholeTimeoutInSeconds = this._udpPinholeTimeoutInSeconds;
        }
        if (this._udpPortReuseMinimumHoldTimeInSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.udpPortReuseMinimumHoldTimeInSeconds = this._udpPortReuseMinimumHoldTimeInSeconds;
        }
        if (this._portRange?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.portRange = this._portRange?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._icmpPinholeTimeoutInSeconds = undefined;
            this._pinholeMaximumNumber = undefined;
            this._tcpPinholeTimeoutInSeconds = undefined;
            this._tcpPortReuseMinimumHoldTimeInSeconds = undefined;
            this._udpPinholeTimeoutInSeconds = undefined;
            this._udpPortReuseMinimumHoldTimeInSeconds = undefined;
            this._portRange.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._icmpPinholeTimeoutInSeconds = value.icmpPinholeTimeoutInSeconds;
            this._pinholeMaximumNumber = value.pinholeMaximumNumber;
            this._tcpPinholeTimeoutInSeconds = value.tcpPinholeTimeoutInSeconds;
            this._tcpPortReuseMinimumHoldTimeInSeconds = value.tcpPortReuseMinimumHoldTimeInSeconds;
            this._udpPinholeTimeoutInSeconds = value.udpPinholeTimeoutInSeconds;
            this._udpPortReuseMinimumHoldTimeInSeconds = value.udpPortReuseMinimumHoldTimeInSeconds;
            this._portRange.internalValue = value.portRange;
        }
    }
    get icmpPinholeTimeoutInSeconds() {
        return this.getNumberAttribute('icmp_pinhole_timeout_in_seconds');
    }
    set icmpPinholeTimeoutInSeconds(value) {
        this._icmpPinholeTimeoutInSeconds = value;
    }
    resetIcmpPinholeTimeoutInSeconds() {
        this._icmpPinholeTimeoutInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get icmpPinholeTimeoutInSecondsInput() {
        return this._icmpPinholeTimeoutInSeconds;
    }
    get pinholeMaximumNumber() {
        return this.getNumberAttribute('pinhole_maximum_number');
    }
    set pinholeMaximumNumber(value) {
        this._pinholeMaximumNumber = value;
    }
    resetPinholeMaximumNumber() {
        this._pinholeMaximumNumber = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pinholeMaximumNumberInput() {
        return this._pinholeMaximumNumber;
    }
    get tcpPinholeTimeoutInSeconds() {
        return this.getNumberAttribute('tcp_pinhole_timeout_in_seconds');
    }
    set tcpPinholeTimeoutInSeconds(value) {
        this._tcpPinholeTimeoutInSeconds = value;
    }
    resetTcpPinholeTimeoutInSeconds() {
        this._tcpPinholeTimeoutInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tcpPinholeTimeoutInSecondsInput() {
        return this._tcpPinholeTimeoutInSeconds;
    }
    get tcpPortReuseMinimumHoldTimeInSeconds() {
        return this.getNumberAttribute('tcp_port_reuse_minimum_hold_time_in_seconds');
    }
    set tcpPortReuseMinimumHoldTimeInSeconds(value) {
        this._tcpPortReuseMinimumHoldTimeInSeconds = value;
    }
    resetTcpPortReuseMinimumHoldTimeInSeconds() {
        this._tcpPortReuseMinimumHoldTimeInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tcpPortReuseMinimumHoldTimeInSecondsInput() {
        return this._tcpPortReuseMinimumHoldTimeInSeconds;
    }
    get udpPinholeTimeoutInSeconds() {
        return this.getNumberAttribute('udp_pinhole_timeout_in_seconds');
    }
    set udpPinholeTimeoutInSeconds(value) {
        this._udpPinholeTimeoutInSeconds = value;
    }
    resetUdpPinholeTimeoutInSeconds() {
        this._udpPinholeTimeoutInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get udpPinholeTimeoutInSecondsInput() {
        return this._udpPinholeTimeoutInSeconds;
    }
    get udpPortReuseMinimumHoldTimeInSeconds() {
        return this.getNumberAttribute('udp_port_reuse_minimum_hold_time_in_seconds');
    }
    set udpPortReuseMinimumHoldTimeInSeconds(value) {
        this._udpPortReuseMinimumHoldTimeInSeconds = value;
    }
    resetUdpPortReuseMinimumHoldTimeInSeconds() {
        this._udpPortReuseMinimumHoldTimeInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get udpPortReuseMinimumHoldTimeInSecondsInput() {
        return this._udpPortReuseMinimumHoldTimeInSeconds;
    }
    get portRange() {
        return this._portRange;
    }
    putPortRange(value) {
        this._portRange.internalValue = value;
    }
    resetPortRange() {
        this._portRange.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portRangeInput() {
        return this._portRange.internalValue;
    }
}
exports.MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference = MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference;
_b = JSII_RTTI_SYMBOL_1;
MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.mobileNetworkAttachedDataNetwork.MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference", version: "11.0.1" };
function mobileNetworkAttachedDataNetworkTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.mobileNetworkAttachedDataNetworkTimeoutsToTerraform = mobileNetworkAttachedDataNetworkTimeoutsToTerraform;
class MobileNetworkAttachedDataNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.MobileNetworkAttachedDataNetworkTimeoutsOutputReference = MobileNetworkAttachedDataNetworkTimeoutsOutputReference;
_c = JSII_RTTI_SYMBOL_1;
MobileNetworkAttachedDataNetworkTimeoutsOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.mobileNetworkAttachedDataNetwork.MobileNetworkAttachedDataNetworkTimeoutsOutputReference", version: "11.0.1" };
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mobile_network_attached_data_network azurerm_mobile_network_attached_data_network}
*/
class MobileNetworkAttachedDataNetwork extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a MobileNetworkAttachedDataNetwork resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MobileNetworkAttachedDataNetwork to import
    * @param importFromId The id of the existing MobileNetworkAttachedDataNetwork that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mobile_network_attached_data_network#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MobileNetworkAttachedDataNetwork to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "azurerm_mobile_network_attached_data_network", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mobile_network_attached_data_network azurerm_mobile_network_attached_data_network} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MobileNetworkAttachedDataNetworkConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_mobile_network_attached_data_network',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.77.0',
                providerVersionConstraint: '~> 3.10'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // network_address_port_translation - computed: false, optional: true, required: false
        this._networkAddressPortTranslation = new MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference(this, "network_address_port_translation");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new MobileNetworkAttachedDataNetworkTimeoutsOutputReference(this, "timeouts");
        this._dnsAddresses = config.dnsAddresses;
        this._id = config.id;
        this._location = config.location;
        this._mobileNetworkDataNetworkName = config.mobileNetworkDataNetworkName;
        this._mobileNetworkPacketCoreDataPlaneId = config.mobileNetworkPacketCoreDataPlaneId;
        this._tags = config.tags;
        this._userEquipmentAddressPoolPrefixes = config.userEquipmentAddressPoolPrefixes;
        this._userEquipmentStaticAddressPoolPrefixes = config.userEquipmentStaticAddressPoolPrefixes;
        this._userPlaneAccessIpv4Address = config.userPlaneAccessIpv4Address;
        this._userPlaneAccessIpv4Gateway = config.userPlaneAccessIpv4Gateway;
        this._userPlaneAccessIpv4Subnet = config.userPlaneAccessIpv4Subnet;
        this._userPlaneAccessName = config.userPlaneAccessName;
        this._networkAddressPortTranslation.internalValue = config.networkAddressPortTranslation;
        this._timeouts.internalValue = config.timeouts;
    }
    get dnsAddresses() {
        return this.getListAttribute('dns_addresses');
    }
    set dnsAddresses(value) {
        this._dnsAddresses = value;
    }
    // Temporarily expose input value. Use with caution.
    get dnsAddressesInput() {
        return this._dnsAddresses;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get location() {
        return this.getStringAttribute('location');
    }
    set location(value) {
        this._location = value;
    }
    // Temporarily expose input value. Use with caution.
    get locationInput() {
        return this._location;
    }
    get mobileNetworkDataNetworkName() {
        return this.getStringAttribute('mobile_network_data_network_name');
    }
    set mobileNetworkDataNetworkName(value) {
        this._mobileNetworkDataNetworkName = value;
    }
    // Temporarily expose input value. Use with caution.
    get mobileNetworkDataNetworkNameInput() {
        return this._mobileNetworkDataNetworkName;
    }
    get mobileNetworkPacketCoreDataPlaneId() {
        return this.getStringAttribute('mobile_network_packet_core_data_plane_id');
    }
    set mobileNetworkPacketCoreDataPlaneId(value) {
        this._mobileNetworkPacketCoreDataPlaneId = value;
    }
    // Temporarily expose input value. Use with caution.
    get mobileNetworkPacketCoreDataPlaneIdInput() {
        return this._mobileNetworkPacketCoreDataPlaneId;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get userEquipmentAddressPoolPrefixes() {
        return this.getListAttribute('user_equipment_address_pool_prefixes');
    }
    set userEquipmentAddressPoolPrefixes(value) {
        this._userEquipmentAddressPoolPrefixes = value;
    }
    resetUserEquipmentAddressPoolPrefixes() {
        this._userEquipmentAddressPoolPrefixes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userEquipmentAddressPoolPrefixesInput() {
        return this._userEquipmentAddressPoolPrefixes;
    }
    get userEquipmentStaticAddressPoolPrefixes() {
        return this.getListAttribute('user_equipment_static_address_pool_prefixes');
    }
    set userEquipmentStaticAddressPoolPrefixes(value) {
        this._userEquipmentStaticAddressPoolPrefixes = value;
    }
    resetUserEquipmentStaticAddressPoolPrefixes() {
        this._userEquipmentStaticAddressPoolPrefixes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userEquipmentStaticAddressPoolPrefixesInput() {
        return this._userEquipmentStaticAddressPoolPrefixes;
    }
    get userPlaneAccessIpv4Address() {
        return this.getStringAttribute('user_plane_access_ipv4_address');
    }
    set userPlaneAccessIpv4Address(value) {
        this._userPlaneAccessIpv4Address = value;
    }
    resetUserPlaneAccessIpv4Address() {
        this._userPlaneAccessIpv4Address = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userPlaneAccessIpv4AddressInput() {
        return this._userPlaneAccessIpv4Address;
    }
    get userPlaneAccessIpv4Gateway() {
        return this.getStringAttribute('user_plane_access_ipv4_gateway');
    }
    set userPlaneAccessIpv4Gateway(value) {
        this._userPlaneAccessIpv4Gateway = value;
    }
    resetUserPlaneAccessIpv4Gateway() {
        this._userPlaneAccessIpv4Gateway = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userPlaneAccessIpv4GatewayInput() {
        return this._userPlaneAccessIpv4Gateway;
    }
    get userPlaneAccessIpv4Subnet() {
        return this.getStringAttribute('user_plane_access_ipv4_subnet');
    }
    set userPlaneAccessIpv4Subnet(value) {
        this._userPlaneAccessIpv4Subnet = value;
    }
    resetUserPlaneAccessIpv4Subnet() {
        this._userPlaneAccessIpv4Subnet = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userPlaneAccessIpv4SubnetInput() {
        return this._userPlaneAccessIpv4Subnet;
    }
    get userPlaneAccessName() {
        return this.getStringAttribute('user_plane_access_name');
    }
    set userPlaneAccessName(value) {
        this._userPlaneAccessName = value;
    }
    resetUserPlaneAccessName() {
        this._userPlaneAccessName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userPlaneAccessNameInput() {
        return this._userPlaneAccessName;
    }
    get networkAddressPortTranslation() {
        return this._networkAddressPortTranslation;
    }
    putNetworkAddressPortTranslation(value) {
        this._networkAddressPortTranslation.internalValue = value;
    }
    resetNetworkAddressPortTranslation() {
        this._networkAddressPortTranslation.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkAddressPortTranslationInput() {
        return this._networkAddressPortTranslation.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            dns_addresses: cdktf.listMapper(cdktf.stringToTerraform, false)(this._dnsAddresses),
            id: cdktf.stringToTerraform(this._id),
            location: cdktf.stringToTerraform(this._location),
            mobile_network_data_network_name: cdktf.stringToTerraform(this._mobileNetworkDataNetworkName),
            mobile_network_packet_core_data_plane_id: cdktf.stringToTerraform(this._mobileNetworkPacketCoreDataPlaneId),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            user_equipment_address_pool_prefixes: cdktf.listMapper(cdktf.stringToTerraform, false)(this._userEquipmentAddressPoolPrefixes),
            user_equipment_static_address_pool_prefixes: cdktf.listMapper(cdktf.stringToTerraform, false)(this._userEquipmentStaticAddressPoolPrefixes),
            user_plane_access_ipv4_address: cdktf.stringToTerraform(this._userPlaneAccessIpv4Address),
            user_plane_access_ipv4_gateway: cdktf.stringToTerraform(this._userPlaneAccessIpv4Gateway),
            user_plane_access_ipv4_subnet: cdktf.stringToTerraform(this._userPlaneAccessIpv4Subnet),
            user_plane_access_name: cdktf.stringToTerraform(this._userPlaneAccessName),
            network_address_port_translation: mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToTerraform(this._networkAddressPortTranslation.internalValue),
            timeouts: mobileNetworkAttachedDataNetworkTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.MobileNetworkAttachedDataNetwork = MobileNetworkAttachedDataNetwork;
_d = JSII_RTTI_SYMBOL_1;
MobileNetworkAttachedDataNetwork[_d] = { fqn: "@cdktf/provider-azurerm.mobileNetworkAttachedDataNetwork.MobileNetworkAttachedDataNetwork", version: "11.0.1" };
// =================
// STATIC PROPERTIES
// =================
MobileNetworkAttachedDataNetwork.tfResourceType = "azurerm_mobile_network_attached_data_network";
//# sourceMappingURL=data:application/json;base64,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