/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorActionRuleActionGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#action_group_id MonitorActionRuleActionGroup#action_group_id}
    */
    readonly actionGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#description MonitorActionRuleActionGroup#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#enabled MonitorActionRuleActionGroup#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#id MonitorActionRuleActionGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#name MonitorActionRuleActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#resource_group_name MonitorActionRuleActionGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#tags MonitorActionRuleActionGroup#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#condition MonitorActionRuleActionGroup#condition}
    */
    readonly condition?: MonitorActionRuleActionGroupCondition;
    /**
    * scope block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#scope MonitorActionRuleActionGroup#scope}
    */
    readonly scope?: MonitorActionRuleActionGroupScope;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#timeouts MonitorActionRuleActionGroup#timeouts}
    */
    readonly timeouts?: MonitorActionRuleActionGroupTimeouts;
}
export interface MonitorActionRuleActionGroupConditionAlertContext {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#operator MonitorActionRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#values MonitorActionRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorActionRuleActionGroupConditionAlertContextToTerraform(struct?: MonitorActionRuleActionGroupConditionAlertContextOutputReference | MonitorActionRuleActionGroupConditionAlertContext): any;
export declare class MonitorActionRuleActionGroupConditionAlertContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleActionGroupConditionAlertContext | undefined;
    set internalValue(value: MonitorActionRuleActionGroupConditionAlertContext | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorActionRuleActionGroupConditionAlertRuleId {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#operator MonitorActionRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#values MonitorActionRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorActionRuleActionGroupConditionAlertRuleIdToTerraform(struct?: MonitorActionRuleActionGroupConditionAlertRuleIdOutputReference | MonitorActionRuleActionGroupConditionAlertRuleId): any;
export declare class MonitorActionRuleActionGroupConditionAlertRuleIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleActionGroupConditionAlertRuleId | undefined;
    set internalValue(value: MonitorActionRuleActionGroupConditionAlertRuleId | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorActionRuleActionGroupConditionDescription {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#operator MonitorActionRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#values MonitorActionRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorActionRuleActionGroupConditionDescriptionToTerraform(struct?: MonitorActionRuleActionGroupConditionDescriptionOutputReference | MonitorActionRuleActionGroupConditionDescription): any;
export declare class MonitorActionRuleActionGroupConditionDescriptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleActionGroupConditionDescription | undefined;
    set internalValue(value: MonitorActionRuleActionGroupConditionDescription | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorActionRuleActionGroupConditionMonitor {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#operator MonitorActionRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#values MonitorActionRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorActionRuleActionGroupConditionMonitorToTerraform(struct?: MonitorActionRuleActionGroupConditionMonitorOutputReference | MonitorActionRuleActionGroupConditionMonitor): any;
export declare class MonitorActionRuleActionGroupConditionMonitorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleActionGroupConditionMonitor | undefined;
    set internalValue(value: MonitorActionRuleActionGroupConditionMonitor | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorActionRuleActionGroupConditionMonitorService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#operator MonitorActionRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#values MonitorActionRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorActionRuleActionGroupConditionMonitorServiceToTerraform(struct?: MonitorActionRuleActionGroupConditionMonitorServiceOutputReference | MonitorActionRuleActionGroupConditionMonitorService): any;
export declare class MonitorActionRuleActionGroupConditionMonitorServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleActionGroupConditionMonitorService | undefined;
    set internalValue(value: MonitorActionRuleActionGroupConditionMonitorService | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorActionRuleActionGroupConditionSeverity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#operator MonitorActionRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#values MonitorActionRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorActionRuleActionGroupConditionSeverityToTerraform(struct?: MonitorActionRuleActionGroupConditionSeverityOutputReference | MonitorActionRuleActionGroupConditionSeverity): any;
export declare class MonitorActionRuleActionGroupConditionSeverityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleActionGroupConditionSeverity | undefined;
    set internalValue(value: MonitorActionRuleActionGroupConditionSeverity | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorActionRuleActionGroupConditionTargetResourceType {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#operator MonitorActionRuleActionGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#values MonitorActionRuleActionGroup#values}
    */
    readonly values: string[];
}
export declare function monitorActionRuleActionGroupConditionTargetResourceTypeToTerraform(struct?: MonitorActionRuleActionGroupConditionTargetResourceTypeOutputReference | MonitorActionRuleActionGroupConditionTargetResourceType): any;
export declare class MonitorActionRuleActionGroupConditionTargetResourceTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleActionGroupConditionTargetResourceType | undefined;
    set internalValue(value: MonitorActionRuleActionGroupConditionTargetResourceType | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorActionRuleActionGroupCondition {
    /**
    * alert_context block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#alert_context MonitorActionRuleActionGroup#alert_context}
    */
    readonly alertContext?: MonitorActionRuleActionGroupConditionAlertContext;
    /**
    * alert_rule_id block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#alert_rule_id MonitorActionRuleActionGroup#alert_rule_id}
    */
    readonly alertRuleId?: MonitorActionRuleActionGroupConditionAlertRuleId;
    /**
    * description block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#description MonitorActionRuleActionGroup#description}
    */
    readonly description?: MonitorActionRuleActionGroupConditionDescription;
    /**
    * monitor block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#monitor MonitorActionRuleActionGroup#monitor}
    */
    readonly monitor?: MonitorActionRuleActionGroupConditionMonitor;
    /**
    * monitor_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#monitor_service MonitorActionRuleActionGroup#monitor_service}
    */
    readonly monitorService?: MonitorActionRuleActionGroupConditionMonitorService;
    /**
    * severity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#severity MonitorActionRuleActionGroup#severity}
    */
    readonly severity?: MonitorActionRuleActionGroupConditionSeverity;
    /**
    * target_resource_type block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#target_resource_type MonitorActionRuleActionGroup#target_resource_type}
    */
    readonly targetResourceType?: MonitorActionRuleActionGroupConditionTargetResourceType;
}
export declare function monitorActionRuleActionGroupConditionToTerraform(struct?: MonitorActionRuleActionGroupConditionOutputReference | MonitorActionRuleActionGroupCondition): any;
export declare class MonitorActionRuleActionGroupConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleActionGroupCondition | undefined;
    set internalValue(value: MonitorActionRuleActionGroupCondition | undefined);
    private _alertContext;
    get alertContext(): MonitorActionRuleActionGroupConditionAlertContextOutputReference;
    putAlertContext(value: MonitorActionRuleActionGroupConditionAlertContext): void;
    resetAlertContext(): void;
    get alertContextInput(): MonitorActionRuleActionGroupConditionAlertContext | undefined;
    private _alertRuleId;
    get alertRuleId(): MonitorActionRuleActionGroupConditionAlertRuleIdOutputReference;
    putAlertRuleId(value: MonitorActionRuleActionGroupConditionAlertRuleId): void;
    resetAlertRuleId(): void;
    get alertRuleIdInput(): MonitorActionRuleActionGroupConditionAlertRuleId | undefined;
    private _description;
    get description(): MonitorActionRuleActionGroupConditionDescriptionOutputReference;
    putDescription(value: MonitorActionRuleActionGroupConditionDescription): void;
    resetDescription(): void;
    get descriptionInput(): MonitorActionRuleActionGroupConditionDescription | undefined;
    private _monitor;
    get monitor(): MonitorActionRuleActionGroupConditionMonitorOutputReference;
    putMonitor(value: MonitorActionRuleActionGroupConditionMonitor): void;
    resetMonitor(): void;
    get monitorInput(): MonitorActionRuleActionGroupConditionMonitor | undefined;
    private _monitorService;
    get monitorService(): MonitorActionRuleActionGroupConditionMonitorServiceOutputReference;
    putMonitorService(value: MonitorActionRuleActionGroupConditionMonitorService): void;
    resetMonitorService(): void;
    get monitorServiceInput(): MonitorActionRuleActionGroupConditionMonitorService | undefined;
    private _severity;
    get severity(): MonitorActionRuleActionGroupConditionSeverityOutputReference;
    putSeverity(value: MonitorActionRuleActionGroupConditionSeverity): void;
    resetSeverity(): void;
    get severityInput(): MonitorActionRuleActionGroupConditionSeverity | undefined;
    private _targetResourceType;
    get targetResourceType(): MonitorActionRuleActionGroupConditionTargetResourceTypeOutputReference;
    putTargetResourceType(value: MonitorActionRuleActionGroupConditionTargetResourceType): void;
    resetTargetResourceType(): void;
    get targetResourceTypeInput(): MonitorActionRuleActionGroupConditionTargetResourceType | undefined;
}
export interface MonitorActionRuleActionGroupScope {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#resource_ids MonitorActionRuleActionGroup#resource_ids}
    */
    readonly resourceIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#type MonitorActionRuleActionGroup#type}
    */
    readonly type: string;
}
export declare function monitorActionRuleActionGroupScopeToTerraform(struct?: MonitorActionRuleActionGroupScopeOutputReference | MonitorActionRuleActionGroupScope): any;
export declare class MonitorActionRuleActionGroupScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleActionGroupScope | undefined;
    set internalValue(value: MonitorActionRuleActionGroupScope | undefined);
    private _resourceIds?;
    get resourceIds(): string[];
    set resourceIds(value: string[]);
    get resourceIdsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MonitorActionRuleActionGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#create MonitorActionRuleActionGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#delete MonitorActionRuleActionGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#read MonitorActionRuleActionGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#update MonitorActionRuleActionGroup#update}
    */
    readonly update?: string;
}
export declare function monitorActionRuleActionGroupTimeoutsToTerraform(struct?: MonitorActionRuleActionGroupTimeouts | cdktf.IResolvable): any;
export declare class MonitorActionRuleActionGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleActionGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActionRuleActionGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group azurerm_monitor_action_rule_action_group}
*/
export declare class MonitorActionRuleActionGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_action_rule_action_group";
    /**
    * Generates CDKTF code for importing a MonitorActionRuleActionGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MonitorActionRuleActionGroup to import
    * @param importFromId The id of the existing MonitorActionRuleActionGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MonitorActionRuleActionGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_action_rule_action_group azurerm_monitor_action_rule_action_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorActionRuleActionGroupConfig
    */
    constructor(scope: Construct, id: string, config: MonitorActionRuleActionGroupConfig);
    private _actionGroupId?;
    get actionGroupId(): string;
    set actionGroupId(value: string);
    get actionGroupIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _condition;
    get condition(): MonitorActionRuleActionGroupConditionOutputReference;
    putCondition(value: MonitorActionRuleActionGroupCondition): void;
    resetCondition(): void;
    get conditionInput(): MonitorActionRuleActionGroupCondition | undefined;
    private _scope;
    get scope(): MonitorActionRuleActionGroupScopeOutputReference;
    putScope(value: MonitorActionRuleActionGroupScope): void;
    resetScope(): void;
    get scopeInput(): MonitorActionRuleActionGroupScope | undefined;
    private _timeouts;
    get timeouts(): MonitorActionRuleActionGroupTimeoutsOutputReference;
    putTimeouts(value: MonitorActionRuleActionGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorActionRuleActionGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
