/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorMetricAlertConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#auto_mitigate MonitorMetricAlert#auto_mitigate}
    */
    readonly autoMitigate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#description MonitorMetricAlert#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#enabled MonitorMetricAlert#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#frequency MonitorMetricAlert#frequency}
    */
    readonly frequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#id MonitorMetricAlert#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#name MonitorMetricAlert#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#resource_group_name MonitorMetricAlert#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#scopes MonitorMetricAlert#scopes}
    */
    readonly scopes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#severity MonitorMetricAlert#severity}
    */
    readonly severity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#tags MonitorMetricAlert#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * The location of the target pluginsdk. Required when using subscription, resource group scope or multiple scopes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#target_resource_location MonitorMetricAlert#target_resource_location}
    */
    readonly targetResourceLocation?: string;
    /**
    * The resource type (e.g. Microsoft.Compute/virtualMachines) of the target pluginsdk. Required when using subscription, resource group scope or multiple scopes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#target_resource_type MonitorMetricAlert#target_resource_type}
    */
    readonly targetResourceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#window_size MonitorMetricAlert#window_size}
    */
    readonly windowSize?: string;
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#action MonitorMetricAlert#action}
    */
    readonly action?: MonitorMetricAlertAction[] | cdktf.IResolvable;
    /**
    * application_insights_web_test_location_availability_criteria block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#application_insights_web_test_location_availability_criteria MonitorMetricAlert#application_insights_web_test_location_availability_criteria}
    */
    readonly applicationInsightsWebTestLocationAvailabilityCriteria?: MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria;
    /**
    * criteria block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#criteria MonitorMetricAlert#criteria}
    */
    readonly criteria?: MonitorMetricAlertCriteria[] | cdktf.IResolvable;
    /**
    * dynamic_criteria block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#dynamic_criteria MonitorMetricAlert#dynamic_criteria}
    */
    readonly dynamicCriteria?: MonitorMetricAlertDynamicCriteria;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#timeouts MonitorMetricAlert#timeouts}
    */
    readonly timeouts?: MonitorMetricAlertTimeouts;
}
export interface MonitorMetricAlertAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#action_group_id MonitorMetricAlert#action_group_id}
    */
    readonly actionGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#webhook_properties MonitorMetricAlert#webhook_properties}
    */
    readonly webhookProperties?: {
        [key: string]: string;
    };
}
export declare function monitorMetricAlertActionToTerraform(struct?: MonitorMetricAlertAction | cdktf.IResolvable): any;
export declare class MonitorMetricAlertActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorMetricAlertAction | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorMetricAlertAction | cdktf.IResolvable | undefined);
    private _actionGroupId?;
    get actionGroupId(): string;
    set actionGroupId(value: string);
    get actionGroupIdInput(): string | undefined;
    private _webhookProperties?;
    get webhookProperties(): {
        [key: string]: string;
    };
    set webhookProperties(value: {
        [key: string]: string;
    });
    resetWebhookProperties(): void;
    get webhookPropertiesInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class MonitorMetricAlertActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorMetricAlertAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorMetricAlertActionOutputReference;
}
export interface MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#component_id MonitorMetricAlert#component_id}
    */
    readonly componentId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#failed_location_count MonitorMetricAlert#failed_location_count}
    */
    readonly failedLocationCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#web_test_id MonitorMetricAlert#web_test_id}
    */
    readonly webTestId: string;
}
export declare function monitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaToTerraform(struct?: MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaOutputReference | MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria): any;
export declare class MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria | undefined;
    set internalValue(value: MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria | undefined);
    private _componentId?;
    get componentId(): string;
    set componentId(value: string);
    get componentIdInput(): string | undefined;
    private _failedLocationCount?;
    get failedLocationCount(): number;
    set failedLocationCount(value: number);
    get failedLocationCountInput(): number | undefined;
    private _webTestId?;
    get webTestId(): string;
    set webTestId(value: string);
    get webTestIdInput(): string | undefined;
}
export interface MonitorMetricAlertCriteriaDimension {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#name MonitorMetricAlert#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#operator MonitorMetricAlert#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#values MonitorMetricAlert#values}
    */
    readonly values: string[];
}
export declare function monitorMetricAlertCriteriaDimensionToTerraform(struct?: MonitorMetricAlertCriteriaDimension | cdktf.IResolvable): any;
export declare class MonitorMetricAlertCriteriaDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorMetricAlertCriteriaDimension | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorMetricAlertCriteriaDimension | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class MonitorMetricAlertCriteriaDimensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorMetricAlertCriteriaDimension[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorMetricAlertCriteriaDimensionOutputReference;
}
export interface MonitorMetricAlertCriteria {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#aggregation MonitorMetricAlert#aggregation}
    */
    readonly aggregation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#metric_name MonitorMetricAlert#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#metric_namespace MonitorMetricAlert#metric_namespace}
    */
    readonly metricNamespace: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#operator MonitorMetricAlert#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#skip_metric_validation MonitorMetricAlert#skip_metric_validation}
    */
    readonly skipMetricValidation?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#threshold MonitorMetricAlert#threshold}
    */
    readonly threshold: number;
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#dimension MonitorMetricAlert#dimension}
    */
    readonly dimension?: MonitorMetricAlertCriteriaDimension[] | cdktf.IResolvable;
}
export declare function monitorMetricAlertCriteriaToTerraform(struct?: MonitorMetricAlertCriteria | cdktf.IResolvable): any;
export declare class MonitorMetricAlertCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorMetricAlertCriteria | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorMetricAlertCriteria | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _metricNamespace?;
    get metricNamespace(): string;
    set metricNamespace(value: string);
    get metricNamespaceInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _skipMetricValidation?;
    get skipMetricValidation(): boolean | cdktf.IResolvable;
    set skipMetricValidation(value: boolean | cdktf.IResolvable);
    resetSkipMetricValidation(): void;
    get skipMetricValidationInput(): boolean | cdktf.IResolvable | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _dimension;
    get dimension(): MonitorMetricAlertCriteriaDimensionList;
    putDimension(value: MonitorMetricAlertCriteriaDimension[] | cdktf.IResolvable): void;
    resetDimension(): void;
    get dimensionInput(): cdktf.IResolvable | MonitorMetricAlertCriteriaDimension[] | undefined;
}
export declare class MonitorMetricAlertCriteriaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorMetricAlertCriteria[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorMetricAlertCriteriaOutputReference;
}
export interface MonitorMetricAlertDynamicCriteriaDimension {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#name MonitorMetricAlert#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#operator MonitorMetricAlert#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#values MonitorMetricAlert#values}
    */
    readonly values: string[];
}
export declare function monitorMetricAlertDynamicCriteriaDimensionToTerraform(struct?: MonitorMetricAlertDynamicCriteriaDimension | cdktf.IResolvable): any;
export declare class MonitorMetricAlertDynamicCriteriaDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorMetricAlertDynamicCriteriaDimension | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorMetricAlertDynamicCriteriaDimension | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class MonitorMetricAlertDynamicCriteriaDimensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorMetricAlertDynamicCriteriaDimension[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorMetricAlertDynamicCriteriaDimensionOutputReference;
}
export interface MonitorMetricAlertDynamicCriteria {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#aggregation MonitorMetricAlert#aggregation}
    */
    readonly aggregation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#alert_sensitivity MonitorMetricAlert#alert_sensitivity}
    */
    readonly alertSensitivity: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#evaluation_failure_count MonitorMetricAlert#evaluation_failure_count}
    */
    readonly evaluationFailureCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#evaluation_total_count MonitorMetricAlert#evaluation_total_count}
    */
    readonly evaluationTotalCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#ignore_data_before MonitorMetricAlert#ignore_data_before}
    */
    readonly ignoreDataBefore?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#metric_name MonitorMetricAlert#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#metric_namespace MonitorMetricAlert#metric_namespace}
    */
    readonly metricNamespace: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#operator MonitorMetricAlert#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#skip_metric_validation MonitorMetricAlert#skip_metric_validation}
    */
    readonly skipMetricValidation?: boolean | cdktf.IResolvable;
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#dimension MonitorMetricAlert#dimension}
    */
    readonly dimension?: MonitorMetricAlertDynamicCriteriaDimension[] | cdktf.IResolvable;
}
export declare function monitorMetricAlertDynamicCriteriaToTerraform(struct?: MonitorMetricAlertDynamicCriteriaOutputReference | MonitorMetricAlertDynamicCriteria): any;
export declare class MonitorMetricAlertDynamicCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorMetricAlertDynamicCriteria | undefined;
    set internalValue(value: MonitorMetricAlertDynamicCriteria | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _alertSensitivity?;
    get alertSensitivity(): string;
    set alertSensitivity(value: string);
    get alertSensitivityInput(): string | undefined;
    private _evaluationFailureCount?;
    get evaluationFailureCount(): number;
    set evaluationFailureCount(value: number);
    resetEvaluationFailureCount(): void;
    get evaluationFailureCountInput(): number | undefined;
    private _evaluationTotalCount?;
    get evaluationTotalCount(): number;
    set evaluationTotalCount(value: number);
    resetEvaluationTotalCount(): void;
    get evaluationTotalCountInput(): number | undefined;
    private _ignoreDataBefore?;
    get ignoreDataBefore(): string;
    set ignoreDataBefore(value: string);
    resetIgnoreDataBefore(): void;
    get ignoreDataBeforeInput(): string | undefined;
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _metricNamespace?;
    get metricNamespace(): string;
    set metricNamespace(value: string);
    get metricNamespaceInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _skipMetricValidation?;
    get skipMetricValidation(): boolean | cdktf.IResolvable;
    set skipMetricValidation(value: boolean | cdktf.IResolvable);
    resetSkipMetricValidation(): void;
    get skipMetricValidationInput(): boolean | cdktf.IResolvable | undefined;
    private _dimension;
    get dimension(): MonitorMetricAlertDynamicCriteriaDimensionList;
    putDimension(value: MonitorMetricAlertDynamicCriteriaDimension[] | cdktf.IResolvable): void;
    resetDimension(): void;
    get dimensionInput(): cdktf.IResolvable | MonitorMetricAlertDynamicCriteriaDimension[] | undefined;
}
export interface MonitorMetricAlertTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#create MonitorMetricAlert#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#delete MonitorMetricAlert#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#read MonitorMetricAlert#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#update MonitorMetricAlert#update}
    */
    readonly update?: string;
}
export declare function monitorMetricAlertTimeoutsToTerraform(struct?: MonitorMetricAlertTimeouts | cdktf.IResolvable): any;
export declare class MonitorMetricAlertTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorMetricAlertTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorMetricAlertTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert azurerm_monitor_metric_alert}
*/
export declare class MonitorMetricAlert extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_metric_alert";
    /**
    * Generates CDKTF code for importing a MonitorMetricAlert resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MonitorMetricAlert to import
    * @param importFromId The id of the existing MonitorMetricAlert that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MonitorMetricAlert to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/monitor_metric_alert azurerm_monitor_metric_alert} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorMetricAlertConfig
    */
    constructor(scope: Construct, id: string, config: MonitorMetricAlertConfig);
    private _autoMitigate?;
    get autoMitigate(): boolean | cdktf.IResolvable;
    set autoMitigate(value: boolean | cdktf.IResolvable);
    resetAutoMitigate(): void;
    get autoMitigateInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    resetFrequency(): void;
    get frequencyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    private _severity?;
    get severity(): number;
    set severity(value: number);
    resetSeverity(): void;
    get severityInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _targetResourceLocation?;
    get targetResourceLocation(): string;
    set targetResourceLocation(value: string);
    resetTargetResourceLocation(): void;
    get targetResourceLocationInput(): string | undefined;
    private _targetResourceType?;
    get targetResourceType(): string;
    set targetResourceType(value: string);
    resetTargetResourceType(): void;
    get targetResourceTypeInput(): string | undefined;
    private _windowSize?;
    get windowSize(): string;
    set windowSize(value: string);
    resetWindowSize(): void;
    get windowSizeInput(): string | undefined;
    private _action;
    get action(): MonitorMetricAlertActionList;
    putAction(value: MonitorMetricAlertAction[] | cdktf.IResolvable): void;
    resetAction(): void;
    get actionInput(): cdktf.IResolvable | MonitorMetricAlertAction[] | undefined;
    private _applicationInsightsWebTestLocationAvailabilityCriteria;
    get applicationInsightsWebTestLocationAvailabilityCriteria(): MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaOutputReference;
    putApplicationInsightsWebTestLocationAvailabilityCriteria(value: MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria): void;
    resetApplicationInsightsWebTestLocationAvailabilityCriteria(): void;
    get applicationInsightsWebTestLocationAvailabilityCriteriaInput(): MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria | undefined;
    private _criteria;
    get criteria(): MonitorMetricAlertCriteriaList;
    putCriteria(value: MonitorMetricAlertCriteria[] | cdktf.IResolvable): void;
    resetCriteria(): void;
    get criteriaInput(): cdktf.IResolvable | MonitorMetricAlertCriteria[] | undefined;
    private _dynamicCriteria;
    get dynamicCriteria(): MonitorMetricAlertDynamicCriteriaOutputReference;
    putDynamicCriteria(value: MonitorMetricAlertDynamicCriteria): void;
    resetDynamicCriteria(): void;
    get dynamicCriteriaInput(): MonitorMetricAlertDynamicCriteria | undefined;
    private _timeouts;
    get timeouts(): MonitorMetricAlertTimeoutsOutputReference;
    putTimeouts(value: MonitorMetricAlertTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorMetricAlertTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
