/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlFailoverGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#databases MssqlFailoverGroup#databases}
    */
    readonly databases?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#id MssqlFailoverGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#name MssqlFailoverGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#readonly_endpoint_failover_policy_enabled MssqlFailoverGroup#readonly_endpoint_failover_policy_enabled}
    */
    readonly readonlyEndpointFailoverPolicyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#server_id MssqlFailoverGroup#server_id}
    */
    readonly serverId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#tags MssqlFailoverGroup#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * partner_server block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#partner_server MssqlFailoverGroup#partner_server}
    */
    readonly partnerServer: MssqlFailoverGroupPartnerServer[] | cdktf.IResolvable;
    /**
    * read_write_endpoint_failover_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#read_write_endpoint_failover_policy MssqlFailoverGroup#read_write_endpoint_failover_policy}
    */
    readonly readWriteEndpointFailoverPolicy: MssqlFailoverGroupReadWriteEndpointFailoverPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#timeouts MssqlFailoverGroup#timeouts}
    */
    readonly timeouts?: MssqlFailoverGroupTimeouts;
}
export interface MssqlFailoverGroupPartnerServer {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#id MssqlFailoverGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function mssqlFailoverGroupPartnerServerToTerraform(struct?: MssqlFailoverGroupPartnerServer | cdktf.IResolvable): any;
export declare class MssqlFailoverGroupPartnerServerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MssqlFailoverGroupPartnerServer | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlFailoverGroupPartnerServer | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    get location(): string;
    get role(): string;
}
export declare class MssqlFailoverGroupPartnerServerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MssqlFailoverGroupPartnerServer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MssqlFailoverGroupPartnerServerOutputReference;
}
export interface MssqlFailoverGroupReadWriteEndpointFailoverPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#grace_minutes MssqlFailoverGroup#grace_minutes}
    */
    readonly graceMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#mode MssqlFailoverGroup#mode}
    */
    readonly mode: string;
}
export declare function mssqlFailoverGroupReadWriteEndpointFailoverPolicyToTerraform(struct?: MssqlFailoverGroupReadWriteEndpointFailoverPolicyOutputReference | MssqlFailoverGroupReadWriteEndpointFailoverPolicy): any;
export declare class MssqlFailoverGroupReadWriteEndpointFailoverPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlFailoverGroupReadWriteEndpointFailoverPolicy | undefined;
    set internalValue(value: MssqlFailoverGroupReadWriteEndpointFailoverPolicy | undefined);
    private _graceMinutes?;
    get graceMinutes(): number;
    set graceMinutes(value: number);
    resetGraceMinutes(): void;
    get graceMinutesInput(): number | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
}
export interface MssqlFailoverGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#create MssqlFailoverGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#delete MssqlFailoverGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#read MssqlFailoverGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#update MssqlFailoverGroup#update}
    */
    readonly update?: string;
}
export declare function mssqlFailoverGroupTimeoutsToTerraform(struct?: MssqlFailoverGroupTimeouts | cdktf.IResolvable): any;
export declare class MssqlFailoverGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlFailoverGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlFailoverGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group azurerm_mssql_failover_group}
*/
export declare class MssqlFailoverGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_failover_group";
    /**
    * Generates CDKTF code for importing a MssqlFailoverGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MssqlFailoverGroup to import
    * @param importFromId The id of the existing MssqlFailoverGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MssqlFailoverGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_failover_group azurerm_mssql_failover_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlFailoverGroupConfig
    */
    constructor(scope: Construct, id: string, config: MssqlFailoverGroupConfig);
    private _databases?;
    get databases(): string[];
    set databases(value: string[]);
    resetDatabases(): void;
    get databasesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _readonlyEndpointFailoverPolicyEnabled?;
    get readonlyEndpointFailoverPolicyEnabled(): boolean | cdktf.IResolvable;
    set readonlyEndpointFailoverPolicyEnabled(value: boolean | cdktf.IResolvable);
    resetReadonlyEndpointFailoverPolicyEnabled(): void;
    get readonlyEndpointFailoverPolicyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    get serverIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _partnerServer;
    get partnerServer(): MssqlFailoverGroupPartnerServerList;
    putPartnerServer(value: MssqlFailoverGroupPartnerServer[] | cdktf.IResolvable): void;
    get partnerServerInput(): cdktf.IResolvable | MssqlFailoverGroupPartnerServer[] | undefined;
    private _readWriteEndpointFailoverPolicy;
    get readWriteEndpointFailoverPolicy(): MssqlFailoverGroupReadWriteEndpointFailoverPolicyOutputReference;
    putReadWriteEndpointFailoverPolicy(value: MssqlFailoverGroupReadWriteEndpointFailoverPolicy): void;
    get readWriteEndpointFailoverPolicyInput(): MssqlFailoverGroupReadWriteEndpointFailoverPolicy | undefined;
    private _timeouts;
    get timeouts(): MssqlFailoverGroupTimeoutsOutputReference;
    putTimeouts(value: MssqlFailoverGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MssqlFailoverGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
