/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlManagedInstanceVulnerabilityAssessmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#id MssqlManagedInstanceVulnerabilityAssessment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#managed_instance_id MssqlManagedInstanceVulnerabilityAssessment#managed_instance_id}
    */
    readonly managedInstanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#storage_account_access_key MssqlManagedInstanceVulnerabilityAssessment#storage_account_access_key}
    */
    readonly storageAccountAccessKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#storage_container_path MssqlManagedInstanceVulnerabilityAssessment#storage_container_path}
    */
    readonly storageContainerPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#storage_container_sas_key MssqlManagedInstanceVulnerabilityAssessment#storage_container_sas_key}
    */
    readonly storageContainerSasKey?: string;
    /**
    * recurring_scans block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#recurring_scans MssqlManagedInstanceVulnerabilityAssessment#recurring_scans}
    */
    readonly recurringScans?: MssqlManagedInstanceVulnerabilityAssessmentRecurringScans;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#timeouts MssqlManagedInstanceVulnerabilityAssessment#timeouts}
    */
    readonly timeouts?: MssqlManagedInstanceVulnerabilityAssessmentTimeouts;
}
export interface MssqlManagedInstanceVulnerabilityAssessmentRecurringScans {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#email_subscription_admins MssqlManagedInstanceVulnerabilityAssessment#email_subscription_admins}
    */
    readonly emailSubscriptionAdmins?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#emails MssqlManagedInstanceVulnerabilityAssessment#emails}
    */
    readonly emails?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#enabled MssqlManagedInstanceVulnerabilityAssessment#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function mssqlManagedInstanceVulnerabilityAssessmentRecurringScansToTerraform(struct?: MssqlManagedInstanceVulnerabilityAssessmentRecurringScansOutputReference | MssqlManagedInstanceVulnerabilityAssessmentRecurringScans): any;
export declare class MssqlManagedInstanceVulnerabilityAssessmentRecurringScansOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlManagedInstanceVulnerabilityAssessmentRecurringScans | undefined;
    set internalValue(value: MssqlManagedInstanceVulnerabilityAssessmentRecurringScans | undefined);
    private _emailSubscriptionAdmins?;
    get emailSubscriptionAdmins(): boolean | cdktf.IResolvable;
    set emailSubscriptionAdmins(value: boolean | cdktf.IResolvable);
    resetEmailSubscriptionAdmins(): void;
    get emailSubscriptionAdminsInput(): boolean | cdktf.IResolvable | undefined;
    private _emails?;
    get emails(): string[];
    set emails(value: string[]);
    resetEmails(): void;
    get emailsInput(): string[] | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MssqlManagedInstanceVulnerabilityAssessmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#create MssqlManagedInstanceVulnerabilityAssessment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#delete MssqlManagedInstanceVulnerabilityAssessment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#read MssqlManagedInstanceVulnerabilityAssessment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#update MssqlManagedInstanceVulnerabilityAssessment#update}
    */
    readonly update?: string;
}
export declare function mssqlManagedInstanceVulnerabilityAssessmentTimeoutsToTerraform(struct?: MssqlManagedInstanceVulnerabilityAssessmentTimeouts | cdktf.IResolvable): any;
export declare class MssqlManagedInstanceVulnerabilityAssessmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlManagedInstanceVulnerabilityAssessmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlManagedInstanceVulnerabilityAssessmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment azurerm_mssql_managed_instance_vulnerability_assessment}
*/
export declare class MssqlManagedInstanceVulnerabilityAssessment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_managed_instance_vulnerability_assessment";
    /**
    * Generates CDKTF code for importing a MssqlManagedInstanceVulnerabilityAssessment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MssqlManagedInstanceVulnerabilityAssessment to import
    * @param importFromId The id of the existing MssqlManagedInstanceVulnerabilityAssessment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MssqlManagedInstanceVulnerabilityAssessment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/mssql_managed_instance_vulnerability_assessment azurerm_mssql_managed_instance_vulnerability_assessment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlManagedInstanceVulnerabilityAssessmentConfig
    */
    constructor(scope: Construct, id: string, config: MssqlManagedInstanceVulnerabilityAssessmentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managedInstanceId?;
    get managedInstanceId(): string;
    set managedInstanceId(value: string);
    get managedInstanceIdInput(): string | undefined;
    private _storageAccountAccessKey?;
    get storageAccountAccessKey(): string;
    set storageAccountAccessKey(value: string);
    resetStorageAccountAccessKey(): void;
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageContainerPath?;
    get storageContainerPath(): string;
    set storageContainerPath(value: string);
    get storageContainerPathInput(): string | undefined;
    private _storageContainerSasKey?;
    get storageContainerSasKey(): string;
    set storageContainerSasKey(value: string);
    resetStorageContainerSasKey(): void;
    get storageContainerSasKeyInput(): string | undefined;
    private _recurringScans;
    get recurringScans(): MssqlManagedInstanceVulnerabilityAssessmentRecurringScansOutputReference;
    putRecurringScans(value: MssqlManagedInstanceVulnerabilityAssessmentRecurringScans): void;
    resetRecurringScans(): void;
    get recurringScansInput(): MssqlManagedInstanceVulnerabilityAssessmentRecurringScans | undefined;
    private _timeouts;
    get timeouts(): MssqlManagedInstanceVulnerabilityAssessmentTimeoutsOutputReference;
    putTimeouts(value: MssqlManagedInstanceVulnerabilityAssessmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MssqlManagedInstanceVulnerabilityAssessmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
