/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkPacketCaptureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#id NetworkPacketCapture#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#maximum_bytes_per_packet NetworkPacketCapture#maximum_bytes_per_packet}
    */
    readonly maximumBytesPerPacket?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#maximum_bytes_per_session NetworkPacketCapture#maximum_bytes_per_session}
    */
    readonly maximumBytesPerSession?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#maximum_capture_duration NetworkPacketCapture#maximum_capture_duration}
    */
    readonly maximumCaptureDuration?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#name NetworkPacketCapture#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#network_watcher_name NetworkPacketCapture#network_watcher_name}
    */
    readonly networkWatcherName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#resource_group_name NetworkPacketCapture#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#target_resource_id NetworkPacketCapture#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#filter NetworkPacketCapture#filter}
    */
    readonly filter?: NetworkPacketCaptureFilter[] | cdktf.IResolvable;
    /**
    * storage_location block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#storage_location NetworkPacketCapture#storage_location}
    */
    readonly storageLocation: NetworkPacketCaptureStorageLocation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#timeouts NetworkPacketCapture#timeouts}
    */
    readonly timeouts?: NetworkPacketCaptureTimeouts;
}
export interface NetworkPacketCaptureFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#local_ip_address NetworkPacketCapture#local_ip_address}
    */
    readonly localIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#local_port NetworkPacketCapture#local_port}
    */
    readonly localPort?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#protocol NetworkPacketCapture#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#remote_ip_address NetworkPacketCapture#remote_ip_address}
    */
    readonly remoteIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#remote_port NetworkPacketCapture#remote_port}
    */
    readonly remotePort?: string;
}
export declare function networkPacketCaptureFilterToTerraform(struct?: NetworkPacketCaptureFilter | cdktf.IResolvable): any;
export declare class NetworkPacketCaptureFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetworkPacketCaptureFilter | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkPacketCaptureFilter | cdktf.IResolvable | undefined);
    private _localIpAddress?;
    get localIpAddress(): string;
    set localIpAddress(value: string);
    resetLocalIpAddress(): void;
    get localIpAddressInput(): string | undefined;
    private _localPort?;
    get localPort(): string;
    set localPort(value: string);
    resetLocalPort(): void;
    get localPortInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _remoteIpAddress?;
    get remoteIpAddress(): string;
    set remoteIpAddress(value: string);
    resetRemoteIpAddress(): void;
    get remoteIpAddressInput(): string | undefined;
    private _remotePort?;
    get remotePort(): string;
    set remotePort(value: string);
    resetRemotePort(): void;
    get remotePortInput(): string | undefined;
}
export declare class NetworkPacketCaptureFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NetworkPacketCaptureFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetworkPacketCaptureFilterOutputReference;
}
export interface NetworkPacketCaptureStorageLocation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#file_path NetworkPacketCapture#file_path}
    */
    readonly filePath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#storage_account_id NetworkPacketCapture#storage_account_id}
    */
    readonly storageAccountId?: string;
}
export declare function networkPacketCaptureStorageLocationToTerraform(struct?: NetworkPacketCaptureStorageLocationOutputReference | NetworkPacketCaptureStorageLocation): any;
export declare class NetworkPacketCaptureStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkPacketCaptureStorageLocation | undefined;
    set internalValue(value: NetworkPacketCaptureStorageLocation | undefined);
    private _filePath?;
    get filePath(): string;
    set filePath(value: string);
    resetFilePath(): void;
    get filePathInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    get storagePath(): string;
}
export interface NetworkPacketCaptureTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#create NetworkPacketCapture#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#delete NetworkPacketCapture#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#read NetworkPacketCapture#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#update NetworkPacketCapture#update}
    */
    readonly update?: string;
}
export declare function networkPacketCaptureTimeoutsToTerraform(struct?: NetworkPacketCaptureTimeouts | cdktf.IResolvable): any;
export declare class NetworkPacketCaptureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkPacketCaptureTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkPacketCaptureTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture azurerm_network_packet_capture}
*/
export declare class NetworkPacketCapture extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_packet_capture";
    /**
    * Generates CDKTF code for importing a NetworkPacketCapture resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetworkPacketCapture to import
    * @param importFromId The id of the existing NetworkPacketCapture that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetworkPacketCapture to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/network_packet_capture azurerm_network_packet_capture} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkPacketCaptureConfig
    */
    constructor(scope: Construct, id: string, config: NetworkPacketCaptureConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maximumBytesPerPacket?;
    get maximumBytesPerPacket(): number;
    set maximumBytesPerPacket(value: number);
    resetMaximumBytesPerPacket(): void;
    get maximumBytesPerPacketInput(): number | undefined;
    private _maximumBytesPerSession?;
    get maximumBytesPerSession(): number;
    set maximumBytesPerSession(value: number);
    resetMaximumBytesPerSession(): void;
    get maximumBytesPerSessionInput(): number | undefined;
    private _maximumCaptureDuration?;
    get maximumCaptureDuration(): number;
    set maximumCaptureDuration(value: number);
    resetMaximumCaptureDuration(): void;
    get maximumCaptureDurationInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkWatcherName?;
    get networkWatcherName(): string;
    set networkWatcherName(value: string);
    get networkWatcherNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _filter;
    get filter(): NetworkPacketCaptureFilterList;
    putFilter(value: NetworkPacketCaptureFilter[] | cdktf.IResolvable): void;
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | NetworkPacketCaptureFilter[] | undefined;
    private _storageLocation;
    get storageLocation(): NetworkPacketCaptureStorageLocationOutputReference;
    putStorageLocation(value: NetworkPacketCaptureStorageLocation): void;
    get storageLocationInput(): NetworkPacketCaptureStorageLocation | undefined;
    private _timeouts;
    get timeouts(): NetworkPacketCaptureTimeoutsOutputReference;
    putTimeouts(value: NetworkPacketCaptureTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkPacketCaptureTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
