/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicebusSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#auto_delete_on_idle ServicebusSubscription#auto_delete_on_idle}
    */
    readonly autoDeleteOnIdle?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#client_scoped_subscription_enabled ServicebusSubscription#client_scoped_subscription_enabled}
    */
    readonly clientScopedSubscriptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#dead_lettering_on_filter_evaluation_error ServicebusSubscription#dead_lettering_on_filter_evaluation_error}
    */
    readonly deadLetteringOnFilterEvaluationError?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#dead_lettering_on_message_expiration ServicebusSubscription#dead_lettering_on_message_expiration}
    */
    readonly deadLetteringOnMessageExpiration?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#default_message_ttl ServicebusSubscription#default_message_ttl}
    */
    readonly defaultMessageTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#enable_batched_operations ServicebusSubscription#enable_batched_operations}
    */
    readonly enableBatchedOperations?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#forward_dead_lettered_messages_to ServicebusSubscription#forward_dead_lettered_messages_to}
    */
    readonly forwardDeadLetteredMessagesTo?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#forward_to ServicebusSubscription#forward_to}
    */
    readonly forwardTo?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#id ServicebusSubscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#lock_duration ServicebusSubscription#lock_duration}
    */
    readonly lockDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#max_delivery_count ServicebusSubscription#max_delivery_count}
    */
    readonly maxDeliveryCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#name ServicebusSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#requires_session ServicebusSubscription#requires_session}
    */
    readonly requiresSession?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#status ServicebusSubscription#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#topic_id ServicebusSubscription#topic_id}
    */
    readonly topicId: string;
    /**
    * client_scoped_subscription block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#client_scoped_subscription ServicebusSubscription#client_scoped_subscription}
    */
    readonly clientScopedSubscription?: ServicebusSubscriptionClientScopedSubscription;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#timeouts ServicebusSubscription#timeouts}
    */
    readonly timeouts?: ServicebusSubscriptionTimeouts;
}
export interface ServicebusSubscriptionClientScopedSubscription {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#client_id ServicebusSubscription#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#is_client_scoped_subscription_shareable ServicebusSubscription#is_client_scoped_subscription_shareable}
    */
    readonly isClientScopedSubscriptionShareable?: boolean | cdktf.IResolvable;
}
export declare function servicebusSubscriptionClientScopedSubscriptionToTerraform(struct?: ServicebusSubscriptionClientScopedSubscriptionOutputReference | ServicebusSubscriptionClientScopedSubscription): any;
export declare class ServicebusSubscriptionClientScopedSubscriptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicebusSubscriptionClientScopedSubscription | undefined;
    set internalValue(value: ServicebusSubscriptionClientScopedSubscription | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    get isClientScopedSubscriptionDurable(): cdktf.IResolvable;
    private _isClientScopedSubscriptionShareable?;
    get isClientScopedSubscriptionShareable(): boolean | cdktf.IResolvable;
    set isClientScopedSubscriptionShareable(value: boolean | cdktf.IResolvable);
    resetIsClientScopedSubscriptionShareable(): void;
    get isClientScopedSubscriptionShareableInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ServicebusSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#create ServicebusSubscription#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#delete ServicebusSubscription#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#read ServicebusSubscription#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#update ServicebusSubscription#update}
    */
    readonly update?: string;
}
export declare function servicebusSubscriptionTimeoutsToTerraform(struct?: ServicebusSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class ServicebusSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicebusSubscriptionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ServicebusSubscriptionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription azurerm_servicebus_subscription}
*/
export declare class ServicebusSubscription extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_servicebus_subscription";
    /**
    * Generates CDKTF code for importing a ServicebusSubscription resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ServicebusSubscription to import
    * @param importFromId The id of the existing ServicebusSubscription that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ServicebusSubscription to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/servicebus_subscription azurerm_servicebus_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicebusSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: ServicebusSubscriptionConfig);
    private _autoDeleteOnIdle?;
    get autoDeleteOnIdle(): string;
    set autoDeleteOnIdle(value: string);
    resetAutoDeleteOnIdle(): void;
    get autoDeleteOnIdleInput(): string | undefined;
    private _clientScopedSubscriptionEnabled?;
    get clientScopedSubscriptionEnabled(): boolean | cdktf.IResolvable;
    set clientScopedSubscriptionEnabled(value: boolean | cdktf.IResolvable);
    resetClientScopedSubscriptionEnabled(): void;
    get clientScopedSubscriptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _deadLetteringOnFilterEvaluationError?;
    get deadLetteringOnFilterEvaluationError(): boolean | cdktf.IResolvable;
    set deadLetteringOnFilterEvaluationError(value: boolean | cdktf.IResolvable);
    resetDeadLetteringOnFilterEvaluationError(): void;
    get deadLetteringOnFilterEvaluationErrorInput(): boolean | cdktf.IResolvable | undefined;
    private _deadLetteringOnMessageExpiration?;
    get deadLetteringOnMessageExpiration(): boolean | cdktf.IResolvable;
    set deadLetteringOnMessageExpiration(value: boolean | cdktf.IResolvable);
    resetDeadLetteringOnMessageExpiration(): void;
    get deadLetteringOnMessageExpirationInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultMessageTtl?;
    get defaultMessageTtl(): string;
    set defaultMessageTtl(value: string);
    resetDefaultMessageTtl(): void;
    get defaultMessageTtlInput(): string | undefined;
    private _enableBatchedOperations?;
    get enableBatchedOperations(): boolean | cdktf.IResolvable;
    set enableBatchedOperations(value: boolean | cdktf.IResolvable);
    resetEnableBatchedOperations(): void;
    get enableBatchedOperationsInput(): boolean | cdktf.IResolvable | undefined;
    private _forwardDeadLetteredMessagesTo?;
    get forwardDeadLetteredMessagesTo(): string;
    set forwardDeadLetteredMessagesTo(value: string);
    resetForwardDeadLetteredMessagesTo(): void;
    get forwardDeadLetteredMessagesToInput(): string | undefined;
    private _forwardTo?;
    get forwardTo(): string;
    set forwardTo(value: string);
    resetForwardTo(): void;
    get forwardToInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lockDuration?;
    get lockDuration(): string;
    set lockDuration(value: string);
    resetLockDuration(): void;
    get lockDurationInput(): string | undefined;
    private _maxDeliveryCount?;
    get maxDeliveryCount(): number;
    set maxDeliveryCount(value: number);
    get maxDeliveryCountInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _requiresSession?;
    get requiresSession(): boolean | cdktf.IResolvable;
    set requiresSession(value: boolean | cdktf.IResolvable);
    resetRequiresSession(): void;
    get requiresSessionInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _topicId?;
    get topicId(): string;
    set topicId(value: string);
    get topicIdInput(): string | undefined;
    private _clientScopedSubscription;
    get clientScopedSubscription(): ServicebusSubscriptionClientScopedSubscriptionOutputReference;
    putClientScopedSubscription(value: ServicebusSubscriptionClientScopedSubscription): void;
    resetClientScopedSubscription(): void;
    get clientScopedSubscriptionInput(): ServicebusSubscriptionClientScopedSubscription | undefined;
    private _timeouts;
    get timeouts(): ServicebusSubscriptionTimeoutsOutputReference;
    putTimeouts(value: ServicebusSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ServicebusSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
