/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SourceControlTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/source_control_token#id SourceControlToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/source_control_token#token SourceControlToken#token}
    */
    readonly token: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/source_control_token#token_secret SourceControlToken#token_secret}
    */
    readonly tokenSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/source_control_token#type SourceControlToken#type}
    */
    readonly type: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/source_control_token#timeouts SourceControlToken#timeouts}
    */
    readonly timeouts?: SourceControlTokenTimeouts;
}
export interface SourceControlTokenTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/source_control_token#create SourceControlToken#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/source_control_token#delete SourceControlToken#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/source_control_token#read SourceControlToken#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/source_control_token#update SourceControlToken#update}
    */
    readonly update?: string;
}
export declare function sourceControlTokenTimeoutsToTerraform(struct?: SourceControlTokenTimeouts | cdktf.IResolvable): any;
export declare class SourceControlTokenTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SourceControlTokenTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SourceControlTokenTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/source_control_token azurerm_source_control_token}
*/
export declare class SourceControlToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_source_control_token";
    /**
    * Generates CDKTF code for importing a SourceControlToken resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SourceControlToken to import
    * @param importFromId The id of the existing SourceControlToken that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/source_control_token#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SourceControlToken to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/source_control_token azurerm_source_control_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SourceControlTokenConfig
    */
    constructor(scope: Construct, id: string, config: SourceControlTokenConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    get tokenInput(): string | undefined;
    private _tokenSecret?;
    get tokenSecret(): string;
    set tokenSecret(value: string);
    resetTokenSecret(): void;
    get tokenSecretInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _timeouts;
    get timeouts(): SourceControlTokenTimeoutsOutputReference;
    putTimeouts(value: SourceControlTokenTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SourceControlTokenTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
