/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VideoAnalyzerEdgeModuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/video_analyzer_edge_module#id VideoAnalyzerEdgeModule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/video_analyzer_edge_module#name VideoAnalyzerEdgeModule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/video_analyzer_edge_module#resource_group_name VideoAnalyzerEdgeModule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/video_analyzer_edge_module#video_analyzer_name VideoAnalyzerEdgeModule#video_analyzer_name}
    */
    readonly videoAnalyzerName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/video_analyzer_edge_module#timeouts VideoAnalyzerEdgeModule#timeouts}
    */
    readonly timeouts?: VideoAnalyzerEdgeModuleTimeouts;
}
export interface VideoAnalyzerEdgeModuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/video_analyzer_edge_module#create VideoAnalyzerEdgeModule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/video_analyzer_edge_module#delete VideoAnalyzerEdgeModule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/video_analyzer_edge_module#read VideoAnalyzerEdgeModule#read}
    */
    readonly read?: string;
}
export declare function videoAnalyzerEdgeModuleTimeoutsToTerraform(struct?: VideoAnalyzerEdgeModuleTimeouts | cdktf.IResolvable): any;
export declare class VideoAnalyzerEdgeModuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VideoAnalyzerEdgeModuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VideoAnalyzerEdgeModuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/video_analyzer_edge_module azurerm_video_analyzer_edge_module}
*/
export declare class VideoAnalyzerEdgeModule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_video_analyzer_edge_module";
    /**
    * Generates CDKTF code for importing a VideoAnalyzerEdgeModule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VideoAnalyzerEdgeModule to import
    * @param importFromId The id of the existing VideoAnalyzerEdgeModule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/video_analyzer_edge_module#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VideoAnalyzerEdgeModule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/video_analyzer_edge_module azurerm_video_analyzer_edge_module} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VideoAnalyzerEdgeModuleConfig
    */
    constructor(scope: Construct, id: string, config: VideoAnalyzerEdgeModuleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _videoAnalyzerName?;
    get videoAnalyzerName(): string;
    set videoAnalyzerName(value: string);
    get videoAnalyzerNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): VideoAnalyzerEdgeModuleTimeoutsOutputReference;
    putTimeouts(value: VideoAnalyzerEdgeModuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VideoAnalyzerEdgeModuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
