/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpnSiteConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#address_cidrs VpnSite#address_cidrs}
    */
    readonly addressCidrs?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#device_model VpnSite#device_model}
    */
    readonly deviceModel?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#device_vendor VpnSite#device_vendor}
    */
    readonly deviceVendor?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#id VpnSite#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#location VpnSite#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#name VpnSite#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#resource_group_name VpnSite#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#tags VpnSite#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#virtual_wan_id VpnSite#virtual_wan_id}
    */
    readonly virtualWanId: string;
    /**
    * link block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#link VpnSite#link}
    */
    readonly link?: VpnSiteLink[] | cdktf.IResolvable;
    /**
    * o365_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#o365_policy VpnSite#o365_policy}
    */
    readonly o365Policy?: VpnSiteO365Policy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#timeouts VpnSite#timeouts}
    */
    readonly timeouts?: VpnSiteTimeouts;
}
export interface VpnSiteLinkBgp {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#asn VpnSite#asn}
    */
    readonly asn: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#peering_address VpnSite#peering_address}
    */
    readonly peeringAddress: string;
}
export declare function vpnSiteLinkBgpToTerraform(struct?: VpnSiteLinkBgpOutputReference | VpnSiteLinkBgp): any;
export declare class VpnSiteLinkBgpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnSiteLinkBgp | undefined;
    set internalValue(value: VpnSiteLinkBgp | undefined);
    private _asn?;
    get asn(): number;
    set asn(value: number);
    get asnInput(): number | undefined;
    private _peeringAddress?;
    get peeringAddress(): string;
    set peeringAddress(value: string);
    get peeringAddressInput(): string | undefined;
}
export interface VpnSiteLink {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#fqdn VpnSite#fqdn}
    */
    readonly fqdn?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#ip_address VpnSite#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#name VpnSite#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#provider_name VpnSite#provider_name}
    */
    readonly providerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#speed_in_mbps VpnSite#speed_in_mbps}
    */
    readonly speedInMbps?: number;
    /**
    * bgp block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#bgp VpnSite#bgp}
    */
    readonly bgp?: VpnSiteLinkBgp;
}
export declare function vpnSiteLinkToTerraform(struct?: VpnSiteLink | cdktf.IResolvable): any;
export declare class VpnSiteLinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnSiteLink | cdktf.IResolvable | undefined;
    set internalValue(value: VpnSiteLink | cdktf.IResolvable | undefined);
    private _fqdn?;
    get fqdn(): string;
    set fqdn(value: string);
    resetFqdn(): void;
    get fqdnInput(): string | undefined;
    get id(): string;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _providerName?;
    get providerName(): string;
    set providerName(value: string);
    resetProviderName(): void;
    get providerNameInput(): string | undefined;
    private _speedInMbps?;
    get speedInMbps(): number;
    set speedInMbps(value: number);
    resetSpeedInMbps(): void;
    get speedInMbpsInput(): number | undefined;
    private _bgp;
    get bgp(): VpnSiteLinkBgpOutputReference;
    putBgp(value: VpnSiteLinkBgp): void;
    resetBgp(): void;
    get bgpInput(): VpnSiteLinkBgp | undefined;
}
export declare class VpnSiteLinkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnSiteLink[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnSiteLinkOutputReference;
}
export interface VpnSiteO365PolicyTrafficCategory {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#allow_endpoint_enabled VpnSite#allow_endpoint_enabled}
    */
    readonly allowEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#default_endpoint_enabled VpnSite#default_endpoint_enabled}
    */
    readonly defaultEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#optimize_endpoint_enabled VpnSite#optimize_endpoint_enabled}
    */
    readonly optimizeEndpointEnabled?: boolean | cdktf.IResolvable;
}
export declare function vpnSiteO365PolicyTrafficCategoryToTerraform(struct?: VpnSiteO365PolicyTrafficCategoryOutputReference | VpnSiteO365PolicyTrafficCategory): any;
export declare class VpnSiteO365PolicyTrafficCategoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnSiteO365PolicyTrafficCategory | undefined;
    set internalValue(value: VpnSiteO365PolicyTrafficCategory | undefined);
    private _allowEndpointEnabled?;
    get allowEndpointEnabled(): boolean | cdktf.IResolvable;
    set allowEndpointEnabled(value: boolean | cdktf.IResolvable);
    resetAllowEndpointEnabled(): void;
    get allowEndpointEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultEndpointEnabled?;
    get defaultEndpointEnabled(): boolean | cdktf.IResolvable;
    set defaultEndpointEnabled(value: boolean | cdktf.IResolvable);
    resetDefaultEndpointEnabled(): void;
    get defaultEndpointEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _optimizeEndpointEnabled?;
    get optimizeEndpointEnabled(): boolean | cdktf.IResolvable;
    set optimizeEndpointEnabled(value: boolean | cdktf.IResolvable);
    resetOptimizeEndpointEnabled(): void;
    get optimizeEndpointEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface VpnSiteO365Policy {
    /**
    * traffic_category block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#traffic_category VpnSite#traffic_category}
    */
    readonly trafficCategory?: VpnSiteO365PolicyTrafficCategory;
}
export declare function vpnSiteO365PolicyToTerraform(struct?: VpnSiteO365PolicyOutputReference | VpnSiteO365Policy): any;
export declare class VpnSiteO365PolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnSiteO365Policy | undefined;
    set internalValue(value: VpnSiteO365Policy | undefined);
    private _trafficCategory;
    get trafficCategory(): VpnSiteO365PolicyTrafficCategoryOutputReference;
    putTrafficCategory(value: VpnSiteO365PolicyTrafficCategory): void;
    resetTrafficCategory(): void;
    get trafficCategoryInput(): VpnSiteO365PolicyTrafficCategory | undefined;
}
export interface VpnSiteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#create VpnSite#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#delete VpnSite#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#read VpnSite#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#update VpnSite#update}
    */
    readonly update?: string;
}
export declare function vpnSiteTimeoutsToTerraform(struct?: VpnSiteTimeouts | cdktf.IResolvable): any;
export declare class VpnSiteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnSiteTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VpnSiteTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site azurerm_vpn_site}
*/
export declare class VpnSite extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_vpn_site";
    /**
    * Generates CDKTF code for importing a VpnSite resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VpnSite to import
    * @param importFromId The id of the existing VpnSite that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VpnSite to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/vpn_site azurerm_vpn_site} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpnSiteConfig
    */
    constructor(scope: Construct, id: string, config: VpnSiteConfig);
    private _addressCidrs?;
    get addressCidrs(): string[];
    set addressCidrs(value: string[]);
    resetAddressCidrs(): void;
    get addressCidrsInput(): string[] | undefined;
    private _deviceModel?;
    get deviceModel(): string;
    set deviceModel(value: string);
    resetDeviceModel(): void;
    get deviceModelInput(): string | undefined;
    private _deviceVendor?;
    get deviceVendor(): string;
    set deviceVendor(value: string);
    resetDeviceVendor(): void;
    get deviceVendorInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualWanId?;
    get virtualWanId(): string;
    set virtualWanId(value: string);
    get virtualWanIdInput(): string | undefined;
    private _link;
    get link(): VpnSiteLinkList;
    putLink(value: VpnSiteLink[] | cdktf.IResolvable): void;
    resetLink(): void;
    get linkInput(): cdktf.IResolvable | VpnSiteLink[] | undefined;
    private _o365Policy;
    get o365Policy(): VpnSiteO365PolicyOutputReference;
    putO365Policy(value: VpnSiteO365Policy): void;
    resetO365Policy(): void;
    get o365PolicyInput(): VpnSiteO365Policy | undefined;
    private _timeouts;
    get timeouts(): VpnSiteTimeoutsOutputReference;
    putTimeouts(value: VpnSiteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VpnSiteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
