/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WebPubsubCustomCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/web_pubsub_custom_certificate#custom_certificate_id WebPubsubCustomCertificate#custom_certificate_id}
    */
    readonly customCertificateId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/web_pubsub_custom_certificate#id WebPubsubCustomCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/web_pubsub_custom_certificate#name WebPubsubCustomCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/web_pubsub_custom_certificate#web_pubsub_id WebPubsubCustomCertificate#web_pubsub_id}
    */
    readonly webPubsubId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/web_pubsub_custom_certificate#timeouts WebPubsubCustomCertificate#timeouts}
    */
    readonly timeouts?: WebPubsubCustomCertificateTimeouts;
}
export interface WebPubsubCustomCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/web_pubsub_custom_certificate#create WebPubsubCustomCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/web_pubsub_custom_certificate#delete WebPubsubCustomCertificate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/web_pubsub_custom_certificate#read WebPubsubCustomCertificate#read}
    */
    readonly read?: string;
}
export declare function webPubsubCustomCertificateTimeoutsToTerraform(struct?: WebPubsubCustomCertificateTimeouts | cdktf.IResolvable): any;
export declare class WebPubsubCustomCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebPubsubCustomCertificateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WebPubsubCustomCertificateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/web_pubsub_custom_certificate azurerm_web_pubsub_custom_certificate}
*/
export declare class WebPubsubCustomCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_web_pubsub_custom_certificate";
    /**
    * Generates CDKTF code for importing a WebPubsubCustomCertificate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the WebPubsubCustomCertificate to import
    * @param importFromId The id of the existing WebPubsubCustomCertificate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/web_pubsub_custom_certificate#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the WebPubsubCustomCertificate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/web_pubsub_custom_certificate azurerm_web_pubsub_custom_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WebPubsubCustomCertificateConfig
    */
    constructor(scope: Construct, id: string, config: WebPubsubCustomCertificateConfig);
    get certificateVersion(): string;
    private _customCertificateId?;
    get customCertificateId(): string;
    set customCertificateId(value: string);
    get customCertificateIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _webPubsubId?;
    get webPubsubId(): string;
    set webPubsubId(value: string);
    get webPubsubIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): WebPubsubCustomCertificateTimeoutsOutputReference;
    putTimeouts(value: WebPubsubCustomCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WebPubsubCustomCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
