/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WindowsWebAppSlotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#app_service_id WindowsWebAppSlot#app_service_id}
    */
    readonly appServiceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#app_settings WindowsWebAppSlot#app_settings}
    */
    readonly appSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_affinity_enabled WindowsWebAppSlot#client_affinity_enabled}
    */
    readonly clientAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_certificate_enabled WindowsWebAppSlot#client_certificate_enabled}
    */
    readonly clientCertificateEnabled?: boolean | cdktf.IResolvable;
    /**
    * Paths to exclude when using client certificates, separated by ;
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_certificate_exclusion_paths WindowsWebAppSlot#client_certificate_exclusion_paths}
    */
    readonly clientCertificateExclusionPaths?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_certificate_mode WindowsWebAppSlot#client_certificate_mode}
    */
    readonly clientCertificateMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#enabled WindowsWebAppSlot#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#https_only WindowsWebAppSlot#https_only}
    */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#id WindowsWebAppSlot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#key_vault_reference_identity_id WindowsWebAppSlot#key_vault_reference_identity_id}
    */
    readonly keyVaultReferenceIdentityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#name WindowsWebAppSlot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#public_network_access_enabled WindowsWebAppSlot#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#service_plan_id WindowsWebAppSlot#service_plan_id}
    */
    readonly servicePlanId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#tags WindowsWebAppSlot#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#virtual_network_subnet_id WindowsWebAppSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
    /**
    * The local path and filename of the Zip packaged application to deploy to this Windows Web App. **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` on the App in `app_settings`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#zip_deploy_file WindowsWebAppSlot#zip_deploy_file}
    */
    readonly zipDeployFile?: string;
    /**
    * auth_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#auth_settings WindowsWebAppSlot#auth_settings}
    */
    readonly authSettings?: WindowsWebAppSlotAuthSettings;
    /**
    * auth_settings_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#auth_settings_v2 WindowsWebAppSlot#auth_settings_v2}
    */
    readonly authSettingsV2?: WindowsWebAppSlotAuthSettingsV2;
    /**
    * backup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#backup WindowsWebAppSlot#backup}
    */
    readonly backup?: WindowsWebAppSlotBackup;
    /**
    * connection_string block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#connection_string WindowsWebAppSlot#connection_string}
    */
    readonly connectionString?: WindowsWebAppSlotConnectionString[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#identity WindowsWebAppSlot#identity}
    */
    readonly identity?: WindowsWebAppSlotIdentity;
    /**
    * logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#logs WindowsWebAppSlot#logs}
    */
    readonly logs?: WindowsWebAppSlotLogs;
    /**
    * site_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#site_config WindowsWebAppSlot#site_config}
    */
    readonly siteConfig: WindowsWebAppSlotSiteConfig;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#storage_account WindowsWebAppSlot#storage_account}
    */
    readonly storageAccount?: WindowsWebAppSlotStorageAccount[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#timeouts WindowsWebAppSlot#timeouts}
    */
    readonly timeouts?: WindowsWebAppSlotTimeouts;
}
export interface WindowsWebAppSlotSiteCredential {
}
export declare function windowsWebAppSlotSiteCredentialToTerraform(struct?: WindowsWebAppSlotSiteCredential): any;
export declare class WindowsWebAppSlotSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSlotSiteCredential | undefined;
    set internalValue(value: WindowsWebAppSlotSiteCredential | undefined);
    get name(): string;
    get password(): string;
}
export declare class WindowsWebAppSlotSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSlotSiteCredentialOutputReference;
}
export interface WindowsWebAppSlotAuthSettingsActiveDirectory {
    /**
    * Specifies a list of Allowed audience values to consider when validating JWTs issued by Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#allowed_audiences WindowsWebAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The ID of the Client to use to authenticate with Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_id WindowsWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The Client Secret for the Client ID. Cannot be used with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_secret WindowsWebAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The App Setting name that contains the client secret of the Client. Cannot be used with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_secret_setting_name WindowsWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
}
export declare function windowsWebAppSlotAuthSettingsActiveDirectoryToTerraform(struct?: WindowsWebAppSlotAuthSettingsActiveDirectoryOutputReference | WindowsWebAppSlotAuthSettingsActiveDirectory): any;
export declare class WindowsWebAppSlotAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsActiveDirectory | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsActiveDirectory | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
}
export interface WindowsWebAppSlotAuthSettingsFacebook {
    /**
    * The App ID of the Facebook app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#app_id WindowsWebAppSlot#app_id}
    */
    readonly appId: string;
    /**
    * The App Secret of the Facebook app used for Facebook Login. Cannot be specified with `app_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#app_secret WindowsWebAppSlot#app_secret}
    */
    readonly appSecret?: string;
    /**
    * The app setting name that contains the `app_secret` value used for Facebook Login. Cannot be specified with `app_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#app_secret_setting_name WindowsWebAppSlot#app_secret_setting_name}
    */
    readonly appSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes to be requested as part of Facebook Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#oauth_scopes WindowsWebAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function windowsWebAppSlotAuthSettingsFacebookToTerraform(struct?: WindowsWebAppSlotAuthSettingsFacebookOutputReference | WindowsWebAppSlotAuthSettingsFacebook): any;
export declare class WindowsWebAppSlotAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsFacebook | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsFacebook | undefined);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecret?;
    get appSecret(): string;
    set appSecret(value: string);
    resetAppSecret(): void;
    get appSecretInput(): string | undefined;
    private _appSecretSettingName?;
    get appSecretSettingName(): string;
    set appSecretSettingName(value: string);
    resetAppSecretSettingName(): void;
    get appSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface WindowsWebAppSlotAuthSettingsGithub {
    /**
    * The ID of the GitHub app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_id WindowsWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The Client Secret of the GitHub app used for GitHub Login. Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_secret WindowsWebAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name that contains the `client_secret` value used for GitHub Login. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_secret_setting_name WindowsWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#oauth_scopes WindowsWebAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function windowsWebAppSlotAuthSettingsGithubToTerraform(struct?: WindowsWebAppSlotAuthSettingsGithubOutputReference | WindowsWebAppSlotAuthSettingsGithub): any;
export declare class WindowsWebAppSlotAuthSettingsGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsGithub | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsGithub | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface WindowsWebAppSlotAuthSettingsGoogle {
    /**
    * The OpenID Connect Client ID for the Google web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_id WindowsWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The client secret associated with the Google web application.  Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_secret WindowsWebAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name that contains the `client_secret` value used for Google Login. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_secret_setting_name WindowsWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication. If not specified, "openid", "profile", and "email" are used as default scopes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#oauth_scopes WindowsWebAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function windowsWebAppSlotAuthSettingsGoogleToTerraform(struct?: WindowsWebAppSlotAuthSettingsGoogleOutputReference | WindowsWebAppSlotAuthSettingsGoogle): any;
export declare class WindowsWebAppSlotAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsGoogle | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsGoogle | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface WindowsWebAppSlotAuthSettingsMicrosoft {
    /**
    * The OAuth 2.0 client ID that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_id WindowsWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The OAuth 2.0 client secret that was created for the app used for authentication. Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_secret WindowsWebAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name containing the OAuth 2.0 client secret that was created for the app used for authentication. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_secret_setting_name WindowsWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * The list of OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication. If not specified, `wl.basic` is used as the default scope.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#oauth_scopes WindowsWebAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function windowsWebAppSlotAuthSettingsMicrosoftToTerraform(struct?: WindowsWebAppSlotAuthSettingsMicrosoftOutputReference | WindowsWebAppSlotAuthSettingsMicrosoft): any;
export declare class WindowsWebAppSlotAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsMicrosoft | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsMicrosoft | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface WindowsWebAppSlotAuthSettingsTwitter {
    /**
    * The OAuth 1.0a consumer key of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#consumer_key WindowsWebAppSlot#consumer_key}
    */
    readonly consumerKey: string;
    /**
    * The OAuth 1.0a consumer secret of the Twitter application used for sign-in. Cannot be specified with `consumer_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#consumer_secret WindowsWebAppSlot#consumer_secret}
    */
    readonly consumerSecret?: string;
    /**
    * The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in. Cannot be specified with `consumer_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#consumer_secret_setting_name WindowsWebAppSlot#consumer_secret_setting_name}
    */
    readonly consumerSecretSettingName?: string;
}
export declare function windowsWebAppSlotAuthSettingsTwitterToTerraform(struct?: WindowsWebAppSlotAuthSettingsTwitterOutputReference | WindowsWebAppSlotAuthSettingsTwitter): any;
export declare class WindowsWebAppSlotAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsTwitter | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsTwitter | undefined);
    private _consumerKey?;
    get consumerKey(): string;
    set consumerKey(value: string);
    get consumerKeyInput(): string | undefined;
    private _consumerSecret?;
    get consumerSecret(): string;
    set consumerSecret(value: string);
    resetConsumerSecret(): void;
    get consumerSecretInput(): string | undefined;
    private _consumerSecretSettingName?;
    get consumerSecretSettingName(): string;
    set consumerSecretSettingName(value: string);
    resetConsumerSecretSettingName(): void;
    get consumerSecretSettingNameInput(): string | undefined;
}
export interface WindowsWebAppSlotAuthSettings {
    /**
    * Specifies a map of Login Parameters to send to the OpenID Connect authorization endpoint when a user logs in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#additional_login_parameters WindowsWebAppSlot#additional_login_parameters}
    */
    readonly additionalLoginParameters?: {
        [key: string]: string;
    };
    /**
    * Specifies a list of External URLs that can be redirected to as part of logging in or logging out of the Windows Web App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#allowed_external_redirect_urls WindowsWebAppSlot#allowed_external_redirect_urls}
    */
    readonly allowedExternalRedirectUrls?: string[];
    /**
    * The default authentication provider to use when multiple providers are configured. Possible values include: `AzureActiveDirectory`, `Facebook`, `Google`, `MicrosoftAccount`, `Twitter`, `Github`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#default_provider WindowsWebAppSlot#default_provider}
    */
    readonly defaultProvider?: string;
    /**
    * Should the Authentication / Authorization feature be enabled?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#enabled WindowsWebAppSlot#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The OpenID Connect Issuer URI that represents the entity which issues access tokens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#issuer WindowsWebAppSlot#issuer}
    */
    readonly issuer?: string;
    /**
    * The RuntimeVersion of the Authentication / Authorization feature in use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#runtime_version WindowsWebAppSlot#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * The number of hours after session token expiration that a session token can be used to call the token refresh API. Defaults to `72` hours.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#token_refresh_extension_hours WindowsWebAppSlot#token_refresh_extension_hours}
    */
    readonly tokenRefreshExtensionHours?: number;
    /**
    * Should the Windows Web App durably store platform-specific security tokens that are obtained during login flows? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#token_store_enabled WindowsWebAppSlot#token_store_enabled}
    */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * The action to take when an unauthenticated client attempts to access the app. Possible values include: `RedirectToLoginPage`, `AllowAnonymous`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#unauthenticated_client_action WindowsWebAppSlot#unauthenticated_client_action}
    */
    readonly unauthenticatedClientAction?: string;
    /**
    * active_directory block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#active_directory WindowsWebAppSlot#active_directory}
    */
    readonly activeDirectory?: WindowsWebAppSlotAuthSettingsActiveDirectory;
    /**
    * facebook block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#facebook WindowsWebAppSlot#facebook}
    */
    readonly facebook?: WindowsWebAppSlotAuthSettingsFacebook;
    /**
    * github block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#github WindowsWebAppSlot#github}
    */
    readonly github?: WindowsWebAppSlotAuthSettingsGithub;
    /**
    * google block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#google WindowsWebAppSlot#google}
    */
    readonly google?: WindowsWebAppSlotAuthSettingsGoogle;
    /**
    * microsoft block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#microsoft WindowsWebAppSlot#microsoft}
    */
    readonly microsoft?: WindowsWebAppSlotAuthSettingsMicrosoft;
    /**
    * twitter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#twitter WindowsWebAppSlot#twitter}
    */
    readonly twitter?: WindowsWebAppSlotAuthSettingsTwitter;
}
export declare function windowsWebAppSlotAuthSettingsToTerraform(struct?: WindowsWebAppSlotAuthSettingsOutputReference | WindowsWebAppSlotAuthSettings): any;
export declare class WindowsWebAppSlotAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettings | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettings | undefined);
    private _additionalLoginParameters?;
    get additionalLoginParameters(): {
        [key: string]: string;
    };
    set additionalLoginParameters(value: {
        [key: string]: string;
    });
    resetAdditionalLoginParameters(): void;
    get additionalLoginParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _allowedExternalRedirectUrls?;
    get allowedExternalRedirectUrls(): string[];
    set allowedExternalRedirectUrls(value: string[]);
    resetAllowedExternalRedirectUrls(): void;
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _defaultProvider?;
    get defaultProvider(): string;
    set defaultProvider(value: string);
    resetDefaultProvider(): void;
    get defaultProviderInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _tokenRefreshExtensionHours?;
    get tokenRefreshExtensionHours(): number;
    set tokenRefreshExtensionHours(value: number);
    resetTokenRefreshExtensionHours(): void;
    get tokenRefreshExtensionHoursInput(): number | undefined;
    private _tokenStoreEnabled?;
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    resetTokenStoreEnabled(): void;
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _unauthenticatedClientAction?;
    get unauthenticatedClientAction(): string;
    set unauthenticatedClientAction(value: string);
    resetUnauthenticatedClientAction(): void;
    get unauthenticatedClientActionInput(): string | undefined;
    private _activeDirectory;
    get activeDirectory(): WindowsWebAppSlotAuthSettingsActiveDirectoryOutputReference;
    putActiveDirectory(value: WindowsWebAppSlotAuthSettingsActiveDirectory): void;
    resetActiveDirectory(): void;
    get activeDirectoryInput(): WindowsWebAppSlotAuthSettingsActiveDirectory | undefined;
    private _facebook;
    get facebook(): WindowsWebAppSlotAuthSettingsFacebookOutputReference;
    putFacebook(value: WindowsWebAppSlotAuthSettingsFacebook): void;
    resetFacebook(): void;
    get facebookInput(): WindowsWebAppSlotAuthSettingsFacebook | undefined;
    private _github;
    get github(): WindowsWebAppSlotAuthSettingsGithubOutputReference;
    putGithub(value: WindowsWebAppSlotAuthSettingsGithub): void;
    resetGithub(): void;
    get githubInput(): WindowsWebAppSlotAuthSettingsGithub | undefined;
    private _google;
    get google(): WindowsWebAppSlotAuthSettingsGoogleOutputReference;
    putGoogle(value: WindowsWebAppSlotAuthSettingsGoogle): void;
    resetGoogle(): void;
    get googleInput(): WindowsWebAppSlotAuthSettingsGoogle | undefined;
    private _microsoft;
    get microsoft(): WindowsWebAppSlotAuthSettingsMicrosoftOutputReference;
    putMicrosoft(value: WindowsWebAppSlotAuthSettingsMicrosoft): void;
    resetMicrosoft(): void;
    get microsoftInput(): WindowsWebAppSlotAuthSettingsMicrosoft | undefined;
    private _twitter;
    get twitter(): WindowsWebAppSlotAuthSettingsTwitterOutputReference;
    putTwitter(value: WindowsWebAppSlotAuthSettingsTwitter): void;
    resetTwitter(): void;
    get twitterInput(): WindowsWebAppSlotAuthSettingsTwitter | undefined;
}
export interface WindowsWebAppSlotAuthSettingsV2ActiveDirectoryV2 {
    /**
    * The list of allowed Applications for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#allowed_applications WindowsWebAppSlot#allowed_applications}
    */
    readonly allowedApplications?: string[];
    /**
    * Specifies a list of Allowed audience values to consider when validating JWTs issued by Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#allowed_audiences WindowsWebAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The list of allowed Group Names for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#allowed_groups WindowsWebAppSlot#allowed_groups}
    */
    readonly allowedGroups?: string[];
    /**
    * The list of allowed Identities for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#allowed_identities WindowsWebAppSlot#allowed_identities}
    */
    readonly allowedIdentities?: string[];
    /**
    * The ID of the Client to use to authenticate with Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_id WindowsWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The thumbprint of the certificate used for signing purposes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_secret_certificate_thumbprint WindowsWebAppSlot#client_secret_certificate_thumbprint}
    */
    readonly clientSecretCertificateThumbprint?: string;
    /**
    * The App Setting name that contains the client secret of the Client.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_secret_setting_name WindowsWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * A list of Allowed Client Applications in the JWT Claim.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#jwt_allowed_client_applications WindowsWebAppSlot#jwt_allowed_client_applications}
    */
    readonly jwtAllowedClientApplications?: string[];
    /**
    * A list of Allowed Groups in the JWT Claim.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#jwt_allowed_groups WindowsWebAppSlot#jwt_allowed_groups}
    */
    readonly jwtAllowedGroups?: string[];
    /**
    * A map of key-value pairs to send to the Authorisation Endpoint when a user logs in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#login_parameters WindowsWebAppSlot#login_parameters}
    */
    readonly loginParameters?: {
        [key: string]: string;
    };
    /**
    * The Azure Tenant Endpoint for the Authenticating Tenant. e.g. `https://login.microsoftonline.com/v2.0/{tenant-guid}/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#tenant_auth_endpoint WindowsWebAppSlot#tenant_auth_endpoint}
    */
    readonly tenantAuthEndpoint: string;
    /**
    * Should the www-authenticate provider should be omitted from the request? Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#www_authentication_disabled WindowsWebAppSlot#www_authentication_disabled}
    */
    readonly wwwAuthenticationDisabled?: boolean | cdktf.IResolvable;
}
export declare function windowsWebAppSlotAuthSettingsV2ActiveDirectoryV2ToTerraform(struct?: WindowsWebAppSlotAuthSettingsV2ActiveDirectoryV2OutputReference | WindowsWebAppSlotAuthSettingsV2ActiveDirectoryV2): any;
export declare class WindowsWebAppSlotAuthSettingsV2ActiveDirectoryV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsV2ActiveDirectoryV2 | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsV2ActiveDirectoryV2 | undefined);
    private _allowedApplications?;
    get allowedApplications(): string[];
    set allowedApplications(value: string[]);
    resetAllowedApplications(): void;
    get allowedApplicationsInput(): string[] | undefined;
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _allowedGroups?;
    get allowedGroups(): string[];
    set allowedGroups(value: string[]);
    resetAllowedGroups(): void;
    get allowedGroupsInput(): string[] | undefined;
    private _allowedIdentities?;
    get allowedIdentities(): string[];
    set allowedIdentities(value: string[]);
    resetAllowedIdentities(): void;
    get allowedIdentitiesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretCertificateThumbprint?;
    get clientSecretCertificateThumbprint(): string;
    set clientSecretCertificateThumbprint(value: string);
    resetClientSecretCertificateThumbprint(): void;
    get clientSecretCertificateThumbprintInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _jwtAllowedClientApplications?;
    get jwtAllowedClientApplications(): string[];
    set jwtAllowedClientApplications(value: string[]);
    resetJwtAllowedClientApplications(): void;
    get jwtAllowedClientApplicationsInput(): string[] | undefined;
    private _jwtAllowedGroups?;
    get jwtAllowedGroups(): string[];
    set jwtAllowedGroups(value: string[]);
    resetJwtAllowedGroups(): void;
    get jwtAllowedGroupsInput(): string[] | undefined;
    private _loginParameters?;
    get loginParameters(): {
        [key: string]: string;
    };
    set loginParameters(value: {
        [key: string]: string;
    });
    resetLoginParameters(): void;
    get loginParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _tenantAuthEndpoint?;
    get tenantAuthEndpoint(): string;
    set tenantAuthEndpoint(value: string);
    get tenantAuthEndpointInput(): string | undefined;
    private _wwwAuthenticationDisabled?;
    get wwwAuthenticationDisabled(): boolean | cdktf.IResolvable;
    set wwwAuthenticationDisabled(value: boolean | cdktf.IResolvable);
    resetWwwAuthenticationDisabled(): void;
    get wwwAuthenticationDisabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WindowsWebAppSlotAuthSettingsV2AppleV2 {
    /**
    * The OpenID Connect Client ID for the Apple web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_id WindowsWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for Apple Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_secret_setting_name WindowsWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
}
export declare function windowsWebAppSlotAuthSettingsV2AppleV2ToTerraform(struct?: WindowsWebAppSlotAuthSettingsV2AppleV2OutputReference | WindowsWebAppSlotAuthSettingsV2AppleV2): any;
export declare class WindowsWebAppSlotAuthSettingsV2AppleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsV2AppleV2 | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsV2AppleV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    get loginScopes(): string[];
}
export interface WindowsWebAppSlotAuthSettingsV2AzureStaticWebAppV2 {
    /**
    * The ID of the Client to use to authenticate with Azure Static Web App Authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_id WindowsWebAppSlot#client_id}
    */
    readonly clientId: string;
}
export declare function windowsWebAppSlotAuthSettingsV2AzureStaticWebAppV2ToTerraform(struct?: WindowsWebAppSlotAuthSettingsV2AzureStaticWebAppV2OutputReference | WindowsWebAppSlotAuthSettingsV2AzureStaticWebAppV2): any;
export declare class WindowsWebAppSlotAuthSettingsV2AzureStaticWebAppV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsV2AzureStaticWebAppV2 | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsV2AzureStaticWebAppV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
}
export interface WindowsWebAppSlotAuthSettingsV2CustomOidcV2 {
    /**
    * The ID of the Client to use to authenticate with this Custom OIDC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_id WindowsWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The name of the Custom OIDC Authentication Provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#name WindowsWebAppSlot#name}
    */
    readonly name: string;
    /**
    * The name of the claim that contains the users name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#name_claim_type WindowsWebAppSlot#name_claim_type}
    */
    readonly nameClaimType?: string;
    /**
    * The endpoint that contains all the configuration endpoints for this Custom OIDC provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#openid_configuration_endpoint WindowsWebAppSlot#openid_configuration_endpoint}
    */
    readonly openidConfigurationEndpoint: string;
    /**
    * The list of the scopes that should be requested while authenticating.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#scopes WindowsWebAppSlot#scopes}
    */
    readonly scopes?: string[];
}
export declare function windowsWebAppSlotAuthSettingsV2CustomOidcV2ToTerraform(struct?: WindowsWebAppSlotAuthSettingsV2CustomOidcV2 | cdktf.IResolvable): any;
export declare class WindowsWebAppSlotAuthSettingsV2CustomOidcV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSlotAuthSettingsV2CustomOidcV2 | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsV2CustomOidcV2 | cdktf.IResolvable | undefined);
    get authorisationEndpoint(): string;
    get certificationUri(): string;
    get clientCredentialMethod(): string;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    get clientSecretSettingName(): string;
    get issuerEndpoint(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nameClaimType?;
    get nameClaimType(): string;
    set nameClaimType(value: string);
    resetNameClaimType(): void;
    get nameClaimTypeInput(): string | undefined;
    private _openidConfigurationEndpoint?;
    get openidConfigurationEndpoint(): string;
    set openidConfigurationEndpoint(value: string);
    get openidConfigurationEndpointInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
    get tokenEndpoint(): string;
}
export declare class WindowsWebAppSlotAuthSettingsV2CustomOidcV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSlotAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSlotAuthSettingsV2CustomOidcV2OutputReference;
}
export interface WindowsWebAppSlotAuthSettingsV2FacebookV2 {
    /**
    * The App ID of the Facebook app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#app_id WindowsWebAppSlot#app_id}
    */
    readonly appId: string;
    /**
    * The app setting name that contains the `app_secret` value used for Facebook Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#app_secret_setting_name WindowsWebAppSlot#app_secret_setting_name}
    */
    readonly appSecretSettingName: string;
    /**
    * The version of the Facebook API to be used while logging in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#graph_api_version WindowsWebAppSlot#graph_api_version}
    */
    readonly graphApiVersion?: string;
    /**
    * Specifies a list of scopes to be requested as part of Facebook Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#login_scopes WindowsWebAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function windowsWebAppSlotAuthSettingsV2FacebookV2ToTerraform(struct?: WindowsWebAppSlotAuthSettingsV2FacebookV2OutputReference | WindowsWebAppSlotAuthSettingsV2FacebookV2): any;
export declare class WindowsWebAppSlotAuthSettingsV2FacebookV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsV2FacebookV2 | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsV2FacebookV2 | undefined);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecretSettingName?;
    get appSecretSettingName(): string;
    set appSecretSettingName(value: string);
    get appSecretSettingNameInput(): string | undefined;
    private _graphApiVersion?;
    get graphApiVersion(): string;
    set graphApiVersion(value: string);
    resetGraphApiVersion(): void;
    get graphApiVersionInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface WindowsWebAppSlotAuthSettingsV2GithubV2 {
    /**
    * The ID of the GitHub app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_id WindowsWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for GitHub Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_secret_setting_name WindowsWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#login_scopes WindowsWebAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function windowsWebAppSlotAuthSettingsV2GithubV2ToTerraform(struct?: WindowsWebAppSlotAuthSettingsV2GithubV2OutputReference | WindowsWebAppSlotAuthSettingsV2GithubV2): any;
export declare class WindowsWebAppSlotAuthSettingsV2GithubV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsV2GithubV2 | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsV2GithubV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface WindowsWebAppSlotAuthSettingsV2GoogleV2 {
    /**
    * Specifies a list of Allowed Audiences that will be requested as part of Google Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#allowed_audiences WindowsWebAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The OpenID Connect Client ID for the Google web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_id WindowsWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for Google Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_secret_setting_name WindowsWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * Specifies a list of Login scopes that will be requested as part of Google Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#login_scopes WindowsWebAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function windowsWebAppSlotAuthSettingsV2GoogleV2ToTerraform(struct?: WindowsWebAppSlotAuthSettingsV2GoogleV2OutputReference | WindowsWebAppSlotAuthSettingsV2GoogleV2): any;
export declare class WindowsWebAppSlotAuthSettingsV2GoogleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsV2GoogleV2 | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsV2GoogleV2 | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface WindowsWebAppSlotAuthSettingsV2Login {
    /**
    * External URLs that can be redirected to as part of logging in or logging out of the app. This is an advanced setting typically only needed by Windows Store application backends. **Note:** URLs within the current domain are always implicitly allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#allowed_external_redirect_urls WindowsWebAppSlot#allowed_external_redirect_urls}
    */
    readonly allowedExternalRedirectUrls?: string[];
    /**
    * The method by which cookies expire. Possible values include: `FixedTime`, and `IdentityProviderDerived`. Defaults to `FixedTime`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#cookie_expiration_convention WindowsWebAppSlot#cookie_expiration_convention}
    */
    readonly cookieExpirationConvention?: string;
    /**
    * The time after the request is made when the session cookie should expire. Defaults to `08:00:00`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#cookie_expiration_time WindowsWebAppSlot#cookie_expiration_time}
    */
    readonly cookieExpirationTime?: string;
    /**
    * The endpoint to which logout requests should be made.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#logout_endpoint WindowsWebAppSlot#logout_endpoint}
    */
    readonly logoutEndpoint?: string;
    /**
    * The time after the request is made when the nonce should expire. Defaults to `00:05:00`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#nonce_expiration_time WindowsWebAppSlot#nonce_expiration_time}
    */
    readonly nonceExpirationTime?: string;
    /**
    * Should the fragments from the request be preserved after the login request is made. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#preserve_url_fragments_for_logins WindowsWebAppSlot#preserve_url_fragments_for_logins}
    */
    readonly preserveUrlFragmentsForLogins?: boolean | cdktf.IResolvable;
    /**
    * The number of hours after session token expiration that a session token can be used to call the token refresh API. Defaults to `72` hours.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#token_refresh_extension_time WindowsWebAppSlot#token_refresh_extension_time}
    */
    readonly tokenRefreshExtensionTime?: number;
    /**
    * Should the Token Store configuration Enabled. Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#token_store_enabled WindowsWebAppSlot#token_store_enabled}
    */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * The directory path in the App Filesystem in which the tokens will be stored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#token_store_path WindowsWebAppSlot#token_store_path}
    */
    readonly tokenStorePath?: string;
    /**
    * The name of the app setting which contains the SAS URL of the blob storage containing the tokens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#token_store_sas_setting_name WindowsWebAppSlot#token_store_sas_setting_name}
    */
    readonly tokenStoreSasSettingName?: string;
    /**
    * Should the nonce be validated while completing the login flow. Defaults to `true`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#validate_nonce WindowsWebAppSlot#validate_nonce}
    */
    readonly validateNonce?: boolean | cdktf.IResolvable;
}
export declare function windowsWebAppSlotAuthSettingsV2LoginToTerraform(struct?: WindowsWebAppSlotAuthSettingsV2LoginOutputReference | WindowsWebAppSlotAuthSettingsV2Login): any;
export declare class WindowsWebAppSlotAuthSettingsV2LoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsV2Login | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsV2Login | undefined);
    private _allowedExternalRedirectUrls?;
    get allowedExternalRedirectUrls(): string[];
    set allowedExternalRedirectUrls(value: string[]);
    resetAllowedExternalRedirectUrls(): void;
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _cookieExpirationConvention?;
    get cookieExpirationConvention(): string;
    set cookieExpirationConvention(value: string);
    resetCookieExpirationConvention(): void;
    get cookieExpirationConventionInput(): string | undefined;
    private _cookieExpirationTime?;
    get cookieExpirationTime(): string;
    set cookieExpirationTime(value: string);
    resetCookieExpirationTime(): void;
    get cookieExpirationTimeInput(): string | undefined;
    private _logoutEndpoint?;
    get logoutEndpoint(): string;
    set logoutEndpoint(value: string);
    resetLogoutEndpoint(): void;
    get logoutEndpointInput(): string | undefined;
    private _nonceExpirationTime?;
    get nonceExpirationTime(): string;
    set nonceExpirationTime(value: string);
    resetNonceExpirationTime(): void;
    get nonceExpirationTimeInput(): string | undefined;
    private _preserveUrlFragmentsForLogins?;
    get preserveUrlFragmentsForLogins(): boolean | cdktf.IResolvable;
    set preserveUrlFragmentsForLogins(value: boolean | cdktf.IResolvable);
    resetPreserveUrlFragmentsForLogins(): void;
    get preserveUrlFragmentsForLoginsInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenRefreshExtensionTime?;
    get tokenRefreshExtensionTime(): number;
    set tokenRefreshExtensionTime(value: number);
    resetTokenRefreshExtensionTime(): void;
    get tokenRefreshExtensionTimeInput(): number | undefined;
    private _tokenStoreEnabled?;
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    resetTokenStoreEnabled(): void;
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenStorePath?;
    get tokenStorePath(): string;
    set tokenStorePath(value: string);
    resetTokenStorePath(): void;
    get tokenStorePathInput(): string | undefined;
    private _tokenStoreSasSettingName?;
    get tokenStoreSasSettingName(): string;
    set tokenStoreSasSettingName(value: string);
    resetTokenStoreSasSettingName(): void;
    get tokenStoreSasSettingNameInput(): string | undefined;
    private _validateNonce?;
    get validateNonce(): boolean | cdktf.IResolvable;
    set validateNonce(value: boolean | cdktf.IResolvable);
    resetValidateNonce(): void;
    get validateNonceInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WindowsWebAppSlotAuthSettingsV2MicrosoftV2 {
    /**
    * Specifies a list of Allowed Audiences that will be requested as part of Microsoft Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#allowed_audiences WindowsWebAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The OAuth 2.0 client ID that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_id WindowsWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name containing the OAuth 2.0 client secret that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#client_secret_setting_name WindowsWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * The list of Login scopes that will be requested as part of Microsoft Account authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#login_scopes WindowsWebAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function windowsWebAppSlotAuthSettingsV2MicrosoftV2ToTerraform(struct?: WindowsWebAppSlotAuthSettingsV2MicrosoftV2OutputReference | WindowsWebAppSlotAuthSettingsV2MicrosoftV2): any;
export declare class WindowsWebAppSlotAuthSettingsV2MicrosoftV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsV2MicrosoftV2 | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsV2MicrosoftV2 | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface WindowsWebAppSlotAuthSettingsV2TwitterV2 {
    /**
    * The OAuth 1.0a consumer key of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#consumer_key WindowsWebAppSlot#consumer_key}
    */
    readonly consumerKey: string;
    /**
    * The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#consumer_secret_setting_name WindowsWebAppSlot#consumer_secret_setting_name}
    */
    readonly consumerSecretSettingName: string;
}
export declare function windowsWebAppSlotAuthSettingsV2TwitterV2ToTerraform(struct?: WindowsWebAppSlotAuthSettingsV2TwitterV2OutputReference | WindowsWebAppSlotAuthSettingsV2TwitterV2): any;
export declare class WindowsWebAppSlotAuthSettingsV2TwitterV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsV2TwitterV2 | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsV2TwitterV2 | undefined);
    private _consumerKey?;
    get consumerKey(): string;
    set consumerKey(value: string);
    get consumerKeyInput(): string | undefined;
    private _consumerSecretSettingName?;
    get consumerSecretSettingName(): string;
    set consumerSecretSettingName(value: string);
    get consumerSecretSettingNameInput(): string | undefined;
}
export interface WindowsWebAppSlotAuthSettingsV2 {
    /**
    * Should the AuthV2 Settings be enabled. Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#auth_enabled WindowsWebAppSlot#auth_enabled}
    */
    readonly authEnabled?: boolean | cdktf.IResolvable;
    /**
    * The path to the App Auth settings. **Note:** Relative Paths are evaluated from the Site Root directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#config_file_path WindowsWebAppSlot#config_file_path}
    */
    readonly configFilePath?: string;
    /**
    * The Default Authentication Provider to use when the `unauthenticated_action` is set to `RedirectToLoginPage`. Possible values include: `apple`, `azureactivedirectory`, `facebook`, `github`, `google`, `twitter` and the `name` of your `custom_oidc_v2` provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#default_provider WindowsWebAppSlot#default_provider}
    */
    readonly defaultProvider?: string;
    /**
    * The paths which should be excluded from the `unauthenticated_action` when it is set to `RedirectToLoginPage`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#excluded_paths WindowsWebAppSlot#excluded_paths}
    */
    readonly excludedPaths?: string[];
    /**
    * The convention used to determine the url of the request made. Possible values include `ForwardProxyConventionNoProxy`, `ForwardProxyConventionStandard`, `ForwardProxyConventionCustom`. Defaults to `ForwardProxyConventionNoProxy`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#forward_proxy_convention WindowsWebAppSlot#forward_proxy_convention}
    */
    readonly forwardProxyConvention?: string;
    /**
    * The name of the header containing the host of the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#forward_proxy_custom_host_header_name WindowsWebAppSlot#forward_proxy_custom_host_header_name}
    */
    readonly forwardProxyCustomHostHeaderName?: string;
    /**
    * The name of the header containing the scheme of the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#forward_proxy_custom_scheme_header_name WindowsWebAppSlot#forward_proxy_custom_scheme_header_name}
    */
    readonly forwardProxyCustomSchemeHeaderName?: string;
    /**
    * The prefix that should precede all the authentication and authorisation paths. Defaults to `/.auth`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#http_route_api_prefix WindowsWebAppSlot#http_route_api_prefix}
    */
    readonly httpRouteApiPrefix?: string;
    /**
    * Should the authentication flow be used for all requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#require_authentication WindowsWebAppSlot#require_authentication}
    */
    readonly requireAuthentication?: boolean | cdktf.IResolvable;
    /**
    * Should HTTPS be required on connections? Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#require_https WindowsWebAppSlot#require_https}
    */
    readonly requireHttps?: boolean | cdktf.IResolvable;
    /**
    * The Runtime Version of the Authentication and Authorisation feature of this App. Defaults to `~1`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#runtime_version WindowsWebAppSlot#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * The action to take for requests made without authentication. Possible values include `RedirectToLoginPage`, `AllowAnonymous`, `Return401`, and `Return403`. Defaults to `RedirectToLoginPage`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#unauthenticated_action WindowsWebAppSlot#unauthenticated_action}
    */
    readonly unauthenticatedAction?: string;
    /**
    * active_directory_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#active_directory_v2 WindowsWebAppSlot#active_directory_v2}
    */
    readonly activeDirectoryV2?: WindowsWebAppSlotAuthSettingsV2ActiveDirectoryV2;
    /**
    * apple_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#apple_v2 WindowsWebAppSlot#apple_v2}
    */
    readonly appleV2?: WindowsWebAppSlotAuthSettingsV2AppleV2;
    /**
    * azure_static_web_app_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#azure_static_web_app_v2 WindowsWebAppSlot#azure_static_web_app_v2}
    */
    readonly azureStaticWebAppV2?: WindowsWebAppSlotAuthSettingsV2AzureStaticWebAppV2;
    /**
    * custom_oidc_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#custom_oidc_v2 WindowsWebAppSlot#custom_oidc_v2}
    */
    readonly customOidcV2?: WindowsWebAppSlotAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable;
    /**
    * facebook_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#facebook_v2 WindowsWebAppSlot#facebook_v2}
    */
    readonly facebookV2?: WindowsWebAppSlotAuthSettingsV2FacebookV2;
    /**
    * github_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#github_v2 WindowsWebAppSlot#github_v2}
    */
    readonly githubV2?: WindowsWebAppSlotAuthSettingsV2GithubV2;
    /**
    * google_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#google_v2 WindowsWebAppSlot#google_v2}
    */
    readonly googleV2?: WindowsWebAppSlotAuthSettingsV2GoogleV2;
    /**
    * login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#login WindowsWebAppSlot#login}
    */
    readonly login: WindowsWebAppSlotAuthSettingsV2Login;
    /**
    * microsoft_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#microsoft_v2 WindowsWebAppSlot#microsoft_v2}
    */
    readonly microsoftV2?: WindowsWebAppSlotAuthSettingsV2MicrosoftV2;
    /**
    * twitter_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#twitter_v2 WindowsWebAppSlot#twitter_v2}
    */
    readonly twitterV2?: WindowsWebAppSlotAuthSettingsV2TwitterV2;
}
export declare function windowsWebAppSlotAuthSettingsV2ToTerraform(struct?: WindowsWebAppSlotAuthSettingsV2OutputReference | WindowsWebAppSlotAuthSettingsV2): any;
export declare class WindowsWebAppSlotAuthSettingsV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotAuthSettingsV2 | undefined;
    set internalValue(value: WindowsWebAppSlotAuthSettingsV2 | undefined);
    private _authEnabled?;
    get authEnabled(): boolean | cdktf.IResolvable;
    set authEnabled(value: boolean | cdktf.IResolvable);
    resetAuthEnabled(): void;
    get authEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _configFilePath?;
    get configFilePath(): string;
    set configFilePath(value: string);
    resetConfigFilePath(): void;
    get configFilePathInput(): string | undefined;
    private _defaultProvider?;
    get defaultProvider(): string;
    set defaultProvider(value: string);
    resetDefaultProvider(): void;
    get defaultProviderInput(): string | undefined;
    private _excludedPaths?;
    get excludedPaths(): string[];
    set excludedPaths(value: string[]);
    resetExcludedPaths(): void;
    get excludedPathsInput(): string[] | undefined;
    private _forwardProxyConvention?;
    get forwardProxyConvention(): string;
    set forwardProxyConvention(value: string);
    resetForwardProxyConvention(): void;
    get forwardProxyConventionInput(): string | undefined;
    private _forwardProxyCustomHostHeaderName?;
    get forwardProxyCustomHostHeaderName(): string;
    set forwardProxyCustomHostHeaderName(value: string);
    resetForwardProxyCustomHostHeaderName(): void;
    get forwardProxyCustomHostHeaderNameInput(): string | undefined;
    private _forwardProxyCustomSchemeHeaderName?;
    get forwardProxyCustomSchemeHeaderName(): string;
    set forwardProxyCustomSchemeHeaderName(value: string);
    resetForwardProxyCustomSchemeHeaderName(): void;
    get forwardProxyCustomSchemeHeaderNameInput(): string | undefined;
    private _httpRouteApiPrefix?;
    get httpRouteApiPrefix(): string;
    set httpRouteApiPrefix(value: string);
    resetHttpRouteApiPrefix(): void;
    get httpRouteApiPrefixInput(): string | undefined;
    private _requireAuthentication?;
    get requireAuthentication(): boolean | cdktf.IResolvable;
    set requireAuthentication(value: boolean | cdktf.IResolvable);
    resetRequireAuthentication(): void;
    get requireAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _requireHttps?;
    get requireHttps(): boolean | cdktf.IResolvable;
    set requireHttps(value: boolean | cdktf.IResolvable);
    resetRequireHttps(): void;
    get requireHttpsInput(): boolean | cdktf.IResolvable | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _unauthenticatedAction?;
    get unauthenticatedAction(): string;
    set unauthenticatedAction(value: string);
    resetUnauthenticatedAction(): void;
    get unauthenticatedActionInput(): string | undefined;
    private _activeDirectoryV2;
    get activeDirectoryV2(): WindowsWebAppSlotAuthSettingsV2ActiveDirectoryV2OutputReference;
    putActiveDirectoryV2(value: WindowsWebAppSlotAuthSettingsV2ActiveDirectoryV2): void;
    resetActiveDirectoryV2(): void;
    get activeDirectoryV2Input(): WindowsWebAppSlotAuthSettingsV2ActiveDirectoryV2 | undefined;
    private _appleV2;
    get appleV2(): WindowsWebAppSlotAuthSettingsV2AppleV2OutputReference;
    putAppleV2(value: WindowsWebAppSlotAuthSettingsV2AppleV2): void;
    resetAppleV2(): void;
    get appleV2Input(): WindowsWebAppSlotAuthSettingsV2AppleV2 | undefined;
    private _azureStaticWebAppV2;
    get azureStaticWebAppV2(): WindowsWebAppSlotAuthSettingsV2AzureStaticWebAppV2OutputReference;
    putAzureStaticWebAppV2(value: WindowsWebAppSlotAuthSettingsV2AzureStaticWebAppV2): void;
    resetAzureStaticWebAppV2(): void;
    get azureStaticWebAppV2Input(): WindowsWebAppSlotAuthSettingsV2AzureStaticWebAppV2 | undefined;
    private _customOidcV2;
    get customOidcV2(): WindowsWebAppSlotAuthSettingsV2CustomOidcV2List;
    putCustomOidcV2(value: WindowsWebAppSlotAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable): void;
    resetCustomOidcV2(): void;
    get customOidcV2Input(): cdktf.IResolvable | WindowsWebAppSlotAuthSettingsV2CustomOidcV2[] | undefined;
    private _facebookV2;
    get facebookV2(): WindowsWebAppSlotAuthSettingsV2FacebookV2OutputReference;
    putFacebookV2(value: WindowsWebAppSlotAuthSettingsV2FacebookV2): void;
    resetFacebookV2(): void;
    get facebookV2Input(): WindowsWebAppSlotAuthSettingsV2FacebookV2 | undefined;
    private _githubV2;
    get githubV2(): WindowsWebAppSlotAuthSettingsV2GithubV2OutputReference;
    putGithubV2(value: WindowsWebAppSlotAuthSettingsV2GithubV2): void;
    resetGithubV2(): void;
    get githubV2Input(): WindowsWebAppSlotAuthSettingsV2GithubV2 | undefined;
    private _googleV2;
    get googleV2(): WindowsWebAppSlotAuthSettingsV2GoogleV2OutputReference;
    putGoogleV2(value: WindowsWebAppSlotAuthSettingsV2GoogleV2): void;
    resetGoogleV2(): void;
    get googleV2Input(): WindowsWebAppSlotAuthSettingsV2GoogleV2 | undefined;
    private _login;
    get login(): WindowsWebAppSlotAuthSettingsV2LoginOutputReference;
    putLogin(value: WindowsWebAppSlotAuthSettingsV2Login): void;
    get loginInput(): WindowsWebAppSlotAuthSettingsV2Login | undefined;
    private _microsoftV2;
    get microsoftV2(): WindowsWebAppSlotAuthSettingsV2MicrosoftV2OutputReference;
    putMicrosoftV2(value: WindowsWebAppSlotAuthSettingsV2MicrosoftV2): void;
    resetMicrosoftV2(): void;
    get microsoftV2Input(): WindowsWebAppSlotAuthSettingsV2MicrosoftV2 | undefined;
    private _twitterV2;
    get twitterV2(): WindowsWebAppSlotAuthSettingsV2TwitterV2OutputReference;
    putTwitterV2(value: WindowsWebAppSlotAuthSettingsV2TwitterV2): void;
    resetTwitterV2(): void;
    get twitterV2Input(): WindowsWebAppSlotAuthSettingsV2TwitterV2 | undefined;
}
export interface WindowsWebAppSlotBackupSchedule {
    /**
    * How often the backup should be executed (e.g. for weekly backup, this should be set to `7` and `frequency_unit` should be set to `Day`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#frequency_interval WindowsWebAppSlot#frequency_interval}
    */
    readonly frequencyInterval: number;
    /**
    * The unit of time for how often the backup should take place. Possible values include: `Day` and `Hour`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#frequency_unit WindowsWebAppSlot#frequency_unit}
    */
    readonly frequencyUnit: string;
    /**
    * Should the service keep at least one backup, regardless of age of backup. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#keep_at_least_one_backup WindowsWebAppSlot#keep_at_least_one_backup}
    */
    readonly keepAtLeastOneBackup?: boolean | cdktf.IResolvable;
    /**
    * After how many days backups should be deleted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#retention_period_days WindowsWebAppSlot#retention_period_days}
    */
    readonly retentionPeriodDays?: number;
    /**
    * When the schedule should start working in RFC-3339 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#start_time WindowsWebAppSlot#start_time}
    */
    readonly startTime?: string;
}
export declare function windowsWebAppSlotBackupScheduleToTerraform(struct?: WindowsWebAppSlotBackupScheduleOutputReference | WindowsWebAppSlotBackupSchedule): any;
export declare class WindowsWebAppSlotBackupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotBackupSchedule | undefined;
    set internalValue(value: WindowsWebAppSlotBackupSchedule | undefined);
    private _frequencyInterval?;
    get frequencyInterval(): number;
    set frequencyInterval(value: number);
    get frequencyIntervalInput(): number | undefined;
    private _frequencyUnit?;
    get frequencyUnit(): string;
    set frequencyUnit(value: string);
    get frequencyUnitInput(): string | undefined;
    private _keepAtLeastOneBackup?;
    get keepAtLeastOneBackup(): boolean | cdktf.IResolvable;
    set keepAtLeastOneBackup(value: boolean | cdktf.IResolvable);
    resetKeepAtLeastOneBackup(): void;
    get keepAtLeastOneBackupInput(): boolean | cdktf.IResolvable | undefined;
    get lastExecutionTime(): string;
    private _retentionPeriodDays?;
    get retentionPeriodDays(): number;
    set retentionPeriodDays(value: number);
    resetRetentionPeriodDays(): void;
    get retentionPeriodDaysInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export interface WindowsWebAppSlotBackup {
    /**
    * Should this backup job be enabled?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#enabled WindowsWebAppSlot#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The name which should be used for this Backup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#name WindowsWebAppSlot#name}
    */
    readonly name: string;
    /**
    * The SAS URL to the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#storage_account_url WindowsWebAppSlot#storage_account_url}
    */
    readonly storageAccountUrl: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#schedule WindowsWebAppSlot#schedule}
    */
    readonly schedule: WindowsWebAppSlotBackupSchedule;
}
export declare function windowsWebAppSlotBackupToTerraform(struct?: WindowsWebAppSlotBackupOutputReference | WindowsWebAppSlotBackup): any;
export declare class WindowsWebAppSlotBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotBackup | undefined;
    set internalValue(value: WindowsWebAppSlotBackup | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountUrl?;
    get storageAccountUrl(): string;
    set storageAccountUrl(value: string);
    get storageAccountUrlInput(): string | undefined;
    private _schedule;
    get schedule(): WindowsWebAppSlotBackupScheduleOutputReference;
    putSchedule(value: WindowsWebAppSlotBackupSchedule): void;
    get scheduleInput(): WindowsWebAppSlotBackupSchedule | undefined;
}
export interface WindowsWebAppSlotConnectionString {
    /**
    * The name which should be used for this Connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#name WindowsWebAppSlot#name}
    */
    readonly name: string;
    /**
    * Type of database. Possible values include: `MySQL`, `SQLServer`, `SQLAzure`, `Custom`, `NotificationHub`, `ServiceBus`, `EventHub`, `APIHub`, `DocDb`, `RedisCache`, and `PostgreSQL`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#type WindowsWebAppSlot#type}
    */
    readonly type: string;
    /**
    * The connection string value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#value WindowsWebAppSlot#value}
    */
    readonly value: string;
}
export declare function windowsWebAppSlotConnectionStringToTerraform(struct?: WindowsWebAppSlotConnectionString | cdktf.IResolvable): any;
export declare class WindowsWebAppSlotConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSlotConnectionString | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSlotConnectionString | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class WindowsWebAppSlotConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSlotConnectionString[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSlotConnectionStringOutputReference;
}
export interface WindowsWebAppSlotIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#identity_ids WindowsWebAppSlot#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#type WindowsWebAppSlot#type}
    */
    readonly type: string;
}
export declare function windowsWebAppSlotIdentityToTerraform(struct?: WindowsWebAppSlotIdentityOutputReference | WindowsWebAppSlotIdentity): any;
export declare class WindowsWebAppSlotIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotIdentity | undefined;
    set internalValue(value: WindowsWebAppSlotIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface WindowsWebAppSlotLogsApplicationLogsAzureBlobStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#level WindowsWebAppSlot#level}
    */
    readonly level: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#retention_in_days WindowsWebAppSlot#retention_in_days}
    */
    readonly retentionInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#sas_url WindowsWebAppSlot#sas_url}
    */
    readonly sasUrl: string;
}
export declare function windowsWebAppSlotLogsApplicationLogsAzureBlobStorageToTerraform(struct?: WindowsWebAppSlotLogsApplicationLogsAzureBlobStorageOutputReference | WindowsWebAppSlotLogsApplicationLogsAzureBlobStorage): any;
export declare class WindowsWebAppSlotLogsApplicationLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotLogsApplicationLogsAzureBlobStorage | undefined;
    set internalValue(value: WindowsWebAppSlotLogsApplicationLogsAzureBlobStorage | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    get levelInput(): string | undefined;
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    get retentionInDaysInput(): number | undefined;
    private _sasUrl?;
    get sasUrl(): string;
    set sasUrl(value: string);
    get sasUrlInput(): string | undefined;
}
export interface WindowsWebAppSlotLogsApplicationLogs {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#file_system_level WindowsWebAppSlot#file_system_level}
    */
    readonly fileSystemLevel: string;
    /**
    * azure_blob_storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#azure_blob_storage WindowsWebAppSlot#azure_blob_storage}
    */
    readonly azureBlobStorage?: WindowsWebAppSlotLogsApplicationLogsAzureBlobStorage;
}
export declare function windowsWebAppSlotLogsApplicationLogsToTerraform(struct?: WindowsWebAppSlotLogsApplicationLogsOutputReference | WindowsWebAppSlotLogsApplicationLogs): any;
export declare class WindowsWebAppSlotLogsApplicationLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotLogsApplicationLogs | undefined;
    set internalValue(value: WindowsWebAppSlotLogsApplicationLogs | undefined);
    private _fileSystemLevel?;
    get fileSystemLevel(): string;
    set fileSystemLevel(value: string);
    get fileSystemLevelInput(): string | undefined;
    private _azureBlobStorage;
    get azureBlobStorage(): WindowsWebAppSlotLogsApplicationLogsAzureBlobStorageOutputReference;
    putAzureBlobStorage(value: WindowsWebAppSlotLogsApplicationLogsAzureBlobStorage): void;
    resetAzureBlobStorage(): void;
    get azureBlobStorageInput(): WindowsWebAppSlotLogsApplicationLogsAzureBlobStorage | undefined;
}
export interface WindowsWebAppSlotLogsHttpLogsAzureBlobStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#retention_in_days WindowsWebAppSlot#retention_in_days}
    */
    readonly retentionInDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#sas_url WindowsWebAppSlot#sas_url}
    */
    readonly sasUrl: string;
}
export declare function windowsWebAppSlotLogsHttpLogsAzureBlobStorageToTerraform(struct?: WindowsWebAppSlotLogsHttpLogsAzureBlobStorageOutputReference | WindowsWebAppSlotLogsHttpLogsAzureBlobStorage): any;
export declare class WindowsWebAppSlotLogsHttpLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotLogsHttpLogsAzureBlobStorage | undefined;
    set internalValue(value: WindowsWebAppSlotLogsHttpLogsAzureBlobStorage | undefined);
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    resetRetentionInDays(): void;
    get retentionInDaysInput(): number | undefined;
    private _sasUrl?;
    get sasUrl(): string;
    set sasUrl(value: string);
    get sasUrlInput(): string | undefined;
}
export interface WindowsWebAppSlotLogsHttpLogsFileSystem {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#retention_in_days WindowsWebAppSlot#retention_in_days}
    */
    readonly retentionInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#retention_in_mb WindowsWebAppSlot#retention_in_mb}
    */
    readonly retentionInMb: number;
}
export declare function windowsWebAppSlotLogsHttpLogsFileSystemToTerraform(struct?: WindowsWebAppSlotLogsHttpLogsFileSystemOutputReference | WindowsWebAppSlotLogsHttpLogsFileSystem): any;
export declare class WindowsWebAppSlotLogsHttpLogsFileSystemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotLogsHttpLogsFileSystem | undefined;
    set internalValue(value: WindowsWebAppSlotLogsHttpLogsFileSystem | undefined);
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    get retentionInDaysInput(): number | undefined;
    private _retentionInMb?;
    get retentionInMb(): number;
    set retentionInMb(value: number);
    get retentionInMbInput(): number | undefined;
}
export interface WindowsWebAppSlotLogsHttpLogs {
    /**
    * azure_blob_storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#azure_blob_storage WindowsWebAppSlot#azure_blob_storage}
    */
    readonly azureBlobStorage?: WindowsWebAppSlotLogsHttpLogsAzureBlobStorage;
    /**
    * file_system block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#file_system WindowsWebAppSlot#file_system}
    */
    readonly fileSystem?: WindowsWebAppSlotLogsHttpLogsFileSystem;
}
export declare function windowsWebAppSlotLogsHttpLogsToTerraform(struct?: WindowsWebAppSlotLogsHttpLogsOutputReference | WindowsWebAppSlotLogsHttpLogs): any;
export declare class WindowsWebAppSlotLogsHttpLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotLogsHttpLogs | undefined;
    set internalValue(value: WindowsWebAppSlotLogsHttpLogs | undefined);
    private _azureBlobStorage;
    get azureBlobStorage(): WindowsWebAppSlotLogsHttpLogsAzureBlobStorageOutputReference;
    putAzureBlobStorage(value: WindowsWebAppSlotLogsHttpLogsAzureBlobStorage): void;
    resetAzureBlobStorage(): void;
    get azureBlobStorageInput(): WindowsWebAppSlotLogsHttpLogsAzureBlobStorage | undefined;
    private _fileSystem;
    get fileSystem(): WindowsWebAppSlotLogsHttpLogsFileSystemOutputReference;
    putFileSystem(value: WindowsWebAppSlotLogsHttpLogsFileSystem): void;
    resetFileSystem(): void;
    get fileSystemInput(): WindowsWebAppSlotLogsHttpLogsFileSystem | undefined;
}
export interface WindowsWebAppSlotLogs {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#detailed_error_messages WindowsWebAppSlot#detailed_error_messages}
    */
    readonly detailedErrorMessages?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#failed_request_tracing WindowsWebAppSlot#failed_request_tracing}
    */
    readonly failedRequestTracing?: boolean | cdktf.IResolvable;
    /**
    * application_logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#application_logs WindowsWebAppSlot#application_logs}
    */
    readonly applicationLogs?: WindowsWebAppSlotLogsApplicationLogs;
    /**
    * http_logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#http_logs WindowsWebAppSlot#http_logs}
    */
    readonly httpLogs?: WindowsWebAppSlotLogsHttpLogs;
}
export declare function windowsWebAppSlotLogsToTerraform(struct?: WindowsWebAppSlotLogsOutputReference | WindowsWebAppSlotLogs): any;
export declare class WindowsWebAppSlotLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotLogs | undefined;
    set internalValue(value: WindowsWebAppSlotLogs | undefined);
    private _detailedErrorMessages?;
    get detailedErrorMessages(): boolean | cdktf.IResolvable;
    set detailedErrorMessages(value: boolean | cdktf.IResolvable);
    resetDetailedErrorMessages(): void;
    get detailedErrorMessagesInput(): boolean | cdktf.IResolvable | undefined;
    private _failedRequestTracing?;
    get failedRequestTracing(): boolean | cdktf.IResolvable;
    set failedRequestTracing(value: boolean | cdktf.IResolvable);
    resetFailedRequestTracing(): void;
    get failedRequestTracingInput(): boolean | cdktf.IResolvable | undefined;
    private _applicationLogs;
    get applicationLogs(): WindowsWebAppSlotLogsApplicationLogsOutputReference;
    putApplicationLogs(value: WindowsWebAppSlotLogsApplicationLogs): void;
    resetApplicationLogs(): void;
    get applicationLogsInput(): WindowsWebAppSlotLogsApplicationLogs | undefined;
    private _httpLogs;
    get httpLogs(): WindowsWebAppSlotLogsHttpLogsOutputReference;
    putHttpLogs(value: WindowsWebAppSlotLogsHttpLogs): void;
    resetHttpLogs(): void;
    get httpLogsInput(): WindowsWebAppSlotLogsHttpLogs | undefined;
}
export interface WindowsWebAppSlotSiteConfigApplicationStack {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#current_stack WindowsWebAppSlot#current_stack}
    */
    readonly currentStack?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#docker_container_name WindowsWebAppSlot#docker_container_name}
    */
    readonly dockerContainerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#docker_container_registry WindowsWebAppSlot#docker_container_registry}
    */
    readonly dockerContainerRegistry?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#docker_container_tag WindowsWebAppSlot#docker_container_tag}
    */
    readonly dockerContainerTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#docker_image_name WindowsWebAppSlot#docker_image_name}
    */
    readonly dockerImageName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#docker_registry_password WindowsWebAppSlot#docker_registry_password}
    */
    readonly dockerRegistryPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#docker_registry_url WindowsWebAppSlot#docker_registry_url}
    */
    readonly dockerRegistryUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#docker_registry_username WindowsWebAppSlot#docker_registry_username}
    */
    readonly dockerRegistryUsername?: string;
    /**
    * The version of DotNetCore to use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#dotnet_core_version WindowsWebAppSlot#dotnet_core_version}
    */
    readonly dotnetCoreVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#dotnet_version WindowsWebAppSlot#dotnet_version}
    */
    readonly dotnetVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#java_container WindowsWebAppSlot#java_container}
    */
    readonly javaContainer?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#java_container_version WindowsWebAppSlot#java_container_version}
    */
    readonly javaContainerVersion?: string;
    /**
    * Should the application use the embedded web server for the version of Java in use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#java_embedded_server_enabled WindowsWebAppSlot#java_embedded_server_enabled}
    */
    readonly javaEmbeddedServerEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#java_version WindowsWebAppSlot#java_version}
    */
    readonly javaVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#node_version WindowsWebAppSlot#node_version}
    */
    readonly nodeVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#php_version WindowsWebAppSlot#php_version}
    */
    readonly phpVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#python WindowsWebAppSlot#python}
    */
    readonly python?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#python_version WindowsWebAppSlot#python_version}
    */
    readonly pythonVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#tomcat_version WindowsWebAppSlot#tomcat_version}
    */
    readonly tomcatVersion?: string;
}
export declare function windowsWebAppSlotSiteConfigApplicationStackToTerraform(struct?: WindowsWebAppSlotSiteConfigApplicationStackOutputReference | WindowsWebAppSlotSiteConfigApplicationStack): any;
export declare class WindowsWebAppSlotSiteConfigApplicationStackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotSiteConfigApplicationStack | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigApplicationStack | undefined);
    private _currentStack?;
    get currentStack(): string;
    set currentStack(value: string);
    resetCurrentStack(): void;
    get currentStackInput(): string | undefined;
    private _dockerContainerName?;
    get dockerContainerName(): string;
    set dockerContainerName(value: string);
    resetDockerContainerName(): void;
    get dockerContainerNameInput(): string | undefined;
    private _dockerContainerRegistry?;
    get dockerContainerRegistry(): string;
    set dockerContainerRegistry(value: string);
    resetDockerContainerRegistry(): void;
    get dockerContainerRegistryInput(): string | undefined;
    private _dockerContainerTag?;
    get dockerContainerTag(): string;
    set dockerContainerTag(value: string);
    resetDockerContainerTag(): void;
    get dockerContainerTagInput(): string | undefined;
    private _dockerImageName?;
    get dockerImageName(): string;
    set dockerImageName(value: string);
    resetDockerImageName(): void;
    get dockerImageNameInput(): string | undefined;
    private _dockerRegistryPassword?;
    get dockerRegistryPassword(): string;
    set dockerRegistryPassword(value: string);
    resetDockerRegistryPassword(): void;
    get dockerRegistryPasswordInput(): string | undefined;
    private _dockerRegistryUrl?;
    get dockerRegistryUrl(): string;
    set dockerRegistryUrl(value: string);
    resetDockerRegistryUrl(): void;
    get dockerRegistryUrlInput(): string | undefined;
    private _dockerRegistryUsername?;
    get dockerRegistryUsername(): string;
    set dockerRegistryUsername(value: string);
    resetDockerRegistryUsername(): void;
    get dockerRegistryUsernameInput(): string | undefined;
    private _dotnetCoreVersion?;
    get dotnetCoreVersion(): string;
    set dotnetCoreVersion(value: string);
    resetDotnetCoreVersion(): void;
    get dotnetCoreVersionInput(): string | undefined;
    private _dotnetVersion?;
    get dotnetVersion(): string;
    set dotnetVersion(value: string);
    resetDotnetVersion(): void;
    get dotnetVersionInput(): string | undefined;
    private _javaContainer?;
    get javaContainer(): string;
    set javaContainer(value: string);
    resetJavaContainer(): void;
    get javaContainerInput(): string | undefined;
    private _javaContainerVersion?;
    get javaContainerVersion(): string;
    set javaContainerVersion(value: string);
    resetJavaContainerVersion(): void;
    get javaContainerVersionInput(): string | undefined;
    private _javaEmbeddedServerEnabled?;
    get javaEmbeddedServerEnabled(): boolean | cdktf.IResolvable;
    set javaEmbeddedServerEnabled(value: boolean | cdktf.IResolvable);
    resetJavaEmbeddedServerEnabled(): void;
    get javaEmbeddedServerEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _javaVersion?;
    get javaVersion(): string;
    set javaVersion(value: string);
    resetJavaVersion(): void;
    get javaVersionInput(): string | undefined;
    private _nodeVersion?;
    get nodeVersion(): string;
    set nodeVersion(value: string);
    resetNodeVersion(): void;
    get nodeVersionInput(): string | undefined;
    private _phpVersion?;
    get phpVersion(): string;
    set phpVersion(value: string);
    resetPhpVersion(): void;
    get phpVersionInput(): string | undefined;
    private _python?;
    get python(): boolean | cdktf.IResolvable;
    set python(value: boolean | cdktf.IResolvable);
    resetPython(): void;
    get pythonInput(): boolean | cdktf.IResolvable | undefined;
    private _pythonVersion?;
    get pythonVersion(): string;
    set pythonVersion(value: string);
    resetPythonVersion(): void;
    get pythonVersionInput(): string | undefined;
    private _tomcatVersion?;
    get tomcatVersion(): string;
    set tomcatVersion(value: string);
    resetTomcatVersion(): void;
    get tomcatVersionInput(): string | undefined;
}
export interface WindowsWebAppSlotSiteConfigAutoHealSettingActionCustomAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#executable WindowsWebAppSlot#executable}
    */
    readonly executable: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#parameters WindowsWebAppSlot#parameters}
    */
    readonly parameters?: string;
}
export declare function windowsWebAppSlotSiteConfigAutoHealSettingActionCustomActionToTerraform(struct?: WindowsWebAppSlotSiteConfigAutoHealSettingActionCustomActionOutputReference | WindowsWebAppSlotSiteConfigAutoHealSettingActionCustomAction): any;
export declare class WindowsWebAppSlotSiteConfigAutoHealSettingActionCustomActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotSiteConfigAutoHealSettingActionCustomAction | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigAutoHealSettingActionCustomAction | undefined);
    private _executable?;
    get executable(): string;
    set executable(value: string);
    get executableInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
}
export interface WindowsWebAppSlotSiteConfigAutoHealSettingAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#action_type WindowsWebAppSlot#action_type}
    */
    readonly actionType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#minimum_process_execution_time WindowsWebAppSlot#minimum_process_execution_time}
    */
    readonly minimumProcessExecutionTime?: string;
    /**
    * custom_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#custom_action WindowsWebAppSlot#custom_action}
    */
    readonly customAction?: WindowsWebAppSlotSiteConfigAutoHealSettingActionCustomAction;
}
export declare function windowsWebAppSlotSiteConfigAutoHealSettingActionToTerraform(struct?: WindowsWebAppSlotSiteConfigAutoHealSettingActionOutputReference | WindowsWebAppSlotSiteConfigAutoHealSettingAction): any;
export declare class WindowsWebAppSlotSiteConfigAutoHealSettingActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotSiteConfigAutoHealSettingAction | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigAutoHealSettingAction | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    get actionTypeInput(): string | undefined;
    private _minimumProcessExecutionTime?;
    get minimumProcessExecutionTime(): string;
    set minimumProcessExecutionTime(value: string);
    resetMinimumProcessExecutionTime(): void;
    get minimumProcessExecutionTimeInput(): string | undefined;
    private _customAction;
    get customAction(): WindowsWebAppSlotSiteConfigAutoHealSettingActionCustomActionOutputReference;
    putCustomAction(value: WindowsWebAppSlotSiteConfigAutoHealSettingActionCustomAction): void;
    resetCustomAction(): void;
    get customActionInput(): WindowsWebAppSlotSiteConfigAutoHealSettingActionCustomAction | undefined;
}
export interface WindowsWebAppSlotSiteConfigAutoHealSettingTriggerRequests {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#count WindowsWebAppSlot#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#interval WindowsWebAppSlot#interval}
    */
    readonly interval: string;
}
export declare function windowsWebAppSlotSiteConfigAutoHealSettingTriggerRequestsToTerraform(struct?: WindowsWebAppSlotSiteConfigAutoHealSettingTriggerRequestsOutputReference | WindowsWebAppSlotSiteConfigAutoHealSettingTriggerRequests): any;
export declare class WindowsWebAppSlotSiteConfigAutoHealSettingTriggerRequestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotSiteConfigAutoHealSettingTriggerRequests | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigAutoHealSettingTriggerRequests | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
}
export interface WindowsWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequest {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#count WindowsWebAppSlot#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#interval WindowsWebAppSlot#interval}
    */
    readonly interval: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#path WindowsWebAppSlot#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#time_taken WindowsWebAppSlot#time_taken}
    */
    readonly timeTaken: string;
}
export declare function windowsWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequestToTerraform(struct?: WindowsWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequestOutputReference | WindowsWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequest): any;
export declare class WindowsWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequest | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequest | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _timeTaken?;
    get timeTaken(): string;
    set timeTaken(value: string);
    get timeTakenInput(): string | undefined;
}
export interface WindowsWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#count WindowsWebAppSlot#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#interval WindowsWebAppSlot#interval}
    */
    readonly interval: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#path WindowsWebAppSlot#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#status_code_range WindowsWebAppSlot#status_code_range}
    */
    readonly statusCodeRange: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#sub_status WindowsWebAppSlot#sub_status}
    */
    readonly subStatus?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#win32_status_code WindowsWebAppSlot#win32_status_code}
    */
    readonly win32StatusCode?: number;
}
export declare function windowsWebAppSlotSiteConfigAutoHealSettingTriggerStatusCodeToTerraform(struct?: WindowsWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode | cdktf.IResolvable): any;
export declare class WindowsWebAppSlotSiteConfigAutoHealSettingTriggerStatusCodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _statusCodeRange?;
    get statusCodeRange(): string;
    set statusCodeRange(value: string);
    get statusCodeRangeInput(): string | undefined;
    private _subStatus?;
    get subStatus(): number;
    set subStatus(value: number);
    resetSubStatus(): void;
    get subStatusInput(): number | undefined;
    private _win32StatusCode?;
    get win32StatusCode(): number;
    set win32StatusCode(value: number);
    resetWin32StatusCode(): void;
    get win32StatusCodeInput(): number | undefined;
}
export declare class WindowsWebAppSlotSiteConfigAutoHealSettingTriggerStatusCodeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSlotSiteConfigAutoHealSettingTriggerStatusCodeOutputReference;
}
export interface WindowsWebAppSlotSiteConfigAutoHealSettingTrigger {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#private_memory_kb WindowsWebAppSlot#private_memory_kb}
    */
    readonly privateMemoryKb?: number;
    /**
    * requests block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#requests WindowsWebAppSlot#requests}
    */
    readonly requests?: WindowsWebAppSlotSiteConfigAutoHealSettingTriggerRequests;
    /**
    * slow_request block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#slow_request WindowsWebAppSlot#slow_request}
    */
    readonly slowRequest?: WindowsWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequest;
    /**
    * status_code block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#status_code WindowsWebAppSlot#status_code}
    */
    readonly statusCode?: WindowsWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode[] | cdktf.IResolvable;
}
export declare function windowsWebAppSlotSiteConfigAutoHealSettingTriggerToTerraform(struct?: WindowsWebAppSlotSiteConfigAutoHealSettingTriggerOutputReference | WindowsWebAppSlotSiteConfigAutoHealSettingTrigger): any;
export declare class WindowsWebAppSlotSiteConfigAutoHealSettingTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotSiteConfigAutoHealSettingTrigger | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigAutoHealSettingTrigger | undefined);
    private _privateMemoryKb?;
    get privateMemoryKb(): number;
    set privateMemoryKb(value: number);
    resetPrivateMemoryKb(): void;
    get privateMemoryKbInput(): number | undefined;
    private _requests;
    get requests(): WindowsWebAppSlotSiteConfigAutoHealSettingTriggerRequestsOutputReference;
    putRequests(value: WindowsWebAppSlotSiteConfigAutoHealSettingTriggerRequests): void;
    resetRequests(): void;
    get requestsInput(): WindowsWebAppSlotSiteConfigAutoHealSettingTriggerRequests | undefined;
    private _slowRequest;
    get slowRequest(): WindowsWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequestOutputReference;
    putSlowRequest(value: WindowsWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequest): void;
    resetSlowRequest(): void;
    get slowRequestInput(): WindowsWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequest | undefined;
    private _statusCode;
    get statusCode(): WindowsWebAppSlotSiteConfigAutoHealSettingTriggerStatusCodeList;
    putStatusCode(value: WindowsWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode[] | cdktf.IResolvable): void;
    resetStatusCode(): void;
    get statusCodeInput(): cdktf.IResolvable | WindowsWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode[] | undefined;
}
export interface WindowsWebAppSlotSiteConfigAutoHealSetting {
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#action WindowsWebAppSlot#action}
    */
    readonly action: WindowsWebAppSlotSiteConfigAutoHealSettingAction;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#trigger WindowsWebAppSlot#trigger}
    */
    readonly trigger: WindowsWebAppSlotSiteConfigAutoHealSettingTrigger;
}
export declare function windowsWebAppSlotSiteConfigAutoHealSettingToTerraform(struct?: WindowsWebAppSlotSiteConfigAutoHealSettingOutputReference | WindowsWebAppSlotSiteConfigAutoHealSetting): any;
export declare class WindowsWebAppSlotSiteConfigAutoHealSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotSiteConfigAutoHealSetting | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigAutoHealSetting | undefined);
    private _action;
    get action(): WindowsWebAppSlotSiteConfigAutoHealSettingActionOutputReference;
    putAction(value: WindowsWebAppSlotSiteConfigAutoHealSettingAction): void;
    get actionInput(): WindowsWebAppSlotSiteConfigAutoHealSettingAction | undefined;
    private _trigger;
    get trigger(): WindowsWebAppSlotSiteConfigAutoHealSettingTriggerOutputReference;
    putTrigger(value: WindowsWebAppSlotSiteConfigAutoHealSettingTrigger): void;
    get triggerInput(): WindowsWebAppSlotSiteConfigAutoHealSettingTrigger | undefined;
}
export interface WindowsWebAppSlotSiteConfigCors {
    /**
    * Specifies a list of origins that should be allowed to make cross-origin calls.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#allowed_origins WindowsWebAppSlot#allowed_origins}
    */
    readonly allowedOrigins?: string[];
    /**
    * Are credentials allowed in CORS requests? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#support_credentials WindowsWebAppSlot#support_credentials}
    */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function windowsWebAppSlotSiteConfigCorsToTerraform(struct?: WindowsWebAppSlotSiteConfigCorsOutputReference | WindowsWebAppSlotSiteConfigCors): any;
export declare class WindowsWebAppSlotSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotSiteConfigCors | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigCors | undefined);
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    resetAllowedOrigins(): void;
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    get supportCredentials(): boolean | cdktf.IResolvable;
    set supportCredentials(value: boolean | cdktf.IResolvable);
    resetSupportCredentials(): void;
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WindowsWebAppSlotSiteConfigIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#x_azure_fdid WindowsWebAppSlot#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#x_fd_health_probe WindowsWebAppSlot#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#x_forwarded_for WindowsWebAppSlot#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#x_forwarded_host WindowsWebAppSlot#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function windowsWebAppSlotSiteConfigIpRestrictionHeadersToTerraform(struct?: WindowsWebAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class WindowsWebAppSlotSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class WindowsWebAppSlotSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSlotSiteConfigIpRestrictionHeadersOutputReference;
}
export interface WindowsWebAppSlotSiteConfigIpRestriction {
    /**
    * The action to take. Possible values are `Allow` or `Deny`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#action WindowsWebAppSlot#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#headers WindowsWebAppSlot#headers}
    */
    readonly headers?: WindowsWebAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * The CIDR notation of the IP or IP Range to match. For example: `10.0.0.0/24` or `192.168.10.1/32` or `fe80::/64` or `13.107.6.152/31,13.107.128.0/22`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#ip_address WindowsWebAppSlot#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The name which should be used for this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#name WindowsWebAppSlot#name}
    */
    readonly name?: string;
    /**
    * The priority value of this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#priority WindowsWebAppSlot#priority}
    */
    readonly priority?: number;
    /**
    * The Service Tag used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#service_tag WindowsWebAppSlot#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * The Virtual Network Subnet ID used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#virtual_network_subnet_id WindowsWebAppSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function windowsWebAppSlotSiteConfigIpRestrictionToTerraform(struct?: WindowsWebAppSlotSiteConfigIpRestriction | cdktf.IResolvable): any;
export declare class WindowsWebAppSlotSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSlotSiteConfigIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _headers;
    get headers(): WindowsWebAppSlotSiteConfigIpRestrictionHeadersList;
    putHeaders(value: WindowsWebAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | WindowsWebAppSlotSiteConfigIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class WindowsWebAppSlotSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSlotSiteConfigIpRestrictionOutputReference;
}
export interface WindowsWebAppSlotSiteConfigScmIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#x_azure_fdid WindowsWebAppSlot#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#x_fd_health_probe WindowsWebAppSlot#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#x_forwarded_for WindowsWebAppSlot#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#x_forwarded_host WindowsWebAppSlot#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function windowsWebAppSlotSiteConfigScmIpRestrictionHeadersToTerraform(struct?: WindowsWebAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class WindowsWebAppSlotSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class WindowsWebAppSlotSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSlotSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface WindowsWebAppSlotSiteConfigScmIpRestriction {
    /**
    * The action to take. Possible values are `Allow` or `Deny`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#action WindowsWebAppSlot#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#headers WindowsWebAppSlot#headers}
    */
    readonly headers?: WindowsWebAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * The CIDR notation of the IP or IP Range to match. For example: `10.0.0.0/24` or `192.168.10.1/32` or `fe80::/64` or `13.107.6.152/31,13.107.128.0/22`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#ip_address WindowsWebAppSlot#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The name which should be used for this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#name WindowsWebAppSlot#name}
    */
    readonly name?: string;
    /**
    * The priority value of this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#priority WindowsWebAppSlot#priority}
    */
    readonly priority?: number;
    /**
    * The Service Tag used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#service_tag WindowsWebAppSlot#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * The Virtual Network Subnet ID used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#virtual_network_subnet_id WindowsWebAppSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function windowsWebAppSlotSiteConfigScmIpRestrictionToTerraform(struct?: WindowsWebAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable): any;
export declare class WindowsWebAppSlotSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _headers;
    get headers(): WindowsWebAppSlotSiteConfigScmIpRestrictionHeadersList;
    putHeaders(value: WindowsWebAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | WindowsWebAppSlotSiteConfigScmIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class WindowsWebAppSlotSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSlotSiteConfigScmIpRestrictionOutputReference;
}
export interface WindowsWebAppSlotSiteConfigVirtualApplicationVirtualDirectory {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#physical_path WindowsWebAppSlot#physical_path}
    */
    readonly physicalPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#virtual_path WindowsWebAppSlot#virtual_path}
    */
    readonly virtualPath?: string;
}
export declare function windowsWebAppSlotSiteConfigVirtualApplicationVirtualDirectoryToTerraform(struct?: WindowsWebAppSlotSiteConfigVirtualApplicationVirtualDirectory | cdktf.IResolvable): any;
export declare class WindowsWebAppSlotSiteConfigVirtualApplicationVirtualDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSlotSiteConfigVirtualApplicationVirtualDirectory | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigVirtualApplicationVirtualDirectory | cdktf.IResolvable | undefined);
    private _physicalPath?;
    get physicalPath(): string;
    set physicalPath(value: string);
    resetPhysicalPath(): void;
    get physicalPathInput(): string | undefined;
    private _virtualPath?;
    get virtualPath(): string;
    set virtualPath(value: string);
    resetVirtualPath(): void;
    get virtualPathInput(): string | undefined;
}
export declare class WindowsWebAppSlotSiteConfigVirtualApplicationVirtualDirectoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSlotSiteConfigVirtualApplicationVirtualDirectory[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSlotSiteConfigVirtualApplicationVirtualDirectoryOutputReference;
}
export interface WindowsWebAppSlotSiteConfigVirtualApplication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#physical_path WindowsWebAppSlot#physical_path}
    */
    readonly physicalPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#preload WindowsWebAppSlot#preload}
    */
    readonly preload: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#virtual_path WindowsWebAppSlot#virtual_path}
    */
    readonly virtualPath: string;
    /**
    * virtual_directory block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#virtual_directory WindowsWebAppSlot#virtual_directory}
    */
    readonly virtualDirectory?: WindowsWebAppSlotSiteConfigVirtualApplicationVirtualDirectory[] | cdktf.IResolvable;
}
export declare function windowsWebAppSlotSiteConfigVirtualApplicationToTerraform(struct?: WindowsWebAppSlotSiteConfigVirtualApplication | cdktf.IResolvable): any;
export declare class WindowsWebAppSlotSiteConfigVirtualApplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSlotSiteConfigVirtualApplication | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfigVirtualApplication | cdktf.IResolvable | undefined);
    private _physicalPath?;
    get physicalPath(): string;
    set physicalPath(value: string);
    get physicalPathInput(): string | undefined;
    private _preload?;
    get preload(): boolean | cdktf.IResolvable;
    set preload(value: boolean | cdktf.IResolvable);
    get preloadInput(): boolean | cdktf.IResolvable | undefined;
    private _virtualPath?;
    get virtualPath(): string;
    set virtualPath(value: string);
    get virtualPathInput(): string | undefined;
    private _virtualDirectory;
    get virtualDirectory(): WindowsWebAppSlotSiteConfigVirtualApplicationVirtualDirectoryList;
    putVirtualDirectory(value: WindowsWebAppSlotSiteConfigVirtualApplicationVirtualDirectory[] | cdktf.IResolvable): void;
    resetVirtualDirectory(): void;
    get virtualDirectoryInput(): cdktf.IResolvable | WindowsWebAppSlotSiteConfigVirtualApplicationVirtualDirectory[] | undefined;
}
export declare class WindowsWebAppSlotSiteConfigVirtualApplicationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSlotSiteConfigVirtualApplication[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSlotSiteConfigVirtualApplicationOutputReference;
}
export interface WindowsWebAppSlotSiteConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#always_on WindowsWebAppSlot#always_on}
    */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#api_definition_url WindowsWebAppSlot#api_definition_url}
    */
    readonly apiDefinitionUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#api_management_api_id WindowsWebAppSlot#api_management_api_id}
    */
    readonly apiManagementApiId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#app_command_line WindowsWebAppSlot#app_command_line}
    */
    readonly appCommandLine?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#auto_heal_enabled WindowsWebAppSlot#auto_heal_enabled}
    */
    readonly autoHealEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#auto_swap_slot_name WindowsWebAppSlot#auto_swap_slot_name}
    */
    readonly autoSwapSlotName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#container_registry_managed_identity_client_id WindowsWebAppSlot#container_registry_managed_identity_client_id}
    */
    readonly containerRegistryManagedIdentityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#container_registry_use_managed_identity WindowsWebAppSlot#container_registry_use_managed_identity}
    */
    readonly containerRegistryUseManagedIdentity?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#default_documents WindowsWebAppSlot#default_documents}
    */
    readonly defaultDocuments?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#ftps_state WindowsWebAppSlot#ftps_state}
    */
    readonly ftpsState?: string;
    /**
    * The amount of time in minutes that a node is unhealthy before being removed from the load balancer. Possible values are between `2` and `10`. Defaults to `10`. Only valid in conjunction with `health_check_path`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#health_check_eviction_time_in_min WindowsWebAppSlot#health_check_eviction_time_in_min}
    */
    readonly healthCheckEvictionTimeInMin?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#health_check_path WindowsWebAppSlot#health_check_path}
    */
    readonly healthCheckPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#http2_enabled WindowsWebAppSlot#http2_enabled}
    */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#load_balancing_mode WindowsWebAppSlot#load_balancing_mode}
    */
    readonly loadBalancingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#local_mysql_enabled WindowsWebAppSlot#local_mysql_enabled}
    */
    readonly localMysqlEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#managed_pipeline_mode WindowsWebAppSlot#managed_pipeline_mode}
    */
    readonly managedPipelineMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#minimum_tls_version WindowsWebAppSlot#minimum_tls_version}
    */
    readonly minimumTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#remote_debugging_enabled WindowsWebAppSlot#remote_debugging_enabled}
    */
    readonly remoteDebuggingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#remote_debugging_version WindowsWebAppSlot#remote_debugging_version}
    */
    readonly remoteDebuggingVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#scm_minimum_tls_version WindowsWebAppSlot#scm_minimum_tls_version}
    */
    readonly scmMinimumTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#scm_use_main_ip_restriction WindowsWebAppSlot#scm_use_main_ip_restriction}
    */
    readonly scmUseMainIpRestriction?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#use_32_bit_worker WindowsWebAppSlot#use_32_bit_worker}
    */
    readonly use32BitWorker?: boolean | cdktf.IResolvable;
    /**
    * Should all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#vnet_route_all_enabled WindowsWebAppSlot#vnet_route_all_enabled}
    */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#websockets_enabled WindowsWebAppSlot#websockets_enabled}
    */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#worker_count WindowsWebAppSlot#worker_count}
    */
    readonly workerCount?: number;
    /**
    * application_stack block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#application_stack WindowsWebAppSlot#application_stack}
    */
    readonly applicationStack?: WindowsWebAppSlotSiteConfigApplicationStack;
    /**
    * auto_heal_setting block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#auto_heal_setting WindowsWebAppSlot#auto_heal_setting}
    */
    readonly autoHealSetting?: WindowsWebAppSlotSiteConfigAutoHealSetting;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#cors WindowsWebAppSlot#cors}
    */
    readonly cors?: WindowsWebAppSlotSiteConfigCors;
    /**
    * ip_restriction block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#ip_restriction WindowsWebAppSlot#ip_restriction}
    */
    readonly ipRestriction?: WindowsWebAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * scm_ip_restriction block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#scm_ip_restriction WindowsWebAppSlot#scm_ip_restriction}
    */
    readonly scmIpRestriction?: WindowsWebAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
    * virtual_application block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#virtual_application WindowsWebAppSlot#virtual_application}
    */
    readonly virtualApplication?: WindowsWebAppSlotSiteConfigVirtualApplication[] | cdktf.IResolvable;
}
export declare function windowsWebAppSlotSiteConfigToTerraform(struct?: WindowsWebAppSlotSiteConfigOutputReference | WindowsWebAppSlotSiteConfig): any;
export declare class WindowsWebAppSlotSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotSiteConfig | undefined;
    set internalValue(value: WindowsWebAppSlotSiteConfig | undefined);
    private _alwaysOn?;
    get alwaysOn(): boolean | cdktf.IResolvable;
    set alwaysOn(value: boolean | cdktf.IResolvable);
    resetAlwaysOn(): void;
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _apiDefinitionUrl?;
    get apiDefinitionUrl(): string;
    set apiDefinitionUrl(value: string);
    resetApiDefinitionUrl(): void;
    get apiDefinitionUrlInput(): string | undefined;
    private _apiManagementApiId?;
    get apiManagementApiId(): string;
    set apiManagementApiId(value: string);
    resetApiManagementApiId(): void;
    get apiManagementApiIdInput(): string | undefined;
    private _appCommandLine?;
    get appCommandLine(): string;
    set appCommandLine(value: string);
    resetAppCommandLine(): void;
    get appCommandLineInput(): string | undefined;
    private _autoHealEnabled?;
    get autoHealEnabled(): boolean | cdktf.IResolvable;
    set autoHealEnabled(value: boolean | cdktf.IResolvable);
    resetAutoHealEnabled(): void;
    get autoHealEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoSwapSlotName?;
    get autoSwapSlotName(): string;
    set autoSwapSlotName(value: string);
    resetAutoSwapSlotName(): void;
    get autoSwapSlotNameInput(): string | undefined;
    private _containerRegistryManagedIdentityClientId?;
    get containerRegistryManagedIdentityClientId(): string;
    set containerRegistryManagedIdentityClientId(value: string);
    resetContainerRegistryManagedIdentityClientId(): void;
    get containerRegistryManagedIdentityClientIdInput(): string | undefined;
    private _containerRegistryUseManagedIdentity?;
    get containerRegistryUseManagedIdentity(): boolean | cdktf.IResolvable;
    set containerRegistryUseManagedIdentity(value: boolean | cdktf.IResolvable);
    resetContainerRegistryUseManagedIdentity(): void;
    get containerRegistryUseManagedIdentityInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultDocuments?;
    get defaultDocuments(): string[];
    set defaultDocuments(value: string[]);
    resetDefaultDocuments(): void;
    get defaultDocumentsInput(): string[] | undefined;
    get detailedErrorLoggingEnabled(): cdktf.IResolvable;
    private _ftpsState?;
    get ftpsState(): string;
    set ftpsState(value: string);
    resetFtpsState(): void;
    get ftpsStateInput(): string | undefined;
    private _healthCheckEvictionTimeInMin?;
    get healthCheckEvictionTimeInMin(): number;
    set healthCheckEvictionTimeInMin(value: number);
    resetHealthCheckEvictionTimeInMin(): void;
    get healthCheckEvictionTimeInMinInput(): number | undefined;
    private _healthCheckPath?;
    get healthCheckPath(): string;
    set healthCheckPath(value: string);
    resetHealthCheckPath(): void;
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    get http2Enabled(): boolean | cdktf.IResolvable;
    set http2Enabled(value: boolean | cdktf.IResolvable);
    resetHttp2Enabled(): void;
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _loadBalancingMode?;
    get loadBalancingMode(): string;
    set loadBalancingMode(value: string);
    resetLoadBalancingMode(): void;
    get loadBalancingModeInput(): string | undefined;
    private _localMysqlEnabled?;
    get localMysqlEnabled(): boolean | cdktf.IResolvable;
    set localMysqlEnabled(value: boolean | cdktf.IResolvable);
    resetLocalMysqlEnabled(): void;
    get localMysqlEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _managedPipelineMode?;
    get managedPipelineMode(): string;
    set managedPipelineMode(value: string);
    resetManagedPipelineMode(): void;
    get managedPipelineModeInput(): string | undefined;
    private _minimumTlsVersion?;
    get minimumTlsVersion(): string;
    set minimumTlsVersion(value: string);
    resetMinimumTlsVersion(): void;
    get minimumTlsVersionInput(): string | undefined;
    private _remoteDebuggingEnabled?;
    get remoteDebuggingEnabled(): boolean | cdktf.IResolvable;
    set remoteDebuggingEnabled(value: boolean | cdktf.IResolvable);
    resetRemoteDebuggingEnabled(): void;
    get remoteDebuggingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _remoteDebuggingVersion?;
    get remoteDebuggingVersion(): string;
    set remoteDebuggingVersion(value: string);
    resetRemoteDebuggingVersion(): void;
    get remoteDebuggingVersionInput(): string | undefined;
    private _scmMinimumTlsVersion?;
    get scmMinimumTlsVersion(): string;
    set scmMinimumTlsVersion(value: string);
    resetScmMinimumTlsVersion(): void;
    get scmMinimumTlsVersionInput(): string | undefined;
    get scmType(): string;
    private _scmUseMainIpRestriction?;
    get scmUseMainIpRestriction(): boolean | cdktf.IResolvable;
    set scmUseMainIpRestriction(value: boolean | cdktf.IResolvable);
    resetScmUseMainIpRestriction(): void;
    get scmUseMainIpRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorker?;
    get use32BitWorker(): boolean | cdktf.IResolvable;
    set use32BitWorker(value: boolean | cdktf.IResolvable);
    resetUse32BitWorker(): void;
    get use32BitWorkerInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    resetVnetRouteAllEnabled(): void;
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    resetWebsocketsEnabled(): void;
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get windowsFxVersion(): string;
    private _workerCount?;
    get workerCount(): number;
    set workerCount(value: number);
    resetWorkerCount(): void;
    get workerCountInput(): number | undefined;
    private _applicationStack;
    get applicationStack(): WindowsWebAppSlotSiteConfigApplicationStackOutputReference;
    putApplicationStack(value: WindowsWebAppSlotSiteConfigApplicationStack): void;
    resetApplicationStack(): void;
    get applicationStackInput(): WindowsWebAppSlotSiteConfigApplicationStack | undefined;
    private _autoHealSetting;
    get autoHealSetting(): WindowsWebAppSlotSiteConfigAutoHealSettingOutputReference;
    putAutoHealSetting(value: WindowsWebAppSlotSiteConfigAutoHealSetting): void;
    resetAutoHealSetting(): void;
    get autoHealSettingInput(): WindowsWebAppSlotSiteConfigAutoHealSetting | undefined;
    private _cors;
    get cors(): WindowsWebAppSlotSiteConfigCorsOutputReference;
    putCors(value: WindowsWebAppSlotSiteConfigCors): void;
    resetCors(): void;
    get corsInput(): WindowsWebAppSlotSiteConfigCors | undefined;
    private _ipRestriction;
    get ipRestriction(): WindowsWebAppSlotSiteConfigIpRestrictionList;
    putIpRestriction(value: WindowsWebAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable): void;
    resetIpRestriction(): void;
    get ipRestrictionInput(): cdktf.IResolvable | WindowsWebAppSlotSiteConfigIpRestriction[] | undefined;
    private _scmIpRestriction;
    get scmIpRestriction(): WindowsWebAppSlotSiteConfigScmIpRestrictionList;
    putScmIpRestriction(value: WindowsWebAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable): void;
    resetScmIpRestriction(): void;
    get scmIpRestrictionInput(): cdktf.IResolvable | WindowsWebAppSlotSiteConfigScmIpRestriction[] | undefined;
    private _virtualApplication;
    get virtualApplication(): WindowsWebAppSlotSiteConfigVirtualApplicationList;
    putVirtualApplication(value: WindowsWebAppSlotSiteConfigVirtualApplication[] | cdktf.IResolvable): void;
    resetVirtualApplication(): void;
    get virtualApplicationInput(): cdktf.IResolvable | WindowsWebAppSlotSiteConfigVirtualApplication[] | undefined;
}
export interface WindowsWebAppSlotStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#access_key WindowsWebAppSlot#access_key}
    */
    readonly accessKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#account_name WindowsWebAppSlot#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#mount_path WindowsWebAppSlot#mount_path}
    */
    readonly mountPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#name WindowsWebAppSlot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#share_name WindowsWebAppSlot#share_name}
    */
    readonly shareName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#type WindowsWebAppSlot#type}
    */
    readonly type: string;
}
export declare function windowsWebAppSlotStorageAccountToTerraform(struct?: WindowsWebAppSlotStorageAccount | cdktf.IResolvable): any;
export declare class WindowsWebAppSlotStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSlotStorageAccount | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSlotStorageAccount | cdktf.IResolvable | undefined);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    get accessKeyInput(): string | undefined;
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    resetMountPath(): void;
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class WindowsWebAppSlotStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSlotStorageAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSlotStorageAccountOutputReference;
}
export interface WindowsWebAppSlotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#create WindowsWebAppSlot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#delete WindowsWebAppSlot#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#read WindowsWebAppSlot#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#update WindowsWebAppSlot#update}
    */
    readonly update?: string;
}
export declare function windowsWebAppSlotTimeoutsToTerraform(struct?: WindowsWebAppSlotTimeouts | cdktf.IResolvable): any;
export declare class WindowsWebAppSlotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSlotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSlotTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot azurerm_windows_web_app_slot}
*/
export declare class WindowsWebAppSlot extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_windows_web_app_slot";
    /**
    * Generates CDKTF code for importing a WindowsWebAppSlot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the WindowsWebAppSlot to import
    * @param importFromId The id of the existing WindowsWebAppSlot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the WindowsWebAppSlot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/windows_web_app_slot azurerm_windows_web_app_slot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WindowsWebAppSlotConfig
    */
    constructor(scope: Construct, id: string, config: WindowsWebAppSlotConfig);
    private _appServiceId?;
    get appServiceId(): string;
    set appServiceId(value: string);
    get appServiceIdInput(): string | undefined;
    private _appSettings?;
    get appSettings(): {
        [key: string]: string;
    };
    set appSettings(value: {
        [key: string]: string;
    });
    resetAppSettings(): void;
    get appSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _clientAffinityEnabled?;
    get clientAffinityEnabled(): boolean | cdktf.IResolvable;
    set clientAffinityEnabled(value: boolean | cdktf.IResolvable);
    resetClientAffinityEnabled(): void;
    get clientAffinityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertificateEnabled?;
    get clientCertificateEnabled(): boolean | cdktf.IResolvable;
    set clientCertificateEnabled(value: boolean | cdktf.IResolvable);
    resetClientCertificateEnabled(): void;
    get clientCertificateEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertificateExclusionPaths?;
    get clientCertificateExclusionPaths(): string;
    set clientCertificateExclusionPaths(value: string);
    resetClientCertificateExclusionPaths(): void;
    get clientCertificateExclusionPathsInput(): string | undefined;
    private _clientCertificateMode?;
    get clientCertificateMode(): string;
    set clientCertificateMode(value: string);
    resetClientCertificateMode(): void;
    get clientCertificateModeInput(): string | undefined;
    get customDomainVerificationId(): string;
    get defaultHostname(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get hostingEnvironmentId(): string;
    private _httpsOnly?;
    get httpsOnly(): boolean | cdktf.IResolvable;
    set httpsOnly(value: boolean | cdktf.IResolvable);
    resetHttpsOnly(): void;
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultReferenceIdentityId?;
    get keyVaultReferenceIdentityId(): string;
    set keyVaultReferenceIdentityId(value: string);
    resetKeyVaultReferenceIdentityId(): void;
    get keyVaultReferenceIdentityIdInput(): string | undefined;
    get kind(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddressList(): string[];
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddressList(): string[];
    get possibleOutboundIpAddresses(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _servicePlanId?;
    get servicePlanId(): string;
    set servicePlanId(value: string);
    resetServicePlanId(): void;
    get servicePlanIdInput(): string | undefined;
    private _siteCredential;
    get siteCredential(): WindowsWebAppSlotSiteCredentialList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
    private _zipDeployFile?;
    get zipDeployFile(): string;
    set zipDeployFile(value: string);
    resetZipDeployFile(): void;
    get zipDeployFileInput(): string | undefined;
    private _authSettings;
    get authSettings(): WindowsWebAppSlotAuthSettingsOutputReference;
    putAuthSettings(value: WindowsWebAppSlotAuthSettings): void;
    resetAuthSettings(): void;
    get authSettingsInput(): WindowsWebAppSlotAuthSettings | undefined;
    private _authSettingsV2;
    get authSettingsV2(): WindowsWebAppSlotAuthSettingsV2OutputReference;
    putAuthSettingsV2(value: WindowsWebAppSlotAuthSettingsV2): void;
    resetAuthSettingsV2(): void;
    get authSettingsV2Input(): WindowsWebAppSlotAuthSettingsV2 | undefined;
    private _backup;
    get backup(): WindowsWebAppSlotBackupOutputReference;
    putBackup(value: WindowsWebAppSlotBackup): void;
    resetBackup(): void;
    get backupInput(): WindowsWebAppSlotBackup | undefined;
    private _connectionString;
    get connectionString(): WindowsWebAppSlotConnectionStringList;
    putConnectionString(value: WindowsWebAppSlotConnectionString[] | cdktf.IResolvable): void;
    resetConnectionString(): void;
    get connectionStringInput(): cdktf.IResolvable | WindowsWebAppSlotConnectionString[] | undefined;
    private _identity;
    get identity(): WindowsWebAppSlotIdentityOutputReference;
    putIdentity(value: WindowsWebAppSlotIdentity): void;
    resetIdentity(): void;
    get identityInput(): WindowsWebAppSlotIdentity | undefined;
    private _logs;
    get logs(): WindowsWebAppSlotLogsOutputReference;
    putLogs(value: WindowsWebAppSlotLogs): void;
    resetLogs(): void;
    get logsInput(): WindowsWebAppSlotLogs | undefined;
    private _siteConfig;
    get siteConfig(): WindowsWebAppSlotSiteConfigOutputReference;
    putSiteConfig(value: WindowsWebAppSlotSiteConfig): void;
    get siteConfigInput(): WindowsWebAppSlotSiteConfig | undefined;
    private _storageAccount;
    get storageAccount(): WindowsWebAppSlotStorageAccountList;
    putStorageAccount(value: WindowsWebAppSlotStorageAccount[] | cdktf.IResolvable): void;
    resetStorageAccount(): void;
    get storageAccountInput(): cdktf.IResolvable | WindowsWebAppSlotStorageAccount[] | undefined;
    private _timeouts;
    get timeouts(): WindowsWebAppSlotTimeoutsOutputReference;
    putTimeouts(value: WindowsWebAppSlotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WindowsWebAppSlotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
