# Generated by Django 3.1 on 2020-08-27 12:25

import app_kit.generic
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Glossary',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('primary_language', models.CharField(max_length=15)),
                ('name', models.CharField(max_length=255, null=True)),
                ('published_version', models.IntegerField(null=True)),
                ('current_version', models.IntegerField(default=1)),
                ('is_locked', models.BooleanField(default=False)),
                ('messages', models.JSONField(null=True)),
                ('global_options', models.JSONField(null=True)),
            ],
            options={
                'verbose_name': 'Glossary',
            },
            bases=(app_kit.generic.GenericContentMethodsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='GlossaryEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=355, unique=True)),
                ('definition', models.TextField()),
                ('glossary', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='glossary.glossary')),
            ],
            options={
                'ordering': ['term'],
            },
        ),
        migrations.CreateModel(
            name='TermSynonym',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=355, unique=True)),
                ('glossary_entry', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='glossary.glossaryentry')),
            ],
            options={
                'unique_together': {('glossary_entry', 'term')},
            },
        ),
    ]
