# Generated by Django 3.1 on 2020-08-27 12:24

import app_kit.generic
import app_kit.models
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('localcosmos_server', '0001_initial'),
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='MetaApp',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('published_version', models.IntegerField(null=True)),
                ('current_version', models.IntegerField(default=1)),
                ('is_locked', models.BooleanField(default=False)),
                ('global_options', models.JSONField(null=True)),
                ('package_name', models.CharField(max_length=100, unique=True)),
                ('build_settings', models.JSONField(null=True)),
                ('build_number', models.IntegerField(null=True)),
                ('theme', models.CharField(max_length=255)),
                ('store_links', models.JSONField(null=True)),
                ('appbuilder_version', models.CharField(choices=[('1', '1')], max_length=10)),
                ('build_status', models.CharField(choices=[('failing', 'failing'), ('passing', 'passing'), ('in_progress', 'build in progress')], max_length=50, null=True)),
                ('last_build_report', models.JSONField(null=True)),
                ('validation_status', models.CharField(choices=[('in_progress', 'validation in progress'), ('valid', 'valid'), ('warnings', 'warnings'), ('errors', 'errors')], max_length=50, null=True)),
                ('last_validation_report', models.JSONField(null=True)),
                ('last_release_report', models.JSONField(null=True)),
                ('last_modified_at', models.DateTimeField(auto_now=True)),
                ('last_published_at', models.DateTimeField(null=True)),
                ('app', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='localcosmos_server.app')),
            ],
            options={
                'verbose_name': 'App',
                'verbose_name_plural': 'Meta apps',
            },
            bases=(app_kit.models.ContentImageMixin, app_kit.generic.GenericContentMethodsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='MetaCache',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('cache', models.JSONField(null=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='ImageStore',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('taxon_latname', models.CharField(max_length=255, null=True)),
                ('taxon_author', models.CharField(max_length=255, null=True)),
                ('taxon_source', models.CharField(max_length=255, null=True)),
                ('taxon_include_descendants', models.BooleanField(default=False)),
                ('taxon_nuid', models.CharField(max_length=255, null=True)),
                ('name_uuid', models.UUIDField(null=True)),
                ('source_image', models.ImageField(upload_to=app_kit.models.get_image_store_path)),
                ('md5', models.CharField(max_length=255)),
                ('uploaded_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContentImage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('crop_parameters', models.TextField(null=True)),
                ('object_id', models.IntegerField()),
                ('image_type', models.CharField(default='image', max_length=100)),
                ('position', models.IntegerField(default=0)),
                ('is_primary', models.BooleanField(default=False)),
                ('text', models.CharField(max_length=355, null=True)),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
                ('image_store', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app_kit.imagestore')),
            ],
        ),
        migrations.CreateModel(
            name='MetaAppGenericContent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.IntegerField()),
                ('options', models.JSONField(null=True)),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
                ('meta_app', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app_kit.metaapp')),
            ],
            options={
                'unique_together': {('meta_app', 'content_type', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='AppContentTaxonomicRestriction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('taxon_latname', models.CharField(max_length=255)),
                ('taxon_author', models.CharField(max_length=255, null=True)),
                ('taxon_source', models.CharField(max_length=255)),
                ('taxon_include_descendants', models.BooleanField(default=False)),
                ('taxon_nuid', models.CharField(max_length=255)),
                ('name_uuid', models.UUIDField()),
                ('object_id', models.IntegerField()),
                ('restriction_type', models.CharField(choices=[('exists', 'exists'), ('required', 'required'), ('optional', 'optional')], default='exists', max_length=100)),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
            ],
            options={
                'abstract': False,
                'unique_together': {('content_type', 'object_id', 'taxon_latname', 'taxon_author')},
            },
        ),
    ]
