"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Intrinsic = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const stack_trace_1 = require("../stack-trace");
const token_1 = require("../token");
/**
 * Token subclass that represents values intrinsic to the target document language.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @stability stable
 */
class Intrinsic {
    /**
     * @stability stable
     */
    constructor(value, options = {}) {
        var _b;
        if (isFunction(value)) {
            throw new Error(`Argument to Intrinsic must be a plain value object, got ${value}`);
        }
        this.creationStack = ((_b = options.stackTrace) !== null && _b !== void 0 ? _b : true) ? stack_trace_1.captureStackTrace() : [];
        this.value = value;
    }
    /**
     * Produce the Token's value at resolution time.
     *
     * @stability stable
     */
    resolve(_context) {
        return this.value;
    }
    /**
     * Convert an instance of this Token to a string.
     *
     * This method will be called implicitly by language runtimes if the object
     * is embedded into a string. We treat it the same as an explicit
     * stringification.
     *
     * @stability stable
     */
    toString() {
        return token_1.Token.asString(this);
    }
    /**
     * Turn this Token into JSON.
     *
     * Called automatically when JSON.stringify() is called on a Token.
     *
     * @stability stable
     */
    toJSON() {
        // We can't do the right work here because in case we contain a function, we
        // won't know the type of value that function represents (in the simplest
        // case, string or number), and we can't know that without an
        // IResolveContext to actually do the resolution, which we don't have.
        // We used to throw an error, but since JSON.stringify() is often used in
        // error messages to produce a readable representation of an object, if we
        // throw here we'll obfuscate that descriptive error with something worse.
        // So return a string representation that indicates this thing is a token
        // and needs resolving.
        return '<unresolved-token>';
    }
    /**
     * Creates a throwable Error object that contains the token creation stack trace.
     *
     * @param message Error message.
     * @stability stable
     */
    newError(message) {
        return new Error(`${message}\nToken created:\n    at ${this.creationStack.join('\n    at ')}\nError thrown:`);
    }
}
exports.Intrinsic = Intrinsic;
_a = JSII_RTTI_SYMBOL_1;
Intrinsic[_a] = { fqn: "@aws-cdk/core.Intrinsic", version: "1.114.0" };
function isFunction(x) {
    return typeof x === 'function';
}
//# sourceMappingURL=data:application/json;base64,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