#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon May 20 11:32:33 2019

@author: stuart
"""

#deadpan_api image tools

import time


import traceback

import jsonpickle
from flask import request, Response
from flask.views import View

from flask_api import FlaskAPI

import urllib

#memory and cpu usage collection tools

import sys
import os

import socket

py_version = int(sys.version[0])

import inspect

import uuid

from deadpan_api import scrub_newlines, usage_collection


import logging

log = logging.Logger('pronlem')

def pullAndSave(url):

    name = '/tmp/{0}.pdf'.format(str(uuid.uuid1()))

    log.warning("PULLING FROM URL")
    
    try:
        filename, _ = urllib.request.urlretrieve(url, name)
        
    except Exception as exp:
        
        if '403' in str(exp):
            log.warning("403 ERROR")
            raise Exception('403 ERROR')
        elif '404' in str(exp):
            log.warning("404 ERROR")
            raise Exception('404 ERROR')
        else:
            log.warning("UNKNOWN ERROR")
            log.warning(exp)
            raise Exception('UNKNOWN ERROR')

    return filename


def run_file(r, app): 

    #if the user has sent a url then we want to extract that URL like this
    if r.headers['Content-Type'] != 'application/json':
    
        variables_info = dict(r.args)
                
        # convert string of image data to uint8
        try:
            filename = r.files['file'].filename
            r.files['file'].save(filename)
        except:
            raise Exception("COULD NOT EXTRACT FILE, PLEASE CHECK REQUEST AND RETRY")

    #if the user has sent an image then lets extract that image and store it as
    #a PIL
    else:
        #extract the variables info sent to the plugin
        try:
            variables_info = r.json
        except:
            raise Exception("VARIABLES JSON IS MALFORMED, PLEASE EXAMINE YOUR REQUEST AND RETRY")

        try:
            #extract the image from the sent url
            filename = pullAndSave(variables_info['contentUrl'])
        except Exception as exp:            
            
            if '403' in str(exp):
                
                raise Exception("COULD NOT PULL FROM URL DUE TO PERMISSIONS ERROR, PLEASE CHECK AND RETRY")
            
            elif '404' in str(exp):
                
                raise Exception("COULD NOT PULL FROM URL DUE TO 404 ERROR, PLEASE CHECK AND RETRY")
                
            else:
                raise Exception("COULD NOT PULL FROM URL, PLEASE CHECK URL AND RETRY")
            
        variables_info.pop('contentUrl', None)

    #apply the function to the image
    
    if inspect.getargspec(app.config['function'])[0][-1] == 'variables':
        out_predictions = app.config['function'](filename, variables_info)
    else:
        out_predictions = app.config['function'](filename)

    os.remove(filename)
          
    if not isinstance(out_predictions, dict):
        raise Exception("FUNCTION MUST RETURN A DICTIONARY")
    
    return out_predictions

#function to check if the user defined function is as it should be
def check_file_function_is_valid(function):

    args = inspect.getargspec(function)[0]

    if args != ['filename', 'variables'] and args != ['self', 'filename', 'variables'] and args != ['filename'] and args != ['self', 'filename']:
        
        return False
        
    else:
        return True

class mount_function(object):
    
    def __init__(self, function, host='0.0.0.0', port=5000, path='/model/predict'):
        
        
        debug_mode = False
        if 'PYTHON_DEBUG' in os.environ:
            if os.environ['PYTHON_DEBUG'].lower() == 'true':
                
                debug_mode = True
        
        self.app = FlaskAPI(__name__)

        self.app.config['debug'] = debug_mode
        
        self.app.config['function'] = function
        
        self.host = host
        
        self.port = port
        
        self.path = path
        
        if check_file_function_is_valid(self.app.config['function']):
            
            #define the class we're mounting onto post
            tool = filesAPI
            
            #if we're in debug mode we will need to collect usage statistics
            if True:
                tool.debug_mode = True
                tool.collection_tool = usage_collection()
            else:
                tool.debug_mode = False
            
            #store a link to the app in tool
            tool.app = self.app
            
            #create the rule for /model/predict
            self.app.add_url_rule(self.path, view_func = tool.as_view('UserAPI'))
            
            #run the app
            self.app.run(host=self.host, port=self.port, debug=self.app.config['debug'])
        
        else:
            #if the function has bad inputs reject it
            raise Exception("BAD ARGUMENTS SENT TO FUNCTION")

    
class filesAPI(View):
    
    methods = ['POST']
    
    def dispatch_request(self):
        
        try:
            #start usage stats collection
            if True:
                self.collection_tool.start_collection()
                start_time = time.time()
            
            #run the function
            answer = run_file(request, self.app)
            
            #check a dictionary has been returned
            if not isinstance(answer, dict):
                raise Exception("PLUGIN MUST RETURN A DICTIONARY, RETURNED {0}".format(str(type(answer))))
            
            #grab usage stats
            if True:
                [max_mem, max_cpu] = self.collection_tool.finish_collection()
                
            #store the usage stats
            if True:
                answer['max_cpu'] = max_cpu
                answer['max_mem'] = max_mem
                answer['containerID'] = socket.gethostname()
                answer['time_taken'] = round(time.time() - start_time, 2)
                if os.path.exists("/VERSION"):
                    with open("/VERSION", "r") as f:
                        version = scrub_newlines(f.read())    
                    answer["image_version"] = version
                    
                if os.path.exists("/IMAGE_NAME"):
                    with open("/IMAGE_NAME", "r") as f:
                        img_name = scrub_newlines(f.read())
                    answer['image_name'] = img_name
            
            answer['status'] = 'ok'
            
            response_pic = jsonpickle.encode(answer)
            #everything has gone fine, return the results in a nice response
            return Response(response=response_pic, status=200, mimetype="application/json")
        
        except Exception as exp:
        
            response = {'status':'failure', 'error':str(exp)}
            
            #if we're in debug mode then return a full traceback
            if self.app.config['debug']:
                response['full_traceback'] = str(traceback.format_exc())
                
            response_pic = jsonpickle.encode(response)
            
            #something has gone wrong return the bad result in this response
            return Response(response=response_pic, status=400, mimetype='application/json')
