"""empty message

Revision ID: 0ef6416a507b
Revises: 3fee3bd10f9d
Create Date: 2018-10-31 17:26:38.172799

"""
from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = '0ef6416a507b'
down_revision = '3fee3bd10f9d'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('asset_instance', sa.Column('target_asset_id', sqlalchemy_utils.types.uuid.UUIDType(binary=False), default=uuid.uuid4, nullable=True))
    op.create_index(op.f('ix_asset_instance_target_asset_id'), 'asset_instance', ['target_asset_id'], unique=False)
    op.drop_constraint('asset_instance_uc', 'asset_instance', type_='unique')
    op.create_unique_constraint('asset_instance_uc', 'asset_instance', ['asset_id', 'target_asset_id', 'scene_id', 'number'])
    op.drop_constraint('asset_instance_name_uc', 'asset_instance', type_='unique')
    op.create_foreign_key(None, 'asset_instance', 'entity', ['target_asset_id'], ['id'])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'asset_instance', type_='foreignkey')
    op.create_unique_constraint('asset_instance_name_uc', 'asset_instance', ['scene_id', 'name'])
    op.drop_constraint('asset_instance_uc', 'asset_instance', type_='unique')
    op.create_unique_constraint('asset_instance_uc', 'asset_instance', ['asset_id', 'scene_id', 'number'])
    op.drop_index(op.f('ix_asset_instance_target_asset_id'), table_name='asset_instance')
    op.drop_column('asset_instance', 'target_asset_id')
    # ### end Alembic commands ###
