# coding: utf-8

"""
    WASM OJ Wonderland API

    You can interact with WASM OJ Wonderland through this API  # noqa: E501

    The version of the OpenAPI document: 0.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, validator

class ApiSubmissionGet200ResponseSubmissionsInner(BaseModel):
    """
    ApiSubmissionGet200ResponseSubmissionsInner
    """
    id: StrictStr = Field(...)
    code_lang: StrictStr = Field(...)
    problem_id: StrictStr = Field(...)
    status: StrictStr = Field(...)
    submitter_id: StrictStr = Field(...)
    score: Optional[Union[StrictFloat, StrictInt]] = Field(...)
    cost: Optional[Union[StrictFloat, StrictInt]] = Field(...)
    memory: Optional[Union[StrictFloat, StrictInt]] = Field(...)
    __properties = ["id", "code_lang", "problem_id", "status", "submitter_id", "score", "cost", "memory"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('running', 'AC', 'WA', 'SLE', 'MLE', 'RE', 'error'):
            raise ValueError("must be one of enum values ('running', 'AC', 'WA', 'SLE', 'MLE', 'RE', 'error')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiSubmissionGet200ResponseSubmissionsInner:
        """Create an instance of ApiSubmissionGet200ResponseSubmissionsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if score (nullable) is None
        # and __fields_set__ contains the field
        if self.score is None and "score" in self.__fields_set__:
            _dict['score'] = None

        # set to None if cost (nullable) is None
        # and __fields_set__ contains the field
        if self.cost is None and "cost" in self.__fields_set__:
            _dict['cost'] = None

        # set to None if memory (nullable) is None
        # and __fields_set__ contains the field
        if self.memory is None and "memory" in self.__fields_set__:
            _dict['memory'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiSubmissionGet200ResponseSubmissionsInner:
        """Create an instance of ApiSubmissionGet200ResponseSubmissionsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiSubmissionGet200ResponseSubmissionsInner.parse_obj(obj)

        _obj = ApiSubmissionGet200ResponseSubmissionsInner.parse_obj({
            "id": obj.get("id"),
            "code_lang": obj.get("code_lang"),
            "problem_id": obj.get("problem_id"),
            "status": obj.get("status"),
            "submitter_id": obj.get("submitter_id"),
            "score": obj.get("score"),
            "cost": obj.get("cost"),
            "memory": obj.get("memory")
        })
        return _obj

