# coding: utf-8

"""
    WASM OJ Wonderland API

    You can interact with WASM OJ Wonderland through this API  # noqa: E501

    The version of the OpenAPI document: 0.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, validator

class ApiSubmissionIdGet200ResponseSubmission(BaseModel):
    """
    ApiSubmissionIdGet200ResponseSubmission
    """
    id: StrictStr = Field(...)
    submitter_id: StrictStr = Field(...)
    status: StrictStr = Field(...)
    code: StrictStr = Field(...)
    code_lang: StrictStr = Field(...)
    problem_id: StrictStr = Field(...)
    compiler_version: StrictStr = Field(...)
    runner_version: StrictStr = Field(...)
    score: Optional[Union[StrictFloat, StrictInt]] = Field(...)
    cost: Optional[Union[StrictFloat, StrictInt]] = Field(...)
    memory: Optional[Union[StrictFloat, StrictInt]] = Field(...)
    details: Optional[StrictStr] = Field(...)
    __properties = ["id", "submitter_id", "status", "code", "code_lang", "problem_id", "compiler_version", "runner_version", "score", "cost", "memory", "details"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('running', 'AC', 'WA', 'SLE', 'MLE', 'RE', 'error'):
            raise ValueError("must be one of enum values ('running', 'AC', 'WA', 'SLE', 'MLE', 'RE', 'error')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiSubmissionIdGet200ResponseSubmission:
        """Create an instance of ApiSubmissionIdGet200ResponseSubmission from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if score (nullable) is None
        # and __fields_set__ contains the field
        if self.score is None and "score" in self.__fields_set__:
            _dict['score'] = None

        # set to None if cost (nullable) is None
        # and __fields_set__ contains the field
        if self.cost is None and "cost" in self.__fields_set__:
            _dict['cost'] = None

        # set to None if memory (nullable) is None
        # and __fields_set__ contains the field
        if self.memory is None and "memory" in self.__fields_set__:
            _dict['memory'] = None

        # set to None if details (nullable) is None
        # and __fields_set__ contains the field
        if self.details is None and "details" in self.__fields_set__:
            _dict['details'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiSubmissionIdGet200ResponseSubmission:
        """Create an instance of ApiSubmissionIdGet200ResponseSubmission from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiSubmissionIdGet200ResponseSubmission.parse_obj(obj)

        _obj = ApiSubmissionIdGet200ResponseSubmission.parse_obj({
            "id": obj.get("id"),
            "submitter_id": obj.get("submitter_id"),
            "status": obj.get("status"),
            "code": obj.get("code"),
            "code_lang": obj.get("code_lang"),
            "problem_id": obj.get("problem_id"),
            "compiler_version": obj.get("compiler_version"),
            "runner_version": obj.get("runner_version"),
            "score": obj.get("score"),
            "cost": obj.get("cost"),
            "memory": obj.get("memory"),
            "details": obj.get("details")
        })
        return _obj

