"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BucketWebsiteTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
/**
 * Use a S3 as an alias record target.
 *
 * @stability stable
 */
class BucketWebsiteTarget {
    /**
     * @stability stable
     */
    constructor(bucket) {
        this.bucket = bucket;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record) {
        const { region } = core_1.Stack.of(this.bucket.stack);
        if (core_1.Token.isUnresolved(region)) {
            throw new Error([
                'Cannot use an S3 record alias in region-agnostic stacks.',
                'You must specify a specific region when you define the stack',
                '(see https://docs.aws.amazon.com/cdk/latest/guide/environments.html)',
            ].join(' '));
        }
        const { s3StaticWebsiteHostedZoneId: hostedZoneId, s3StaticWebsiteEndpoint: dnsName } = region_info_1.RegionInfo.get(region);
        if (!hostedZoneId || !dnsName) {
            throw new Error(`Bucket website target is not supported for the "${region}" region`);
        }
        return { hostedZoneId, dnsName };
    }
}
exports.BucketWebsiteTarget = BucketWebsiteTarget;
_a = JSII_RTTI_SYMBOL_1;
BucketWebsiteTarget[_a] = { fqn: "@aws-cdk/aws-route53-targets.BucketWebsiteTarget", version: "1.106.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYnVja2V0LXdlYnNpdGUtdGFyZ2V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYnVja2V0LXdlYnNpdGUtdGFyZ2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBRUEsd0NBQTZDO0FBQzdDLHNEQUFrRDs7Ozs7O0FBS2xELE1BQWEsbUJBQW1COzs7O0lBQzlCLFlBQTZCLE1BQWtCO1FBQWxCLFdBQU0sR0FBTixNQUFNLENBQVk7SUFDL0MsQ0FBQzs7Ozs7O0lBRU0sSUFBSSxDQUFDLE9BQTJCO1FBQ3JDLE1BQU0sRUFBRSxNQUFNLEVBQUUsR0FBRyxZQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFL0MsSUFBSSxZQUFLLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1lBQzlCLE1BQU0sSUFBSSxLQUFLLENBQUM7Z0JBQ2QsMERBQTBEO2dCQUMxRCw4REFBOEQ7Z0JBQzlELHNFQUFzRTthQUN2RSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO1NBQ2Q7UUFFRCxNQUFNLEVBQUUsMkJBQTJCLEVBQUUsWUFBWSxFQUFFLHVCQUF1QixFQUFFLE9BQU8sRUFBRSxHQUFHLHdCQUFVLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBRS9HLElBQUksQ0FBQyxZQUFZLElBQUksQ0FBQyxPQUFPLEVBQUU7WUFDN0IsTUFBTSxJQUFJLEtBQUssQ0FBQyxtREFBbUQsTUFBTSxVQUFVLENBQUMsQ0FBQztTQUN0RjtRQUVELE9BQU8sRUFBRSxZQUFZLEVBQUUsT0FBTyxFQUFFLENBQUM7SUFDbkMsQ0FBQzs7QUF0Qkgsa0RBdUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm91dGU1MyBmcm9tICdAYXdzLWNkay9hd3Mtcm91dGU1Myc7XG5pbXBvcnQgKiBhcyBzMyBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0IHsgU3RhY2ssIFRva2VuIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBSZWdpb25JbmZvIH0gZnJvbSAnQGF3cy1jZGsvcmVnaW9uLWluZm8nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBCdWNrZXRXZWJzaXRlVGFyZ2V0IGltcGxlbWVudHMgcm91dGU1My5JQWxpYXNSZWNvcmRUYXJnZXQge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGJ1Y2tldDogczMuSUJ1Y2tldCkge1xuICB9XG5cbiAgcHVibGljIGJpbmQoX3JlY29yZDogcm91dGU1My5JUmVjb3JkU2V0KTogcm91dGU1My5BbGlhc1JlY29yZFRhcmdldENvbmZpZyB7XG4gICAgY29uc3QgeyByZWdpb24gfSA9IFN0YWNrLm9mKHRoaXMuYnVja2V0LnN0YWNrKTtcblxuICAgIGlmIChUb2tlbi5pc1VucmVzb2x2ZWQocmVnaW9uKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFtcbiAgICAgICAgJ0Nhbm5vdCB1c2UgYW4gUzMgcmVjb3JkIGFsaWFzIGluIHJlZ2lvbi1hZ25vc3RpYyBzdGFja3MuJyxcbiAgICAgICAgJ1lvdSBtdXN0IHNwZWNpZnkgYSBzcGVjaWZpYyByZWdpb24gd2hlbiB5b3UgZGVmaW5lIHRoZSBzdGFjaycsXG4gICAgICAgICcoc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jZGsvbGF0ZXN0L2d1aWRlL2Vudmlyb25tZW50cy5odG1sKScsXG4gICAgICBdLmpvaW4oJyAnKSk7XG4gICAgfVxuXG4gICAgY29uc3QgeyBzM1N0YXRpY1dlYnNpdGVIb3N0ZWRab25lSWQ6IGhvc3RlZFpvbmVJZCwgczNTdGF0aWNXZWJzaXRlRW5kcG9pbnQ6IGRuc05hbWUgfSA9IFJlZ2lvbkluZm8uZ2V0KHJlZ2lvbik7XG5cbiAgICBpZiAoIWhvc3RlZFpvbmVJZCB8fCAhZG5zTmFtZSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBCdWNrZXQgd2Vic2l0ZSB0YXJnZXQgaXMgbm90IHN1cHBvcnRlZCBmb3IgdGhlIFwiJHtyZWdpb259XCIgcmVnaW9uYCk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHsgaG9zdGVkWm9uZUlkLCBkbnNOYW1lIH07XG4gIH1cbn1cbiJdfQ==