""" Code is generated by ucloud-model, DO NOT EDIT IT. """


from ucloud.core.typesystem import schema, fields
from ucloud.services.ulb.schemas import models

""" ULB API Schema
"""


"""
API: AddTargets

给应用型负载均衡监听器添加后端服务节点
"""


class AddTargetsParamTargetsSchema(schema.RequestSchema):
    """AddTargetsParamTargets -"""

    fields = {
        "Enabled": fields.Bool(required=False, dump_to="Enabled"),
        "IsBackup": fields.Bool(required=False, dump_to="IsBackup"),
        "Port": fields.Int(required=False, dump_to="Port"),
        "ResourceIP": fields.Str(required=False, dump_to="ResourceIP"),
        "ResourceId": fields.Str(required=False, dump_to="ResourceId"),
        "ResourceType": fields.Str(required=False, dump_to="ResourceType"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Weight": fields.Int(required=False, dump_to="Weight"),
    }


class AddTargetsRequestSchema(schema.RequestSchema):
    """AddTargets - 给应用型负载均衡监听器添加后端服务节点"""

    fields = {
        "ListenerId": fields.Str(required=True, dump_to="ListenerId"),
        "LoadBalancerId": fields.Str(required=True, dump_to="LoadBalancerId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Targets": fields.List(AddTargetsParamTargetsSchema()),
    }


class AddTargetsResponseSchema(schema.ResponseSchema):
    """AddTargets - 给应用型负载均衡监听器添加后端服务节点"""

    fields = {
        "Targets": fields.List(
            models.TargetSetSchema(), required=False, load_from="Targets"
        ),
    }


"""
API: AllocateBackend

添加CLB后端资源实例
"""


class AllocateBackendRequestSchema(schema.RequestSchema):
    """AllocateBackend - 添加CLB后端资源实例"""

    fields = {
        "Enabled": fields.Int(required=False, dump_to="Enabled"),
        "IsBackup": fields.Int(required=False, dump_to="IsBackup"),
        "Port": fields.Int(required=False, dump_to="Port"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceIP": fields.Str(required=False, dump_to="ResourceIP"),
        "ResourceId": fields.Str(required=False, dump_to="ResourceId"),
        "ResourceType": fields.Str(required=True, dump_to="ResourceType"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "ULBId": fields.Str(required=True, dump_to="ULBId"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "VServerId": fields.Str(required=True, dump_to="VServerId"),
        "Weight": fields.Int(required=False, dump_to="Weight"),
    }


class AllocateBackendResponseSchema(schema.ResponseSchema):
    """AllocateBackend - 添加CLB后端资源实例"""

    fields = {
        "BackendId": fields.Str(required=False, load_from="BackendId"),
    }


"""
API: AllocateBackendBatch


"""


class AllocateBackendBatchRequestSchema(schema.RequestSchema):
    """AllocateBackendBatch -"""

    fields = {
        "ApiVersion": fields.Int(required=False, dump_to="ApiVersion"),
        "Backends": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ULBId": fields.Str(required=True, dump_to="ULBId"),
        "VServerId": fields.Str(required=True, dump_to="VServerId"),
    }


class AllocateBackendBatchResponseSchema(schema.ResponseSchema):
    """AllocateBackendBatch -"""

    fields = {
        "BackendSet": fields.List(
            models.BackendSetSchema(), required=False, load_from="BackendSet"
        ),
    }


"""
API: BindSSL

将SSL证书绑定到传统型负载均衡VServer
"""


class BindSSLRequestSchema(schema.RequestSchema):
    """BindSSL - 将SSL证书绑定到传统型负载均衡VServer"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSLId": fields.Str(required=True, dump_to="SSLId"),
        "ULBId": fields.Str(required=True, dump_to="ULBId"),
        "VServerId": fields.Str(required=True, dump_to="VServerId"),
    }


class BindSSLResponseSchema(schema.ResponseSchema):
    """BindSSL - 将SSL证书绑定到传统型负载均衡VServer"""

    fields = {}


"""
API: CreateListener

创建一个应用型负载均衡的监听器
"""


class CreateListenerParamStickinessConfigSchema(schema.RequestSchema):
    """CreateListenerParamStickinessConfig -"""

    fields = {
        "CookieName": fields.Str(required=False, dump_to="CookieName"),
        "Enabled": fields.Bool(required=False, dump_to="Enabled"),
        "Type": fields.Str(required=False, dump_to="Type"),
    }


class CreateListenerParamHealthCheckConfigSchema(schema.RequestSchema):
    """CreateListenerParamHealthCheckConfig -"""

    fields = {
        "Domain": fields.Str(required=False, dump_to="Domain"),
        "Enabled": fields.Bool(required=False, dump_to="Enabled"),
        "Path": fields.Str(required=False, dump_to="Path"),
        "Type": fields.Str(required=False, dump_to="Type"),
    }


class CreateListenerRequestSchema(schema.RequestSchema):
    """CreateListener - 创建一个应用型负载均衡的监听器"""

    fields = {
        "Certificates": fields.List(fields.Str()),
        "CompressionEnabled": fields.Bool(
            required=False, dump_to="CompressionEnabled"
        ),
        "HTTP2Enabled": fields.Bool(required=False, dump_to="HTTP2Enabled"),
        "HealthCheckConfig": CreateListenerParamHealthCheckConfigSchema(
            required=False, dump_to="HealthCheckConfig"
        ),
        "IdleTimeout": fields.Int(required=False, dump_to="IdleTimeout"),
        "ListenerPort": fields.Int(required=False, dump_to="ListenerPort"),
        "ListenerProtocol": fields.Str(
            required=False, dump_to="ListenerProtocol"
        ),
        "LoadBalancerId": fields.Str(required=True, dump_to="LoadBalancerId"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "RedirectEnabled": fields.Bool(
            required=False, dump_to="RedirectEnabled"
        ),
        "RedirectPort": fields.Int(required=False, dump_to="RedirectPort"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "Scheduler": fields.Str(required=False, dump_to="Scheduler"),
        "SecurityPolicyId": fields.Str(
            required=False, dump_to="SecurityPolicyId"
        ),
        "StickinessConfig": CreateListenerParamStickinessConfigSchema(
            required=False, dump_to="StickinessConfig"
        ),
    }


class CreateListenerResponseSchema(schema.ResponseSchema):
    """CreateListener - 创建一个应用型负载均衡的监听器"""

    fields = {
        "ListenerId": fields.Str(required=True, load_from="ListenerId"),
    }


"""
API: CreateLoadBalancer

创建一个应用型负载均衡实例
"""


class CreateLoadBalancerRequestSchema(schema.RequestSchema):
    """CreateLoadBalancer - 创建一个应用型负载均衡实例"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "IPVersion": fields.Str(required=False, dump_to="IPVersion"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "SubnetId": fields.Str(required=True, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "Type": fields.Str(required=False, dump_to="Type"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
    }


class CreateLoadBalancerResponseSchema(schema.ResponseSchema):
    """CreateLoadBalancer - 创建一个应用型负载均衡实例"""

    fields = {
        "LoadBalancerId": fields.Str(
            required=False, load_from="LoadBalancerId"
        ),
    }


"""
API: CreatePolicy

传统型负载均衡创建VServer内容转发策略
"""


class CreatePolicyRequestSchema(schema.RequestSchema):
    """CreatePolicy - 传统型负载均衡创建VServer内容转发策略"""

    fields = {
        "BackendId": fields.List(fields.Str()),
        "DomainMatchMode": fields.Str(
            required=False, dump_to="DomainMatchMode"
        ),
        "Match": fields.Str(required=True, dump_to="Match"),
        "PolicyPriority": fields.Int(required=False, dump_to="PolicyPriority"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Type": fields.Str(required=False, dump_to="Type"),
        "ULBId": fields.Str(required=True, dump_to="ULBId"),
        "VServerId": fields.Str(required=True, dump_to="VServerId"),
    }


class CreatePolicyResponseSchema(schema.ResponseSchema):
    """CreatePolicy - 传统型负载均衡创建VServer内容转发策略"""

    fields = {
        "PolicyId": fields.Str(required=False, load_from="PolicyId"),
    }


"""
API: CreateRule

给应用型负载均衡监听器创建一条转发规则
"""


class CreateRuleParamRuleActionsForwardConfigTargetsSchema(
    schema.RequestSchema
):
    """CreateRuleParamRuleActionsForwardConfigTargets -"""

    fields = {
        "Id": fields.Str(required=False, dump_to="Id"),
        "Weight": fields.Int(required=False, dump_to="Weight"),
    }


class CreateRuleParamRuleConditionsPathConfigSchema(schema.RequestSchema):
    """CreateRuleParamRuleConditionsPathConfig -"""

    fields = {
        "Values": fields.List(fields.Str()),
    }


class CreateRuleParamRuleConditionsHostConfigSchema(schema.RequestSchema):
    """CreateRuleParamRuleConditionsHostConfig -"""

    fields = {
        "MatchMode": fields.Str(required=False, dump_to="MatchMode"),
        "Values": fields.List(fields.Str()),
    }


class CreateRuleParamRuleActionsForwardConfigSchema(schema.RequestSchema):
    """CreateRuleParamRuleActionsForwardConfig -"""

    fields = {
        "Targets": fields.List(
            CreateRuleParamRuleActionsForwardConfigTargetsSchema()
        ),
    }


class CreateRuleParamRuleConditionsSchema(schema.RequestSchema):
    """CreateRuleParamRuleConditions -"""

    fields = {
        "HostConfig": CreateRuleParamRuleConditionsHostConfigSchema(
            required=False, dump_to="HostConfig"
        ),
        "PathConfig": CreateRuleParamRuleConditionsPathConfigSchema(
            required=False, dump_to="PathConfig"
        ),
        "Type": fields.Str(required=True, dump_to="Type"),
    }


class CreateRuleParamRuleActionsSchema(schema.RequestSchema):
    """CreateRuleParamRuleActions -"""

    fields = {
        "ForwardConfig": CreateRuleParamRuleActionsForwardConfigSchema(
            required=False, dump_to="ForwardConfig"
        ),
        "Type": fields.Str(required=True, dump_to="Type"),
    }


class CreateRuleRequestSchema(schema.RequestSchema):
    """CreateRule - 给应用型负载均衡监听器创建一条转发规则"""

    fields = {
        "ListenerId": fields.Str(required=True, dump_to="ListenerId"),
        "LoadBalancerId": fields.Str(required=True, dump_to="LoadBalancerId"),
        "Pass": fields.Bool(required=False, dump_to="Pass"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RuleActions": fields.List(CreateRuleParamRuleActionsSchema()),
        "RuleConditions": fields.List(CreateRuleParamRuleConditionsSchema()),
    }


class CreateRuleResponseSchema(schema.ResponseSchema):
    """CreateRule - 给应用型负载均衡监听器创建一条转发规则"""

    fields = {
        "RuleId": fields.Str(required=True, load_from="RuleId"),
    }


"""
API: CreateSSL

创建SSL证书，可以把整个 Pem 证书内容传过来，或者把证书、私钥、CA证书分别传过来
"""


class CreateSSLRequestSchema(schema.RequestSchema):
    """CreateSSL - 创建SSL证书，可以把整个 Pem 证书内容传过来，或者把证书、私钥、CA证书分别传过来"""

    fields = {
        "CaCert": fields.Str(required=False, dump_to="CaCert"),
        "PrivateKey": fields.Str(required=False, dump_to="PrivateKey"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSLContent": fields.Str(required=False, dump_to="SSLContent"),
        "SSLName": fields.Str(required=True, dump_to="SSLName"),
        "SSLType": fields.Str(required=False, dump_to="SSLType"),
        "USSLId": fields.Str(required=False, dump_to="USSLId"),
        "UserCert": fields.Str(required=False, dump_to="UserCert"),
    }


class CreateSSLResponseSchema(schema.ResponseSchema):
    """CreateSSL - 创建SSL证书，可以把整个 Pem 证书内容传过来，或者把证书、私钥、CA证书分别传过来"""

    fields = {
        "SSLId": fields.Str(required=False, load_from="SSLId"),
    }


"""
API: CreateSecurityPolicy

创建安全策略
"""


class CreateSecurityPolicyRequestSchema(schema.RequestSchema):
    """CreateSecurityPolicy - 创建安全策略"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSLCiphers": fields.List(fields.Str()),
        "SecurityPolicyName": fields.Str(
            required=True, dump_to="SecurityPolicyName"
        ),
        "TLSVersion": fields.Str(required=True, dump_to="TLSVersion"),
    }


class CreateSecurityPolicyResponseSchema(schema.ResponseSchema):
    """CreateSecurityPolicy - 创建安全策略"""

    fields = {
        "SecurityPolicyId": fields.Str(
            required=True, load_from="SecurityPolicyId"
        ),
    }


"""
API: CreateULB

创建传统型负载均衡负载均衡实例，可以选择内网或者外网
"""


class CreateULBRequestSchema(schema.RequestSchema):
    """CreateULB - 创建传统型负载均衡负载均衡实例，可以选择内网或者外网"""

    fields = {
        "BusinessId": fields.Str(required=False, dump_to="BusinessId"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "FirewallId": fields.Str(required=False, dump_to="FirewallId"),
        "IPVersion": fields.Str(
            required=False, dump_to="IPVersion"
        ),  # Deprecated, will be removed at 1.0
        "InnerMode": fields.Str(required=False, dump_to="InnerMode"),
        "ListenType": fields.Str(required=False, dump_to="ListenType"),
        "OuterMode": fields.Str(required=False, dump_to="OuterMode"),
        "PrivateIp": fields.Str(
            required=False, dump_to="PrivateIp"
        ),  # Deprecated, will be removed at 1.0
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "ULBName": fields.Str(required=False, dump_to="ULBName"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
    }


class CreateULBResponseSchema(schema.ResponseSchema):
    """CreateULB - 创建传统型负载均衡负载均衡实例，可以选择内网或者外网"""

    fields = {
        "IPv6AddressId": fields.Str(required=False, load_from="IPv6AddressId"),
        "ULBId": fields.Str(required=False, load_from="ULBId"),
    }


"""
API: CreateVServer

创建CLB的VServer实例，定义监听的协议和端口以及负载均衡算法
"""


class CreateVServerRequestSchema(schema.RequestSchema):
    """CreateVServer - 创建CLB的VServer实例，定义监听的协议和端口以及负载均衡算法"""

    fields = {
        "ClientTimeout": fields.Int(required=False, dump_to="ClientTimeout"),
        "Domain": fields.Str(required=False, dump_to="Domain"),
        "EnableCompression": fields.Int(
            required=False, dump_to="EnableCompression"
        ),
        "EnableHTTP2": fields.Int(required=False, dump_to="EnableHTTP2"),
        "ForwardPort": fields.Int(required=False, dump_to="ForwardPort"),
        "FrontendPort": fields.Int(required=False, dump_to="FrontendPort"),
        "ListenType": fields.Str(required=False, dump_to="ListenType"),
        "Method": fields.Str(required=False, dump_to="Method"),
        "MonitorType": fields.Str(required=False, dump_to="MonitorType"),
        "Path": fields.Str(required=False, dump_to="Path"),
        "PersistenceInfo": fields.Str(
            required=False, dump_to="PersistenceInfo"
        ),
        "PersistenceType": fields.Str(
            required=False, dump_to="PersistenceType"
        ),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Protocol": fields.Str(required=False, dump_to="Protocol"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RequestMsg": fields.Str(required=False, dump_to="RequestMsg"),
        "ResponseMsg": fields.Str(required=False, dump_to="ResponseMsg"),
        "SecurityPolicyId": fields.Str(
            required=False, dump_to="SecurityPolicyId"
        ),
        "ULBId": fields.Str(required=True, dump_to="ULBId"),
        "VServerName": fields.Str(required=False, dump_to="VServerName"),
    }


class CreateVServerResponseSchema(schema.ResponseSchema):
    """CreateVServer - 创建CLB的VServer实例，定义监听的协议和端口以及负载均衡算法"""

    fields = {
        "VServerId": fields.Str(required=False, load_from="VServerId"),
    }


"""
API: DeleteListener

删除一个应用型负载均衡监听器
"""


class DeleteListenerRequestSchema(schema.RequestSchema):
    """DeleteListener - 删除一个应用型负载均衡监听器"""

    fields = {
        "ListenerId": fields.Str(required=True, dump_to="ListenerId"),
        "LoadBalancerId": fields.Str(required=True, dump_to="LoadBalancerId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RelatedRedirectDisabled": fields.Bool(
            required=True, dump_to="RelatedRedirectDisabled"
        ),
    }


class DeleteListenerResponseSchema(schema.ResponseSchema):
    """DeleteListener - 删除一个应用型负载均衡监听器"""

    fields = {}


"""
API: DeleteLoadBalancer

删除一个应用型负载均衡实例
"""


class DeleteLoadBalancerRequestSchema(schema.RequestSchema):
    """DeleteLoadBalancer - 删除一个应用型负载均衡实例"""

    fields = {
        "LoadBalancerId": fields.Str(required=True, dump_to="LoadBalancerId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DeleteLoadBalancerResponseSchema(schema.ResponseSchema):
    """DeleteLoadBalancer - 删除一个应用型负载均衡实例"""

    fields = {}


"""
API: DeletePolicy

删除传统型负载均衡的内容转发策略
"""


class DeletePolicyRequestSchema(schema.RequestSchema):
    """DeletePolicy - 删除传统型负载均衡的内容转发策略"""

    fields = {
        "GroupId": fields.Str(
            required=False, dump_to="GroupId"
        ),  # Deprecated, will be removed at 1.0
        "PolicyId": fields.Str(required=True, dump_to="PolicyId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VServerId": fields.Str(required=False, dump_to="VServerId"),
    }


class DeletePolicyResponseSchema(schema.ResponseSchema):
    """DeletePolicy - 删除传统型负载均衡的内容转发策略"""

    fields = {}


"""
API: DeleteRule

删除应用型负载均衡监听器的一条转发规则
"""


class DeleteRuleRequestSchema(schema.RequestSchema):
    """DeleteRule - 删除应用型负载均衡监听器的一条转发规则"""

    fields = {
        "ListenerId": fields.Str(required=True, dump_to="ListenerId"),
        "LoadBalancerId": fields.Str(required=True, dump_to="LoadBalancerId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RuleId": fields.Str(required=True, dump_to="RuleId"),
    }


class DeleteRuleResponseSchema(schema.ResponseSchema):
    """DeleteRule - 删除应用型负载均衡监听器的一条转发规则"""

    fields = {}


"""
API: DeleteSSL

删除SSL证书
"""


class DeleteSSLRequestSchema(schema.RequestSchema):
    """DeleteSSL - 删除SSL证书"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSLId": fields.Str(required=True, dump_to="SSLId"),
    }


class DeleteSSLResponseSchema(schema.ResponseSchema):
    """DeleteSSL - 删除SSL证书"""

    fields = {}


"""
API: DeleteSecurityPolicy

删除安全策略
"""


class DeleteSecurityPolicyRequestSchema(schema.RequestSchema):
    """DeleteSecurityPolicy - 删除安全策略"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SecurityPolicyId": fields.Str(
            required=True, dump_to="SecurityPolicyId"
        ),
    }


class DeleteSecurityPolicyResponseSchema(schema.ResponseSchema):
    """DeleteSecurityPolicy - 删除安全策略"""

    fields = {}


"""
API: DeleteULB

删除传统型负载均衡实例
"""


class DeleteULBRequestSchema(schema.RequestSchema):
    """DeleteULB - 删除传统型负载均衡实例"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ReleaseEip": fields.Bool(required=False, dump_to="ReleaseEip"),
        "ULBId": fields.Str(required=True, dump_to="ULBId"),
    }


class DeleteULBResponseSchema(schema.ResponseSchema):
    """DeleteULB - 删除传统型负载均衡实例"""

    fields = {}


"""
API: DeleteVServer

删除CLB的VServer实例
"""


class DeleteVServerRequestSchema(schema.RequestSchema):
    """DeleteVServer - 删除CLB的VServer实例"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ULBId": fields.Str(required=True, dump_to="ULBId"),
        "VServerId": fields.Str(required=True, dump_to="VServerId"),
    }


class DeleteVServerResponseSchema(schema.ResponseSchema):
    """DeleteVServer - 删除CLB的VServer实例"""

    fields = {}


"""
API: DescribeListeners

描述一个指定的监听器或者一个应用型负载均衡实例下的所有监听器
"""


class DescribeListenersRequestSchema(schema.RequestSchema):
    """DescribeListeners - 描述一个指定的监听器或者一个应用型负载均衡实例下的所有监听器"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "ListenerId": fields.Str(required=False, dump_to="ListenerId"),
        "LoadBalancerId": fields.Str(required=False, dump_to="LoadBalancerId"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DescribeListenersResponseSchema(schema.ResponseSchema):
    """DescribeListeners - 描述一个指定的监听器或者一个应用型负载均衡实例下的所有监听器"""

    fields = {
        "Listeners": fields.List(
            models.ListenerSchema(), required=False, load_from="Listeners"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeLoadBalancers

描述特定条件下的应用型负载均衡实例或者全部的应用型负载均衡实例
"""


class DescribeLoadBalancersRequestSchema(schema.RequestSchema):
    """DescribeLoadBalancers - 描述特定条件下的应用型负载均衡实例或者全部的应用型负载均衡实例"""

    fields = {
        "Limit": fields.Str(required=False, dump_to="Limit"),
        "LoadBalancerIds": fields.List(fields.Str()),
        "Offset": fields.Str(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ShowDetail": fields.Bool(required=False, dump_to="ShowDetail"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "Type": fields.Str(required=False, dump_to="Type"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
    }


class DescribeLoadBalancersResponseSchema(schema.ResponseSchema):
    """DescribeLoadBalancers - 描述特定条件下的应用型负载均衡实例或者全部的应用型负载均衡实例"""

    fields = {
        "LoadBalancers": fields.List(
            models.LoadBalancerSchema(),
            required=True,
            load_from="LoadBalancers",
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeRules

描述一条指定的转发规则或者一个应用型负载均衡监听器下的所有转发规则
"""


class DescribeRulesRequestSchema(schema.RequestSchema):
    """DescribeRules - 描述一条指定的转发规则或者一个应用型负载均衡监听器下的所有转发规则"""

    fields = {
        "ListenerId": fields.Str(required=True, dump_to="ListenerId"),
        "LoadBalancerId": fields.Str(required=True, dump_to="LoadBalancerId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RuleId": fields.Str(required=False, dump_to="RuleId"),
    }


class DescribeRulesResponseSchema(schema.ResponseSchema):
    """DescribeRules - 描述一条指定的转发规则或者一个应用型负载均衡监听器下的所有转发规则"""

    fields = {
        "Rules": fields.List(
            models.RuleSchema(), required=True, load_from="Rules"
        ),
    }


"""
API: DescribeSSL

获取SSL证书信息，仅能获取SSL证书与传统型负载均衡监听器的绑定关系
"""


class DescribeSSLRequestSchema(schema.RequestSchema):
    """DescribeSSL - 获取SSL证书信息，仅能获取SSL证书与传统型负载均衡监听器的绑定关系"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSLId": fields.Str(required=False, dump_to="SSLId"),
    }


class DescribeSSLResponseSchema(schema.ResponseSchema):
    """DescribeSSL - 获取SSL证书信息，仅能获取SSL证书与传统型负载均衡监听器的绑定关系"""

    fields = {
        "DataSet": fields.List(
            models.ULBSSLSetSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeSSLV2

获取SSL证书信息，该接口可以同时获取SSL与传统型和应用型负载均衡监听器的绑定关系
"""


class DescribeSSLV2RequestSchema(schema.RequestSchema):
    """DescribeSSLV2 - 获取SSL证书信息，该接口可以同时获取SSL与传统型和应用型负载均衡监听器的绑定关系"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSLId": fields.Str(required=False, dump_to="SSLId"),
    }


class DescribeSSLV2ResponseSchema(schema.ResponseSchema):
    """DescribeSSLV2 - 获取SSL证书信息，该接口可以同时获取SSL与传统型和应用型负载均衡监听器的绑定关系"""

    fields = {
        "DataSet": fields.List(
            models.SSLInfoSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeSecurityPolicies

获取安全策略的信息，绑定关系仅能获取安全策略与传统型负载均衡监听器的绑定关系
"""


class DescribeSecurityPoliciesRequestSchema(schema.RequestSchema):
    """DescribeSecurityPolicies - 获取安全策略的信息，绑定关系仅能获取安全策略与传统型负载均衡监听器的绑定关系"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SecurityPolicyId": fields.Str(
            required=False, dump_to="SecurityPolicyId"
        ),
    }


class DescribeSecurityPoliciesResponseSchema(schema.ResponseSchema):
    """DescribeSecurityPolicies - 获取安全策略的信息，绑定关系仅能获取安全策略与传统型负载均衡监听器的绑定关系"""

    fields = {
        "DataSet": fields.List(
            models.SecurityPolicySchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeSecurityPoliciesV2

获取安全策略的信息，可以同时获取安全策略与传统型和应用性负载均衡监听器的绑定关系
"""


class DescribeSecurityPoliciesV2RequestSchema(schema.RequestSchema):
    """DescribeSecurityPoliciesV2 - 获取安全策略的信息，可以同时获取安全策略与传统型和应用性负载均衡监听器的绑定关系"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SecurityPolicyId": fields.Str(
            required=False, dump_to="SecurityPolicyId"
        ),
    }


class DescribeSecurityPoliciesV2ResponseSchema(schema.ResponseSchema):
    """DescribeSecurityPoliciesV2 - 获取安全策略的信息，可以同时获取安全策略与传统型和应用性负载均衡监听器的绑定关系"""

    fields = {
        "DataSet": fields.List(
            models.SecurityPolicyInfoSchema(),
            required=False,
            load_from="DataSet",
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeSupportCiphers

返回安全策略所有支持的加密套件
"""


class DescribeSupportCiphersRequestSchema(schema.RequestSchema):
    """DescribeSupportCiphers - 返回安全策略所有支持的加密套件"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DescribeSupportCiphersResponseSchema(schema.ResponseSchema):
    """DescribeSupportCiphers - 返回安全策略所有支持的加密套件"""

    fields = {
        "DataSet": fields.List(
            models.TLSAndCiphersSchema(), required=False, load_from="DataSet"
        ),
    }


"""
API: DescribeULB

获取CLB详细信息
"""


class DescribeULBRequestSchema(schema.RequestSchema):
    """DescribeULB - 获取CLB详细信息"""

    fields = {
        "BusinessId": fields.Str(required=False, dump_to="BusinessId"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "ULBId": fields.Str(required=False, dump_to="ULBId"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
    }


class DescribeULBResponseSchema(schema.ResponseSchema):
    """DescribeULB - 获取CLB详细信息"""

    fields = {
        "DataSet": fields.List(
            models.ULBSetSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeULBSimple

获取CLB信息
"""


class DescribeULBSimpleRequestSchema(schema.RequestSchema):
    """DescribeULBSimple - 获取CLB信息"""

    fields = {
        "BusinessId": fields.Str(required=False, dump_to="BusinessId"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "ULBId": fields.Str(required=False, dump_to="ULBId"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
    }


class DescribeULBSimpleResponseSchema(schema.ResponseSchema):
    """DescribeULBSimple - 获取CLB信息"""

    fields = {
        "DataSet": fields.List(
            models.ULBSimpleSetSchema(), required=True, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeVServer

获取CLB下的VServer的详细信息
"""


class DescribeVServerRequestSchema(schema.RequestSchema):
    """DescribeVServer - 获取CLB下的VServer的详细信息"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ULBId": fields.Str(required=False, dump_to="ULBId"),
        "VServerId": fields.Str(required=False, dump_to="VServerId"),
    }


class DescribeVServerResponseSchema(schema.ResponseSchema):
    """DescribeVServer - 获取CLB下的VServer的详细信息"""

    fields = {
        "DataSet": fields.List(
            models.ULBVServerSetSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: ReleaseBackend

从CLB的VServer释放后端资源实例
"""


class ReleaseBackendRequestSchema(schema.RequestSchema):
    """ReleaseBackend - 从CLB的VServer释放后端资源实例"""

    fields = {
        "BackendId": fields.Str(required=True, dump_to="BackendId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ULBId": fields.Str(required=True, dump_to="ULBId"),
    }


class ReleaseBackendResponseSchema(schema.ResponseSchema):
    """ReleaseBackend - 从CLB的VServer释放后端资源实例"""

    fields = {}


"""
API: RemoveTargets

从应用型负载均衡监听器删除后端服务节点
"""


class RemoveTargetsRequestSchema(schema.RequestSchema):
    """RemoveTargets - 从应用型负载均衡监听器删除后端服务节点"""

    fields = {
        "Ids": fields.List(fields.Str()),
        "ListenerId": fields.Str(required=True, dump_to="ListenerId"),
        "LoadBalancerId": fields.Str(required=True, dump_to="LoadBalancerId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class RemoveTargetsResponseSchema(schema.ResponseSchema):
    """RemoveTargets - 从应用型负载均衡监听器删除后端服务节点"""

    fields = {}


"""
API: UnBindSecurityPolicy

批量解绑安全策略，会同时解绑与传统型和应用型负载均衡监听器的绑定关系
"""


class UnBindSecurityPolicyRequestSchema(schema.RequestSchema):
    """UnBindSecurityPolicy - 批量解绑安全策略，会同时解绑与传统型和应用型负载均衡监听器的绑定关系"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SecurityPolicyId": fields.Str(
            required=True, dump_to="SecurityPolicyId"
        ),
    }


class UnBindSecurityPolicyResponseSchema(schema.ResponseSchema):
    """UnBindSecurityPolicy - 批量解绑安全策略，会同时解绑与传统型和应用型负载均衡监听器的绑定关系"""

    fields = {}


"""
API: UnbindSSL

从CLB下的VServer解绑SSL证书
"""


class UnbindSSLRequestSchema(schema.RequestSchema):
    """UnbindSSL - 从CLB下的VServer解绑SSL证书"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSLId": fields.Str(required=True, dump_to="SSLId"),
        "ULBId": fields.Str(required=True, dump_to="ULBId"),
        "VServerId": fields.Str(required=True, dump_to="VServerId"),
    }


class UnbindSSLResponseSchema(schema.ResponseSchema):
    """UnbindSSL - 从CLB下的VServer解绑SSL证书"""

    fields = {}


"""
API: UpdateBackendAttribute

更新CLB后端资源实例(服务节点)属性
"""


class UpdateBackendAttributeRequestSchema(schema.RequestSchema):
    """UpdateBackendAttribute - 更新CLB后端资源实例(服务节点)属性"""

    fields = {
        "BackendId": fields.Str(required=True, dump_to="BackendId"),
        "Enabled": fields.Int(required=False, dump_to="Enabled"),
        "IsBackup": fields.Int(required=False, dump_to="IsBackup"),
        "Port": fields.Int(required=False, dump_to="Port"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ULBId": fields.Str(required=True, dump_to="ULBId"),
        "Weight": fields.Int(required=False, dump_to="Weight"),
    }


class UpdateBackendAttributeResponseSchema(schema.ResponseSchema):
    """UpdateBackendAttribute - 更新CLB后端资源实例(服务节点)属性"""

    fields = {}


"""
API: UpdateBackendBatch

批量更新ULB后端资源实例(服务节点)属性
"""


class UpdateBackendBatchParamAttributesSchema(schema.RequestSchema):
    """UpdateBackendBatchParamAttributes -"""

    fields = {
        "BackendId": fields.Str(required=True, dump_to="BackendId"),
        "Enabled": fields.Int(required=False, dump_to="Enabled"),
        "IsBackup": fields.Int(required=False, dump_to="IsBackup"),
        "Port": fields.Int(required=False, dump_to="Port"),
        "Weight": fields.Int(required=False, dump_to="Weight"),
    }


class UpdateBackendBatchRequestSchema(schema.RequestSchema):
    """UpdateBackendBatch - 批量更新ULB后端资源实例(服务节点)属性"""

    fields = {
        "Attributes": fields.List(UpdateBackendBatchParamAttributesSchema()),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ULBId": fields.Str(required=True, dump_to="ULBId"),
    }


class UpdateBackendBatchResponseSchema(schema.ResponseSchema):
    """UpdateBackendBatch - 批量更新ULB后端资源实例(服务节点)属性"""

    fields = {
        "BackendSet": fields.List(
            models.BackendMsgSchema(), required=False, load_from="BackendSet"
        ),
    }


"""
API: UpdateListenerAttribute

更新一个应用型负载均衡监听器的属性
"""


class UpdateListenerAttributeParamStickinessConfigSchema(schema.RequestSchema):
    """UpdateListenerAttributeParamStickinessConfig -"""

    fields = {
        "CookieName": fields.Str(required=False, dump_to="CookieName"),
        "Enabled": fields.Bool(required=False, dump_to="Enabled"),
        "Type": fields.Str(required=False, dump_to="Type"),
    }


class UpdateListenerAttributeParamHealthCheckConfigSchema(schema.RequestSchema):
    """UpdateListenerAttributeParamHealthCheckConfig -"""

    fields = {
        "Domain": fields.Str(required=False, dump_to="Domain"),
        "Enabled": fields.Bool(required=False, dump_to="Enabled"),
        "Path": fields.Str(required=False, dump_to="Path"),
        "Type": fields.Str(required=False, dump_to="Type"),
    }


class UpdateListenerAttributeRequestSchema(schema.RequestSchema):
    """UpdateListenerAttribute - 更新一个应用型负载均衡监听器的属性"""

    fields = {
        "Certificates": fields.List(fields.Str()),
        "CompressionEnabled": fields.Bool(
            required=False, dump_to="CompressionEnabled"
        ),
        "HTTP2Enabled": fields.Bool(required=False, dump_to="HTTP2Enabled"),
        "HealthCheckConfig": UpdateListenerAttributeParamHealthCheckConfigSchema(
            required=False, dump_to="HealthCheckConfig"
        ),
        "IdleTimeout": fields.Int(required=False, dump_to="IdleTimeout"),
        "ListenerId": fields.Str(required=True, dump_to="ListenerId"),
        "LoadBalancerId": fields.Str(required=True, dump_to="LoadBalancerId"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "RedirectEnabled": fields.Bool(
            required=False, dump_to="RedirectEnabled"
        ),
        "RedirectPort": fields.Int(required=False, dump_to="RedirectPort"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "Scheduler": fields.Str(required=False, dump_to="Scheduler"),
        "SecurityPolicyId": fields.Str(
            required=False, dump_to="SecurityPolicyId"
        ),
        "StickinessConfig": UpdateListenerAttributeParamStickinessConfigSchema(
            required=False, dump_to="StickinessConfig"
        ),
    }


class UpdateListenerAttributeResponseSchema(schema.ResponseSchema):
    """UpdateListenerAttribute - 更新一个应用型负载均衡监听器的属性"""

    fields = {}


"""
API: UpdateLoadBalancerAttribute

更新一个应用型负载均衡实例的属性
"""


class UpdateLoadBalancerAttributeParamAccessLogConfigSchema(
    schema.RequestSchema
):
    """UpdateLoadBalancerAttributeParamAccessLogConfig -"""

    fields = {
        "Enabled": fields.Bool(required=False, dump_to="Enabled"),
        "US3BucketName": fields.Str(required=False, dump_to="US3BucketName"),
        "US3TokenId": fields.Str(required=False, dump_to="US3TokenId"),
    }


class UpdateLoadBalancerAttributeRequestSchema(schema.RequestSchema):
    """UpdateLoadBalancerAttribute - 更新一个应用型负载均衡实例的属性"""

    fields = {
        "AccessLogConfig": UpdateLoadBalancerAttributeParamAccessLogConfigSchema(
            required=False, dump_to="AccessLogConfig"
        ),
        "LoadBalancerId": fields.Str(required=True, dump_to="LoadBalancerId"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
    }


class UpdateLoadBalancerAttributeResponseSchema(schema.ResponseSchema):
    """UpdateLoadBalancerAttribute - 更新一个应用型负载均衡实例的属性"""

    fields = {}


"""
API: UpdatePolicy

更新传统型负载均衡内容转发规则，包括转发规则后的服务节点
"""


class UpdatePolicyRequestSchema(schema.RequestSchema):
    """UpdatePolicy - 更新传统型负载均衡内容转发规则，包括转发规则后的服务节点"""

    fields = {
        "BackendId": fields.List(fields.Str()),
        "DomainMatchMode": fields.Str(
            required=False, dump_to="DomainMatchMode"
        ),
        "Match": fields.Str(required=True, dump_to="Match"),
        "PolicyId": fields.Str(required=False, dump_to="PolicyId"),
        "PolicyPriority": fields.Int(required=False, dump_to="PolicyPriority"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Type": fields.Str(required=False, dump_to="Type"),
        "ULBId": fields.Str(required=True, dump_to="ULBId"),
        "VServerId": fields.Str(required=True, dump_to="VServerId"),
    }


class UpdatePolicyResponseSchema(schema.ResponseSchema):
    """UpdatePolicy - 更新传统型负载均衡内容转发规则，包括转发规则后的服务节点"""

    fields = {
        "PolicyId": fields.Str(
            required=False, load_from="PolicyId"
        ),  # Deprecated, will be removed at 1.0
    }


"""
API: UpdateRuleAttribute

更新应用型负载均衡监听器的一条转发规则的属性
"""


class UpdateRuleAttributeParamRuleActionsForwardConfigTargetsSchema(
    schema.RequestSchema
):
    """UpdateRuleAttributeParamRuleActionsForwardConfigTargets -"""

    fields = {
        "Id": fields.Str(required=False, dump_to="Id"),
        "Weight": fields.Int(required=False, dump_to="Weight"),
    }


class UpdateRuleAttributeParamRuleActionsForwardConfigSchema(
    schema.RequestSchema
):
    """UpdateRuleAttributeParamRuleActionsForwardConfig -"""

    fields = {
        "Targets": fields.List(
            UpdateRuleAttributeParamRuleActionsForwardConfigTargetsSchema()
        ),
    }


class UpdateRuleAttributeParamRuleConditionsPathConfigSchema(
    schema.RequestSchema
):
    """UpdateRuleAttributeParamRuleConditionsPathConfig -"""

    fields = {
        "Values": fields.List(fields.Str()),
    }


class UpdateRuleAttributeParamRuleConditionsHostConfigSchema(
    schema.RequestSchema
):
    """UpdateRuleAttributeParamRuleConditionsHostConfig -"""

    fields = {
        "MatchMode": fields.Str(required=False, dump_to="MatchMode"),
        "Values": fields.List(fields.Str()),
    }


class UpdateRuleAttributeParamRuleActionsSchema(schema.RequestSchema):
    """UpdateRuleAttributeParamRuleActions -"""

    fields = {
        "ForwardConfig": UpdateRuleAttributeParamRuleActionsForwardConfigSchema(
            required=False, dump_to="ForwardConfig"
        ),
        "Type": fields.Str(required=False, dump_to="Type"),
    }


class UpdateRuleAttributeParamRuleConditionsSchema(schema.RequestSchema):
    """UpdateRuleAttributeParamRuleConditions -"""

    fields = {
        "HostConfig": UpdateRuleAttributeParamRuleConditionsHostConfigSchema(
            required=False, dump_to="HostConfig"
        ),
        "PathConfig": UpdateRuleAttributeParamRuleConditionsPathConfigSchema(
            required=False, dump_to="PathConfig"
        ),
        "Type": fields.Str(required=False, dump_to="Type"),
    }


class UpdateRuleAttributeRequestSchema(schema.RequestSchema):
    """UpdateRuleAttribute - 更新应用型负载均衡监听器的一条转发规则的属性"""

    fields = {
        "ListenerId": fields.Str(required=True, dump_to="ListenerId"),
        "LoadBalancerId": fields.Str(required=True, dump_to="LoadBalancerId"),
        "Pass": fields.Bool(required=False, dump_to="Pass"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RuleActions": fields.List(UpdateRuleAttributeParamRuleActionsSchema()),
        "RuleConditions": fields.List(
            UpdateRuleAttributeParamRuleConditionsSchema()
        ),
        "RuleId": fields.Str(required=True, dump_to="RuleId"),
    }


class UpdateRuleAttributeResponseSchema(schema.ResponseSchema):
    """UpdateRuleAttribute - 更新应用型负载均衡监听器的一条转发规则的属性"""

    fields = {}


"""
API: UpdateSSLAttribute

更新修改SSL的属性，如：修改SSLName
"""


class UpdateSSLAttributeRequestSchema(schema.RequestSchema):
    """UpdateSSLAttribute - 更新修改SSL的属性，如：修改SSLName"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSLId": fields.Str(required=True, dump_to="SSLId"),
        "SSLName": fields.Str(required=True, dump_to="SSLName"),
    }


class UpdateSSLAttributeResponseSchema(schema.ResponseSchema):
    """UpdateSSLAttribute - 更新修改SSL的属性，如：修改SSLName"""

    fields = {}


"""
API: UpdateSSLBinding

将传统型或应用型负载均衡监听器绑定的证书更换为另一个证书，
"""


class UpdateSSLBindingRequestSchema(schema.RequestSchema):
    """UpdateSSLBinding - 将传统型或应用型负载均衡监听器绑定的证书更换为另一个证书，"""

    fields = {
        "ListenerId": fields.Str(required=False, dump_to="ListenerId"),
        "LoadBalancerId": fields.Str(required=False, dump_to="LoadBalancerId"),
        "NewSSLId": fields.Str(required=True, dump_to="NewSSLId"),
        "OldSSLId": fields.Str(required=True, dump_to="OldSSLId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class UpdateSSLBindingResponseSchema(schema.ResponseSchema):
    """UpdateSSLBinding - 将传统型或应用型负载均衡监听器绑定的证书更换为另一个证书，"""

    fields = {}


"""
API: UpdateSecurityPolicy

更新安全策略
"""


class UpdateSecurityPolicyRequestSchema(schema.RequestSchema):
    """UpdateSecurityPolicy - 更新安全策略"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSLCiphers": fields.List(fields.Str()),
        "SecurityPolicyId": fields.Str(
            required=True, dump_to="SecurityPolicyId"
        ),
        "SecurityPolicyName": fields.Str(
            required=False, dump_to="SecurityPolicyName"
        ),
        "TLSVersion": fields.Str(required=False, dump_to="TLSVersion"),
    }


class UpdateSecurityPolicyResponseSchema(schema.ResponseSchema):
    """UpdateSecurityPolicy - 更新安全策略"""

    fields = {}


"""
API: UpdateTargetsAttribute

更新应用型负载均衡监听器后端服务节点的属性
"""


class UpdateTargetsAttributeParamTargetsSchema(schema.RequestSchema):
    """UpdateTargetsAttributeParamTargets -"""

    fields = {
        "Enabled": fields.Bool(required=False, dump_to="Enabled"),
        "Id": fields.Str(required=False, dump_to="Id"),
        "IsBackup": fields.Bool(required=False, dump_to="IsBackup"),
        "Weight": fields.Int(required=False, dump_to="Weight"),
    }


class UpdateTargetsAttributeRequestSchema(schema.RequestSchema):
    """UpdateTargetsAttribute - 更新应用型负载均衡监听器后端服务节点的属性"""

    fields = {
        "ListenerId": fields.Str(required=True, dump_to="ListenerId"),
        "LoadBalancerId": fields.Str(required=True, dump_to="LoadBalancerId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Targets": fields.List(UpdateTargetsAttributeParamTargetsSchema()),
    }


class UpdateTargetsAttributeResponseSchema(schema.ResponseSchema):
    """UpdateTargetsAttribute - 更新应用型负载均衡监听器后端服务节点的属性"""

    fields = {}


"""
API: UpdateULBAttribute

更新CLB名字业务组备注等属性字段
"""


class UpdateULBAttributeRequestSchema(schema.RequestSchema):
    """UpdateULBAttribute - 更新CLB名字业务组备注等属性字段"""

    fields = {
        "BucketName": fields.Str(required=False, dump_to="BucketName"),
        "EnableLog": fields.Int(required=False, dump_to="EnableLog"),
        "IsWAFOn": fields.Str(required=False, dump_to="IsWAFOn"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "TokenId": fields.Str(required=False, dump_to="TokenId"),
        "TokenName": fields.Str(required=False, dump_to="TokenName"),
        "ULBId": fields.Str(required=True, dump_to="ULBId"),
    }


class UpdateULBAttributeResponseSchema(schema.ResponseSchema):
    """UpdateULBAttribute - 更新CLB名字业务组备注等属性字段"""

    fields = {}


"""
API: UpdateVServerAttribute

更新传统型负载均衡VServer实例属性
"""


class UpdateVServerAttributeRequestSchema(schema.RequestSchema):
    """UpdateVServerAttribute - 更新传统型负载均衡VServer实例属性"""

    fields = {
        "ClientTimeout": fields.Int(required=False, dump_to="ClientTimeout"),
        "Domain": fields.Str(required=False, dump_to="Domain"),
        "EnableCompression": fields.Int(
            required=False, dump_to="EnableCompression"
        ),
        "EnableHTTP2": fields.Int(required=False, dump_to="EnableHTTP2"),
        "ForwardPort": fields.Int(required=False, dump_to="ForwardPort"),
        "Method": fields.Str(required=False, dump_to="Method"),
        "MonitorType": fields.Str(required=False, dump_to="MonitorType"),
        "Path": fields.Str(required=False, dump_to="Path"),
        "PersistenceInfo": fields.Str(
            required=False, dump_to="PersistenceInfo"
        ),
        "PersistenceType": fields.Str(
            required=False, dump_to="PersistenceType"
        ),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Protocol": fields.Str(
            required=False, dump_to="Protocol"
        ),  # Deprecated, will be removed at 1.0
        "Region": fields.Str(required=True, dump_to="Region"),
        "RequestMsg": fields.Str(required=False, dump_to="RequestMsg"),
        "ResponseMsg": fields.Str(required=False, dump_to="ResponseMsg"),
        "SecurityPolicyId": fields.Str(
            required=False, dump_to="SecurityPolicyId"
        ),
        "ULBId": fields.Str(required=True, dump_to="ULBId"),
        "VServerId": fields.Str(required=True, dump_to="VServerId"),
        "VServerName": fields.Str(required=False, dump_to="VServerName"),
    }


class UpdateVServerAttributeResponseSchema(schema.ResponseSchema):
    """UpdateVServerAttribute - 更新传统型负载均衡VServer实例属性"""

    fields = {}
