import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RowAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the row access policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy#comment RowAccessPolicy#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the row access policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy#database RowAccessPolicy#database}
    */
    readonly database: string;
    /**
    * Specifies the identifier for the row access policy; must be unique for the database and schema in which the row access policy is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy#name RowAccessPolicy#name}
    */
    readonly name: string;
    /**
    * Specifies the SQL expression. The expression can be any boolean-valued SQL expression.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy#row_access_expression RowAccessPolicy#row_access_expression}
    */
    readonly rowAccessExpression: string;
    /**
    * The schema in which to create the row access policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy#schema RowAccessPolicy#schema}
    */
    readonly schema: string;
    /**
    * Specifies signature (arguments) for the row access policy (uppercase and sorted to avoid recreation of resource). A signature specifies a set of attributes that must be considered to determine whether the row is accessible. The attribute values come from the database object (e.g. table or view) to be protected by the row access policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy#signature RowAccessPolicy#signature}
    */
    readonly signature: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy snowflake_row_access_policy}
*/
export declare class RowAccessPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_row_access_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy snowflake_row_access_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RowAccessPolicyConfig
    */
    constructor(scope: Construct, id: string, config: RowAccessPolicyConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rowAccessExpression?;
    get rowAccessExpression(): string;
    set rowAccessExpression(value: string);
    get rowAccessExpressionInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _signature?;
    get signature(): {
        [key: string]: string;
    };
    set signature(value: {
        [key: string]: string;
    });
    get signatureInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
