
# This file is automatically generated.
# Do not edit directly.

from openeo.internal.processes.builder import ProcessBuilderBase, UNSET


class ProcessBuilder(ProcessBuilderBase):

    def __add__(self, other) -> 'ProcessBuilder':
        return self.add(other)

    def __sub__(self, other) -> 'ProcessBuilder':
        return self.subtract(other)

    def __mul__(self, other) -> 'ProcessBuilder':
        return self.multiply(other)

    def __truediv__(self, other) -> 'ProcessBuilder':
        return self.divide(other)

    def __neg__(self) -> 'ProcessBuilder':
        return self.multiply(-1)

    def __pow__(self, other) -> 'ProcessBuilder':
        return self.power(other)

    def absolute(self) -> 'ProcessBuilder':
        """
        Absolute value

        :param self: A number.

        :return: The computed absolute value.
        """
        return absolute(x=self)

    def add(self, y) -> 'ProcessBuilder':
        """
        Addition of two numbers

        :param self: The first summand.
        :param y: The second summand.

        :return: The computed sum of the two numbers.
        """
        return add(x=self, y=y)

    def add_dimension(self, name, label, type=UNSET) -> 'ProcessBuilder':
        """
        Add a new dimension

        :param self: A data cube to add the dimension to.
        :param name: Name for the dimension.
        :param label: A dimension label.
        :param type: The type of dimension, defaults to `other`.

        :return: The data cube with a newly added dimension. The new dimension has exactly one dimension label.
            All other dimensions remain unchanged.
        """
        return add_dimension(data=self, name=name, label=label, type=type)

    def aggregate_spatial(self, geometries, reducer, target_dimension=UNSET, context=UNSET) -> 'ProcessBuilder':
        """
        Zonal statistics for geometries

        :param self: A raster data cube. The data cube implicitly gets restricted to the bounds of the
            geometries as if ``filter_spatial()`` would have been used with the same values for the corresponding
            parameters immediately before this process.
        :param geometries: Geometries as GeoJSON on which the aggregation will be based.
        :param reducer: A reducer to be applied on all values of each geometry. A reducer is a single process
            such as ``mean()`` or a set of processes, which computes a single value for a list of values, see the
            category 'reducer' for such processes.
        :param target_dimension: The new dimension name to be used for storing the results. Defaults to
            `result`.
        :param context: Additional data to be passed to the reducer.

        :return: A vector data cube with the computed results and restricted to the bounds of the geometries.
            The computed value is stored in dimension with the name that was specified in the parameter
            `target_dimension`.  The computation also stores information about the total count of pixels (valid +
            invalid pixels) and the number of valid pixels (see ``is_valid()``) for each geometry. These values are
            stored as new dimension with a dimension name derived from `target_dimension` by adding the suffix
            `_meta`. The new dimension has the dimension labels `total_count` and `valid_count`.
        """
        return aggregate_spatial(data=self, geometries=geometries, reducer=reducer, target_dimension=target_dimension, context=context)

    def aggregate_spatial_binary(self, geometries, reducer, target_dimension=UNSET, context=UNSET) -> 'ProcessBuilder':
        """
        Zonal statistics for geometries by binary aggregation

        :param self: A raster data cube. The data cube implicitly gets restricted to the bounds of the
            geometries as if ``filter_spatial()`` would have been used with the same values for the corresponding
            parameters immediately before this process.
        :param geometries: Geometries as GeoJSON on which the aggregation will be based.
        :param reducer: A reduction operator to be applied consecutively on tuples of values. It must be both
            associative and commutative as the execution may be executed in parallel and therefore the order of
            execution is arbitrary. The reduction operator may be a single process such as ``multiply()`` or
            consist of multiple sub-processes.
        :param target_dimension: The new dimension name to be used for storing the results. Defaults to
            `result`.
        :param context: Additional data to be passed to the reducer.

        :return: A vector data cube with the computed results and restricted to the bounds of the geometries.
            The computed value is stored in dimension with the name that was specified in the parameter
            `target_dimension`.  The computation also stores information about the total count of pixels (valid +
            invalid pixels) and the number of valid pixels (see ``is_valid()``) for each geometry. These values are
            stored as new dimension with a dimension name derived from `target_dimension` by adding the suffix
            `_meta`. The new dimension has the dimension labels `total_count` and `valid_count`.
        """
        return aggregate_spatial_binary(data=self, geometries=geometries, reducer=reducer, target_dimension=target_dimension, context=context)

    def aggregate_temporal(self, intervals, reducer, labels=UNSET, dimension=UNSET, context=UNSET) -> 'ProcessBuilder':
        """
        Temporal aggregations

        :param self: A data cube.
        :param intervals: Left-closed temporal intervals, which are allowed to overlap. Each temporal interval
            in the array has exactly two elements:  1. The first element is the start of the temporal interval. The
            specified instance in time is **included** in the interval. 2. The second element is the end of the
            temporal interval. The specified instance in time is **excluded** from the interval.  The specified
            temporal strings follow [RFC 3339](https://tools.ietf.org/html/rfc3339). Although [RFC 3339 prohibits
            the hour to be '24'](https://tools.ietf.org/html/rfc3339#section-5.7), **this process allows the value
            '24' for the hour** of an end time in order to make it possible that left-closed time intervals can
            fully cover the day.
        :param reducer: A reducer to be applied on all values along the specified dimension. A reducer is a
            single process such as ``mean()`` or a set of processes, which computes a single value for a list of
            values, see the category 'reducer' for such processes.
        :param labels: Distinct labels for the intervals, which can contain dates and/or times. Is only
            required to be specified if the values for the start of the temporal intervals are not distinct and
            thus the default labels would not be unique. The number of labels and the number of groups need to be
            equal.
        :param dimension: The name of the temporal dimension for aggregation. All data along the dimension is
            passed through the specified reducer. If the dimension is not set or set to `null`, the data cube is
            expected to only have one temporal dimension. Fails with a `TooManyDimensions` error if it has more
            dimensions. Fails with a `DimensionNotAvailable` error if the specified dimension does not exist.
        :param context: Additional data to be passed to the reducer.

        :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
            system and resolution) remain unchanged, except for the resolution and dimension labels of the given
            temporal dimension.
        """
        return aggregate_temporal(data=self, intervals=intervals, reducer=reducer, labels=labels, dimension=dimension, context=context)

    def aggregate_temporal_period(self, period, reducer, dimension=UNSET, context=UNSET) -> 'ProcessBuilder':
        """
        Temporal aggregations based on calendar hierarchies

        :param self: A data cube.
        :param period: The time intervals to aggregate. The following pre-defined values are available:  *
            `hour`: Hour of the day * `day`: Day of the year * `week`: Week of the year * `dekad`: Ten day periods,
            counted per year with three periods per month (day 1 - 10, 11 - 20 and 21 - end of month). The third
            dekad of the month can range from 8 to 11 days. For example, the fourth dekad is Feb, 1 - Feb, 10 each
            year. * `month`: Month of the year * `season`: Three month periods of the calendar seasons (December -
            February, March - May, June - August, September - November). * `tropical-season`: Six month periods of
            the tropical seasons (November - April, May - October). * `year`: Proleptic years * `decade`: Ten year
            periods ([0-to-9 decade](https://en.wikipedia.org/wiki/Decade#0-to-9_decade)), from a year ending in a
            0 to the next year ending in a 9. * `decade-ad`: Ten year periods ([1-to-0
            decade](https://en.wikipedia.org/wiki/Decade#1-to-0_decade)) better aligned with the Anno Domini (AD)
            calendar era, from a year ending in a 1 to the next year ending in a 0.
        :param reducer: A reducer to be applied on all values along the specified dimension. A reducer is a
            single process such as ``mean()`` or a set of processes, which computes a single value for a list of
            values, see the category 'reducer' for such processes.
        :param dimension: The name of the temporal dimension for aggregation. All data along the dimension is
            passed through the specified reducer. If the dimension is not set or set to `null`, the data cube is
            expected to only have one temporal dimension. Fails with a `TooManyDimensions` error if it has more
            dimensions. Fails with a `DimensionNotAvailable` error if the specified dimension does not exist.
        :param context: Additional data to be passed to the reducer.

        :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
            system and resolution) remain unchanged, except for the resolution and dimension labels of the given
            temporal dimension. The specified temporal dimension has the following dimension labels (`YYYY` = four-
            digit year, `MM` = two-digit month, `DD` two-digit day of month):  * `hour`: `YYYY-MM-DD-00` - `YYYY-
            MM-DD-23` * `day`: `YYYY-001` - `YYYY-365` * `week`: `YYYY-01` - `YYYY-52` * `dekad`: `YYYY-00` -
            `YYYY-36` * `month`: `YYYY-01` - `YYYY-12` * `season`: `YYYY-djf` (December - February), `YYYY-mam`
            (March - May), `YYYY-jja` (June - August), `YYYY-son` (September - November). * `tropical-season`:
            `YYYY-ndjfma` (November - April), `YYYY-mjjaso` (May - October). * `year`: `YYYY` * `decade`: `YYY0` *
            `decade-ad`: `YYY1`
        """
        return aggregate_temporal_period(data=self, period=period, reducer=reducer, dimension=dimension, context=context)

    def all(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Are all of the values true?

        :param self: A set of boolean values.
        :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.

        :return: Boolean result of the logical operation.
        """
        return all(data=self, ignore_nodata=ignore_nodata)

    def and_(self, y) -> 'ProcessBuilder':
        """
        Logical AND

        :param self: A boolean value.
        :param y: A boolean value.

        :return: Boolean result of the logical AND.
        """
        return and_(x=self, y=y)

    def anomaly(self, normals, period) -> 'ProcessBuilder':
        """
        Computes anomalies

        :param self: A data cube with exactly one temporal dimension and the following dimension labels for the
            given period (`YYYY` = four-digit year, `MM` = two-digit month, `DD` two-digit day of month):  *
            `hour`: `YYYY-MM-DD-00` - `YYYY-MM-DD-23` * `day`: `YYYY-001` - `YYYY-365` * `week`: `YYYY-01` -
            `YYYY-52` * `dekad`: `YYYY-00` - `YYYY-36` * `month`: `YYYY-01` - `YYYY-12` * `season`: `YYYY-djf`
            (December - February), `YYYY-mam` (March - May), `YYYY-jja` (June - August), `YYYY-son` (September -
            November). * `tropical-season`: `YYYY-ndjfma` (November - April), `YYYY-mjjaso` (May - October). *
            `year`: `YYYY` * `decade`: `YYY0` * `decade-ad`: `YYY1` * `single-period` / `climatology-period`: Any
            ``aggregate_temporal_period()`` can compute such a data cube.
        :param normals: A data cube with normals, e.g. daily, monthly or yearly values computed from a process
            such as ``climatological_normal()``. Must contain exactly one temporal dimension with the following
            dimension labels for the given period:  * `hour`: `00` - `23` * `day`: `001` - `365` * `week`: `01` -
            `52` * `dekad`: `00` - `36` * `month`: `01` - `12` * `season`: `djf` (December - February), `mam`
            (March - May), `jja` (June - August), `son` (September - November) * `tropical-season`: `ndjfma`
            (November - April), `mjjaso` (May - October) * `year`: Four-digit year numbers * `decade`: Four-digit
            year numbers, the last digit being a `0` * `decade-ad`: Four-digit year numbers, the last digit being a
            `1` * `single-period` / `climatology-period`: A single dimension label with any name is expected.
        :param period: Specifies the time intervals available in the normals data cube. The following options
            are available:  * `hour`: Hour of the day * `day`: Day of the year * `week`: Week of the year *
            `dekad`: Ten day periods, counted per year with three periods per month (day 1 - 10, 11 - 20 and 21 -
            end of month). The third dekad of the month can range from 8 to 11 days. For example, the fourth dekad
            is Feb, 1 - Feb, 10 each year. * `month`: Month of the year * `season`: Three month periods of the
            calendar seasons (December - February, March - May, June - August, September - November). * `tropical-
            season`: Six month periods of the tropical seasons (November - April, May - October). * `year`:
            Proleptic years * `decade`: Ten year periods ([0-to-9
            decade](https://en.wikipedia.org/wiki/Decade#0-to-9_decade)), from a year ending in a 0 to the next
            year ending in a 9. * `decade-ad`: Ten year periods ([1-to-0
            decade](https://en.wikipedia.org/wiki/Decade#1-to-0_decade)) better aligned with the Anno Domini (AD)
            calendar era, from a year ending in a 1 to the next year ending in a 0. * `single-period` /
            `climatology-period`: A single period of arbitrary length

        :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
            system and resolution) remain unchanged.
        """
        return anomaly(data=self, normals=normals, period=period)

    def any(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Is at least one value true?

        :param self: A set of boolean values.
        :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.

        :return: Boolean result of the logical operation.
        """
        return any(data=self, ignore_nodata=ignore_nodata)

    def apply(self, process, context=UNSET) -> 'ProcessBuilder':
        """
        Apply a process to each pixel

        :param self: A data cube.
        :param process: A unary process to be applied on each value, may consist of multiple sub-processes.
        :param context: Additional data to be passed to the process.

        :return: A data cube with the newly computed values and the same dimensions. The dimension properties
            (name, type, labels, reference system and resolution) remain unchanged.
        """
        return apply(data=self, process=process, context=context)

    def apply_dimension(self, process, dimension, target_dimension=UNSET, context=UNSET) -> 'ProcessBuilder':
        """
        Apply a process to pixels along a dimension

        :param self: A data cube.
        :param process: Process to be applied on all pixel values. The specified process needs to accept an
            array as parameter and must return an array with least one element. A process may consist of multiple
            sub-processes.
        :param dimension: The name of the source dimension to apply the process on. Fails with a
            `DimensionNotAvailable` error if the specified dimension does not exist.
        :param target_dimension: The name of the target dimension or `null` (the default) to use the source
            dimension specified in the parameter `dimension`.  By specifying a target dimension, the source
            dimension is removed. The target dimension with the specified name and the type `other` (see
            ``add_dimension()``) is created, if if doesn't exist yet.
        :param context: Additional data to be passed to the process.

        :return: A data cube with the newly computed values. All dimensions stay the same, except for the
            dimensions specified in corresponding parameters. There are three cases how the data cube changes:  1.
            The source dimension **is** the target dimension:    * The (number of) dimensions remain unchanged.
            * The source dimension properties name, type and reference system remain unchanged.    * The dimension
            labels and the resolution are preserved when the number of pixel values in the source dimension is
            equal to the number of values computed by the process. The other case is described below. 2. The source
            dimension **is not** the target dimension and the latter **exists**:    * The number of dimensions
            decreases by one as the source dimension is dropped.    * The target dimension properties name, type
            and reference system remain unchanged.    * The resolution changes, the number of dimension labels is
            equal to the number of values computed by the process and the dimension labels are incrementing
            integers starting from zero 3. The source dimension **is not** the target dimension and the latter
            **does not exist**:    * The number of dimensions remain unchanged, but the source dimension is
            replaced with the target dimension.    * The target dimension has the specified name and the type
            other. The reference system is not changed.    * The resolution changes, the number of dimension labels
            is equal to the number of values computed by the process and the dimension labels are incrementing
            integers starting from zero  For all three cases except for the exception in the first case, the
            resolution changes, the number of dimension labels is equal to the number of values computed by the
            process and the dimension labels are incrementing integers starting from zero.
        """
        return apply_dimension(data=self, process=process, dimension=dimension, target_dimension=target_dimension, context=context)

    def apply_kernel(self, kernel, factor=UNSET, border=UNSET, replace_invalid=UNSET) -> 'ProcessBuilder':
        """
        Apply a spatial convolution with a kernel

        :param self: A data cube.
        :param kernel: Kernel as a two-dimensional array of weights. The inner level of the nested array aligns
            with the `x` axis and the outer level aligns with the `y` axis. Each level of the kernel must have an
            uneven number of elements, otherwise the process throws a `KernelDimensionsUneven` error.
        :param factor: A factor that is multiplied to each value after the kernel has been applied.  This is
            basically a shortcut for explicitly multiplying each value by a factor afterwards, which is often
            required for some kernel-based algorithms such as the Gaussian blur.
        :param border: Determines how the data is extended when the kernel overlaps with the borders. Defaults
            to fill the border with zeroes.  The following options are available:  * *numeric value* - fill with a
            user-defined constant number `n`: `nnnnnn|abcdefgh|nnnnnn` (default, with `n` = 0) * `replicate` -
            repeat the value from the pixel at the border: `aaaaaa|abcdefgh|hhhhhh` * `reflect` - mirror/reflect
            from the border: `fedcba|abcdefgh|hgfedc` * `reflect_pixel` - mirror/reflect from the center of the
            pixel at the border: `gfedcb|abcdefgh|gfedcb` * `wrap` - repeat/wrap the image:
            `cdefgh|abcdefgh|abcdef`
        :param replace_invalid: This parameter specifies the value to replace non-numerical or infinite
            numerical values with. By default, those values are replaced with zeroes.

        :return: A data cube with the newly computed values and the same dimensions. The dimension properties
            (name, type, labels, reference system and resolution) remain unchanged.
        """
        return apply_kernel(data=self, kernel=kernel, factor=factor, border=border, replace_invalid=replace_invalid)

    def apply_neighborhood(self, process, size, overlap=UNSET, context=UNSET) -> 'ProcessBuilder':
        """
        Apply a process to pixels in a n-dimensional neighbourhood

        :param self: A data cube.
        :param process: Process to be applied on all neighbourhoods.
        :param size: Neighbourhood sizes along each dimension.  This object maps dimension names to either a
            physical measure (e.g. 100 m, 10 days) or pixels (e.g. 32 pixels). For dimensions not specified, the
            default is to provide all values. Be aware that including all values from overly large dimensions may
            not be processed at once.
        :param overlap: Overlap of neighbourhoods along each dimension to avoid border effects.  For instance a
            temporal dimension can add 1 month before and after a neighbourhood. In the spatial dimensions, this is
            often a number of pixels. The overlap specified is added before and after, so an overlap of 8 pixels
            will add 8 pixels on both sides of the window, so 16 in total.  Be aware that large overlaps increase
            the need for computational resources and modifying overlapping data in subsequent operations have no
            effect.
        :param context: Additional data to be passed to the process.

        :return: A data cube with the newly computed values and the same dimensions. The dimension properties
            (name, type, labels, reference system and resolution) remain unchanged.
        """
        return apply_neighborhood(data=self, process=process, size=size, overlap=overlap, context=context)

    def arccos(self) -> 'ProcessBuilder':
        """
        Inverse cosine

        :param self: A number.

        :return: The computed angle in radians.
        """
        return arccos(x=self)

    def arcosh(self) -> 'ProcessBuilder':
        """
        Inverse hyperbolic cosine

        :param self: A number.

        :return: The computed angle in radians.
        """
        return arcosh(x=self)

    def arcsin(self) -> 'ProcessBuilder':
        """
        Inverse sine

        :param self: A number.

        :return: The computed angle in radians.
        """
        return arcsin(x=self)

    def arctan(self) -> 'ProcessBuilder':
        """
        Inverse tangent

        :param self: A number.

        :return: The computed angle in radians.
        """
        return arctan(x=self)

    def arctan2(self, x) -> 'ProcessBuilder':
        """
        Inverse tangent of two numbers

        :param self: A number to be used as dividend.
        :param x: A number to be used as divisor.

        :return: The computed angle in radians.
        """
        return arctan2(y=self, x=x)

    def array_apply(self, process, context=UNSET) -> 'ProcessBuilder':
        """
        Applies a unary process to each array element

        :param self: An array.
        :param process: A process to be applied on each value, may consist of multiple sub-processes. The
            specified process must be unary meaning that it must work on a single value.
        :param context: Additional data to be passed to the process.

        :return: An array with the newly computed values. The number of elements are the same as for the
            original array.
        """
        return array_apply(data=self, process=process, context=context)

    def array_contains(self, value) -> 'ProcessBuilder':
        """
        Check whether the array contains a given value

        :param self: List to find the value in.
        :param value: Value to find in `data`.

        :return: Returns `true` if the list contains the value, false` otherwise.
        """
        return array_contains(data=self, value=value)

    def array_element(self, index=UNSET, label=UNSET, return_nodata=UNSET) -> 'ProcessBuilder':
        """
        Get an element from an array

        :param self: An array.
        :param index: The zero-based index of the element to retrieve.
        :param label: The label of the element to retrieve.
        :param return_nodata: By default this process throws an `ArrayElementNotAvailable` exception if the
            index or label is invalid. If you want to return `null` instead, set this flag to `true`.

        :return: The value of the requested element.
        """
        return array_element(data=self, index=index, label=label, return_nodata=return_nodata)

    def array_filter(self, condition, context=UNSET) -> 'ProcessBuilder':
        """
        Filter an array based on a condition

        :param self: An array.
        :param condition: A condition that is evaluated against each value in the array. Only the array
            elements where the condition returns `true` are preserved.
        :param context: Additional data to be passed to the condition.

        :return: An array filtered by the specified condition. The number of elements are less than or equal
            compared to the original array.
        """
        return array_filter(data=self, condition=condition, context=context)

    def array_find(self, value) -> 'ProcessBuilder':
        """
        Get the index for a value in an array

        :param self: List to find the value in.
        :param value: Value to find in `data`.

        :return: Returns the index of the first element with the specified value. If no element was found,
            `null` is returned.
        """
        return array_find(data=self, value=value)

    def array_labels(self) -> 'ProcessBuilder':
        """
        Get the labels for an array

        :param self: An array with labels.

        :return: The labels as array.
        """
        return array_labels(data=self)

    def arsinh(self) -> 'ProcessBuilder':
        """
        Inverse hyperbolic sine

        :param self: A number.

        :return: The computed angle in radians.
        """
        return arsinh(x=self)

    def artanh(self) -> 'ProcessBuilder':
        """
        Inverse hyperbolic tangent

        :param self: A number.

        :return: The computed angle in radians.
        """
        return artanh(x=self)

    def between(self, min, max, exclude_max=UNSET) -> 'ProcessBuilder':
        """
        Between comparison

        :param self: The value to check.
        :param min: Lower boundary (inclusive) to check against.
        :param max: Upper boundary (inclusive) to check against.
        :param exclude_max: Exclude the upper boundary `max` if set to `true`. Defaults to `false`.

        :return: `true` if `x` is between the specified bounds, otherwise `false`.
        """
        return between(x=self, min=min, max=max, exclude_max=exclude_max)

    def ceil(self) -> 'ProcessBuilder':
        """
        Round fractions up

        :param self: A number to round up.

        :return: The number rounded up.
        """
        return ceil(x=self)

    def climatological_normal(self, period, climatology_period=UNSET) -> 'ProcessBuilder':
        """
        Computes climatology normals

        :param self: A data cube with exactly one temporal dimension. The data cube must span at least the
            temporal interval specified in the parameter `climatology-period`.  Seasonal periods may span two
            consecutive years, e.g. temporal winter that includes months December, January and February. If the
            required months before the actual climate period are available, the season is taken into account. If
            not available, the first season is not taken into account and the seasonal mean is based on one year
            less than the other seasonal normals. The incomplete season at the end of the last year is never taken
            into account.
        :param period: The time intervals to aggregate the average value for. The following pre-defined
            frequencies are supported:  * `day`: Day of the year * `month`: Month of the year * `climatology-
            period`: The period specified in the `climatology-period`. * `season`: Three month periods of the
            calendar seasons (December - February, March - May, June - August, September - November). * `tropical-
            season`: Six month periods of the tropical seasons (November - April, May - October).
        :param climatology_period: The climatology period as closed temporal interval. The first element of the
            array is the first year to be fully included in the temporal interval. The second element is the last
            year to be fully included in the temporal interval. The default period is from 1981 until 2010 (both
            inclusive).

        :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
            system and resolution) remain unchanged, except for the resolution and dimension labels of the temporal
            dimension. The temporal dimension has the following dimension labels:  * `day`: `001` - `365` *
            `month`: `01` - `12` * `climatology-period`: `climatology-period` * `season`: `djf` (December -
            February), `mam` (March - May), `jja` (June - August), `son` (September - November) * `tropical-
            season`: `ndjfma` (November - April), `mjjaso` (May - October)
        """
        return climatological_normal(data=self, period=period, climatology_period=climatology_period)

    def clip(self, min, max) -> 'ProcessBuilder':
        """
        Clip a value between a minimum and a maximum

        :param self: A number.
        :param min: Minimum value. If the value is lower than this value, the process will return the value of
            this parameter.
        :param max: Maximum value. If the value is greater than this value, the process will return the value
            of this parameter.

        :return: The value clipped to the specified range.
        """
        return clip(x=self, min=min, max=max)

    def constant(self) -> 'ProcessBuilder':
        """
        Define a constant value

        :param self: The value of the constant.

        :return: The value of the constant.
        """
        return constant(x=self)

    def cos(self) -> 'ProcessBuilder':
        """
        Cosine

        :param self: An angle in radians.

        :return: The computed cosine of `x`.
        """
        return cos(x=self)

    def cosh(self) -> 'ProcessBuilder':
        """
        Hyperbolic cosine

        :param self: An angle in radians.

        :return: The computed hyperbolic cosine of `x`.
        """
        return cosh(x=self)

    def count(self, condition=UNSET, context=UNSET) -> 'ProcessBuilder':
        """
        Count the number of elements

        :param self: An array with elements of any data type.
        :param condition: A condition consists of one ore more processes, which in the end return a boolean
            value. It is evaluated against each element in the array. An element is counted only if the condition
            returns `true`. Defaults to count valid elements in a list (see ``is_valid()``). Setting this parameter
            to boolean `true` counts all elements in the list.
        :param context: Additional data to be passed to the condition.

        :return: The counted number of elements.
        """
        return count(data=self, condition=condition, context=context)

    def create_raster_cube(self) -> 'ProcessBuilder':
        """
        Create an empty raster data cube

        :return: An empty raster data cube with zero dimensions.
        """
        return create_raster_cube()

    def cummax(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Cumulative maxima

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is set for all the following
            elements.

        :return: An array with the computed cumulative maxima.
        """
        return cummax(data=self, ignore_nodata=ignore_nodata)

    def cummin(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Cumulative minima

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is set for all the following
            elements.

        :return: An array with the computed cumulative minima.
        """
        return cummin(data=self, ignore_nodata=ignore_nodata)

    def cumproduct(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Cumulative products

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is set for all the following
            elements.

        :return: An array with the computed cumulative products.
        """
        return cumproduct(data=self, ignore_nodata=ignore_nodata)

    def cumsum(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Cumulative sums

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is set for all the following
            elements.

        :return: An array with the computed cumulative sums.
        """
        return cumsum(data=self, ignore_nodata=ignore_nodata)

    def debug(self, code=UNSET, level=UNSET, message=UNSET) -> 'ProcessBuilder':
        """
        Publish debugging information

        :param self: Data to publish.
        :param code: An identifier to help identify the log entry in a bunch of other log entries.
        :param level: The severity level of this message, defaults to `info`. Note that the level `error`
            forces the computation to be stopped!
        :param message: A message to send in addition to the data.

        :return: Returns the data as passed to the `data` parameter.
        """
        return debug(data=self, code=code, level=level, message=message)

    def dimension_labels(self, dimension) -> 'ProcessBuilder':
        """
        Get the dimension labels

        :param self: The data cube.
        :param dimension: The name of the dimension to get the labels for.

        :return: The labels as array.
        """
        return dimension_labels(data=self, dimension=dimension)

    def divide(self, y) -> 'ProcessBuilder':
        """
        Division of two numbers

        :param self: The dividend.
        :param y: The divisor.

        :return: The computed result.
        """
        return divide(x=self, y=y)

    def drop_dimension(self, name) -> 'ProcessBuilder':
        """
        Remove a dimension

        :param self: The data cube to drop a dimension from.
        :param name: Name of the dimension to drop.

        :return: A data cube without the specified dimension. The number of dimensions decreases by one, but
            the dimension properties (name, type, labels, reference system and resolution) for all other dimensions
            remain unchanged.
        """
        return drop_dimension(data=self, name=name)

    def e(self) -> 'ProcessBuilder':
        """
        Euler's number (e)

        :return: The numerical value of Euler's number.
        """
        return e()

    def eq(self, y, delta=UNSET, case_sensitive=UNSET) -> 'ProcessBuilder':
        """
        Equal to comparison

        :param self: First operand.
        :param y: Second operand.
        :param delta: Only applicable for comparing two numbers. If this optional parameter is set to a
            positive non-zero number the equality of two numbers is checked against a delta value. This is
            especially useful to circumvent problems with floating point inaccuracy in machine-based computation.
            This option is basically an alias for the following computation: `lte(abs(minus([x, y]), delta)`
        :param case_sensitive: Only applicable for comparing two strings. Case sensitive comparison can be
            disabled by setting this parameter to `false`.

        :return: Returns `true` if `x` is equal to `y`, `null` if any operand is `null`, otherwise `false`.
        """
        return eq(x=self, y=y, delta=delta, case_sensitive=case_sensitive)

    def exp(self) -> 'ProcessBuilder':
        """
        Exponentiation to the base e

        :param self: The numerical exponent.

        :return: The computed value for *e* raised to the power of `p`.
        """
        return exp(p=self)

    def extrema(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Minimum and maximum values

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that an array with two `null` values is
            returned if any value is such a value.

        :return: An array containing the minimum and maximum values for the specified numbers. The first
            element is the minimum, the second element is the maximum. If the input array is empty both elements
            are set to `null`.
        """
        return extrema(data=self, ignore_nodata=ignore_nodata)

    def filter_bands(self, bands=UNSET, wavelengths=UNSET) -> 'ProcessBuilder':
        """
        Filter the bands by name

        :param self: A data cube with bands.
        :param bands: A list of band names. Either the unique band name (metadata field `name` in bands) or one
            of the common band names (metadata field `common_name` in bands). If unique band name and common name
            conflict, the unique band name has higher priority.  The order of the specified array defines the order
            of the bands in the data cube. If multiple bands match a common name, all matched bands are included in
            the original order.
        :param wavelengths: A list of sub-lists with each sub-list consisting of two elements. The first
            element is the minimum wavelength and the second element is the maximum wavelength. Wavelengths are
            specified in micrometres (μm).  The order of the specified array defines the order of the bands in the
            data cube. If multiple bands match the wavelengths, all matched bands are included in the original
            order.

        :return: A data cube limited to a subset of its original bands. The dimensions and dimension properties
            (name, type, labels, reference system and resolution) remain unchanged, except that the dimension of
            type `bands` has less (or the same) dimension labels.
        """
        return filter_bands(data=self, bands=bands, wavelengths=wavelengths)

    def filter_bbox(self, extent) -> 'ProcessBuilder':
        """
        Spatial filter using a bounding box

        :param self: A data cube.
        :param extent: A bounding box, which may include a vertical axis (see `base` and `height`).

        :return: A data cube restricted to the bounding box. The dimensions and dimension properties (name,
            type, labels, reference system and resolution) remain unchanged, except that the spatial dimensions
            have less (or the same) dimension labels.
        """
        return filter_bbox(data=self, extent=extent)

    def filter_labels(self, condition, dimension, context=UNSET) -> 'ProcessBuilder':
        """
        Filter dimension labels based on a condition

        :param self: A data cube.
        :param condition: A condition that is evaluated against each dimension label in the specified
            dimension. A dimension label and the corresponding data is preserved for the given dimension, if the
            condition returns `true`.
        :param dimension: The name of the dimension to filter on. Fails with a `DimensionNotAvailable` error if
            the specified dimension does not exist.
        :param context: Additional data to be passed to the condition.

        :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
            system and resolution) remain unchanged, except that the given dimension has less (or the same)
            dimension labels.
        """
        return filter_labels(data=self, condition=condition, dimension=dimension, context=context)

    def filter_spatial(self, geometries) -> 'ProcessBuilder':
        """
        Spatial filter using geometries

        :param self: A data cube.
        :param geometries: One or more geometries used for filtering, specified as GeoJSON.

        :return: A data cube restricted to the specified geometries. The dimensions and dimension properties
            (name, type, labels, reference system and resolution) remain unchanged, except that the spatial
            dimensions have less (or the same) dimension labels.
        """
        return filter_spatial(data=self, geometries=geometries)

    def filter_temporal(self, extent, dimension=UNSET) -> 'ProcessBuilder':
        """
        Temporal filter for a temporal intervals

        :param self: A data cube.
        :param extent: Left-closed temporal interval, i.e. an array with exactly two elements:  1. The first
            element is the start of the temporal interval. The specified instance in time is **included** in the
            interval. 2. The second element is the end of the temporal interval. The specified instance in time is
            **excluded** from the interval.  The specified temporal strings follow [RFC
            3339](https://tools.ietf.org/html/rfc3339). Also supports open intervals by setting one of the
            boundaries to `null`, but never both.
        :param dimension: The name of the temporal dimension to filter on. If the dimension is not set or is
            set to `null`, the filter applies to all temporal dimensions. Fails with a `DimensionNotAvailable`
            error if the specified dimension does not exist.

        :return: A data cube restricted to the specified temporal extent. The dimensions and dimension
            properties (name, type, labels, reference system and resolution) remain unchanged, except that the
            given temporal dimension(s) have less (or the same) dimension labels.
        """
        return filter_temporal(data=self, extent=extent, dimension=dimension)

    def first(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        First element

        :param self: An array with elements of any data type.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if the first value is
            such a value.

        :return: The first element of the input array.
        """
        return first(data=self, ignore_nodata=ignore_nodata)

    def floor(self) -> 'ProcessBuilder':
        """
        Round fractions down

        :param self: A number to round down.

        :return: The number rounded down.
        """
        return floor(x=self)

    def gt(self, y) -> 'ProcessBuilder':
        """
        Greater than comparison

        :param self: First operand.
        :param y: Second operand.

        :return: `true` if `x` is strictly greater than `y` or `null` if any operand is `null`, otherwise
            `false`.
        """
        return gt(x=self, y=y)

    def gte(self, y) -> 'ProcessBuilder':
        """
        Greater than or equal to comparison

        :param self: First operand.
        :param y: Second operand.

        :return: `true` if `x` is greater than or equal to `y`, `null` if any operand is `null`, otherwise
            `false`.
        """
        return gte(x=self, y=y)

    def if_(self, accept, reject=UNSET) -> 'ProcessBuilder':
        """
        If-Then-Else conditional

        :param self: A boolean value.
        :param accept: A value that is returned if the boolean value is `true`.
        :param reject: A value that is returned if the boolean value is **not** `true`. Defaults to `null`.

        :return: Either the `accept` or `reject` argument depending on the given boolean value.
        """
        return if_(value=self, accept=accept, reject=reject)

    def int(self) -> 'ProcessBuilder':
        """
        Integer part of a number

        :param self: A number.

        :return: Integer part of the number.
        """
        return int(x=self)

    def is_nan(self) -> 'ProcessBuilder':
        """
        Value is not a number

        :param self: The data to check.

        :return: `true` if the data is not a number, otherwise `false`
        """
        return is_nan(x=self)

    def is_nodata(self) -> 'ProcessBuilder':
        """
        Value is not a no-data value

        :param self: The data to check.

        :return: `true` if the data is a no-data value, otherwise `false`
        """
        return is_nodata(x=self)

    def is_valid(self) -> 'ProcessBuilder':
        """
        Value is valid data

        :param self: The data to check.

        :return: `true` if the data is valid, otherwise `false`.
        """
        return is_valid(x=self)

    def last(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Last element

        :param self: An array with elements of any data type.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if the last value is
            such a value.

        :return: The last element of the input array.
        """
        return last(data=self, ignore_nodata=ignore_nodata)

    def linear_scale_range(self, inputMin, inputMax, outputMin=UNSET, outputMax=UNSET) -> 'ProcessBuilder':
        """
        Linear transformation between two ranges

        :param self: A number to transform. The number gets clipped to the bounds specified in `inputMin` and
            `inputMax`.
        :param inputMin: Minimum value the input can obtain.
        :param inputMax: Maximum value the input can obtain.
        :param outputMin: Minimum value of the desired output range.
        :param outputMax: Maximum value of the desired output range.

        :return: The transformed number.
        """
        return linear_scale_range(x=self, inputMin=inputMin, inputMax=inputMax, outputMin=outputMin, outputMax=outputMax)

    def ln(self) -> 'ProcessBuilder':
        """
        Natural logarithm

        :param self: A number to compute the natural logarithm for.

        :return: The computed natural logarithm.
        """
        return ln(x=self)

    def load_collection(self, spatial_extent, temporal_extent, bands=UNSET, properties=UNSET) -> 'ProcessBuilder':
        """
        Load a collection

        :param self: The collection id.
        :param spatial_extent: Limits the data to load from the collection to the specified bounding box or
            polygons.  The process puts a pixel into the data cube if the point at the pixel center intersects with
            the bounding box or any of the polygons (as defined in the Simple Features standard by the OGC).  The
            GeoJSON can be one of the following GeoJSON types:  * A `Polygon` geometry, * a `GeometryCollection`
            containing Polygons, * a `Feature` with a `Polygon` geometry or * a `FeatureCollection` containing
            `Feature`s with a `Polygon` geometry.  Set this parameter to `null` to set no limit for the spatial
            extent. Be careful with this when loading large datasets!
        :param temporal_extent: Limits the data to load from the collection to the specified left-closed
            temporal interval. Applies to all temporal dimensions. The interval has to be specified as an array
            with exactly two elements:  1. The first element is the start of the temporal interval. The specified
            instance in time is **included** in the interval. 2. The second element is the end of the temporal
            interval. The specified instance in time is **excluded** from the interval.  The specified temporal
            strings follow [RFC 3339](https://tools.ietf.org/html/rfc3339). Also supports open intervals by setting
            one of the boundaries to `null`, but never both.  Set this parameter to `null` to set no limit for the
            spatial extent. Be careful with this when loading large datasets!
        :param bands: Only adds the specified bands into the data cube so that bands that don't match the list
            of band names are not available. Applies to all dimensions of type `bands`.  Either the unique band
            name (metadata field `name` in bands) or one of the common band names (metadata field `common_name` in
            bands) can be specified. If unique band name and common name conflict, the unique band name has higher
            priority.  The order of the specified array defines the order of the bands in the data cube. f multiple
            bands match a common name, all matched bands are included in the original order.
        :param properties: Limits the data by metadata properties to include only data in the data cube which
            all given conditions return `true` for (AND operation).  Specify key-value-pairs with the key being the
            name of the metadata property, which can be retrieved with the openEO Data Discovery for Collections.
            The value must a condition (user-defined process) to be evaluated against the collection metadata, see
            the example.

        :return: A data cube for further processing. The dimensions and dimension properties (name, type,
            labels, reference system and resolution) correspond to the collection's metadata, but the dimension
            labels are restricted as specified in the parameters.
        """
        return load_collection(id=self, spatial_extent=spatial_extent, temporal_extent=temporal_extent, bands=bands, properties=properties)

    def load_result(self) -> 'ProcessBuilder':
        """
        Load batch job results

        :param self: The id of a batch job with results.

        :return: A data cube for further processing.
        """
        return load_result(id=self)

    def load_uploaded_files(self, format, options=UNSET) -> 'ProcessBuilder':
        """
        Load files from the user workspace

        :param self: The files to read. Folders can't be specified, instead specify all files. An error is
            thrown if a file can't be read.
        :param format: The file format to read from. It must be one of the values that the server reports as
            supported input file formats, which usually correspond to the short GDAL/OGR codes. If the format is
            not suitable for loading the data, a `FormatUnsuitable` exception will be thrown. This parameter is
            *case insensitive*.
        :param options: The file format parameters to be used to read the files. Must correspond to the
            parameters that the server reports as supported parameters for the chosen `format`. The parameter names
            and valid values usually correspond to the GDAL/OGR format options.

        :return: A data cube for further processing.
        """
        return load_uploaded_files(paths=self, format=format, options=options)

    def log(self, base) -> 'ProcessBuilder':
        """
        Logarithm to a base

        :param self: A number to compute the logarithm for.
        :param base: The numerical base.

        :return: The computed logarithm.
        """
        return log(x=self, base=base)

    def lt(self, y) -> 'ProcessBuilder':
        """
        Less than comparison

        :param self: First operand.
        :param y: Second operand.

        :return: `true` if `x` is strictly less than `y`, `null` if any operand is `null`, otherwise `false`.
        """
        return lt(x=self, y=y)

    def lte(self, y) -> 'ProcessBuilder':
        """
        Less than or equal to comparison

        :param self: First operand.
        :param y: Second operand.

        :return: `true` if `x` is less than or equal to `y`, `null` if any operand is `null`, otherwise
            `false`.
        """
        return lte(x=self, y=y)

    def mask(self, mask, replacement=UNSET) -> 'ProcessBuilder':
        """
        Apply a raster mask

        :param self: A raster data cube.
        :param mask: A mask as raster data cube. Every pixel in `data` must have a corresponding element in
            `mask`.
        :param replacement: The value used to replace masked values with.

        :return: A masked raster data cube with the same dimensions. The dimension properties (name, type,
            labels, reference system and resolution) remain unchanged.
        """
        return mask(data=self, mask=mask, replacement=replacement)

    def mask_polygon(self, mask, replacement=UNSET, inside=UNSET) -> 'ProcessBuilder':
        """
        Apply a polygon mask

        :param self: A raster data cube.
        :param mask: A GeoJSON object containing a polygon. The provided feature types can be one of the
            following:  * A `Polygon` geometry, * a `GeometryCollection` containing Polygons, * a `Feature` with a
            `Polygon` geometry or * a `FeatureCollection` containing `Feature`s with a `Polygon` geometry.
        :param replacement: The value used to replace masked values with.
        :param inside: If set to `true` all pixels for which the point at the pixel center **does** intersect
            with any polygon are replaced.

        :return: A masked raster data cube with the same dimensions. The dimension properties (name, type,
            labels, reference system and resolution) remain unchanged.
        """
        return mask_polygon(data=self, mask=mask, replacement=replacement, inside=inside)

    def max(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Maximum value

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The maximum value.
        """
        return max(data=self, ignore_nodata=ignore_nodata)

    def mean(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Arithmetic mean (average)

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The computed arithmetic mean.
        """
        return mean(data=self, ignore_nodata=ignore_nodata)

    def median(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Statistical median

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The computed statistical median.
        """
        return median(data=self, ignore_nodata=ignore_nodata)

    def merge_cubes(self, cube2, overlap_resolver=UNSET, context=UNSET) -> 'ProcessBuilder':
        """
        Merging two data cubes

        :param self: The first data cube.
        :param cube2: The second data cube.
        :param overlap_resolver: A reduction operator that resolves the conflict if the data overlaps. The
            reducer must return a value of the same data type as the input values are. The reduction operator may
            be a single process such as ``multiply()`` or consist of multiple sub-processes. `null` (the default)
            can be specified if no overlap resolver is required.
        :param context: Additional data to be passed to the overlap resolver.

        :return: The merged data cube. See the process description for details regarding the dimensions and
            dimension properties (name, type, labels, reference system and resolution).
        """
        return merge_cubes(cube1=self, cube2=cube2, overlap_resolver=overlap_resolver, context=context)

    def min(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Minimum value

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The minimum value.
        """
        return min(data=self, ignore_nodata=ignore_nodata)

    def mod(self, y) -> 'ProcessBuilder':
        """
        Modulo

        :param self: A number to be used as dividend.
        :param y: A number to be used as divisor.

        :return: The remainder after division.
        """
        return mod(x=self, y=y)

    def multiply(self, y) -> 'ProcessBuilder':
        """
        Multiplication of two numbers

        :param self: The multiplier.
        :param y: The multiplicand.

        :return: The computed product of the two numbers.
        """
        return multiply(x=self, y=y)

    def ndvi(self, nir=UNSET, red=UNSET, target_band=UNSET) -> 'ProcessBuilder':
        """
        Normalized Difference Vegetation Index

        :param self: A raster data cube with two bands that have the common names `red` and `nir` assigned.
        :param nir: The name of the NIR band. Defaults to the band that has the common name `nir` assigned.
            Either the unique band name (metadata field `name` in bands) or one of the common band names (metadata
            field `common_name` in bands) can be specified. If unique band name and common name conflict, the
            unique band name has higher priority.
        :param red: The name of the red band. Defaults to the band that has the common name `red` assigned.
            Either the unique band name (metadata field `name` in bands) or one of the common band names (metadata
            field `common_name` in bands) can be specified. If unique band name and common name conflict, the
            unique band name has higher priority.
        :param target_band: By default, the dimension of type `bands` is dropped. To keep the dimension specify
            a new band name in this parameter so that a new dimension label with the specified name will be added
            for the computed values.

        :return: A raster data cube containing the computed NDVI values. The structure of the data cube differs
            depending on the value passed to `target_band`:  * `target_band` is `null`: The data cube does not
            contain the dimension of type `bands` any more, the number of dimensions decreases by one. The
            dimension properties (name, type, labels, reference system and resolution) for all other dimensions
            remain unchanged. * `target_band` is a string: The data cube keeps the same dimensions. The dimension
            properties remain unchanged, but the number of dimension labels for the dimension of type `bands`
            increases by one. The additional label is named as specified in `target_band`.
        """
        return ndvi(data=self, nir=nir, red=red, target_band=target_band)

    def neq(self, y, delta=UNSET, case_sensitive=UNSET) -> 'ProcessBuilder':
        """
        Not equal to comparison

        :param self: First operand.
        :param y: Second operand.
        :param delta: Only applicable for comparing two numbers. If this optional parameter is set to a
            positive non-zero number the non-equality of two numbers is checked against a delta value. This is
            especially useful to circumvent problems with floating point inaccuracy in machine-based computation.
            This option is basically an alias for the following computation: `gt(abs(minus([x, y]), delta)`
        :param case_sensitive: Only applicable for comparing two strings. Case sensitive comparison can be
            disabled by setting this parameter to `false`.

        :return: Returns `true` if `x` is *not* equal to `y`, `null` if any operand is `null`, otherwise
            `false`.
        """
        return neq(x=self, y=y, delta=delta, case_sensitive=case_sensitive)

    def normalized_difference(self, y) -> 'ProcessBuilder':
        """
        Normalized difference

        :param self: The value for the first band.
        :param y: The value for the second band.

        :return: The computed normalized difference.
        """
        return normalized_difference(x=self, y=y)

    def not_(self) -> 'ProcessBuilder':
        """
        Inverting a boolean

        :param self: Boolean value to invert.

        :return: Inverted boolean value.
        """
        return not_(x=self)

    def or_(self, y) -> 'ProcessBuilder':
        """
        Logical OR

        :param self: A boolean value.
        :param y: A boolean value.

        :return: Boolean result of the logical OR.
        """
        return or_(x=self, y=y)

    def order(self, asc=UNSET, nodata=UNSET) -> 'ProcessBuilder':
        """
        Create a permutation

        :param self: An array to compute the order for.
        :param asc: The default sort order is ascending, with smallest values first. To sort in reverse
            (descending) order, set this parameter to `false`.
        :param nodata: Controls the handling of no-data values (`null`). By default they are removed. If
            `true`, missing values in the data are put last; if `false`, they are put first.

        :return: The computed permutation.
        """
        return order(data=self, asc=asc, nodata=nodata)

    def pi(self) -> 'ProcessBuilder':
        """
        Pi (π)

        :return: The numerical value of Pi.
        """
        return pi()

    def power(self, p) -> 'ProcessBuilder':
        """
        Exponentiation

        :param self: The numerical base.
        :param p: The numerical exponent.

        :return: The computed value for `base` raised to the power of `p`.
        """
        return power(base=self, p=p)

    def product(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Compute the product by multiplying numbers

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The computed product of the sequence of numbers.
        """
        return product(data=self, ignore_nodata=ignore_nodata)

    def quantiles(self, probabilities=UNSET, q=UNSET, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Quantiles

        :param self: An array of numbers.
        :param probabilities: A list of probabilities to calculate quantiles for. The probabilities must be
            between 0 and 1.
        :param q: A number of intervals to calculate quantiles for. Calculates q-quantiles with (nearly) equal-
            sized intervals.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that an array with `null` values is returned
            if any element is such a value.

        :return: An array with the computed quantiles. The list has either  * as many elements as the given
            list of `probabilities` had or * *`q`-1* elements.  If the input array is empty the resulting array is
            filled with as many `null` values as required according to the list above. For an example, see the
            'Empty array example'.
        """
        return quantiles(data=self, probabilities=probabilities, q=q, ignore_nodata=ignore_nodata)

    def rearrange(self, order) -> 'ProcessBuilder':
        """
        Rearrange an array based on a permutation

        :param self: The array to rearrange.
        :param order: The permutation used for rearranging.

        :return: The rearranged array.
        """
        return rearrange(data=self, order=order)

    def reduce_dimension(self, reducer, dimension, context=UNSET) -> 'ProcessBuilder':
        """
        Reduce dimensions

        :param self: A data cube.
        :param reducer: A reducer to apply on the specified dimension. A reducer is a single process such as
            ``mean()`` or a set of processes, which computes a single value for a list of values, see the category
            'reducer' for such processes.
        :param dimension: The name of the dimension over which to reduce. Fails with a `DimensionNotAvailable`
            error if the specified dimension does not exist.
        :param context: Additional data to be passed to the reducer.

        :return: A data cube with the newly computed values. It is missing the given dimension, the number of
            dimensions decreases by one. The dimension properties (name, type, labels, reference system and
            resolution) for all other dimensions remain unchanged.
        """
        return reduce_dimension(data=self, reducer=reducer, dimension=dimension, context=context)

    def reduce_dimension_binary(self, reducer, dimension, context=UNSET) -> 'ProcessBuilder':
        """
        Reduce dimensions using binary reduction

        :param self: A data cube.
        :param reducer: A reduction operator to be applied consecutively on pairs of values. It must be both
            associative and commutative as the execution may be executed in parallel and therefore the order of
            execution is arbitrary. The reduction operator may be a single process such as ``multiply()`` or
            consist of multiple sub-processes.
        :param dimension: The name of the dimension over which to reduce. Fails with a `DimensionNotAvailable`
            error if the specified dimension does not exist.
        :param context: Additional data to be passed to the reducer.

        :return: A data cube with the newly computed values. It is missing the given dimension, the number of
            dimensions decreases by one. The dimension properties (name, type, labels, reference system and
            resolution) for all other dimensions remain unchanged.
        """
        return reduce_dimension_binary(data=self, reducer=reducer, dimension=dimension, context=context)

    def rename_dimension(self, source, target) -> 'ProcessBuilder':
        """
        Rename a dimension

        :param self: The data cube.
        :param source: The current name of the dimension. Fails with a `DimensionNotAvailable` error if the
            specified dimension does not exist.
        :param target: A new Name for the dimension. Fails with a `DimensionExists` error if a dimension with
            the specified name exists.

        :return: A data cube with the same dimensions, but the name of one of the dimensions changes. The old
            name can not be referred to any longer. The dimension properties (name, type, labels, reference system
            and resolution) remain unchanged.
        """
        return rename_dimension(data=self, source=source, target=target)

    def rename_labels(self, dimension, target, source=UNSET) -> 'ProcessBuilder':
        """
        Rename dimension labels

        :param self: The data cube.
        :param dimension: The name of the dimension to rename the labels for.
        :param target: The new names for the labels. The dimension labels in the data cube are expected to be
            enumerated, if the parameter `target` is not specified. If a target dimension label already exists in
            the data cube, a `LabelExists` error is thrown.
        :param source: The names of the labels as they are currently in the data cube. The array defines an
            unsorted and potentially incomplete list of labels that should be renamed to the names available in the
            corresponding array elements in the parameter `target`. If one of the source dimension labels doesn't
            exist, a `LabelNotAvailable` error is thrown. By default, the array is empty so that the dimension
            labels in the data cube are expected to be enumerated.

        :return: The data cube with the same dimensions. The dimension properties (name, type, labels,
            reference system and resolution) remain unchanged, except that for the given dimension the labels
            change. The old labels can not be referred to any longer. The number of labels remains the same.
        """
        return rename_labels(data=self, dimension=dimension, target=target, source=source)

    def resample_cube_spatial(self, target, method=UNSET) -> 'ProcessBuilder':
        """
        Resample the spatial dimensions to match a target data cube

        :param self: A data cube.
        :param target: A data cube that describes the spatial target resolution.
        :param method: Resampling method. Methods are inspired by GDAL, see
            [gdalwarp](https://www.gdal.org/gdalwarp.html) for more information.

        :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
            system and resolution) remain unchanged, except for the resolution and dimension labels of the spatial
            dimensions.
        """
        return resample_cube_spatial(data=self, target=target, method=method)

    def resample_cube_temporal(self, target, method, dimension=UNSET, context=UNSET) -> 'ProcessBuilder':
        """
        Resample a temporal dimension to match a target data cube

        :param self: A data cube.
        :param target: A data cube that describes the temporal target resolution.
        :param method: A resampling method to be applied, could be a reducer for downsampling or other methods
            for upsampling. A reducer is a single process such as ``mean()`` or a set of processes, which computes
            a single value for a list of values, see the category 'reducer' for such processes.
        :param dimension: The name of the temporal dimension to resample, which must exist with this name in
            both data cubes. If the dimension is not set or is set to `null`, the data cube is expected to only
            have one temporal dimension. Fails with a `TooManyDimensions` error if it has more dimensions. Fails
            with a `DimensionNotAvailable` error if the specified dimension does not exist.
        :param context: Additional data to be passed to the process specified for the parameter `method`.

        :return: A raster data cube with the same dimensions and the same dimension properties (name, type,
            labels, reference system and resolution) for all non-temporal dimensions. For the temporal dimension
            the name and type remain unchanged, but the reference system changes and the labels and resolution may
            change.
        """
        return resample_cube_temporal(data=self, target=target, method=method, dimension=dimension, context=context)

    def resample_spatial(self, resolution=UNSET, projection=UNSET, method=UNSET, align=UNSET) -> 'ProcessBuilder':
        """
        Resample and warp the spatial dimensions

        :param self: A raster data cube.
        :param resolution: Resamples the data cube to the target resolution, which can be specified either as
            separate values for x and y or as a single value for both axes. Specified in the units of the target
            projection. Doesn't change the resolution by default (`0`).
        :param projection: Warps the data cube to the target projection, specified as as [EPSG
            code](http://www.epsg-registry.org/), [WKT2 (ISO 19162)
            string](http://docs.opengeospatial.org/is/18-010r7/18-010r7.html), [PROJ definition
            (deprecated)](https://proj.org/usage/quickstart.html). By default (`null`), the projection is not
            changed.
        :param method: Resampling method. Methods are inspired by GDAL, see
            [gdalwarp](https://www.gdal.org/gdalwarp.html) for more information.
        :param align: Specifies to which corner of the spatial extent the new resampled data is aligned to.

        :return: A raster data cube with values warped onto the new projection. It has the same dimensions and
            the same dimension properties (name, type, labels, reference system and resolution) for all non-spatial
            or vertical spatial dimensions. For the horizontal spatial dimensions the name and type remain
            unchanged, but reference system, labels and resolution may change depending on the given parameters.
        """
        return resample_spatial(data=self, resolution=resolution, projection=projection, method=method, align=align)

    def round(self, p=UNSET) -> 'ProcessBuilder':
        """
        Round to a specified precision

        :param self: A number to round.
        :param p: A positive number specifies the number of digits after the decimal point to round to. A
            negative number means rounding to a power of ten, so for example *-2* rounds to the nearest hundred.
            Defaults to *0*.

        :return: The rounded number.
        """
        return round(x=self, p=p)

    def run_udf(self, udf, runtime, version=UNSET, context=UNSET) -> 'ProcessBuilder':
        """
        Run an UDF

        :param self: The data to be passed to the UDF as array or raster data cube.
        :param udf: Either source code, an absolute URL or a path to an UDF script.
        :param runtime: An UDF runtime identifier available at the back-end.
        :param version: An UDF runtime version. If set to `null`, the default runtime version specified for
            each runtime is used.
        :param context: Additional data such as configuration options that should be passed to the UDF.

        :return: The data processed by the UDF.  * Returns a raster data cube, if a raster data cube is passed
            for `data`. Details on the dimensions and dimension properties (name, type, labels, reference system
            and resolution) depend on the UDF. * If an array is passed for `data`, the returned value can be of any
            data type, but is exactly what the UDF returns.
        """
        return run_udf(data=self, udf=udf, runtime=runtime, version=version, context=context)

    def run_udf_externally(self, url, context=UNSET) -> 'ProcessBuilder':
        """
        Run an externally hosted UDF container

        :param self: The data to be passed to the UDF as array or raster data cube.
        :param url: URL to a remote UDF service.
        :param context: Additional data such as configuration options that should be passed to the UDF.

        :return: The data processed by the UDF service.  * Returns a raster data cube, if a raster data cube is
            passed for `data`. Details on the dimensions and dimension properties (name, type, labels, reference
            system and resolution) depend on the UDF. * If an array is passed for `data`, the returned value can be
            of any data type, but is exactly what the UDF returns.
        """
        return run_udf_externally(data=self, url=url, context=context)

    def save_result(self, format, options=UNSET) -> 'ProcessBuilder':
        """
        Save processed data to storage

        :param self: The data to save.
        :param format: The file format to save to. It must be one of the values that the server reports as
            supported output file formats, which usually correspond to the short GDAL/OGR codes. If the format is
            not suitable for storing the underlying data structure, a `FormatUnsuitable` exception will be thrown.
            This parameter is *case insensitive*.
        :param options: The file format parameters to be used to create the file(s). Must correspond to the
            parameters that the server reports as supported parameters for the chosen `format`. The parameter names
            and valid values usually correspond to the GDAL/OGR format options.

        :return: `false` if saving failed, `true` otherwise.
        """
        return save_result(data=self, format=format, options=options)

    def sd(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Standard deviation

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The computed sample standard deviation.
        """
        return sd(data=self, ignore_nodata=ignore_nodata)

    def sgn(self) -> 'ProcessBuilder':
        """
        Signum

        :param self: A number.

        :return: The computed signum value of `x`.
        """
        return sgn(x=self)

    def sin(self) -> 'ProcessBuilder':
        """
        Sine

        :param self: An angle in radians.

        :return: The computed sine of `x`.
        """
        return sin(x=self)

    def sinh(self) -> 'ProcessBuilder':
        """
        Hyperbolic sine

        :param self: An angle in radians.

        :return: The computed hyperbolic sine of `x`.
        """
        return sinh(x=self)

    def sort(self, asc=UNSET, nodata=UNSET) -> 'ProcessBuilder':
        """
        Sort data

        :param self: An array with data to sort.
        :param asc: The default sort order is ascending, with smallest values first. To sort in reverse
            (descending) order, set this parameter to `false`.
        :param nodata: Controls the handling of no-data values (`null`). By default they are removed. If
            `true`, missing values in the data are put last; if `false`, they are put first.

        :return: The sorted array.
        """
        return sort(data=self, asc=asc, nodata=nodata)

    def sqrt(self) -> 'ProcessBuilder':
        """
        Square root

        :param self: A number.

        :return: The computed square root.
        """
        return sqrt(x=self)

    def subtract(self, y) -> 'ProcessBuilder':
        """
        Subtraction of two numbers

        :param self: The minuend.
        :param y: The subtrahend.

        :return: The computed result.
        """
        return subtract(x=self, y=y)

    def sum(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Compute the sum by adding up numbers

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The computed sum of the sequence of numbers.
        """
        return sum(data=self, ignore_nodata=ignore_nodata)

    def tan(self) -> 'ProcessBuilder':
        """
        Tangent

        :param self: An angle in radians.

        :return: The computed tangent of `x`.
        """
        return tan(x=self)

    def tanh(self) -> 'ProcessBuilder':
        """
        Hyperbolic tangent

        :param self: An angle in radians.

        :return: The computed hyperbolic tangent of `x`.
        """
        return tanh(x=self)

    def text_begins(self, pattern, case_sensitive=UNSET) -> 'ProcessBuilder':
        """
        Text begins with another text

        :param self: Text in which to find something at the beginning.
        :param pattern: Text to find at the beginning of `data`. Regular expressions are not supported.
        :param case_sensitive: Case sensitive comparison can be disabled by setting this parameter to `false`.

        :return: `true` if `data` begins with `pattern`, false` otherwise.
        """
        return text_begins(data=self, pattern=pattern, case_sensitive=case_sensitive)

    def text_contains(self, pattern, case_sensitive=UNSET) -> 'ProcessBuilder':
        """
        Text contains another text

        :param self: Text in which to find something in.
        :param pattern: Text to find in `data`. Regular expressions are not supported.
        :param case_sensitive: Case sensitive comparison can be disabled by setting this parameter to `false`.

        :return: `true` if `data` contains the `pattern`, false` otherwise.
        """
        return text_contains(data=self, pattern=pattern, case_sensitive=case_sensitive)

    def text_ends(self, pattern, case_sensitive=UNSET) -> 'ProcessBuilder':
        """
        Text ends with another text

        :param self: Text in which to find something at the end.
        :param pattern: Text to find at the end of `data`. Regular expressions are not supported.
        :param case_sensitive: Case sensitive comparison can be disabled by setting this parameter to `false`.

        :return: `true` if `data` ends with `pattern`, false` otherwise.
        """
        return text_ends(data=self, pattern=pattern, case_sensitive=case_sensitive)

    def text_merge(self, separator=UNSET) -> 'ProcessBuilder':
        """
        Concatenate elements to a string

        :param self: A set of elements. Numbers, boolean values and null values get converted to their (lower
            case) string representation. For example: `1` (integer), `-1.5` (number), `true` / `false` (boolean
            values)
        :param separator: A separator to put between each of the individual texts. Defaults to an empty string.

        :return: Returns a string containing a string representation of all the array elements in the same
            order, with the separator between each element.
        """
        return text_merge(data=self, separator=separator)

    def trim_cube(self) -> 'ProcessBuilder':
        """
        Remove dimension labels with no-data values

        :param self: A raster data cube to trim.

        :return: A trimmed raster data cube with the same dimensions. The dimension properties name, type,
            reference system and resolution remain unchanged. The number of dimension labels may decrease.
        """
        return trim_cube(data=self)

    def variance(self, ignore_nodata=UNSET) -> 'ProcessBuilder':
        """
        Variance

        :param self: An array of numbers.
        :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default.
            Setting this flag to `false` considers no-data values so that `null` is returned if any value is such a
            value.

        :return: The computed sample variance.
        """
        return variance(data=self, ignore_nodata=ignore_nodata)

    def xor(self, y) -> 'ProcessBuilder':
        """
        Logical XOR (exclusive or)

        :param self: A boolean value.
        :param y: A boolean value.

        :return: Boolean result of the logical XOR.
        """
        return xor(x=self, y=y)


# Shortcut
process = ProcessBuilder.process


def absolute(x) -> ProcessBuilder:
    """
    Absolute value

    :param x: A number.

    :return: The computed absolute value.
    """
    return process('absolute', x=x)


def add(x, y) -> ProcessBuilder:
    """
    Addition of two numbers

    :param x: The first summand.
    :param y: The second summand.

    :return: The computed sum of the two numbers.
    """
    return process('add', x=x, y=y)


def add_dimension(data, name, label, type=UNSET) -> ProcessBuilder:
    """
    Add a new dimension

    :param data: A data cube to add the dimension to.
    :param name: Name for the dimension.
    :param label: A dimension label.
    :param type: The type of dimension, defaults to `other`.

    :return: The data cube with a newly added dimension. The new dimension has exactly one dimension label. All
        other dimensions remain unchanged.
    """
    return process('add_dimension', data=data, name=name, label=label, type=type)


def aggregate_spatial(data, geometries, reducer, target_dimension=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Zonal statistics for geometries

    :param data: A raster data cube. The data cube implicitly gets restricted to the bounds of the geometries
        as if ``filter_spatial()`` would have been used with the same values for the corresponding parameters
        immediately before this process.
    :param geometries: Geometries as GeoJSON on which the aggregation will be based.
    :param reducer: A reducer to be applied on all values of each geometry. A reducer is a single process such
        as ``mean()`` or a set of processes, which computes a single value for a list of values, see the category
        'reducer' for such processes.
    :param target_dimension: The new dimension name to be used for storing the results. Defaults to `result`.
    :param context: Additional data to be passed to the reducer.

    :return: A vector data cube with the computed results and restricted to the bounds of the geometries.  The
        computed value is stored in dimension with the name that was specified in the parameter `target_dimension`.
        The computation also stores information about the total count of pixels (valid + invalid pixels) and the
        number of valid pixels (see ``is_valid()``) for each geometry. These values are stored as new dimension
        with a dimension name derived from `target_dimension` by adding the suffix `_meta`. The new dimension has
        the dimension labels `total_count` and `valid_count`.
    """
    return process('aggregate_spatial', data=data, geometries=geometries, reducer=reducer, target_dimension=target_dimension, context=context)


def aggregate_spatial_binary(data, geometries, reducer, target_dimension=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Zonal statistics for geometries by binary aggregation

    :param data: A raster data cube. The data cube implicitly gets restricted to the bounds of the geometries
        as if ``filter_spatial()`` would have been used with the same values for the corresponding parameters
        immediately before this process.
    :param geometries: Geometries as GeoJSON on which the aggregation will be based.
    :param reducer: A reduction operator to be applied consecutively on tuples of values. It must be both
        associative and commutative as the execution may be executed in parallel and therefore the order of
        execution is arbitrary. The reduction operator may be a single process such as ``multiply()`` or consist of
        multiple sub-processes.
    :param target_dimension: The new dimension name to be used for storing the results. Defaults to `result`.
    :param context: Additional data to be passed to the reducer.

    :return: A vector data cube with the computed results and restricted to the bounds of the geometries.  The
        computed value is stored in dimension with the name that was specified in the parameter `target_dimension`.
        The computation also stores information about the total count of pixels (valid + invalid pixels) and the
        number of valid pixels (see ``is_valid()``) for each geometry. These values are stored as new dimension
        with a dimension name derived from `target_dimension` by adding the suffix `_meta`. The new dimension has
        the dimension labels `total_count` and `valid_count`.
    """
    return process('aggregate_spatial_binary', data=data, geometries=geometries, reducer=reducer, target_dimension=target_dimension, context=context)


def aggregate_temporal(data, intervals, reducer, labels=UNSET, dimension=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Temporal aggregations

    :param data: A data cube.
    :param intervals: Left-closed temporal intervals, which are allowed to overlap. Each temporal interval in
        the array has exactly two elements:  1. The first element is the start of the temporal interval. The
        specified instance in time is **included** in the interval. 2. The second element is the end of the
        temporal interval. The specified instance in time is **excluded** from the interval.  The specified
        temporal strings follow [RFC 3339](https://tools.ietf.org/html/rfc3339). Although [RFC 3339 prohibits the
        hour to be '24'](https://tools.ietf.org/html/rfc3339#section-5.7), **this process allows the value '24' for
        the hour** of an end time in order to make it possible that left-closed time intervals can fully cover the
        day.
    :param reducer: A reducer to be applied on all values along the specified dimension. A reducer is a single
        process such as ``mean()`` or a set of processes, which computes a single value for a list of values, see
        the category 'reducer' for such processes.
    :param labels: Distinct labels for the intervals, which can contain dates and/or times. Is only required to
        be specified if the values for the start of the temporal intervals are not distinct and thus the default
        labels would not be unique. The number of labels and the number of groups need to be equal.
    :param dimension: The name of the temporal dimension for aggregation. All data along the dimension is
        passed through the specified reducer. If the dimension is not set or set to `null`, the data cube is
        expected to only have one temporal dimension. Fails with a `TooManyDimensions` error if it has more
        dimensions. Fails with a `DimensionNotAvailable` error if the specified dimension does not exist.
    :param context: Additional data to be passed to the reducer.

    :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
        system and resolution) remain unchanged, except for the resolution and dimension labels of the given
        temporal dimension.
    """
    return process('aggregate_temporal', data=data, intervals=intervals, reducer=reducer, labels=labels, dimension=dimension, context=context)


def aggregate_temporal_period(data, period, reducer, dimension=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Temporal aggregations based on calendar hierarchies

    :param data: A data cube.
    :param period: The time intervals to aggregate. The following pre-defined values are available:  * `hour`:
        Hour of the day * `day`: Day of the year * `week`: Week of the year * `dekad`: Ten day periods, counted per
        year with three periods per month (day 1 - 10, 11 - 20 and 21 - end of month). The third dekad of the month
        can range from 8 to 11 days. For example, the fourth dekad is Feb, 1 - Feb, 10 each year. * `month`: Month
        of the year * `season`: Three month periods of the calendar seasons (December - February, March - May, June
        - August, September - November). * `tropical-season`: Six month periods of the tropical seasons (November -
        April, May - October). * `year`: Proleptic years * `decade`: Ten year periods ([0-to-9
        decade](https://en.wikipedia.org/wiki/Decade#0-to-9_decade)), from a year ending in a 0 to the next year
        ending in a 9. * `decade-ad`: Ten year periods ([1-to-0
        decade](https://en.wikipedia.org/wiki/Decade#1-to-0_decade)) better aligned with the Anno Domini (AD)
        calendar era, from a year ending in a 1 to the next year ending in a 0.
    :param reducer: A reducer to be applied on all values along the specified dimension. A reducer is a single
        process such as ``mean()`` or a set of processes, which computes a single value for a list of values, see
        the category 'reducer' for such processes.
    :param dimension: The name of the temporal dimension for aggregation. All data along the dimension is
        passed through the specified reducer. If the dimension is not set or set to `null`, the data cube is
        expected to only have one temporal dimension. Fails with a `TooManyDimensions` error if it has more
        dimensions. Fails with a `DimensionNotAvailable` error if the specified dimension does not exist.
    :param context: Additional data to be passed to the reducer.

    :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
        system and resolution) remain unchanged, except for the resolution and dimension labels of the given
        temporal dimension. The specified temporal dimension has the following dimension labels (`YYYY` = four-
        digit year, `MM` = two-digit month, `DD` two-digit day of month):  * `hour`: `YYYY-MM-DD-00` - `YYYY-MM-
        DD-23` * `day`: `YYYY-001` - `YYYY-365` * `week`: `YYYY-01` - `YYYY-52` * `dekad`: `YYYY-00` - `YYYY-36` *
        `month`: `YYYY-01` - `YYYY-12` * `season`: `YYYY-djf` (December - February), `YYYY-mam` (March - May),
        `YYYY-jja` (June - August), `YYYY-son` (September - November). * `tropical-season`: `YYYY-ndjfma` (November
        - April), `YYYY-mjjaso` (May - October). * `year`: `YYYY` * `decade`: `YYY0` * `decade-ad`: `YYY1`
    """
    return process('aggregate_temporal_period', data=data, period=period, reducer=reducer, dimension=dimension, context=context)


def all(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Are all of the values true?

    :param data: A set of boolean values.
    :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.

    :return: Boolean result of the logical operation.
    """
    return process('all', data=data, ignore_nodata=ignore_nodata)


def and_(x, y) -> ProcessBuilder:
    """
    Logical AND

    :param x: A boolean value.
    :param y: A boolean value.

    :return: Boolean result of the logical AND.
    """
    return process('and', x=x, y=y)


def anomaly(data, normals, period) -> ProcessBuilder:
    """
    Computes anomalies

    :param data: A data cube with exactly one temporal dimension and the following dimension labels for the
        given period (`YYYY` = four-digit year, `MM` = two-digit month, `DD` two-digit day of month):  * `hour`:
        `YYYY-MM-DD-00` - `YYYY-MM-DD-23` * `day`: `YYYY-001` - `YYYY-365` * `week`: `YYYY-01` - `YYYY-52` *
        `dekad`: `YYYY-00` - `YYYY-36` * `month`: `YYYY-01` - `YYYY-12` * `season`: `YYYY-djf` (December -
        February), `YYYY-mam` (March - May), `YYYY-jja` (June - August), `YYYY-son` (September - November). *
        `tropical-season`: `YYYY-ndjfma` (November - April), `YYYY-mjjaso` (May - October). * `year`: `YYYY` *
        `decade`: `YYY0` * `decade-ad`: `YYY1` * `single-period` / `climatology-period`: Any
        ``aggregate_temporal_period()`` can compute such a data cube.
    :param normals: A data cube with normals, e.g. daily, monthly or yearly values computed from a process such
        as ``climatological_normal()``. Must contain exactly one temporal dimension with the following dimension
        labels for the given period:  * `hour`: `00` - `23` * `day`: `001` - `365` * `week`: `01` - `52` * `dekad`:
        `00` - `36` * `month`: `01` - `12` * `season`: `djf` (December - February), `mam` (March - May), `jja`
        (June - August), `son` (September - November) * `tropical-season`: `ndjfma` (November - April), `mjjaso`
        (May - October) * `year`: Four-digit year numbers * `decade`: Four-digit year numbers, the last digit being
        a `0` * `decade-ad`: Four-digit year numbers, the last digit being a `1` * `single-period` / `climatology-
        period`: A single dimension label with any name is expected.
    :param period: Specifies the time intervals available in the normals data cube. The following options are
        available:  * `hour`: Hour of the day * `day`: Day of the year * `week`: Week of the year * `dekad`: Ten
        day periods, counted per year with three periods per month (day 1 - 10, 11 - 20 and 21 - end of month). The
        third dekad of the month can range from 8 to 11 days. For example, the fourth dekad is Feb, 1 - Feb, 10
        each year. * `month`: Month of the year * `season`: Three month periods of the calendar seasons (December -
        February, March - May, June - August, September - November). * `tropical-season`: Six month periods of the
        tropical seasons (November - April, May - October). * `year`: Proleptic years * `decade`: Ten year periods
        ([0-to-9 decade](https://en.wikipedia.org/wiki/Decade#0-to-9_decade)), from a year ending in a 0 to the
        next year ending in a 9. * `decade-ad`: Ten year periods ([1-to-0
        decade](https://en.wikipedia.org/wiki/Decade#1-to-0_decade)) better aligned with the Anno Domini (AD)
        calendar era, from a year ending in a 1 to the next year ending in a 0. * `single-period` / `climatology-
        period`: A single period of arbitrary length

    :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
        system and resolution) remain unchanged.
    """
    return process('anomaly', data=data, normals=normals, period=period)


def any(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Is at least one value true?

    :param data: A set of boolean values.
    :param ignore_nodata: Indicates whether no-data values are ignored or not and ignores them by default.

    :return: Boolean result of the logical operation.
    """
    return process('any', data=data, ignore_nodata=ignore_nodata)


def apply(data, process, context=UNSET) -> ProcessBuilder:
    """
    Apply a process to each pixel

    :param data: A data cube.
    :param process: A unary process to be applied on each value, may consist of multiple sub-processes.
    :param context: Additional data to be passed to the process.

    :return: A data cube with the newly computed values and the same dimensions. The dimension properties
        (name, type, labels, reference system and resolution) remain unchanged.
    """
    return process('apply', data=data, process=process, context=context)


def apply_dimension(data, process, dimension, target_dimension=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Apply a process to pixels along a dimension

    :param data: A data cube.
    :param process: Process to be applied on all pixel values. The specified process needs to accept an array
        as parameter and must return an array with least one element. A process may consist of multiple sub-
        processes.
    :param dimension: The name of the source dimension to apply the process on. Fails with a
        `DimensionNotAvailable` error if the specified dimension does not exist.
    :param target_dimension: The name of the target dimension or `null` (the default) to use the source
        dimension specified in the parameter `dimension`.  By specifying a target dimension, the source dimension
        is removed. The target dimension with the specified name and the type `other` (see ``add_dimension()``) is
        created, if if doesn't exist yet.
    :param context: Additional data to be passed to the process.

    :return: A data cube with the newly computed values. All dimensions stay the same, except for the
        dimensions specified in corresponding parameters. There are three cases how the data cube changes:  1. The
        source dimension **is** the target dimension:    * The (number of) dimensions remain unchanged.    * The
        source dimension properties name, type and reference system remain unchanged.    * The dimension labels and
        the resolution are preserved when the number of pixel values in the source dimension is equal to the number
        of values computed by the process. The other case is described below. 2. The source dimension **is not**
        the target dimension and the latter **exists**:    * The number of dimensions decreases by one as the
        source dimension is dropped.    * The target dimension properties name, type and reference system remain
        unchanged.    * The resolution changes, the number of dimension labels is equal to the number of values
        computed by the process and the dimension labels are incrementing integers starting from zero 3. The source
        dimension **is not** the target dimension and the latter **does not exist**:    * The number of dimensions
        remain unchanged, but the source dimension is replaced with the target dimension.    * The target dimension
        has the specified name and the type other. The reference system is not changed.    * The resolution
        changes, the number of dimension labels is equal to the number of values computed by the process and the
        dimension labels are incrementing integers starting from zero  For all three cases except for the exception
        in the first case, the resolution changes, the number of dimension labels is equal to the number of values
        computed by the process and the dimension labels are incrementing integers starting from zero.
    """
    return process('apply_dimension', data=data, process=process, dimension=dimension, target_dimension=target_dimension, context=context)


def apply_kernel(data, kernel, factor=UNSET, border=UNSET, replace_invalid=UNSET) -> ProcessBuilder:
    """
    Apply a spatial convolution with a kernel

    :param data: A data cube.
    :param kernel: Kernel as a two-dimensional array of weights. The inner level of the nested array aligns
        with the `x` axis and the outer level aligns with the `y` axis. Each level of the kernel must have an
        uneven number of elements, otherwise the process throws a `KernelDimensionsUneven` error.
    :param factor: A factor that is multiplied to each value after the kernel has been applied.  This is
        basically a shortcut for explicitly multiplying each value by a factor afterwards, which is often required
        for some kernel-based algorithms such as the Gaussian blur.
    :param border: Determines how the data is extended when the kernel overlaps with the borders. Defaults to
        fill the border with zeroes.  The following options are available:  * *numeric value* - fill with a user-
        defined constant number `n`: `nnnnnn|abcdefgh|nnnnnn` (default, with `n` = 0) * `replicate` - repeat the
        value from the pixel at the border: `aaaaaa|abcdefgh|hhhhhh` * `reflect` - mirror/reflect from the border:
        `fedcba|abcdefgh|hgfedc` * `reflect_pixel` - mirror/reflect from the center of the pixel at the border:
        `gfedcb|abcdefgh|gfedcb` * `wrap` - repeat/wrap the image: `cdefgh|abcdefgh|abcdef`
    :param replace_invalid: This parameter specifies the value to replace non-numerical or infinite numerical
        values with. By default, those values are replaced with zeroes.

    :return: A data cube with the newly computed values and the same dimensions. The dimension properties
        (name, type, labels, reference system and resolution) remain unchanged.
    """
    return process('apply_kernel', data=data, kernel=kernel, factor=factor, border=border, replace_invalid=replace_invalid)


def apply_neighborhood(data, process, size, overlap=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Apply a process to pixels in a n-dimensional neighbourhood

    :param data: A data cube.
    :param process: Process to be applied on all neighbourhoods.
    :param size: Neighbourhood sizes along each dimension.  This object maps dimension names to either a
        physical measure (e.g. 100 m, 10 days) or pixels (e.g. 32 pixels). For dimensions not specified, the
        default is to provide all values. Be aware that including all values from overly large dimensions may not
        be processed at once.
    :param overlap: Overlap of neighbourhoods along each dimension to avoid border effects.  For instance a
        temporal dimension can add 1 month before and after a neighbourhood. In the spatial dimensions, this is
        often a number of pixels. The overlap specified is added before and after, so an overlap of 8 pixels will
        add 8 pixels on both sides of the window, so 16 in total.  Be aware that large overlaps increase the need
        for computational resources and modifying overlapping data in subsequent operations have no effect.
    :param context: Additional data to be passed to the process.

    :return: A data cube with the newly computed values and the same dimensions. The dimension properties
        (name, type, labels, reference system and resolution) remain unchanged.
    """
    return process('apply_neighborhood', data=data, process=process, size=size, overlap=overlap, context=context)


def arccos(x) -> ProcessBuilder:
    """
    Inverse cosine

    :param x: A number.

    :return: The computed angle in radians.
    """
    return process('arccos', x=x)


def arcosh(x) -> ProcessBuilder:
    """
    Inverse hyperbolic cosine

    :param x: A number.

    :return: The computed angle in radians.
    """
    return process('arcosh', x=x)


def arcsin(x) -> ProcessBuilder:
    """
    Inverse sine

    :param x: A number.

    :return: The computed angle in radians.
    """
    return process('arcsin', x=x)


def arctan(x) -> ProcessBuilder:
    """
    Inverse tangent

    :param x: A number.

    :return: The computed angle in radians.
    """
    return process('arctan', x=x)


def arctan2(y, x) -> ProcessBuilder:
    """
    Inverse tangent of two numbers

    :param y: A number to be used as dividend.
    :param x: A number to be used as divisor.

    :return: The computed angle in radians.
    """
    return process('arctan2', y=y, x=x)


def array_apply(data, process, context=UNSET) -> ProcessBuilder:
    """
    Applies a unary process to each array element

    :param data: An array.
    :param process: A process to be applied on each value, may consist of multiple sub-processes. The specified
        process must be unary meaning that it must work on a single value.
    :param context: Additional data to be passed to the process.

    :return: An array with the newly computed values. The number of elements are the same as for the original
        array.
    """
    return process('array_apply', data=data, process=process, context=context)


def array_contains(data, value) -> ProcessBuilder:
    """
    Check whether the array contains a given value

    :param data: List to find the value in.
    :param value: Value to find in `data`.

    :return: Returns `true` if the list contains the value, false` otherwise.
    """
    return process('array_contains', data=data, value=value)


def array_element(data, index=UNSET, label=UNSET, return_nodata=UNSET) -> ProcessBuilder:
    """
    Get an element from an array

    :param data: An array.
    :param index: The zero-based index of the element to retrieve.
    :param label: The label of the element to retrieve.
    :param return_nodata: By default this process throws an `ArrayElementNotAvailable` exception if the index
        or label is invalid. If you want to return `null` instead, set this flag to `true`.

    :return: The value of the requested element.
    """
    return process('array_element', data=data, index=index, label=label, return_nodata=return_nodata)


def array_filter(data, condition, context=UNSET) -> ProcessBuilder:
    """
    Filter an array based on a condition

    :param data: An array.
    :param condition: A condition that is evaluated against each value in the array. Only the array elements
        where the condition returns `true` are preserved.
    :param context: Additional data to be passed to the condition.

    :return: An array filtered by the specified condition. The number of elements are less than or equal
        compared to the original array.
    """
    return process('array_filter', data=data, condition=condition, context=context)


def array_find(data, value) -> ProcessBuilder:
    """
    Get the index for a value in an array

    :param data: List to find the value in.
    :param value: Value to find in `data`.

    :return: Returns the index of the first element with the specified value. If no element was found, `null`
        is returned.
    """
    return process('array_find', data=data, value=value)


def array_labels(data) -> ProcessBuilder:
    """
    Get the labels for an array

    :param data: An array with labels.

    :return: The labels as array.
    """
    return process('array_labels', data=data)


def arsinh(x) -> ProcessBuilder:
    """
    Inverse hyperbolic sine

    :param x: A number.

    :return: The computed angle in radians.
    """
    return process('arsinh', x=x)


def artanh(x) -> ProcessBuilder:
    """
    Inverse hyperbolic tangent

    :param x: A number.

    :return: The computed angle in radians.
    """
    return process('artanh', x=x)


def between(x, min, max, exclude_max=UNSET) -> ProcessBuilder:
    """
    Between comparison

    :param x: The value to check.
    :param min: Lower boundary (inclusive) to check against.
    :param max: Upper boundary (inclusive) to check against.
    :param exclude_max: Exclude the upper boundary `max` if set to `true`. Defaults to `false`.

    :return: `true` if `x` is between the specified bounds, otherwise `false`.
    """
    return process('between', x=x, min=min, max=max, exclude_max=exclude_max)


def ceil(x) -> ProcessBuilder:
    """
    Round fractions up

    :param x: A number to round up.

    :return: The number rounded up.
    """
    return process('ceil', x=x)


def climatological_normal(data, period, climatology_period=UNSET) -> ProcessBuilder:
    """
    Computes climatology normals

    :param data: A data cube with exactly one temporal dimension. The data cube must span at least the temporal
        interval specified in the parameter `climatology-period`.  Seasonal periods may span two consecutive years,
        e.g. temporal winter that includes months December, January and February. If the required months before the
        actual climate period are available, the season is taken into account. If not available, the first season
        is not taken into account and the seasonal mean is based on one year less than the other seasonal normals.
        The incomplete season at the end of the last year is never taken into account.
    :param period: The time intervals to aggregate the average value for. The following pre-defined frequencies
        are supported:  * `day`: Day of the year * `month`: Month of the year * `climatology-period`: The period
        specified in the `climatology-period`. * `season`: Three month periods of the calendar seasons (December -
        February, March - May, June - August, September - November). * `tropical-season`: Six month periods of the
        tropical seasons (November - April, May - October).
    :param climatology_period: The climatology period as closed temporal interval. The first element of the
        array is the first year to be fully included in the temporal interval. The second element is the last year
        to be fully included in the temporal interval. The default period is from 1981 until 2010 (both inclusive).

    :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
        system and resolution) remain unchanged, except for the resolution and dimension labels of the temporal
        dimension. The temporal dimension has the following dimension labels:  * `day`: `001` - `365` * `month`:
        `01` - `12` * `climatology-period`: `climatology-period` * `season`: `djf` (December - February), `mam`
        (March - May), `jja` (June - August), `son` (September - November) * `tropical-season`: `ndjfma` (November
        - April), `mjjaso` (May - October)
    """
    return process('climatological_normal', data=data, period=period, climatology_period=climatology_period)


def clip(x, min, max) -> ProcessBuilder:
    """
    Clip a value between a minimum and a maximum

    :param x: A number.
    :param min: Minimum value. If the value is lower than this value, the process will return the value of this
        parameter.
    :param max: Maximum value. If the value is greater than this value, the process will return the value of
        this parameter.

    :return: The value clipped to the specified range.
    """
    return process('clip', x=x, min=min, max=max)


def constant(x) -> ProcessBuilder:
    """
    Define a constant value

    :param x: The value of the constant.

    :return: The value of the constant.
    """
    return process('constant', x=x)


def cos(x) -> ProcessBuilder:
    """
    Cosine

    :param x: An angle in radians.

    :return: The computed cosine of `x`.
    """
    return process('cos', x=x)


def cosh(x) -> ProcessBuilder:
    """
    Hyperbolic cosine

    :param x: An angle in radians.

    :return: The computed hyperbolic cosine of `x`.
    """
    return process('cosh', x=x)


def count(data, condition=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Count the number of elements

    :param data: An array with elements of any data type.
    :param condition: A condition consists of one ore more processes, which in the end return a boolean value.
        It is evaluated against each element in the array. An element is counted only if the condition returns
        `true`. Defaults to count valid elements in a list (see ``is_valid()``). Setting this parameter to boolean
        `true` counts all elements in the list.
    :param context: Additional data to be passed to the condition.

    :return: The counted number of elements.
    """
    return process('count', data=data, condition=condition, context=context)


def create_raster_cube() -> ProcessBuilder:
    """
    Create an empty raster data cube

    :return: An empty raster data cube with zero dimensions.
    """
    return process('create_raster_cube', )


def cummax(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Cumulative maxima

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is set for all the following elements.

    :return: An array with the computed cumulative maxima.
    """
    return process('cummax', data=data, ignore_nodata=ignore_nodata)


def cummin(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Cumulative minima

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is set for all the following elements.

    :return: An array with the computed cumulative minima.
    """
    return process('cummin', data=data, ignore_nodata=ignore_nodata)


def cumproduct(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Cumulative products

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is set for all the following elements.

    :return: An array with the computed cumulative products.
    """
    return process('cumproduct', data=data, ignore_nodata=ignore_nodata)


def cumsum(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Cumulative sums

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is set for all the following elements.

    :return: An array with the computed cumulative sums.
    """
    return process('cumsum', data=data, ignore_nodata=ignore_nodata)


def debug(data, code=UNSET, level=UNSET, message=UNSET) -> ProcessBuilder:
    """
    Publish debugging information

    :param data: Data to publish.
    :param code: An identifier to help identify the log entry in a bunch of other log entries.
    :param level: The severity level of this message, defaults to `info`. Note that the level `error` forces
        the computation to be stopped!
    :param message: A message to send in addition to the data.

    :return: Returns the data as passed to the `data` parameter.
    """
    return process('debug', data=data, code=code, level=level, message=message)


def dimension_labels(data, dimension) -> ProcessBuilder:
    """
    Get the dimension labels

    :param data: The data cube.
    :param dimension: The name of the dimension to get the labels for.

    :return: The labels as array.
    """
    return process('dimension_labels', data=data, dimension=dimension)


def divide(x, y) -> ProcessBuilder:
    """
    Division of two numbers

    :param x: The dividend.
    :param y: The divisor.

    :return: The computed result.
    """
    return process('divide', x=x, y=y)


def drop_dimension(data, name) -> ProcessBuilder:
    """
    Remove a dimension

    :param data: The data cube to drop a dimension from.
    :param name: Name of the dimension to drop.

    :return: A data cube without the specified dimension. The number of dimensions decreases by one, but the
        dimension properties (name, type, labels, reference system and resolution) for all other dimensions remain
        unchanged.
    """
    return process('drop_dimension', data=data, name=name)


def e() -> ProcessBuilder:
    """
    Euler's number (e)

    :return: The numerical value of Euler's number.
    """
    return process('e', )


def eq(x, y, delta=UNSET, case_sensitive=UNSET) -> ProcessBuilder:
    """
    Equal to comparison

    :param x: First operand.
    :param y: Second operand.
    :param delta: Only applicable for comparing two numbers. If this optional parameter is set to a positive
        non-zero number the equality of two numbers is checked against a delta value. This is especially useful to
        circumvent problems with floating point inaccuracy in machine-based computation.  This option is basically
        an alias for the following computation: `lte(abs(minus([x, y]), delta)`
    :param case_sensitive: Only applicable for comparing two strings. Case sensitive comparison can be disabled
        by setting this parameter to `false`.

    :return: Returns `true` if `x` is equal to `y`, `null` if any operand is `null`, otherwise `false`.
    """
    return process('eq', x=x, y=y, delta=delta, case_sensitive=case_sensitive)


def exp(p) -> ProcessBuilder:
    """
    Exponentiation to the base e

    :param p: The numerical exponent.

    :return: The computed value for *e* raised to the power of `p`.
    """
    return process('exp', p=p)


def extrema(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Minimum and maximum values

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that an array with two `null` values is returned if any
        value is such a value.

    :return: An array containing the minimum and maximum values for the specified numbers. The first element is
        the minimum, the second element is the maximum. If the input array is empty both elements are set to
        `null`.
    """
    return process('extrema', data=data, ignore_nodata=ignore_nodata)


def filter_bands(data, bands=UNSET, wavelengths=UNSET) -> ProcessBuilder:
    """
    Filter the bands by name

    :param data: A data cube with bands.
    :param bands: A list of band names. Either the unique band name (metadata field `name` in bands) or one of
        the common band names (metadata field `common_name` in bands). If unique band name and common name
        conflict, the unique band name has higher priority.  The order of the specified array defines the order of
        the bands in the data cube. If multiple bands match a common name, all matched bands are included in the
        original order.
    :param wavelengths: A list of sub-lists with each sub-list consisting of two elements. The first element is
        the minimum wavelength and the second element is the maximum wavelength. Wavelengths are specified in
        micrometres (μm).  The order of the specified array defines the order of the bands in the data cube. If
        multiple bands match the wavelengths, all matched bands are included in the original order.

    :return: A data cube limited to a subset of its original bands. The dimensions and dimension properties
        (name, type, labels, reference system and resolution) remain unchanged, except that the dimension of type
        `bands` has less (or the same) dimension labels.
    """
    return process('filter_bands', data=data, bands=bands, wavelengths=wavelengths)


def filter_bbox(data, extent) -> ProcessBuilder:
    """
    Spatial filter using a bounding box

    :param data: A data cube.
    :param extent: A bounding box, which may include a vertical axis (see `base` and `height`).

    :return: A data cube restricted to the bounding box. The dimensions and dimension properties (name, type,
        labels, reference system and resolution) remain unchanged, except that the spatial dimensions have less (or
        the same) dimension labels.
    """
    return process('filter_bbox', data=data, extent=extent)


def filter_labels(data, condition, dimension, context=UNSET) -> ProcessBuilder:
    """
    Filter dimension labels based on a condition

    :param data: A data cube.
    :param condition: A condition that is evaluated against each dimension label in the specified dimension. A
        dimension label and the corresponding data is preserved for the given dimension, if the condition returns
        `true`.
    :param dimension: The name of the dimension to filter on. Fails with a `DimensionNotAvailable` error if the
        specified dimension does not exist.
    :param context: Additional data to be passed to the condition.

    :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
        system and resolution) remain unchanged, except that the given dimension has less (or the same) dimension
        labels.
    """
    return process('filter_labels', data=data, condition=condition, dimension=dimension, context=context)


def filter_spatial(data, geometries) -> ProcessBuilder:
    """
    Spatial filter using geometries

    :param data: A data cube.
    :param geometries: One or more geometries used for filtering, specified as GeoJSON.

    :return: A data cube restricted to the specified geometries. The dimensions and dimension properties (name,
        type, labels, reference system and resolution) remain unchanged, except that the spatial dimensions have
        less (or the same) dimension labels.
    """
    return process('filter_spatial', data=data, geometries=geometries)


def filter_temporal(data, extent, dimension=UNSET) -> ProcessBuilder:
    """
    Temporal filter for a temporal intervals

    :param data: A data cube.
    :param extent: Left-closed temporal interval, i.e. an array with exactly two elements:  1. The first
        element is the start of the temporal interval. The specified instance in time is **included** in the
        interval. 2. The second element is the end of the temporal interval. The specified instance in time is
        **excluded** from the interval.  The specified temporal strings follow [RFC
        3339](https://tools.ietf.org/html/rfc3339). Also supports open intervals by setting one of the boundaries
        to `null`, but never both.
    :param dimension: The name of the temporal dimension to filter on. If the dimension is not set or is set to
        `null`, the filter applies to all temporal dimensions. Fails with a `DimensionNotAvailable` error if the
        specified dimension does not exist.

    :return: A data cube restricted to the specified temporal extent. The dimensions and dimension properties
        (name, type, labels, reference system and resolution) remain unchanged, except that the given temporal
        dimension(s) have less (or the same) dimension labels.
    """
    return process('filter_temporal', data=data, extent=extent, dimension=dimension)


def first(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    First element

    :param data: An array with elements of any data type.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if the first value is such a
        value.

    :return: The first element of the input array.
    """
    return process('first', data=data, ignore_nodata=ignore_nodata)


def floor(x) -> ProcessBuilder:
    """
    Round fractions down

    :param x: A number to round down.

    :return: The number rounded down.
    """
    return process('floor', x=x)


def gt(x, y) -> ProcessBuilder:
    """
    Greater than comparison

    :param x: First operand.
    :param y: Second operand.

    :return: `true` if `x` is strictly greater than `y` or `null` if any operand is `null`, otherwise `false`.
    """
    return process('gt', x=x, y=y)


def gte(x, y) -> ProcessBuilder:
    """
    Greater than or equal to comparison

    :param x: First operand.
    :param y: Second operand.

    :return: `true` if `x` is greater than or equal to `y`, `null` if any operand is `null`, otherwise `false`.
    """
    return process('gte', x=x, y=y)


def if_(value, accept, reject=UNSET) -> ProcessBuilder:
    """
    If-Then-Else conditional

    :param value: A boolean value.
    :param accept: A value that is returned if the boolean value is `true`.
    :param reject: A value that is returned if the boolean value is **not** `true`. Defaults to `null`.

    :return: Either the `accept` or `reject` argument depending on the given boolean value.
    """
    return process('if', value=value, accept=accept, reject=reject)


def int(x) -> ProcessBuilder:
    """
    Integer part of a number

    :param x: A number.

    :return: Integer part of the number.
    """
    return process('int', x=x)


def is_nan(x) -> ProcessBuilder:
    """
    Value is not a number

    :param x: The data to check.

    :return: `true` if the data is not a number, otherwise `false`
    """
    return process('is_nan', x=x)


def is_nodata(x) -> ProcessBuilder:
    """
    Value is not a no-data value

    :param x: The data to check.

    :return: `true` if the data is a no-data value, otherwise `false`
    """
    return process('is_nodata', x=x)


def is_valid(x) -> ProcessBuilder:
    """
    Value is valid data

    :param x: The data to check.

    :return: `true` if the data is valid, otherwise `false`.
    """
    return process('is_valid', x=x)


def last(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Last element

    :param data: An array with elements of any data type.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if the last value is such a value.

    :return: The last element of the input array.
    """
    return process('last', data=data, ignore_nodata=ignore_nodata)


def linear_scale_range(x, inputMin, inputMax, outputMin=UNSET, outputMax=UNSET) -> ProcessBuilder:
    """
    Linear transformation between two ranges

    :param x: A number to transform. The number gets clipped to the bounds specified in `inputMin` and
        `inputMax`.
    :param inputMin: Minimum value the input can obtain.
    :param inputMax: Maximum value the input can obtain.
    :param outputMin: Minimum value of the desired output range.
    :param outputMax: Maximum value of the desired output range.

    :return: The transformed number.
    """
    return process('linear_scale_range', x=x, inputMin=inputMin, inputMax=inputMax, outputMin=outputMin, outputMax=outputMax)


def ln(x) -> ProcessBuilder:
    """
    Natural logarithm

    :param x: A number to compute the natural logarithm for.

    :return: The computed natural logarithm.
    """
    return process('ln', x=x)


def load_collection(id, spatial_extent, temporal_extent, bands=UNSET, properties=UNSET) -> ProcessBuilder:
    """
    Load a collection

    :param id: The collection id.
    :param spatial_extent: Limits the data to load from the collection to the specified bounding box or
        polygons.  The process puts a pixel into the data cube if the point at the pixel center intersects with the
        bounding box or any of the polygons (as defined in the Simple Features standard by the OGC).  The GeoJSON
        can be one of the following GeoJSON types:  * A `Polygon` geometry, * a `GeometryCollection` containing
        Polygons, * a `Feature` with a `Polygon` geometry or * a `FeatureCollection` containing `Feature`s with a
        `Polygon` geometry.  Set this parameter to `null` to set no limit for the spatial extent. Be careful with
        this when loading large datasets!
    :param temporal_extent: Limits the data to load from the collection to the specified left-closed temporal
        interval. Applies to all temporal dimensions. The interval has to be specified as an array with exactly two
        elements:  1. The first element is the start of the temporal interval. The specified instance in time is
        **included** in the interval. 2. The second element is the end of the temporal interval. The specified
        instance in time is **excluded** from the interval.  The specified temporal strings follow [RFC
        3339](https://tools.ietf.org/html/rfc3339). Also supports open intervals by setting one of the boundaries
        to `null`, but never both.  Set this parameter to `null` to set no limit for the spatial extent. Be careful
        with this when loading large datasets!
    :param bands: Only adds the specified bands into the data cube so that bands that don't match the list of
        band names are not available. Applies to all dimensions of type `bands`.  Either the unique band name
        (metadata field `name` in bands) or one of the common band names (metadata field `common_name` in bands)
        can be specified. If unique band name and common name conflict, the unique band name has higher priority.
        The order of the specified array defines the order of the bands in the data cube. f multiple bands match a
        common name, all matched bands are included in the original order.
    :param properties: Limits the data by metadata properties to include only data in the data cube which all
        given conditions return `true` for (AND operation).  Specify key-value-pairs with the key being the name of
        the metadata property, which can be retrieved with the openEO Data Discovery for Collections. The value
        must a condition (user-defined process) to be evaluated against the collection metadata, see the example.

    :return: A data cube for further processing. The dimensions and dimension properties (name, type, labels,
        reference system and resolution) correspond to the collection's metadata, but the dimension labels are
        restricted as specified in the parameters.
    """
    return process('load_collection', id=id, spatial_extent=spatial_extent, temporal_extent=temporal_extent, bands=bands, properties=properties)


def load_result(id) -> ProcessBuilder:
    """
    Load batch job results

    :param id: The id of a batch job with results.

    :return: A data cube for further processing.
    """
    return process('load_result', id=id)


def load_uploaded_files(paths, format, options=UNSET) -> ProcessBuilder:
    """
    Load files from the user workspace

    :param paths: The files to read. Folders can't be specified, instead specify all files. An error is thrown
        if a file can't be read.
    :param format: The file format to read from. It must be one of the values that the server reports as
        supported input file formats, which usually correspond to the short GDAL/OGR codes. If the format is not
        suitable for loading the data, a `FormatUnsuitable` exception will be thrown. This parameter is *case
        insensitive*.
    :param options: The file format parameters to be used to read the files. Must correspond to the parameters
        that the server reports as supported parameters for the chosen `format`. The parameter names and valid
        values usually correspond to the GDAL/OGR format options.

    :return: A data cube for further processing.
    """
    return process('load_uploaded_files', paths=paths, format=format, options=options)


def log(x, base) -> ProcessBuilder:
    """
    Logarithm to a base

    :param x: A number to compute the logarithm for.
    :param base: The numerical base.

    :return: The computed logarithm.
    """
    return process('log', x=x, base=base)


def lt(x, y) -> ProcessBuilder:
    """
    Less than comparison

    :param x: First operand.
    :param y: Second operand.

    :return: `true` if `x` is strictly less than `y`, `null` if any operand is `null`, otherwise `false`.
    """
    return process('lt', x=x, y=y)


def lte(x, y) -> ProcessBuilder:
    """
    Less than or equal to comparison

    :param x: First operand.
    :param y: Second operand.

    :return: `true` if `x` is less than or equal to `y`, `null` if any operand is `null`, otherwise `false`.
    """
    return process('lte', x=x, y=y)


def mask(data, mask, replacement=UNSET) -> ProcessBuilder:
    """
    Apply a raster mask

    :param data: A raster data cube.
    :param mask: A mask as raster data cube. Every pixel in `data` must have a corresponding element in `mask`.
    :param replacement: The value used to replace masked values with.

    :return: A masked raster data cube with the same dimensions. The dimension properties (name, type, labels,
        reference system and resolution) remain unchanged.
    """
    return process('mask', data=data, mask=mask, replacement=replacement)


def mask_polygon(data, mask, replacement=UNSET, inside=UNSET) -> ProcessBuilder:
    """
    Apply a polygon mask

    :param data: A raster data cube.
    :param mask: A GeoJSON object containing a polygon. The provided feature types can be one of the following:
        * A `Polygon` geometry, * a `GeometryCollection` containing Polygons, * a `Feature` with a `Polygon`
        geometry or * a `FeatureCollection` containing `Feature`s with a `Polygon` geometry.
    :param replacement: The value used to replace masked values with.
    :param inside: If set to `true` all pixels for which the point at the pixel center **does** intersect with
        any polygon are replaced.

    :return: A masked raster data cube with the same dimensions. The dimension properties (name, type, labels,
        reference system and resolution) remain unchanged.
    """
    return process('mask_polygon', data=data, mask=mask, replacement=replacement, inside=inside)


def max(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Maximum value

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The maximum value.
    """
    return process('max', data=data, ignore_nodata=ignore_nodata)


def mean(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Arithmetic mean (average)

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The computed arithmetic mean.
    """
    return process('mean', data=data, ignore_nodata=ignore_nodata)


def median(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Statistical median

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The computed statistical median.
    """
    return process('median', data=data, ignore_nodata=ignore_nodata)


def merge_cubes(cube1, cube2, overlap_resolver=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Merging two data cubes

    :param cube1: The first data cube.
    :param cube2: The second data cube.
    :param overlap_resolver: A reduction operator that resolves the conflict if the data overlaps. The reducer
        must return a value of the same data type as the input values are. The reduction operator may be a single
        process such as ``multiply()`` or consist of multiple sub-processes. `null` (the default) can be specified
        if no overlap resolver is required.
    :param context: Additional data to be passed to the overlap resolver.

    :return: The merged data cube. See the process description for details regarding the dimensions and
        dimension properties (name, type, labels, reference system and resolution).
    """
    return process('merge_cubes', cube1=cube1, cube2=cube2, overlap_resolver=overlap_resolver, context=context)


def min(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Minimum value

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The minimum value.
    """
    return process('min', data=data, ignore_nodata=ignore_nodata)


def mod(x, y) -> ProcessBuilder:
    """
    Modulo

    :param x: A number to be used as dividend.
    :param y: A number to be used as divisor.

    :return: The remainder after division.
    """
    return process('mod', x=x, y=y)


def multiply(x, y) -> ProcessBuilder:
    """
    Multiplication of two numbers

    :param x: The multiplier.
    :param y: The multiplicand.

    :return: The computed product of the two numbers.
    """
    return process('multiply', x=x, y=y)


def ndvi(data, nir=UNSET, red=UNSET, target_band=UNSET) -> ProcessBuilder:
    """
    Normalized Difference Vegetation Index

    :param data: A raster data cube with two bands that have the common names `red` and `nir` assigned.
    :param nir: The name of the NIR band. Defaults to the band that has the common name `nir` assigned.  Either
        the unique band name (metadata field `name` in bands) or one of the common band names (metadata field
        `common_name` in bands) can be specified. If unique band name and common name conflict, the unique band
        name has higher priority.
    :param red: The name of the red band. Defaults to the band that has the common name `red` assigned.  Either
        the unique band name (metadata field `name` in bands) or one of the common band names (metadata field
        `common_name` in bands) can be specified. If unique band name and common name conflict, the unique band
        name has higher priority.
    :param target_band: By default, the dimension of type `bands` is dropped. To keep the dimension specify a
        new band name in this parameter so that a new dimension label with the specified name will be added for the
        computed values.

    :return: A raster data cube containing the computed NDVI values. The structure of the data cube differs
        depending on the value passed to `target_band`:  * `target_band` is `null`: The data cube does not contain
        the dimension of type `bands` any more, the number of dimensions decreases by one. The dimension properties
        (name, type, labels, reference system and resolution) for all other dimensions remain unchanged. *
        `target_band` is a string: The data cube keeps the same dimensions. The dimension properties remain
        unchanged, but the number of dimension labels for the dimension of type `bands` increases by one. The
        additional label is named as specified in `target_band`.
    """
    return process('ndvi', data=data, nir=nir, red=red, target_band=target_band)


def neq(x, y, delta=UNSET, case_sensitive=UNSET) -> ProcessBuilder:
    """
    Not equal to comparison

    :param x: First operand.
    :param y: Second operand.
    :param delta: Only applicable for comparing two numbers. If this optional parameter is set to a positive
        non-zero number the non-equality of two numbers is checked against a delta value. This is especially useful
        to circumvent problems with floating point inaccuracy in machine-based computation.  This option is
        basically an alias for the following computation: `gt(abs(minus([x, y]), delta)`
    :param case_sensitive: Only applicable for comparing two strings. Case sensitive comparison can be disabled
        by setting this parameter to `false`.

    :return: Returns `true` if `x` is *not* equal to `y`, `null` if any operand is `null`, otherwise `false`.
    """
    return process('neq', x=x, y=y, delta=delta, case_sensitive=case_sensitive)


def normalized_difference(x, y) -> ProcessBuilder:
    """
    Normalized difference

    :param x: The value for the first band.
    :param y: The value for the second band.

    :return: The computed normalized difference.
    """
    return process('normalized_difference', x=x, y=y)


def not_(x) -> ProcessBuilder:
    """
    Inverting a boolean

    :param x: Boolean value to invert.

    :return: Inverted boolean value.
    """
    return process('not', x=x)


def or_(x, y) -> ProcessBuilder:
    """
    Logical OR

    :param x: A boolean value.
    :param y: A boolean value.

    :return: Boolean result of the logical OR.
    """
    return process('or', x=x, y=y)


def order(data, asc=UNSET, nodata=UNSET) -> ProcessBuilder:
    """
    Create a permutation

    :param data: An array to compute the order for.
    :param asc: The default sort order is ascending, with smallest values first. To sort in reverse
        (descending) order, set this parameter to `false`.
    :param nodata: Controls the handling of no-data values (`null`). By default they are removed. If `true`,
        missing values in the data are put last; if `false`, they are put first.

    :return: The computed permutation.
    """
    return process('order', data=data, asc=asc, nodata=nodata)


def pi() -> ProcessBuilder:
    """
    Pi (π)

    :return: The numerical value of Pi.
    """
    return process('pi', )


def power(base, p) -> ProcessBuilder:
    """
    Exponentiation

    :param base: The numerical base.
    :param p: The numerical exponent.

    :return: The computed value for `base` raised to the power of `p`.
    """
    return process('power', base=base, p=p)


def product(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Compute the product by multiplying numbers

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The computed product of the sequence of numbers.
    """
    return process('product', data=data, ignore_nodata=ignore_nodata)


def quantiles(data, probabilities=UNSET, q=UNSET, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Quantiles

    :param data: An array of numbers.
    :param probabilities: A list of probabilities to calculate quantiles for. The probabilities must be between
        0 and 1.
    :param q: A number of intervals to calculate quantiles for. Calculates q-quantiles with (nearly) equal-
        sized intervals.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that an array with `null` values is returned if any
        element is such a value.

    :return: An array with the computed quantiles. The list has either  * as many elements as the given list of
        `probabilities` had or * *`q`-1* elements.  If the input array is empty the resulting array is filled with
        as many `null` values as required according to the list above. For an example, see the 'Empty array
        example'.
    """
    return process('quantiles', data=data, probabilities=probabilities, q=q, ignore_nodata=ignore_nodata)


def rearrange(data, order) -> ProcessBuilder:
    """
    Rearrange an array based on a permutation

    :param data: The array to rearrange.
    :param order: The permutation used for rearranging.

    :return: The rearranged array.
    """
    return process('rearrange', data=data, order=order)


def reduce_dimension(data, reducer, dimension, context=UNSET) -> ProcessBuilder:
    """
    Reduce dimensions

    :param data: A data cube.
    :param reducer: A reducer to apply on the specified dimension. A reducer is a single process such as
        ``mean()`` or a set of processes, which computes a single value for a list of values, see the category
        'reducer' for such processes.
    :param dimension: The name of the dimension over which to reduce. Fails with a `DimensionNotAvailable`
        error if the specified dimension does not exist.
    :param context: Additional data to be passed to the reducer.

    :return: A data cube with the newly computed values. It is missing the given dimension, the number of
        dimensions decreases by one. The dimension properties (name, type, labels, reference system and resolution)
        for all other dimensions remain unchanged.
    """
    return process('reduce_dimension', data=data, reducer=reducer, dimension=dimension, context=context)


def reduce_dimension_binary(data, reducer, dimension, context=UNSET) -> ProcessBuilder:
    """
    Reduce dimensions using binary reduction

    :param data: A data cube.
    :param reducer: A reduction operator to be applied consecutively on pairs of values. It must be both
        associative and commutative as the execution may be executed in parallel and therefore the order of
        execution is arbitrary. The reduction operator may be a single process such as ``multiply()`` or consist of
        multiple sub-processes.
    :param dimension: The name of the dimension over which to reduce. Fails with a `DimensionNotAvailable`
        error if the specified dimension does not exist.
    :param context: Additional data to be passed to the reducer.

    :return: A data cube with the newly computed values. It is missing the given dimension, the number of
        dimensions decreases by one. The dimension properties (name, type, labels, reference system and resolution)
        for all other dimensions remain unchanged.
    """
    return process('reduce_dimension_binary', data=data, reducer=reducer, dimension=dimension, context=context)


def rename_dimension(data, source, target) -> ProcessBuilder:
    """
    Rename a dimension

    :param data: The data cube.
    :param source: The current name of the dimension. Fails with a `DimensionNotAvailable` error if the
        specified dimension does not exist.
    :param target: A new Name for the dimension. Fails with a `DimensionExists` error if a dimension with the
        specified name exists.

    :return: A data cube with the same dimensions, but the name of one of the dimensions changes. The old name
        can not be referred to any longer. The dimension properties (name, type, labels, reference system and
        resolution) remain unchanged.
    """
    return process('rename_dimension', data=data, source=source, target=target)


def rename_labels(data, dimension, target, source=UNSET) -> ProcessBuilder:
    """
    Rename dimension labels

    :param data: The data cube.
    :param dimension: The name of the dimension to rename the labels for.
    :param target: The new names for the labels. The dimension labels in the data cube are expected to be
        enumerated, if the parameter `target` is not specified. If a target dimension label already exists in the
        data cube, a `LabelExists` error is thrown.
    :param source: The names of the labels as they are currently in the data cube. The array defines an
        unsorted and potentially incomplete list of labels that should be renamed to the names available in the
        corresponding array elements in the parameter `target`. If one of the source dimension labels doesn't
        exist, a `LabelNotAvailable` error is thrown. By default, the array is empty so that the dimension labels
        in the data cube are expected to be enumerated.

    :return: The data cube with the same dimensions. The dimension properties (name, type, labels, reference
        system and resolution) remain unchanged, except that for the given dimension the labels change. The old
        labels can not be referred to any longer. The number of labels remains the same.
    """
    return process('rename_labels', data=data, dimension=dimension, target=target, source=source)


def resample_cube_spatial(data, target, method=UNSET) -> ProcessBuilder:
    """
    Resample the spatial dimensions to match a target data cube

    :param data: A data cube.
    :param target: A data cube that describes the spatial target resolution.
    :param method: Resampling method. Methods are inspired by GDAL, see
        [gdalwarp](https://www.gdal.org/gdalwarp.html) for more information.

    :return: A data cube with the same dimensions. The dimension properties (name, type, labels, reference
        system and resolution) remain unchanged, except for the resolution and dimension labels of the spatial
        dimensions.
    """
    return process('resample_cube_spatial', data=data, target=target, method=method)


def resample_cube_temporal(data, target, method, dimension=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Resample a temporal dimension to match a target data cube

    :param data: A data cube.
    :param target: A data cube that describes the temporal target resolution.
    :param method: A resampling method to be applied, could be a reducer for downsampling or other methods for
        upsampling. A reducer is a single process such as ``mean()`` or a set of processes, which computes a single
        value for a list of values, see the category 'reducer' for such processes.
    :param dimension: The name of the temporal dimension to resample, which must exist with this name in both
        data cubes. If the dimension is not set or is set to `null`, the data cube is expected to only have one
        temporal dimension. Fails with a `TooManyDimensions` error if it has more dimensions. Fails with a
        `DimensionNotAvailable` error if the specified dimension does not exist.
    :param context: Additional data to be passed to the process specified for the parameter `method`.

    :return: A raster data cube with the same dimensions and the same dimension properties (name, type, labels,
        reference system and resolution) for all non-temporal dimensions. For the temporal dimension the name and
        type remain unchanged, but the reference system changes and the labels and resolution may change.
    """
    return process('resample_cube_temporal', data=data, target=target, method=method, dimension=dimension, context=context)


def resample_spatial(data, resolution=UNSET, projection=UNSET, method=UNSET, align=UNSET) -> ProcessBuilder:
    """
    Resample and warp the spatial dimensions

    :param data: A raster data cube.
    :param resolution: Resamples the data cube to the target resolution, which can be specified either as
        separate values for x and y or as a single value for both axes. Specified in the units of the target
        projection. Doesn't change the resolution by default (`0`).
    :param projection: Warps the data cube to the target projection, specified as as [EPSG
        code](http://www.epsg-registry.org/), [WKT2 (ISO 19162)
        string](http://docs.opengeospatial.org/is/18-010r7/18-010r7.html), [PROJ definition
        (deprecated)](https://proj.org/usage/quickstart.html). By default (`null`), the projection is not changed.
    :param method: Resampling method. Methods are inspired by GDAL, see
        [gdalwarp](https://www.gdal.org/gdalwarp.html) for more information.
    :param align: Specifies to which corner of the spatial extent the new resampled data is aligned to.

    :return: A raster data cube with values warped onto the new projection. It has the same dimensions and the
        same dimension properties (name, type, labels, reference system and resolution) for all non-spatial or
        vertical spatial dimensions. For the horizontal spatial dimensions the name and type remain unchanged, but
        reference system, labels and resolution may change depending on the given parameters.
    """
    return process('resample_spatial', data=data, resolution=resolution, projection=projection, method=method, align=align)


def round(x, p=UNSET) -> ProcessBuilder:
    """
    Round to a specified precision

    :param x: A number to round.
    :param p: A positive number specifies the number of digits after the decimal point to round to. A negative
        number means rounding to a power of ten, so for example *-2* rounds to the nearest hundred. Defaults to
        *0*.

    :return: The rounded number.
    """
    return process('round', x=x, p=p)


def run_udf(data, udf, runtime, version=UNSET, context=UNSET) -> ProcessBuilder:
    """
    Run an UDF

    :param data: The data to be passed to the UDF as array or raster data cube.
    :param udf: Either source code, an absolute URL or a path to an UDF script.
    :param runtime: An UDF runtime identifier available at the back-end.
    :param version: An UDF runtime version. If set to `null`, the default runtime version specified for each
        runtime is used.
    :param context: Additional data such as configuration options that should be passed to the UDF.

    :return: The data processed by the UDF.  * Returns a raster data cube, if a raster data cube is passed for
        `data`. Details on the dimensions and dimension properties (name, type, labels, reference system and
        resolution) depend on the UDF. * If an array is passed for `data`, the returned value can be of any data
        type, but is exactly what the UDF returns.
    """
    return process('run_udf', data=data, udf=udf, runtime=runtime, version=version, context=context)


def run_udf_externally(data, url, context=UNSET) -> ProcessBuilder:
    """
    Run an externally hosted UDF container

    :param data: The data to be passed to the UDF as array or raster data cube.
    :param url: URL to a remote UDF service.
    :param context: Additional data such as configuration options that should be passed to the UDF.

    :return: The data processed by the UDF service.  * Returns a raster data cube, if a raster data cube is
        passed for `data`. Details on the dimensions and dimension properties (name, type, labels, reference system
        and resolution) depend on the UDF. * If an array is passed for `data`, the returned value can be of any
        data type, but is exactly what the UDF returns.
    """
    return process('run_udf_externally', data=data, url=url, context=context)


def save_result(data, format, options=UNSET) -> ProcessBuilder:
    """
    Save processed data to storage

    :param data: The data to save.
    :param format: The file format to save to. It must be one of the values that the server reports as
        supported output file formats, which usually correspond to the short GDAL/OGR codes. If the format is not
        suitable for storing the underlying data structure, a `FormatUnsuitable` exception will be thrown. This
        parameter is *case insensitive*.
    :param options: The file format parameters to be used to create the file(s). Must correspond to the
        parameters that the server reports as supported parameters for the chosen `format`. The parameter names and
        valid values usually correspond to the GDAL/OGR format options.

    :return: `false` if saving failed, `true` otherwise.
    """
    return process('save_result', data=data, format=format, options=options)


def sd(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Standard deviation

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The computed sample standard deviation.
    """
    return process('sd', data=data, ignore_nodata=ignore_nodata)


def sgn(x) -> ProcessBuilder:
    """
    Signum

    :param x: A number.

    :return: The computed signum value of `x`.
    """
    return process('sgn', x=x)


def sin(x) -> ProcessBuilder:
    """
    Sine

    :param x: An angle in radians.

    :return: The computed sine of `x`.
    """
    return process('sin', x=x)


def sinh(x) -> ProcessBuilder:
    """
    Hyperbolic sine

    :param x: An angle in radians.

    :return: The computed hyperbolic sine of `x`.
    """
    return process('sinh', x=x)


def sort(data, asc=UNSET, nodata=UNSET) -> ProcessBuilder:
    """
    Sort data

    :param data: An array with data to sort.
    :param asc: The default sort order is ascending, with smallest values first. To sort in reverse
        (descending) order, set this parameter to `false`.
    :param nodata: Controls the handling of no-data values (`null`). By default they are removed. If `true`,
        missing values in the data are put last; if `false`, they are put first.

    :return: The sorted array.
    """
    return process('sort', data=data, asc=asc, nodata=nodata)


def sqrt(x) -> ProcessBuilder:
    """
    Square root

    :param x: A number.

    :return: The computed square root.
    """
    return process('sqrt', x=x)


def subtract(x, y) -> ProcessBuilder:
    """
    Subtraction of two numbers

    :param x: The minuend.
    :param y: The subtrahend.

    :return: The computed result.
    """
    return process('subtract', x=x, y=y)


def sum(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Compute the sum by adding up numbers

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The computed sum of the sequence of numbers.
    """
    return process('sum', data=data, ignore_nodata=ignore_nodata)


def tan(x) -> ProcessBuilder:
    """
    Tangent

    :param x: An angle in radians.

    :return: The computed tangent of `x`.
    """
    return process('tan', x=x)


def tanh(x) -> ProcessBuilder:
    """
    Hyperbolic tangent

    :param x: An angle in radians.

    :return: The computed hyperbolic tangent of `x`.
    """
    return process('tanh', x=x)


def text_begins(data, pattern, case_sensitive=UNSET) -> ProcessBuilder:
    """
    Text begins with another text

    :param data: Text in which to find something at the beginning.
    :param pattern: Text to find at the beginning of `data`. Regular expressions are not supported.
    :param case_sensitive: Case sensitive comparison can be disabled by setting this parameter to `false`.

    :return: `true` if `data` begins with `pattern`, false` otherwise.
    """
    return process('text_begins', data=data, pattern=pattern, case_sensitive=case_sensitive)


def text_contains(data, pattern, case_sensitive=UNSET) -> ProcessBuilder:
    """
    Text contains another text

    :param data: Text in which to find something in.
    :param pattern: Text to find in `data`. Regular expressions are not supported.
    :param case_sensitive: Case sensitive comparison can be disabled by setting this parameter to `false`.

    :return: `true` if `data` contains the `pattern`, false` otherwise.
    """
    return process('text_contains', data=data, pattern=pattern, case_sensitive=case_sensitive)


def text_ends(data, pattern, case_sensitive=UNSET) -> ProcessBuilder:
    """
    Text ends with another text

    :param data: Text in which to find something at the end.
    :param pattern: Text to find at the end of `data`. Regular expressions are not supported.
    :param case_sensitive: Case sensitive comparison can be disabled by setting this parameter to `false`.

    :return: `true` if `data` ends with `pattern`, false` otherwise.
    """
    return process('text_ends', data=data, pattern=pattern, case_sensitive=case_sensitive)


def text_merge(data, separator=UNSET) -> ProcessBuilder:
    """
    Concatenate elements to a string

    :param data: A set of elements. Numbers, boolean values and null values get converted to their (lower case)
        string representation. For example: `1` (integer), `-1.5` (number), `true` / `false` (boolean values)
    :param separator: A separator to put between each of the individual texts. Defaults to an empty string.

    :return: Returns a string containing a string representation of all the array elements in the same order,
        with the separator between each element.
    """
    return process('text_merge', data=data, separator=separator)


def trim_cube(data) -> ProcessBuilder:
    """
    Remove dimension labels with no-data values

    :param data: A raster data cube to trim.

    :return: A trimmed raster data cube with the same dimensions. The dimension properties name, type,
        reference system and resolution remain unchanged. The number of dimension labels may decrease.
    """
    return process('trim_cube', data=data)


def variance(data, ignore_nodata=UNSET) -> ProcessBuilder:
    """
    Variance

    :param data: An array of numbers.
    :param ignore_nodata: Indicates whether no-data values are ignored or not. Ignores them by default. Setting
        this flag to `false` considers no-data values so that `null` is returned if any value is such a value.

    :return: The computed sample variance.
    """
    return process('variance', data=data, ignore_nodata=ignore_nodata)


def xor(x, y) -> ProcessBuilder:
    """
    Logical XOR (exclusive or)

    :param x: A boolean value.
    :param y: A boolean value.

    :return: Boolean result of the logical XOR.
    """
    return process('xor', x=x, y=y)


