# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BackupSchedule(Model):
    """
    Description of a backup schedule. Describes how often should be the backup
    performed and what should be the retention policy.

    :param int frequency_interval: How often should be the backup executed
     (e.g. for weekly backup, this should be set to 7 and FrequencyUnit
     should be set to Day)
    :param str frequency_unit: How often should be the backup executed (e.g.
     for weekly backup, this should be set to Day and FrequencyInterval
     should be set to 7). Possible values include: 'Day', 'Hour'
    :param bool keep_at_least_one_backup: True if the retention policy should
     always keep at least one backup in the storage account, regardless how
     old it is; false otherwise.
    :param int retention_period_in_days: After how many days backups should
     be deleted
    :param datetime start_time: When the schedule should start working
    :param datetime last_execution_time: The last time when this schedule was
     triggered
    """ 

    _validation = {
        'frequency_unit': {'required': True},
    }

    _attribute_map = {
        'frequency_interval': {'key': 'frequencyInterval', 'type': 'int'},
        'frequency_unit': {'key': 'frequencyUnit', 'type': 'FrequencyUnit'},
        'keep_at_least_one_backup': {'key': 'keepAtLeastOneBackup', 'type': 'bool'},
        'retention_period_in_days': {'key': 'retentionPeriodInDays', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_execution_time': {'key': 'lastExecutionTime', 'type': 'iso-8601'},
    }

    def __init__(self, frequency_unit, frequency_interval=None, keep_at_least_one_backup=None, retention_period_in_days=None, start_time=None, last_execution_time=None, **kwargs):
        self.frequency_interval = frequency_interval
        self.frequency_unit = frequency_unit
        self.keep_at_least_one_backup = keep_at_least_one_backup
        self.retention_period_in_days = retention_period_in_days
        self.start_time = start_time
        self.last_execution_time = last_execution_time
