# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Recommendation(Model):
    """
    Represents a recommendation result generated by the recommendation engine

    :param datetime creation_time: Timestamp when this instance was created.
    :param str recommendation_id: A GUID value that each recommendation
     object is associated with.
    :param str resource_id: Full ARM resource ID string that this
     recommendation object is associated with.
    :param str resource_scope: Name of a resource type this recommendation
     applies, e.g. Subscription, ServerFarm, Site.
    :param str rule_name: Unique name of the rule
    :param str display_name: UI friendly name of the rule (may not be unique)
    :param str message: Localized text of recommendation, good for UI.
    :param str level: Level indicating how critical this recommendation can
     impact. Possible values include: 'Critical', 'Warning', 'Information',
     'NonUrgentSuggestion'
    :param str channels: List of channels that this recommendation can apply.
     Possible values include: 'Notification', 'Api', 'Email', 'All'
    :param str action_name: Name of action recommended by this object.
    :param int enabled: On/off flag indicating the rule is currently enabled
     or disabled.
    :param datetime next_notification_time: When to notify this
     recommendation next. Null means that this will never be notified anymore.
    :param datetime notification_expiration_time: Date and time when this
     notification expires.
    :param datetime notified_time: Last timestamp this instance was actually
     notified. Null means that this recommendation hasn't been notified yet.
    :param float score: A metric value measured by the rule.
    """ 

    _validation = {
        'level': {'required': True},
        'channels': {'required': True},
    }

    _attribute_map = {
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'recommendation_id': {'key': 'recommendationId', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'resource_scope': {'key': 'resourceScope', 'type': 'str'},
        'rule_name': {'key': 'ruleName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'level': {'key': 'level', 'type': 'NotificationLevel'},
        'channels': {'key': 'channels', 'type': 'Channels'},
        'action_name': {'key': 'actionName', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'int'},
        'next_notification_time': {'key': 'nextNotificationTime', 'type': 'iso-8601'},
        'notification_expiration_time': {'key': 'notificationExpirationTime', 'type': 'iso-8601'},
        'notified_time': {'key': 'notifiedTime', 'type': 'iso-8601'},
        'score': {'key': 'score', 'type': 'float'},
    }

    def __init__(self, level, channels, creation_time=None, recommendation_id=None, resource_id=None, resource_scope=None, rule_name=None, display_name=None, message=None, action_name=None, enabled=None, next_notification_time=None, notification_expiration_time=None, notified_time=None, score=None, **kwargs):
        self.creation_time = creation_time
        self.recommendation_id = recommendation_id
        self.resource_id = resource_id
        self.resource_scope = resource_scope
        self.rule_name = rule_name
        self.display_name = display_name
        self.message = message
        self.level = level
        self.channels = channels
        self.action_name = action_name
        self.enabled = enabled
        self.next_notification_time = next_notification_time
        self.notification_expiration_time = notification_expiration_time
        self.notified_time = notified_time
        self.score = score
