# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class ServerFarmWithRichSku(Resource):
    """
    App Service Plan Model

    :param str id: Resource Id
    :param str name: Resource Name
    :param str location: Resource Location
    :param str type: Resource type
    :param dict tags: Resource tags
    :param str server_farm_with_rich_sku_name: Name for the App Service Plan
    :param str worker_tier_name: Target worker tier assigned to the App
     Service Plan
    :param str status: App Service Plan Status. Possible values include:
     'Ready', 'Pending'
    :param str subscription: App Service Plan Subscription
    :param str admin_site_name: App Service Plan administration site
    :param HostingEnvironmentProfile hosting_environment_profile:
     Specification for the hosting environment (App Service Environment) to
     use for the App Service Plan
    :param int maximum_number_of_workers: Maximum number of instances that
     can be assigned to this App Service Plan
    :param str geo_region: Geographical location for the App Service Plan
    :param bool per_site_scaling: If True apps assigned to this App Service
     Plan can be scaled independently
     If False apps assigned to this App Service Plan will scale to
     all instances of the plan
    :param int number_of_sites: Number of web apps assigned to this App
     Service Plan
    :param str resource_group: Resource group of the serverfarm
    :param SkuDescription sku:
    """ 

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'server_farm_with_rich_sku_name': {'key': 'properties.name', 'type': 'str'},
        'worker_tier_name': {'key': 'properties.workerTierName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'StatusOptions'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'admin_site_name': {'key': 'properties.adminSiteName', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'maximum_number_of_workers': {'key': 'properties.maximumNumberOfWorkers', 'type': 'int'},
        'geo_region': {'key': 'properties.geoRegion', 'type': 'str'},
        'per_site_scaling': {'key': 'properties.perSiteScaling', 'type': 'bool'},
        'number_of_sites': {'key': 'properties.numberOfSites', 'type': 'int'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
    }

    def __init__(self, location, id=None, name=None, type=None, tags=None, server_farm_with_rich_sku_name=None, worker_tier_name=None, status=None, subscription=None, admin_site_name=None, hosting_environment_profile=None, maximum_number_of_workers=None, geo_region=None, per_site_scaling=None, number_of_sites=None, resource_group=None, sku=None, **kwargs):
        super(ServerFarmWithRichSku, self).__init__(id=id, name=name, location=location, type=type, tags=tags, **kwargs)
        self.server_farm_with_rich_sku_name = server_farm_with_rich_sku_name
        self.worker_tier_name = worker_tier_name
        self.status = status
        self.subscription = subscription
        self.admin_site_name = admin_site_name
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers = maximum_number_of_workers
        self.geo_region = geo_region
        self.per_site_scaling = per_site_scaling
        self.number_of_sites = number_of_sites
        self.resource_group = resource_group
        self.sku = sku
