"""remove unnecessary columns in polygon financials data

Revision ID: 29fe33d1bd8a
Revises: f23d2166896e
Create Date: 2024-06-06 00:54:08.669748

"""
from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "29fe33d1bd8a"
down_revision: Union[str, None] = "f23d2166896e"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column(
        "polygonapi_financials_data", "income_loss_from_continuing_operations_after_tax"
    )
    op.drop_column(
        "polygonapi_financials_data",
        "other_comprehensive_income_loss_attributable_to_parent",
    )
    op.drop_column(
        "polygonapi_financials_data", "net_income_loss_attributable_to_parent"
    )
    op.drop_column(
        "polygonapi_financials_data",
        "net_cash_flow_from_financing_activities_continuing",
    )
    op.drop_column(
        "polygonapi_financials_data",
        "income_loss_from_continuing_operations_before_tax",
    )
    op.drop_column(
        "polygonapi_financials_data",
        "net_cash_flow_from_operating_activities_continuing",
    )
    op.drop_column(
        "polygonapi_financials_data", "net_cash_flow_from_investing_activities"
    )
    op.drop_column(
        "polygonapi_financials_data",
        "net_income_loss_attributable_to_noncontrolling_interest",
    )
    op.drop_column("polygonapi_financials_data", "diluted_earnings_per_share")
    op.drop_column("polygonapi_financials_data", "net_cash_flow_continuing")
    op.drop_column(
        "polygonapi_financials_data",
        "net_cash_flow_from_investing_activities_continuing",
    )
    op.drop_column("polygonapi_financials_data", "income_tax_expense_benefit_deferred")
    op.drop_column("polygonapi_financials_data", "benefits_costs_expenses")
    op.drop_column(
        "polygonapi_financials_data", "net_cash_flow_from_operating_activities"
    )
    op.drop_column("polygonapi_financials_data", "net_income_loss")
    op.drop_column("polygonapi_financials_data", "interest_expense_operating")
    op.drop_column(
        "polygonapi_financials_data", "income_loss_from_equity_method_investments"
    )
    op.drop_column(
        "polygonapi_financials_data",
        "net_income_loss_available_to_common_stockholders_basic",
    )
    op.drop_column(
        "polygonapi_financials_data",
        "participating_securities_distributed_and_undistributed_earnings",
    )
    op.drop_column("polygonapi_financials_data", "operating_income_loss")
    op.drop_column(
        "polygonapi_financials_data", "preferred_stock_dividends_and_other_adjustments"
    )
    op.drop_column("polygonapi_financials_data", "costs_and_expenses")
    op.drop_column("polygonapi_financials_data", "income_tax_expense_benefit")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "income_tax_expense_benefit",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "costs_and_expenses",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "preferred_stock_dividends_and_other_adjustments",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "operating_income_loss",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "participating_securities_distributed_and_undistributed_earnings",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "net_income_loss_available_to_common_stockholders_basic",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "income_loss_from_equity_method_investments",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "interest_expense_operating",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "net_income_loss",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "net_cash_flow_from_operating_activities",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "benefits_costs_expenses",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "income_tax_expense_benefit_deferred",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "net_cash_flow_from_investing_activities_continuing",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "net_cash_flow_continuing",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "diluted_earnings_per_share",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "net_income_loss_attributable_to_noncontrolling_interest",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "net_cash_flow_from_investing_activities",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "net_cash_flow_from_operating_activities_continuing",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "income_loss_from_continuing_operations_before_tax",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "net_cash_flow_from_financing_activities_continuing",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "net_income_loss_attributable_to_parent",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "other_comprehensive_income_loss_attributable_to_parent",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "income_loss_from_continuing_operations_after_tax",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    # ### end Alembic commands ###
