"""Remove unnecessary columns from polygon financials table

Revision ID: 3ae9ebc67811
Revises: 29fe33d1bd8a
Create Date: 2024-06-06 14:06:43.827791

"""
from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "3ae9ebc67811"
down_revision: Union[str, None] = "29fe33d1bd8a"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "comprehensive_income_loss_attributable_to_parent",
            sa.Float(),
            nullable=True,
        ),
    )
    op.drop_column(
        "polygonapi_financials_data", "income_loss_before_equity_method_investments"
    )
    op.drop_column(
        "polygonapi_financials_data", "loss_attributable_to_noncontrolling_interest"
    )
    op.drop_column("polygonapi_financials_data", "loss_attributable_to_parent")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "loss_attributable_to_parent",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "loss_attributable_to_noncontrolling_interest",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "polygonapi_financials_data",
        sa.Column(
            "income_loss_before_equity_method_investments",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.drop_column(
        "polygonapi_financials_data", "comprehensive_income_loss_attributable_to_parent"
    )
    # ### end Alembic commands ###
