"""rename nasdaq api table

Revision ID: bf8106d0ce4c
Revises: 85226304f8d4
Create Date: 2024-02-29 22:28:45.185214

"""
from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = "bf8106d0ce4c"
down_revision: Union[str, None] = "85226304f8d4"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "nasdaq_api_data",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("symbol", sa.String(length=10), nullable=True),
        sa.Column("last_sale", sa.Float(), nullable=True),
        sa.Column("pct_change", sa.Float(), nullable=True),
        sa.Column("net_change", sa.Float(), nullable=True),
        sa.Column("volume", sa.Float(), nullable=True),
        sa.Column("marketcap", sa.Float(), nullable=True),
        sa.Column("country", sa.String(), nullable=True),
        sa.Column("ipo_year", sa.Integer(), nullable=True),
        sa.Column("industry", sa.String(), nullable=True),
        sa.Column("sector", sa.String(), nullable=True),
        sa.Column("url", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column("updated_at", sa.DateTime(timezone=True), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("symbol"),
    )
    op.drop_table("nasdaq_stocks")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "nasdaq_stocks",
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("symbol", sa.VARCHAR(length=10), autoincrement=False, nullable=True),
        sa.Column(
            "last_sale",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "pct_change",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "net_change",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "volume",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "marketcap",
            sa.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column("country", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column("ipo_year", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("industry", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column("sector", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column("url", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column(
            "created_at",
            postgresql.TIMESTAMP(timezone=True),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            postgresql.TIMESTAMP(timezone=True),
            autoincrement=False,
            nullable=True,
        ),
        sa.PrimaryKeyConstraint("id", name="nasdaq_stocks_pkey"),
        sa.UniqueConstraint("symbol", name="nasdaq_stocks_symbol_key"),
    )
    op.drop_table("nasdaq_api_data")
    # ### end Alembic commands ###
