"""Add exchange column for nasdaqapi data table

Revision ID: c27d882e8528
Revises: 5e20e944d431
Create Date: 2024-05-05 18:17:49.075923

"""
from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "c27d882e8528"
down_revision: Union[str, None] = "5e20e944d431"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "nasdaq_api_data", sa.Column("exchange", sa.String(length=10), nullable=True)
    )
    op.drop_constraint("nasdaq_api_data_symbol_key", "nasdaq_api_data", type_="unique")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_unique_constraint(
        "nasdaq_api_data_symbol_key", "nasdaq_api_data", ["symbol"]
    )
    op.drop_column("nasdaq_api_data", "exchange")
    # ### end Alembic commands ###
