"""adding polygon financials table

Revision ID: f23d2166896e
Revises: c27d882e8528
Create Date: 2024-06-01 14:41:32.085230

"""
from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "f23d2166896e"
down_revision: Union[str, None] = "c27d882e8528"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "polygonapi_financials_data",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "equity_attributable_to_noncontrolling_interest", sa.Float(), nullable=True
        ),
        sa.Column("liabilities", sa.Float(), nullable=True),
        sa.Column("equity_attributable_to_parent", sa.Float(), nullable=True),
        sa.Column("noncurrent_assets", sa.Float(), nullable=True),
        sa.Column("liabilities_and_equity", sa.Float(), nullable=True),
        sa.Column("assets", sa.Float(), nullable=True),
        sa.Column("fixed_assets", sa.Float(), nullable=True),
        sa.Column("other_than_fixed_noncurrent_assets", sa.Float(), nullable=True),
        sa.Column("noncurrent_liabilities", sa.Float(), nullable=True),
        sa.Column("current_assets", sa.Float(), nullable=True),
        sa.Column("equity", sa.Float(), nullable=True),
        sa.Column("current_liabilities", sa.Float(), nullable=True),
        sa.Column("net_cash_flow_from_investing_activities", sa.Float(), nullable=True),
        sa.Column(
            "net_cash_flow_from_operating_activities_continuing",
            sa.Float(),
            nullable=True,
        ),
        sa.Column("exchange_gains_losses", sa.Float(), nullable=True),
        sa.Column("net_cash_flow_continuing", sa.Float(), nullable=True),
        sa.Column("net_cash_flow", sa.Float(), nullable=True),
        sa.Column("net_cash_flow_from_financing_activities", sa.Float(), nullable=True),
        sa.Column(
            "net_cash_flow_from_investing_activities_continuing",
            sa.Float(),
            nullable=True,
        ),
        sa.Column("net_cash_flow_from_operating_activities", sa.Float(), nullable=True),
        sa.Column(
            "net_cash_flow_from_financing_activities_continuing",
            sa.Float(),
            nullable=True,
        ),
        sa.Column(
            "loss_attributable_to_noncontrolling_interest", sa.Float(), nullable=True
        ),
        sa.Column("loss_attributable_to_parent", sa.Float(), nullable=True),
        sa.Column("other_comprehensive_income_loss", sa.Float(), nullable=True),
        sa.Column(
            "other_comprehensive_income_loss_attributable_to_parent",
            sa.Float(),
            nullable=True,
        ),
        sa.Column("comprehensive_income_loss", sa.Float(), nullable=True),
        sa.Column(
            "income_loss_before_equity_method_investments", sa.Float(), nullable=True
        ),
        sa.Column("diluted_earnings_per_share", sa.Float(), nullable=True),
        sa.Column(
            "income_loss_from_equity_method_investments", sa.Float(), nullable=True
        ),
        sa.Column("operating_expenses", sa.Float(), nullable=True),
        sa.Column(
            "income_loss_from_continuing_operations_after_tax",
            sa.Float(),
            nullable=True,
        ),
        sa.Column(
            "preferred_stock_dividends_and_other_adjustments", sa.Float(), nullable=True
        ),
        sa.Column("basic_earnings_per_share", sa.Float(), nullable=True),
        sa.Column("cost_of_revenue", sa.Float(), nullable=True),
        sa.Column("net_income_loss_attributable_to_parent", sa.Float(), nullable=True),
        sa.Column(
            "income_loss_from_continuing_operations_before_tax",
            sa.Float(),
            nullable=True,
        ),
        sa.Column("income_tax_expense_benefit_deferred", sa.Float(), nullable=True),
        sa.Column("costs_and_expenses", sa.Float(), nullable=True),
        sa.Column("gross_profit", sa.Float(), nullable=True),
        sa.Column("benefits_costs_expenses", sa.Float(), nullable=True),
        sa.Column(
            "participating_securities_distributed_and_undistributed_earnings_loss_basic",
            sa.Float(),
            nullable=True,
        ),
        sa.Column("income_tax_expense_benefit", sa.Float(), nullable=True),
        sa.Column(
            "net_income_loss_attributable_to_noncontrolling_interest",
            sa.Float(),
            nullable=True,
        ),
        sa.Column("interest_expense_operating", sa.Float(), nullable=True),
        sa.Column(
            "net_income_loss_available_to_common_stockholders_basic",
            sa.Float(),
            nullable=True,
        ),
        sa.Column("revenues", sa.Float(), nullable=True),
        sa.Column("net_income_loss", sa.Float(), nullable=True),
        sa.Column("operating_income_loss", sa.Float(), nullable=True),
        sa.Column("ticker", sa.String(), nullable=True),
        sa.Column("start_date", sa.String(), nullable=True),
        sa.Column("end_date", sa.String(), nullable=True),
        sa.Column("filing_date", sa.String(), nullable=True),
        sa.Column("cik", sa.String(), nullable=True),
        sa.Column("company_name", sa.String(), nullable=True),
        sa.Column("fiscal_period", sa.String(), nullable=True),
        sa.Column("fiscal_year", sa.String(), nullable=True),
        sa.Column("source_filing_url", sa.String(), nullable=True),
        sa.Column("source_filing_file_url", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("polygonapi_financials_data")
    # ### end Alembic commands ###
