from cryptography import x509
from radkit_common.access.exceptions import CAError
from radkit_common.identities import Email, EndpointID

__all__ = ['RADKitEndpointExtension', 'RADKitEndpointTypeExtension', 'RADKitEndpointIdentityExtension', 'RADKitEndpointRequesterExtension', 'RADKitEndpointOwnerExtension']

class InvalidExtensionValueError(CAError):
    message: str
    status_code: int

class RADKitEndpointExtension(x509.ExtensionType):
    @property
    def value(self) -> str: ...
    def public_bytes(self) -> bytes: ...
    @classmethod
    def from_public_bytes(cls, data: bytes) -> RADKitEndpointExtension: ...

class RADKitEndpointTypeExtension(RADKitEndpointExtension):
    oid = RADKIT_ENDPOINT_TYPE_OID
    def __init__(self, endpoint_type: str) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    @property
    def value(self) -> str: ...
    @classmethod
    def from_public_bytes(cls, data: bytes) -> RADKitEndpointTypeExtension: ...

class RADKitEndpointIdentityExtension(RADKitEndpointExtension):
    oid = RADKIT_ENDPOINT_IDENTITY_OID
    def __init__(self, identity: EndpointID) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    @property
    def value(self) -> str: ...
    @classmethod
    def from_public_bytes(cls, data: bytes) -> RADKitEndpointIdentityExtension: ...

class RADKitEndpointRequesterExtension(RADKitEndpointExtension):
    oid = RADKIT_ENDPOINT_REQUESTER_OID
    def __init__(self, requester: Email) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    @property
    def value(self) -> str: ...
    @classmethod
    def from_public_bytes(cls, data: bytes) -> RADKitEndpointRequesterExtension: ...

class RADKitEndpointOwnerExtension(RADKitEndpointExtension):
    oid = RADKIT_ENDPOINT_OWNER_OID
    def __init__(self, owner: Email) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    @property
    def value(self) -> str: ...
    @classmethod
    def from_public_bytes(cls, data: bytes) -> RADKitEndpointOwnerExtension: ...

class RADKitEndpointDescriptionExtension(RADKitEndpointExtension):
    oid = RADKIT_ENDPOINT_DESCRIPTION_OID
    def __init__(self, description: str) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    @property
    def value(self) -> str: ...
    @classmethod
    def from_public_bytes(cls, data: bytes) -> RADKitEndpointDescriptionExtension: ...
