# -*- coding:utf-8 -*-

# This file is a part of IoT-LAB cli-tools
# Copyright (C) 2015 INRIA (Contact: admin@iot-lab.info)
# Contributor(s) : see AUTHORS file
#
# This software is governed by the CeCILL license under French law
# and abiding by the rules of distribution of free software.  You can  use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# http://www.cecill.info.
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability.
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.

"""Help parser messages"""

PARSER_EPILOG = """

Authentication :
    * Only username: Ask password on command line
        $ {cli}-cli -u login {option} ...
    * Username and password: use given credentials
        $ {cli}-cli -u login -p password  {option} ...
    * Nothing provided: Use credentials file generated by 'auth-cli'
        $ {cli}-cli {option} ...
"""

SUBMIT_EPILOG = """

Examples:
    Note: All the lists must be of the same type: Alias or Physical

    $ experiment-cli submit -d 20 -l <experiment_list> -l <experiment_list_2>

    * Physical experiment list:
        + <site_name,archi,resourceid_list,firmware_path,profile_name>
        + grenoble,m3,1-20,bin/tutorial.elf -l rocquencourt,a8,1-5,,battery
        + grenoble,wsn430,1-5+8+9-11,cc1101.hex,battery
        + grenoble,m3,1-20

    * Alias experiment list:
        + <resources_number,properties,firmware_path,profile_name>
        + 9,archi=wsn430:cc1101+site=grenoble,tp.hex,battery
        + 9,archi=m3:at86rf231+site=grenoble,gre.elf
        + 5,archi=m3:at86rf231+site=strasbourg,stras.elf
"""

WAIT_EPILOG = """
Examples:
    * wait that currently starting experiment becomes 'Running':
        $ experiment-cli wait

    * wait that given experiment gets in state Launching or Running by checking
      every second and timeout after 60 seconds
        $ experiment-cli -i 1234 --state Launching,Running --step 1 \
--timeout 60
"""

LOAD_EPILOG = """

Examples:
    * load experiment :
        $ experiment-cli load -f 192.json
        Note : by default firmwares are searched in the current directory
    * load experiment with firmware list and explicit path:
        $ experiment-cli load -f 192.json -l /home/cc2420.hex,../cc1101.hex
    * reload an experiment :
        $ experiment-cli get -i 192 -a
        $ tar -xzvf 192.tar.gz
        $ cd 192
        $ experiment-cli load -f 192.json
"""

GET_EPILOG = """

Examples:
    * Get an experiment submission
        $ experiment-cli get -p
        Note : with one experiment in the state Running
    * Get an experiment archive with id 1637
        $ experiment-cli get -i 1637 -a
    * Get exeriment resources list with id 1637
        $ experiment-cli get -i 1637 -r
    * Get user's experiment list with filter by state and number
        $ experiment-cli get -l --state Running,Terminated \\
            --offset 10 --limit 20
"""


INFO_EPILOG = """

Examples:
    * Get resources description list with filter by site
        $ expriment-cli info -l --site grenoble
    * Get resources id list (e.g. 1-34+72)
        $ experiment-cli info -li

"""


ADD_EPILOG_WSN430 = """

Examples :
    # Add a profile with consumption measure configuration
    $ profile-cli addwsn430 -n consum -current -voltage -power -cfreq 5000

    # Add a profile with radio rssi measures
    $ profile-cli addwsn430 -n rssi_profile -rfreq 500

    # Add a profile with sensor measures
    $ profile-cli addwsn430 -n sensors -sfreq 1000 -temperature -luminosity
"""

ADD_EPILOG_M3_A8 = """

Examples :
    # Add a profile for {archi} nodes with battery power supply and only
      voltage measure configuration
    $ profile-cli {cmd} -n profile -p battery -voltage -period 8244 -avg 1024

    # Add a profile for {archi} nodes with multi-channel radio rssi measures
    $ profile-cli {cmd} -n prof_rssi -rssi -channels 11 12 -num 10 -rperiod 100

    # Add a profile for {archi} nodes with radio sniffer
    $ profile-cli {cmd} -n sniff_11 -sniffer -channels 11

"""
