# -*- coding: utf-8 -*-
# Generated by Django 1.9.12 on 2017-02-07 21:52
from __future__ import unicode_literals

from django.db import migrations, models


def set_markers(apps, schema_editor):
        YaMaps = apps.get_model('cmsplugin_yandex_maps', 'YandexMaps')
        
        for ya_map in YaMaps.objects.all():
            for place in ya_map.placemark_set.all():
                ya_map.placemarks.add(place)



class Migration(migrations.Migration):

    dependencies = [
        ('cmsplugin_yandex_maps', '0003_auto_20170207_0923'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='yandexmaps',
            options={'verbose_name': 'Yandex Maps', 'verbose_name_plural': 'Yandex Maps'},
        ),
        migrations.AddField(
            model_name='yandexmaps',
            name='placemarks',
            field=models.ManyToManyField(blank=True, to='cmsplugin_yandex_maps.Placemark', verbose_name='Placemark'),
        ),
                  
        migrations.RunPython(set_markers),
        
        migrations.RemoveField(
            model_name='placemark',
            name='map',
        ),
    ]