"""
A module for molecules and stuff

see Chem/index.html in the doc tree for documentation

"""
from __future__ import annotations
from rdkit.Chem.inchi import InchiReadWriteError
from rdkit.Chem.inchi import InchiToInchiKey
from rdkit.Chem.inchi import MolBlockToInchi
from rdkit.Chem.inchi import MolBlockToInchiAndAuxInfo
from rdkit.Chem.inchi import MolFromInchi
from rdkit.Chem.inchi import MolToInchi
from rdkit.Chem.inchi import MolToInchiAndAuxInfo
from rdkit.Chem.inchi import MolToInchiKey
from rdkit.Chem.rdMolInterchange import JSONParseParameters
from rdkit.Chem.rdMolInterchange import JSONWriteParameters
from rdkit.Chem.rdchem import Atom
from rdkit.Chem.rdchem import AtomKekulizeException
from rdkit.Chem.rdchem import AtomMonomerInfo
from rdkit.Chem.rdchem import AtomMonomerType
from rdkit.Chem.rdchem import AtomPDBResidueInfo
from rdkit.Chem.rdchem import AtomSanitizeException
from rdkit.Chem.rdchem import AtomValenceException
from rdkit.Chem.rdchem import Bond
from rdkit.Chem.rdchem import BondDir
from rdkit.Chem.rdchem import BondStereo
from rdkit.Chem.rdchem import BondType
from rdkit.Chem.rdchem import ChiralType
from rdkit.Chem.rdchem import CompositeQueryType
from rdkit.Chem.rdchem import Conformer
from rdkit.Chem.rdchem import EditableMol
from rdkit.Chem.rdchem import FixedMolSizeMolBundle
from rdkit.Chem.rdchem import HybridizationType
from rdkit.Chem.rdchem import KekulizeException
from rdkit.Chem.rdchem import Mol
from rdkit.Chem.rdchem import MolBundle
from rdkit.Chem.rdchem import MolSanitizeException
from rdkit.Chem.rdchem import PeriodicTable
from rdkit.Chem.rdchem import PropertyPickleOptions
from rdkit.Chem.rdchem import QueryAtom
from rdkit.Chem.rdchem import QueryBond
from rdkit.Chem.rdchem import RWMol
from rdkit.Chem.rdchem import ResonanceFlags
from rdkit.Chem.rdchem import ResonanceMolSupplier
from rdkit.Chem.rdchem import ResonanceMolSupplierCallback
from rdkit.Chem.rdchem import RingInfo
from rdkit.Chem.rdchem import StereoDescriptor
from rdkit.Chem.rdchem import StereoGroup
from rdkit.Chem.rdchem import StereoGroupType
from rdkit.Chem.rdchem import StereoGroup_vect
from rdkit.Chem.rdchem import StereoInfo
from rdkit.Chem.rdchem import StereoSpecified
from rdkit.Chem.rdchem import StereoType
from rdkit.Chem.rdchem import SubstanceGroup
from rdkit.Chem.rdchem import SubstanceGroupAttach
from rdkit.Chem.rdchem import SubstanceGroupCState
from rdkit.Chem.rdchem import SubstanceGroup_VECT
from rdkit.Chem.rdchem import SubstructMatchParameters
from rdkit.Chem.rdchem import ValenceType
from rdkit.Chem.rdmolfiles import CXSmilesFields
from rdkit.Chem.rdmolfiles import ForwardSDMolSupplier
from rdkit.Chem.rdmolfiles import MaeMolSupplier
from rdkit.Chem.rdmolfiles import MaeWriter
from rdkit.Chem.rdmolfiles import MolFromSCSRParams
from rdkit.Chem.rdmolfiles import MolWriterParams
from rdkit.Chem.rdmolfiles import MultithreadedSDMolSupplier
from rdkit.Chem.rdmolfiles import MultithreadedSmilesMolSupplier
from rdkit.Chem.rdmolfiles import PDBWriter
from rdkit.Chem.rdmolfiles import PNGMetadataParams
from rdkit.Chem.rdmolfiles import RestoreBondDirOption
from rdkit.Chem.rdmolfiles import SCSRBaseHbondOptions
from rdkit.Chem.rdmolfiles import SCSRTemplateNames
from rdkit.Chem.rdmolfiles import SDMolSupplier
from rdkit.Chem.rdmolfiles import SDWriter
from rdkit.Chem.rdmolfiles import SmartsParserParams
from rdkit.Chem.rdmolfiles import SmilesMolSupplier
from rdkit.Chem.rdmolfiles import SmilesParserParams
from rdkit.Chem.rdmolfiles import SmilesWriteParams
from rdkit.Chem.rdmolfiles import SmilesWriter
from rdkit.Chem.rdmolfiles import TDTMolSupplier
from rdkit.Chem.rdmolfiles import TDTWriter
from rdkit.Chem.rdmolops import AddHsParameters
from rdkit.Chem.rdmolops import AdjustQueryParameters
from rdkit.Chem.rdmolops import AdjustQueryWhichFlags
from rdkit.Chem.rdmolops import AromaticityModel
from rdkit.Chem.rdmolops import BondWedgingParameters
from rdkit.Chem.rdmolops import MolzipLabel
from rdkit.Chem.rdmolops import MolzipParams
from rdkit.Chem.rdmolops import RemoveHsParameters
from rdkit.Chem.rdmolops import SanitizeFlags
from rdkit.Chem.rdmolops import StereoBondThresholds
from rdkit.Chem.rdmolops import StereoGroupAbsOptions
from rdkit import DataStructs
from rdkit.Geometry import rdGeometry
from rdkit import RDConfig
from rdkit import rdBase
from .inchi import *
from .rdCIPLabeler import *
from .rdCoordGen import *
from .rdMolInterchange import *
from .rdchem import *
from .rdinchi import *
from .rdmolfiles import *
from .rdmolops import *
__all__ = ['ADJUST_IGNOREALL', 'ADJUST_IGNORECHAINS', 'ADJUST_IGNOREDUMMIES', 'ADJUST_IGNOREMAPPED', 'ADJUST_IGNORENONDUMMIES', 'ADJUST_IGNORENONE', 'ADJUST_IGNORERINGS', 'ALLOW_CHARGE_SEPARATION', 'ALLOW_INCOMPLETE_OCTETS', 'AROMATICITY_CUSTOM', 'AROMATICITY_DEFAULT', 'AROMATICITY_MDL', 'AROMATICITY_MMFF94', 'AROMATICITY_RDKIT', 'AROMATICITY_SIMPLE', 'AddHsParameters', 'AdjustQueryParameters', 'AdjustQueryWhichFlags', 'AllProps', 'AromaticityModel', 'Atom', 'AtomKekulizeException', 'AtomMonomerInfo', 'AtomMonomerType', 'AtomPDBResidueInfo', 'AtomProps', 'AtomSanitizeException', 'AtomValenceException', 'Bond', 'BondDir', 'BondProps', 'BondStereo', 'BondType', 'BondWedgingParameters', 'CHI_ALLENE', 'CHI_OCTAHEDRAL', 'CHI_OTHER', 'CHI_SQUAREPLANAR', 'CHI_TETRAHEDRAL', 'CHI_TETRAHEDRAL_CCW', 'CHI_TETRAHEDRAL_CW', 'CHI_TRIGONALBIPYRAMIDAL', 'CHI_UNSPECIFIED', 'COMPOSITE_AND', 'COMPOSITE_OR', 'COMPOSITE_XOR', 'CXSmilesFields', 'CanonSmiles', 'ChiralType', 'CompositeQueryType', 'ComputedProps', 'Conformer', 'CoordsAsDouble', 'DataStructs', 'EXPLICIT', 'EditableMol', 'FindMolChiralCenters', 'FixedMolSizeMolBundle', 'ForwardSDMolSupplier', 'HybridizationType', 'IMPLICIT', 'INCHI_AVAILABLE', 'InchiReadWriteError', 'InchiToInchiKey', 'JSONParseParameters', 'JSONWriteParameters', 'KEKULE_ALL', 'KekulizeException', 'LayeredFingerprint_substructLayers', 'MaeMolSupplier', 'MaeWriter', 'Mol', 'MolBlockToInchi', 'MolBlockToInchiAndAuxInfo', 'MolBundle', 'MolFromInchi', 'MolFromSCSRParams', 'MolProps', 'MolSanitizeException', 'MolToInchi', 'MolToInchiAndAuxInfo', 'MolToInchiKey', 'MolWriterParams', 'MolzipLabel', 'MolzipParams', 'MultithreadedSDMolSupplier', 'MultithreadedSmilesMolSupplier', 'NoConformers', 'NoProps', 'PDBWriter', 'PNGMetadataParams', 'PeriodicTable', 'PrivateProps', 'PropertyPickleOptions', 'QueryAtom', 'QueryAtomData', 'QueryBond', 'QuickSmartsMatch', 'RDConfig', 'RWMol', 'RemoveHsParameters', 'ResonanceFlags', 'ResonanceMolSupplier', 'ResonanceMolSupplierCallback', 'RestoreBondDirOption', 'RingInfo', 'SANITIZE_ADJUSTHS', 'SANITIZE_ALL', 'SANITIZE_CLEANUP', 'SANITIZE_CLEANUPATROPISOMERS', 'SANITIZE_CLEANUPCHIRALITY', 'SANITIZE_CLEANUP_ORGANOMETALLICS', 'SANITIZE_FINDRADICALS', 'SANITIZE_KEKULIZE', 'SANITIZE_NONE', 'SANITIZE_PROPERTIES', 'SANITIZE_SETAROMATICITY', 'SANITIZE_SETCONJUGATION', 'SANITIZE_SETHYBRIDIZATION', 'SANITIZE_SYMMRINGS', 'SCSRBaseHbondOptions', 'SCSRTemplateNames', 'SDMolSupplier', 'SDWriter', 'STEREO_ABSOLUTE', 'STEREO_AND', 'STEREO_OR', 'SanitizeFlags', 'SmartsParserParams', 'SmilesMolSupplier', 'SmilesParserParams', 'SmilesWriteParams', 'SmilesWriter', 'StereoBondThresholds', 'StereoDescriptor', 'StereoGroup', 'StereoGroupAbsOptions', 'StereoGroupType', 'StereoGroup_vect', 'StereoInfo', 'StereoSpecified', 'StereoType', 'SubstanceGroup', 'SubstanceGroupAttach', 'SubstanceGroupCState', 'SubstanceGroup_VECT', 'SubstructMatchParameters', 'SupplierFromFilename', 'TDTMolSupplier', 'TDTWriter', 'UNCONSTRAINED_ANIONS', 'UNCONSTRAINED_CATIONS', 'ValenceType', 'inchi', 'rdBase', 'rdCIPLabeler', 'rdCoordGen', 'rdGeometry', 'rdMolInterchange', 'rdchem', 'rdinchi', 'rdmolfiles', 'rdmolops', 'templDir']
class _GetAtomsIterator(_GetRDKitObjIterator):
    def _getRDKitItem(self, i):
        ...
    def _sizeCalc(self):
        ...
class _GetBondsIterator(_GetRDKitObjIterator):
    def _getRDKitItem(self, i):
        ...
    def _sizeCalc(self):
        ...
class _GetRDKitObjIterator:
    def __getitem__(self, i):
        ...
    def __init__(self, mol):
        ...
    def __iter__(self):
        ...
    def __len__(self):
        ...
    def __next__(self):
        ...
    def _getRDKitItem(self, i):
        ...
    def _sizeCalc(self):
        ...
def CanonSmiles(smi, useChiral = 1):
    """
    A convenience function for canonicalizing SMILES
    
    Arguments:
      - smi: the SMILES to canonicalize
      - useChiral: (optional) determines whether or not chiral information is included in the canonicalization and SMILES
    
    Returns:
      the canonical SMILES
    
    """
def FindMolChiralCenters(mol, force = True, includeUnassigned = False, includeCIP = True, useLegacyImplementation = None):
    """
    returns information about the chiral centers in a molecule
    
    Arguments:
      - mol: the molecule to work with
      - force: (optional) if True, stereochemistry will be assigned even if it has been already
      - includeUnassigned: (optional) if True, unassigned stereo centers will be included in the output
      - includeCIP: (optional) if True, the CIP code for each chiral center will be included in the output
      - useLegacyImplementation: (optional) if True, the legacy stereochemistry perception code will be used
    
    Returns:
      a list of tuples of the form (atomId, CIPCode)
    
      >>> from rdkit import Chem
      >>> mol = Chem.MolFromSmiles('[C@H](Cl)(F)Br')
      >>> Chem.FindMolChiralCenters(mol)
      [(0, 'R')]
      >>> mol = Chem.MolFromSmiles('[C@@H](Cl)(F)Br')
      >>> Chem.FindMolChiralCenters(mol)
      [(0, 'S')]
    
      >>> Chem.FindMolChiralCenters(Chem.MolFromSmiles('CCC'))
      []
    
      By default unassigned stereo centers are not reported:
    
      >>> mol = Chem.MolFromSmiles('C[C@H](F)C(F)(Cl)Br')
      >>> Chem.FindMolChiralCenters(mol,force=True)
      [(1, 'S')]
    
      but this can be changed:
    
      >>> Chem.FindMolChiralCenters(mol,force=True,includeUnassigned=True)
      [(1, 'S'), (3, '?')]
    
      The handling of unassigned stereocenters for dependent stereochemistry is not correct 
      using the legacy implementation:
    
      >>> Chem.FindMolChiralCenters(Chem.MolFromSmiles('C1CC(C)C(C)C(C)C1'),includeUnassigned=True, useLegacyImplementation=True)
      [(2, '?'), (6, '?')]
      >>> Chem.FindMolChiralCenters(Chem.MolFromSmiles('C1C[C@H](C)C(C)[C@H](C)C1'),includeUnassigned=True, useLegacyImplementation=True)
      [(2, 'S'), (4, '?'), (6, 'R')]
    
      But works with the new implementation:
    
      >>> Chem.FindMolChiralCenters(Chem.MolFromSmiles('C1CC(C)C(C)C(C)C1'),includeUnassigned=True, useLegacyImplementation=False)
      [(2, '?'), (4, '?'), (6, '?')]
    
      Note that the new implementation also gets the correct descriptors for para-stereochemistry:
    
      >>> Chem.FindMolChiralCenters(Chem.MolFromSmiles('C1C[C@H](C)[C@H](C)[C@H](C)C1'),useLegacyImplementation=False)
      [(2, 'S'), (4, 's'), (6, 'R')]
    
      With the new implementation, if you don't care about the CIP labels of stereocenters, you can save
      some time by disabling those:
    
      >>> Chem.FindMolChiralCenters(Chem.MolFromSmiles('C1C[C@H](C)[C@H](C)[C@H](C)C1'), includeCIP=False, useLegacyImplementation=False)
      [(2, 'Tet_CCW'), (4, 'Tet_CCW'), (6, 'Tet_CCW')]
    
    """
def QuickSmartsMatch(smi, sma, unique = True, display = False):
    """
    A convenience function for quickly matching a SMARTS against a SMILES
    
    Arguments:
      - smi: the SMILES to match
      - sma: the SMARTS to match
      - unique: (optional) determines whether or not only unique matches are returned
      - display: (optional) IGNORED
    
    Returns:
      a list of list of the indices of the atoms in the molecule that match the SMARTS  
    
    """
def SupplierFromFilename(fileN, delim = '', **kwargs):
    """
    A convenience function for creating a molecule supplier from a filename 
    
    Arguments:
      - fileN: the name of the file to read from
      - delim: (optional) the delimiter to use for reading the file (only for csv and txt files)
      - kwargs: additional keyword arguments to be passed to the supplier constructor
    
    Returns:
      a molecule supplier
    
    """
ADJUST_IGNOREALL: rdmolops.AdjustQueryWhichFlags  # value = rdkit.Chem.rdmolops.AdjustQueryWhichFlags.ADJUST_IGNOREALL
ADJUST_IGNORECHAINS: rdmolops.AdjustQueryWhichFlags  # value = rdkit.Chem.rdmolops.AdjustQueryWhichFlags.ADJUST_IGNORECHAINS
ADJUST_IGNOREDUMMIES: rdmolops.AdjustQueryWhichFlags  # value = rdkit.Chem.rdmolops.AdjustQueryWhichFlags.ADJUST_IGNOREDUMMIES
ADJUST_IGNOREMAPPED: rdmolops.AdjustQueryWhichFlags  # value = rdkit.Chem.rdmolops.AdjustQueryWhichFlags.ADJUST_IGNOREMAPPED
ADJUST_IGNORENONDUMMIES: rdmolops.AdjustQueryWhichFlags  # value = rdkit.Chem.rdmolops.AdjustQueryWhichFlags.ADJUST_IGNORENONDUMMIES
ADJUST_IGNORENONE: rdmolops.AdjustQueryWhichFlags  # value = rdkit.Chem.rdmolops.AdjustQueryWhichFlags.ADJUST_IGNORENONE
ADJUST_IGNORERINGS: rdmolops.AdjustQueryWhichFlags  # value = rdkit.Chem.rdmolops.AdjustQueryWhichFlags.ADJUST_IGNORERINGS
ALLOW_CHARGE_SEPARATION: rdchem.ResonanceFlags  # value = rdkit.Chem.rdchem.ResonanceFlags.ALLOW_CHARGE_SEPARATION
ALLOW_INCOMPLETE_OCTETS: rdchem.ResonanceFlags  # value = rdkit.Chem.rdchem.ResonanceFlags.ALLOW_INCOMPLETE_OCTETS
AROMATICITY_CUSTOM: rdmolops.AromaticityModel  # value = rdkit.Chem.rdmolops.AromaticityModel.AROMATICITY_CUSTOM
AROMATICITY_DEFAULT: rdmolops.AromaticityModel  # value = rdkit.Chem.rdmolops.AromaticityModel.AROMATICITY_DEFAULT
AROMATICITY_MDL: rdmolops.AromaticityModel  # value = rdkit.Chem.rdmolops.AromaticityModel.AROMATICITY_MDL
AROMATICITY_MMFF94: rdmolops.AromaticityModel  # value = rdkit.Chem.rdmolops.AromaticityModel.AROMATICITY_MMFF94
AROMATICITY_RDKIT: rdmolops.AromaticityModel  # value = rdkit.Chem.rdmolops.AromaticityModel.AROMATICITY_RDKIT
AROMATICITY_SIMPLE: rdmolops.AromaticityModel  # value = rdkit.Chem.rdmolops.AromaticityModel.AROMATICITY_SIMPLE
AllProps: rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.AllProps
AtomProps: rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.AtomProps
BondProps: rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.BondProps
CHI_ALLENE: rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_ALLENE
CHI_OCTAHEDRAL: rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_OCTAHEDRAL
CHI_OTHER: rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_OTHER
CHI_SQUAREPLANAR: rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_SQUAREPLANAR
CHI_TETRAHEDRAL: rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_TETRAHEDRAL
CHI_TETRAHEDRAL_CCW: rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_TETRAHEDRAL_CCW
CHI_TETRAHEDRAL_CW: rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_TETRAHEDRAL_CW
CHI_TRIGONALBIPYRAMIDAL: rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_TRIGONALBIPYRAMIDAL
CHI_UNSPECIFIED: rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_UNSPECIFIED
COMPOSITE_AND: rdchem.CompositeQueryType  # value = rdkit.Chem.rdchem.CompositeQueryType.COMPOSITE_AND
COMPOSITE_OR: rdchem.CompositeQueryType  # value = rdkit.Chem.rdchem.CompositeQueryType.COMPOSITE_OR
COMPOSITE_XOR: rdchem.CompositeQueryType  # value = rdkit.Chem.rdchem.CompositeQueryType.COMPOSITE_XOR
ComputedProps: rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.ComputedProps
CoordsAsDouble: rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.CoordsAsDouble
EXPLICIT: rdchem.ValenceType  # value = rdkit.Chem.rdchem.ValenceType.EXPLICIT
IMPLICIT: rdchem.ValenceType  # value = rdkit.Chem.rdchem.ValenceType.IMPLICIT
INCHI_AVAILABLE: bool = True
KEKULE_ALL: rdchem.ResonanceFlags  # value = rdkit.Chem.rdchem.ResonanceFlags.KEKULE_ALL
LayeredFingerprint_substructLayers: int = 7
MolProps: rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.MolProps
NoConformers: rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.NoConformers
NoProps: rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.NoProps
PrivateProps: rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.PrivateProps
QueryAtomData: rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.QueryAtomData
SANITIZE_ADJUSTHS: rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_ADJUSTHS
SANITIZE_ALL: rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_ALL
SANITIZE_CLEANUP: rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_CLEANUP
SANITIZE_CLEANUPATROPISOMERS: rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_CLEANUPATROPISOMERS
SANITIZE_CLEANUPCHIRALITY: rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_CLEANUPCHIRALITY
SANITIZE_CLEANUP_ORGANOMETALLICS: rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_CLEANUP_ORGANOMETALLICS
SANITIZE_FINDRADICALS: rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_FINDRADICALS
SANITIZE_KEKULIZE: rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_KEKULIZE
SANITIZE_NONE: rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_NONE
SANITIZE_PROPERTIES: rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_PROPERTIES
SANITIZE_SETAROMATICITY: rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_SETAROMATICITY
SANITIZE_SETCONJUGATION: rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_SETCONJUGATION
SANITIZE_SETHYBRIDIZATION: rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_SETHYBRIDIZATION
SANITIZE_SYMMRINGS: rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_SYMMRINGS
STEREO_ABSOLUTE: rdchem.StereoGroupType  # value = rdkit.Chem.rdchem.StereoGroupType.STEREO_ABSOLUTE
STEREO_AND: rdchem.StereoGroupType  # value = rdkit.Chem.rdchem.StereoGroupType.STEREO_AND
STEREO_OR: rdchem.StereoGroupType  # value = rdkit.Chem.rdchem.StereoGroupType.STEREO_OR
UNCONSTRAINED_ANIONS: rdchem.ResonanceFlags  # value = rdkit.Chem.rdchem.ResonanceFlags.UNCONSTRAINED_ANIONS
UNCONSTRAINED_CATIONS: rdchem.ResonanceFlags  # value = rdkit.Chem.rdchem.ResonanceFlags.UNCONSTRAINED_CATIONS
templDir: str = '/project/build/temp.linux-aarch64-cpython-313/rdkit_install/share/RDKit/Data/'
