/* file: algorithm.h */
/*******************************************************************************
* Copyright 2014-2018 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
//++
//  Implementation of base classes defining algorithm interface.
//--
*/

#ifndef __ALGORITHM_H__
#define __ALGORITHM_H__


#include "services/base.h"
#include "services/daal_memory.h"
#include "services/daal_defines.h"
#include "services/error_handling.h"
#include "data_management/data/numeric_table.h"
#include "services/env_detect.h"
#include "algorithms/algorithm_types.h"
#include "algorithms/algorithm_base.h"
#include "algorithms/analysis.h"
#include "algorithms/training.h"
#include "algorithms/prediction.h"
#include "algorithms/algorithm_quality_metric_batch.h"

#include "algorithms/model.h"

#endif
