from PIL import Image, ImageEnhance

def gamma_correction(image, gamma):
    """
    Applies gamma correction to the given image.
    
    Args:
        image (PIL.Image.Image): The input image.
        gamma (float): The gamma value to apply (e.g., <1 to brighten, >1 to darken).
    
    Returns:
        PIL.Image.Image: The gamma-corrected image.
    """
    if gamma <= 0:
        raise ValueError("Gamma value must be greater than 0.")
    
    # Normalize the gamma value
    inv_gamma = 1.0 / gamma
    
    # Create a lookup table for gamma correction
    table = [int((i / 255.0) ** inv_gamma * 255) for i in range(256)]
    
    # Apply gamma correction using the lookup table
    corrected_image = image.point(table)
    
    return corrected_image