import { CfnAgent } from 'aws-cdk-lib/aws-bedrock';
import { ActionGroupExecutor } from './api-executor';
import { ApiSchema } from './api-schema';
import { FunctionSchema } from './function-schema';
/******************************************************************************
 *                           Signatures
 *****************************************************************************/
/**
 * AWS Defined signatures for enabling certain capabilities in your agent.
 */
export declare class ParentActionGroupSignature {
    /**
     * The AWS-defined signature value for this action group capability.
     */
    readonly value: string;
    /**
     * Signature that allows your agent to request the user for additional information when trying to complete a task.
     */
    static readonly USER_INPUT: ParentActionGroupSignature;
    /**
     * Signature that allows your agent to generate, run, and troubleshoot code when trying to complete a task.
     */
    static readonly CODE_INTERPRETER: ParentActionGroupSignature;
    /**
     * Constructor should be used as a temporary solution when a new signature is supported but its implementation in CDK hasn't been added yet.
     */
    constructor(
    /**
     * The AWS-defined signature value for this action group capability.
     */
    value: string);
    /**
     * Returns the string representation of the signature value.
     * Used when configuring the action group in CloudFormation.
     */
    toString(): string;
}
/******************************************************************************
 *                         PROPS - Action Group Class
 *****************************************************************************/
export interface AgentActionGroupProps {
    /**
     * The name of the action group.
     * @default - A unique name is generated in the format 'action_group_quick_start_UUID'
     */
    readonly name?: string;
    /**
     * A description of the action group.
     *
     * @default undefined - No description is provided
     */
    readonly description?: string;
    /**
     * The API Schema defining the functions available to the agent.
     *
     * @default undefined - No API Schema is provided
     */
    readonly apiSchema?: ApiSchema;
    /**
     * The action group executor that implements the API functions.
     *
     * @default undefined - No executor is provided
     */
    readonly executor?: ActionGroupExecutor;
    /**
     * Specifies whether the action group is available for the agent to invoke or
     * not when sending an InvokeAgent request.
     *
     * @default true - The action group is enabled
     */
    readonly enabled?: boolean;
    /**
     * Specifies whether to delete the resource even if it's in use.
     *
     * @default false - The resource will not be deleted if it's in use
     */
    readonly forceDelete?: boolean;
    /**
     * Defines functions that each define parameters that the agent needs to invoke from the user.
     * NO L2 yet as this doesn't make much sense IMHO.
     *
     * @default undefined - No function schema is provided
     */
    readonly functionSchema?: FunctionSchema;
    /**
     * The AWS Defined signature for enabling certain capabilities in your agent.
     * When this property is specified, you must leave the description, apiSchema,
     * and actionGroupExecutor fields blank for this action group.
     *
     * @default undefined - No parent action group signature is provided
     */
    readonly parentActionGroupSignature?: ParentActionGroupSignature;
}
/******************************************************************************
 *                         DEF - Action Group Class
 *****************************************************************************/
export declare class AgentActionGroup {
    /**
     * Defines an action group that allows your agent to request the user for
     * additional information when trying to complete a task.
     * @param enabled Specifies whether the action group is available for the agent
     */
    static userInput(enabled: boolean): AgentActionGroup;
    /**
     * Defines an action group that allows your agent to request the user for
     * additional information when trying to complete a task.
     * @param enabled Specifies whether the action group is available for the agent
     */
    static codeInterpreter(enabled: boolean): AgentActionGroup;
    /**
     * The name of the action group.
     */
    readonly name: string;
    /**
     * A description of the action group.
     */
    readonly description?: string;
    /**
     * Whether this action group is available for the agent to invoke or not.
     */
    readonly enabled: boolean;
    /**
     * The api schema for this action group (if defined).
     */
    readonly apiSchema?: ApiSchema;
    /**
     * The action group executor for this action group (if defined).
     */
    readonly executor?: ActionGroupExecutor;
    /**
     * Whether to delete the resource even if it's in use.
     */
    readonly forceDelete?: boolean;
    /**
     * The function schema for this action group (if defined).
     */
    readonly functionSchema?: FunctionSchema;
    /**
     * The AWS Defined signature (if defined).
     */
    readonly parentActionGroupSignature?: ParentActionGroupSignature;
    constructor(props: AgentActionGroupProps);
    private validateProps;
    /**
     * Format as CFN properties
     *
     * @internal This is an internal core function and should not be called directly.
     */
    _render(): CfnAgent.AgentActionGroupProperty;
}
