"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgentActionGroup = exports.ParentActionGroupSignature = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const validation_helpers_1 = require("./validation-helpers");
/******************************************************************************
 *                           Signatures
 *****************************************************************************/
/**
 * AWS Defined signatures for enabling certain capabilities in your agent.
 */
class ParentActionGroupSignature {
    /**
     * Constructor should be used as a temporary solution when a new signature is supported but its implementation in CDK hasn't been added yet.
     */
    constructor(
    /**
     * The AWS-defined signature value for this action group capability.
     */
    value) {
        this.value = value;
    }
    /**
     * Returns the string representation of the signature value.
     * Used when configuring the action group in CloudFormation.
     */
    toString() {
        return this.value;
    }
}
exports.ParentActionGroupSignature = ParentActionGroupSignature;
_a = JSII_RTTI_SYMBOL_1;
ParentActionGroupSignature[_a] = { fqn: "@aws-cdk/aws-bedrock-alpha.ParentActionGroupSignature", version: "2.206.0-alpha.0" };
/**
 * Signature that allows your agent to request the user for additional information when trying to complete a task.
 */
ParentActionGroupSignature.USER_INPUT = new ParentActionGroupSignature('AMAZON.UserInput');
/**
 * Signature that allows your agent to generate, run, and troubleshoot code when trying to complete a task.
 */
ParentActionGroupSignature.CODE_INTERPRETER = new ParentActionGroupSignature('AMAZON.CodeInterpreter');
/******************************************************************************
 *                         DEF - Action Group Class
 *****************************************************************************/
class AgentActionGroup {
    // ------------------------------------------------------
    // Static Constructors
    // ------------------------------------------------------
    /**
     * Defines an action group that allows your agent to request the user for
     * additional information when trying to complete a task.
     * @param enabled Specifies whether the action group is available for the agent
     */
    static userInput(enabled) {
        return new AgentActionGroup({
            name: 'UserInputAction',
            enabled: enabled,
            parentActionGroupSignature: ParentActionGroupSignature.USER_INPUT,
        });
    }
    /**
     * Defines an action group that allows your agent to request the user for
     * additional information when trying to complete a task.
     * @param enabled Specifies whether the action group is available for the agent
     */
    static codeInterpreter(enabled) {
        return new AgentActionGroup({
            name: 'CodeInterpreterAction',
            enabled: enabled,
            parentActionGroupSignature: ParentActionGroupSignature.CODE_INTERPRETER,
        });
    }
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_bedrock_alpha_AgentActionGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AgentActionGroup);
            }
            throw error;
        }
        // Validate Props
        this.validateProps(props);
        // ------------------------------------------------------
        // Set attributes or defaults
        // ------------------------------------------------------
        this.name = props.name ?? `action_group_quick_start_${crypto.randomUUID()}`;
        this.description = props.description;
        this.apiSchema = props.apiSchema;
        this.executor = props.executor;
        this.enabled = props.enabled ?? true;
        this.forceDelete = props.forceDelete ?? false;
        this.functionSchema = props.functionSchema;
        this.parentActionGroupSignature = props.parentActionGroupSignature;
    }
    validateProps(props) {
        if (props.parentActionGroupSignature && (props.description || props.apiSchema || props.executor)) {
            throw new validation_helpers_1.ValidationError('When parentActionGroupSignature is specified, you must leave the description, ' +
                'apiSchema, and actionGroupExecutor fields blank for this action group');
        }
    }
    /**
     * Format as CFN properties
     *
     * @internal This is an internal core function and should not be called directly.
     */
    _render() {
        return {
            actionGroupExecutor: this.executor?._render(),
            actionGroupName: this.name,
            actionGroupState: this.enabled ? 'ENABLED' : 'DISABLED',
            apiSchema: this.apiSchema?._render(),
            description: this.description,
            functionSchema: this.functionSchema?._render(),
            parentActionGroupSignature: this.parentActionGroupSignature?.toString(),
            skipResourceInUseCheckOnDelete: this.forceDelete,
        };
    }
}
exports.AgentActionGroup = AgentActionGroup;
_b = JSII_RTTI_SYMBOL_1;
AgentActionGroup[_b] = { fqn: "@aws-cdk/aws-bedrock-alpha.AgentActionGroup", version: "2.206.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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