"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionSchema = exports.Function = exports.FunctionParameter = exports.RequireConfirmation = exports.ParameterType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const validation = require("./validation-helpers");
const schema_base_1 = require("./schema-base");
/**
 * Enum for parameter types in function schemas
 */
var ParameterType;
(function (ParameterType) {
    /**
     * String parameter type
     */
    ParameterType["STRING"] = "string";
    /**
     * Number parameter type
     */
    ParameterType["NUMBER"] = "number";
    /**
     * Integer parameter type
     */
    ParameterType["INTEGER"] = "integer";
    /**
     * Boolean parameter type
     */
    ParameterType["BOOLEAN"] = "boolean";
    /**
     * Array parameter type
     */
    ParameterType["ARRAY"] = "array";
    /**
     * Object parameter type
     */
    ParameterType["OBJECT"] = "object";
})(ParameterType || (exports.ParameterType = ParameterType = {}));
/**
 * Enum for require confirmation state in function schemas
 */
var RequireConfirmation;
(function (RequireConfirmation) {
    /**
     * Confirmation is enabled
     */
    RequireConfirmation["ENABLED"] = "ENABLED";
    /**
     * Confirmation is disabled
     */
    RequireConfirmation["DISABLED"] = "DISABLED";
})(RequireConfirmation || (exports.RequireConfirmation = RequireConfirmation = {}));
/**
 * Represents a function parameter in a function schema
 */
class FunctionParameter {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_bedrock_alpha_FunctionParameterProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FunctionParameter);
            }
            throw error;
        }
        // Validate description if provided
        if (props.description) {
            const descErrors = validation.validateStringFieldLength({
                fieldName: 'parameter description',
                value: props.description,
                minLength: 1,
                maxLength: 500,
            });
            if (descErrors.length > 0) {
                throw new validation.ValidationError(descErrors.join('\n'));
            }
        }
        this.type = props.type;
        this.required = props.required ?? true;
        this.description = props.description;
    }
    /**
     * Render the parameter as a CloudFormation property
     * @internal
     */
    _render() {
        return {
            type: this.type,
            required: this.required,
            description: this.description,
        };
    }
}
exports.FunctionParameter = FunctionParameter;
_a = JSII_RTTI_SYMBOL_1;
FunctionParameter[_a] = { fqn: "@aws-cdk/aws-bedrock-alpha.FunctionParameter", version: "2.206.0-alpha.0" };
/**
 * Represents a function in a function schema
 */
class Function {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_bedrock_alpha_FunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Function);
            }
            throw error;
        }
        // Validate function name
        const nameErrors = validation.validateStringFieldLength({
            fieldName: 'function name',
            value: props.name,
            minLength: 1,
            maxLength: 100,
        });
        if (nameErrors.length > 0) {
            throw new validation.ValidationError(nameErrors.join('\n'));
        }
        // Validate function description
        const descErrors = validation.validateStringFieldLength({
            fieldName: 'function description',
            value: props.description,
            minLength: 1,
            maxLength: 500,
        });
        if (descErrors.length > 0) {
            throw new validation.ValidationError(descErrors.join('\n'));
        }
        this.name = props.name;
        this.description = props.description;
        // Convert parameters object to a record of FunctionParameter instances
        this.parameters = {};
        if (props.parameters) {
            Object.entries(props.parameters).forEach(([name, paramProps]) => {
                // Validate parameter name
                const paramNameErrors = validation.validateStringFieldLength({
                    fieldName: 'parameter name',
                    value: name,
                    minLength: 1,
                    maxLength: 100,
                });
                if (paramNameErrors.length > 0) {
                    throw new validation.ValidationError(paramNameErrors.join('\n'));
                }
                this.parameters[name] = new FunctionParameter(paramProps);
            });
        }
        this.requireConfirmation = props.requireConfirmation ?? RequireConfirmation.DISABLED;
    }
    /**
     * Render the function as a CloudFormation property
     * @internal
     */
    _render() {
        const parametersObj = {};
        Object.entries(this.parameters).forEach(([name, param]) => {
            parametersObj[name] = param._render();
        });
        return {
            name: this.name,
            description: this.description,
            parameters: parametersObj,
            requireConfirmation: this.requireConfirmation,
        };
    }
}
exports.Function = Function;
_b = JSII_RTTI_SYMBOL_1;
Function[_b] = { fqn: "@aws-cdk/aws-bedrock-alpha.Function", version: "2.206.0-alpha.0" };
/**
 * Represents a function schema for a Bedrock Agent Action Group
 */
class FunctionSchema extends schema_base_1.ActionGroupSchema {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_bedrock_alpha_FunctionSchemaProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FunctionSchema);
            }
            throw error;
        }
        if (!props.functions || props.functions.length === 0) {
            throw new validation.ValidationError('At least one function must be defined in the function schema');
        }
        this.functions = props.functions.map(f => new Function(f));
    }
    /**
     * Render the function schema as a CloudFormation property
     * @internal
     */
    _render() {
        return {
            functions: this.functions.map(f => f._render()),
        };
    }
}
exports.FunctionSchema = FunctionSchema;
_c = JSII_RTTI_SYMBOL_1;
FunctionSchema[_c] = { fqn: "@aws-cdk/aws-bedrock-alpha.FunctionSchema", version: "2.206.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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