import { AgentCollaborator, AgentCollaboratorType } from './agent-collaborator';
/**
 * Configuration for agent collaboration settings.
 */
export interface AgentCollaborationConfig {
    /**
     * The collaboration type for the agent.
     */
    readonly type: AgentCollaboratorType;
    /**
     * Collaborators that this agent will work with.
     */
    readonly collaborators: AgentCollaborator[];
}
/**
 * Class to manage agent collaboration configuration.
 */
export declare class AgentCollaboration {
    /**
     * The collaboration type for the agent.
     */
    readonly type: AgentCollaboratorType;
    /**
     * Collaborators that this agent will work with.
     */
    readonly collaborators: AgentCollaborator[];
    constructor(config: AgentCollaborationConfig);
}
