import { CfnAgent } from 'aws-cdk-lib/aws-bedrock';
import { IGrantable, Grant } from 'aws-cdk-lib/aws-iam';
import { IAgentAlias } from './agent-alias';
/**
 * Enum for collaborator's relay conversation history types.
 */
export declare enum AgentCollaboratorType {
    /**
     * Supervisor agent.
     */
    SUPERVISOR = "SUPERVISOR",
    /**
     * Disabling collaboration.
     */
    DISABLED = "DISABLED",
    /**
     * Supervisor router.
     */
    SUPERVISOR_ROUTER = "SUPERVISOR_ROUTER"
}
/******************************************************************************
 *                    PROPS - Agent Collaborator Class
 *****************************************************************************/
export interface AgentCollaboratorProps {
    /**
     * Descriptor for the collaborating agent.
     * This cannot be the TSTALIASID (`agent.testAlias`).
     */
    readonly agentAlias: IAgentAlias;
    /**
     * Instructions on how this agent should collaborate with the main agent.
     */
    readonly collaborationInstruction: string;
    /**
     * A friendly name for the collaborator.
     */
    readonly collaboratorName: string;
    /**
     * Whether to relay conversation history to this collaborator.
     *
     * @default - undefined (uses service default)
     */
    readonly relayConversationHistory?: boolean;
}
/******************************************************************************
 *                         Agent Collaborator Class
 *****************************************************************************/
export declare class AgentCollaborator {
    /**
     * The agent alias that this collaborator represents.
     * This is the agent that will be called upon for collaboration.
     */
    readonly agentAlias: IAgentAlias;
    /**
     * Instructions on how this agent should collaborate with the main agent.
     */
    readonly collaborationInstruction: string;
    /**
     * A friendly name for the collaborator.
     */
    readonly collaboratorName: string;
    /**
     * Whether to relay conversation history to this collaborator.
     *
     * @default - undefined (uses service default)
     */
    readonly relayConversationHistory?: boolean;
    constructor(props: AgentCollaboratorProps);
    private validateProps;
    /**
     * Format as CFN properties
     *
     * @internal This is an internal core function and should not be called directly.
     */
    _render(): CfnAgent.AgentCollaboratorProperty;
    /**
     * Grants the given identity permissions to collaborate with the agent
     * @param grantee The principal to grant permissions to
     * @returns The Grant object
     */
    grant(grantee: IGrantable): Grant;
}
