"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgentCollaborator = exports.AgentCollaboratorType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const validation_helpers_1 = require("./validation-helpers");
/**
 * Enum for collaborator's relay conversation history types.
 */
var AgentCollaboratorType;
(function (AgentCollaboratorType) {
    /**
     * Supervisor agent.
     */
    AgentCollaboratorType["SUPERVISOR"] = "SUPERVISOR";
    /**
     * Disabling collaboration.
     */
    AgentCollaboratorType["DISABLED"] = "DISABLED";
    /**
     * Supervisor router.
     */
    AgentCollaboratorType["SUPERVISOR_ROUTER"] = "SUPERVISOR_ROUTER";
})(AgentCollaboratorType || (exports.AgentCollaboratorType = AgentCollaboratorType = {}));
/**
 * Enum for collaborator's relay conversation history types.
 * @internal
 */
var RelayConversationHistoryType;
(function (RelayConversationHistoryType) {
    /**
     * Sending to the collaborator.
     */
    RelayConversationHistoryType["TO_COLLABORATOR"] = "TO_COLLABORATOR";
    /**
     * Disabling relay of conversation history to the collaborator.
     */
    RelayConversationHistoryType["DISABLED"] = "DISABLED";
})(RelayConversationHistoryType || (RelayConversationHistoryType = {}));
/******************************************************************************
 *                         Agent Collaborator Class
 *****************************************************************************/
class AgentCollaborator {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_bedrock_alpha_AgentCollaboratorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AgentCollaborator);
            }
            throw error;
        }
        // Validate Props
        this.validateProps(props);
        // ------------------------------------------------------
        // Set attributes or defaults
        // ------------------------------------------------------
        this.agentAlias = props.agentAlias;
        this.collaborationInstruction = props.collaborationInstruction;
        this.collaboratorName = props.collaboratorName;
        this.relayConversationHistory = props.relayConversationHistory;
    }
    validateProps(props) {
        if (props.agentAlias.aliasId === 'TSTALIASID') {
            throw new validation_helpers_1.ValidationError('Agent cannot collaborate with TSTALIASID alias of another agent');
        }
    }
    /**
     * Format as CFN properties
     *
     * @internal This is an internal core function and should not be called directly.
     */
    _render() {
        return {
            agentDescriptor: {
                aliasArn: this.agentAlias.aliasArn,
            },
            collaborationInstruction: this.collaborationInstruction,
            collaboratorName: this.collaboratorName,
            relayConversationHistory: this.relayConversationHistory ? RelayConversationHistoryType.TO_COLLABORATOR : RelayConversationHistoryType.DISABLED,
        };
    }
    /**
     * Grants the given identity permissions to collaborate with the agent
     * @param grantee The principal to grant permissions to
     * @returns The Grant object
     */
    grant(grantee) {
        const grant1 = this.agentAlias.grantInvoke(grantee);
        const combinedGrant = grant1.combine(this.agentAlias.grantGet(grantee));
        return combinedGrant;
    }
}
exports.AgentCollaborator = AgentCollaborator;
_a = JSII_RTTI_SYMBOL_1;
AgentCollaborator[_a] = { fqn: "@aws-cdk/aws-bedrock-alpha.AgentCollaborator", version: "2.206.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWdlbnQtY29sbGFib3JhdG9yLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYWdlbnQtY29sbGFib3JhdG9yLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUdBLDZEQUF1RDtBQUV2RDs7R0FFRztBQUNILElBQVkscUJBZVg7QUFmRCxXQUFZLHFCQUFxQjtJQUMvQjs7T0FFRztJQUNILGtEQUF5QixDQUFBO0lBRXpCOztPQUVHO0lBQ0gsOENBQXFCLENBQUE7SUFFckI7O09BRUc7SUFDSCxnRUFBdUMsQ0FBQTtBQUN6QyxDQUFDLEVBZlcscUJBQXFCLHFDQUFyQixxQkFBcUIsUUFlaEM7QUFFRDs7O0dBR0c7QUFDSCxJQUFLLDRCQVVKO0FBVkQsV0FBSyw0QkFBNEI7SUFDL0I7O09BRUc7SUFDSCxtRUFBbUMsQ0FBQTtJQUVuQzs7T0FFRztJQUNILHFEQUFxQixDQUFBO0FBQ3ZCLENBQUMsRUFWSSw0QkFBNEIsS0FBNUIsNEJBQTRCLFFBVWhDO0FBOEJEOzsrRUFFK0U7QUFFL0UsTUFBYSxpQkFBaUI7SUF3QjVCLFlBQW1CLEtBQTZCOzs7Ozs7K0NBeEJyQyxpQkFBaUI7Ozs7UUF5QjFCLGlCQUFpQjtRQUNqQixJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBRTFCLHlEQUF5RDtRQUN6RCw2QkFBNkI7UUFDN0IseURBQXlEO1FBQ3pELElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDLHdCQUF3QixDQUFDO1FBQy9ELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUM7UUFDL0MsSUFBSSxDQUFDLHdCQUF3QixHQUFHLEtBQUssQ0FBQyx3QkFBd0IsQ0FBQztLQUNoRTtJQUVPLGFBQWEsQ0FBQyxLQUE2QjtRQUNqRCxJQUFJLEtBQUssQ0FBQyxVQUFVLENBQUMsT0FBTyxLQUFLLFlBQVksRUFBRSxDQUFDO1lBQzlDLE1BQU0sSUFBSSxvQ0FBZSxDQUFDLGlFQUFpRSxDQUFDLENBQUM7UUFDL0YsQ0FBQztLQUNGO0lBRUQ7Ozs7T0FJRztJQUNJLE9BQU87UUFDWixPQUFPO1lBQ0wsZUFBZSxFQUFFO2dCQUNmLFFBQVEsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLFFBQVE7YUFDbkM7WUFDRCx3QkFBd0IsRUFBRSxJQUFJLENBQUMsd0JBQXdCO1lBQ3ZELGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7WUFDdkMsd0JBQXdCLEVBQUUsSUFBSSxDQUFDLHdCQUF3QixDQUFDLENBQUMsQ0FBQyw0QkFBNEIsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDLDRCQUE0QixDQUFDLFFBQVE7U0FDL0ksQ0FBQztLQUNIO0lBRUQ7Ozs7T0FJRztJQUNJLEtBQUssQ0FBQyxPQUFtQjtRQUM5QixNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUNwRCxNQUFNLGFBQWEsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7UUFDeEUsT0FBTyxhQUFhLENBQUM7S0FDdEI7O0FBcEVILDhDQXFFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENmbkFnZW50IH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWJlZHJvY2snO1xuaW1wb3J0IHsgSUdyYW50YWJsZSwgR3JhbnQgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCB7IElBZ2VudEFsaWFzIH0gZnJvbSAnLi9hZ2VudC1hbGlhcyc7XG5pbXBvcnQgeyBWYWxpZGF0aW9uRXJyb3IgfSBmcm9tICcuL3ZhbGlkYXRpb24taGVscGVycyc7XG5cbi8qKlxuICogRW51bSBmb3IgY29sbGFib3JhdG9yJ3MgcmVsYXkgY29udmVyc2F0aW9uIGhpc3RvcnkgdHlwZXMuXG4gKi9cbmV4cG9ydCBlbnVtIEFnZW50Q29sbGFib3JhdG9yVHlwZSB7XG4gIC8qKlxuICAgKiBTdXBlcnZpc29yIGFnZW50LlxuICAgKi9cbiAgU1VQRVJWSVNPUiA9ICdTVVBFUlZJU09SJyxcblxuICAvKipcbiAgICogRGlzYWJsaW5nIGNvbGxhYm9yYXRpb24uXG4gICAqL1xuICBESVNBQkxFRCA9ICdESVNBQkxFRCcsXG5cbiAgLyoqXG4gICAqIFN1cGVydmlzb3Igcm91dGVyLlxuICAgKi9cbiAgU1VQRVJWSVNPUl9ST1VURVIgPSAnU1VQRVJWSVNPUl9ST1VURVInLFxufVxuXG4vKipcbiAqIEVudW0gZm9yIGNvbGxhYm9yYXRvcidzIHJlbGF5IGNvbnZlcnNhdGlvbiBoaXN0b3J5IHR5cGVzLlxuICogQGludGVybmFsXG4gKi9cbmVudW0gUmVsYXlDb252ZXJzYXRpb25IaXN0b3J5VHlwZSB7XG4gIC8qKlxuICAgKiBTZW5kaW5nIHRvIHRoZSBjb2xsYWJvcmF0b3IuXG4gICAqL1xuICBUT19DT0xMQUJPUkFUT1IgPSAnVE9fQ09MTEFCT1JBVE9SJyxcblxuICAvKipcbiAgICogRGlzYWJsaW5nIHJlbGF5IG9mIGNvbnZlcnNhdGlvbiBoaXN0b3J5IHRvIHRoZSBjb2xsYWJvcmF0b3IuXG4gICAqL1xuICBESVNBQkxFRCA9ICdESVNBQkxFRCcsXG59XG5cbi8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKipcbiAqICAgICAgICAgICAgICAgICAgICBQUk9QUyAtIEFnZW50IENvbGxhYm9yYXRvciBDbGFzc1xuICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqL1xuZXhwb3J0IGludGVyZmFjZSBBZ2VudENvbGxhYm9yYXRvclByb3BzIHtcbiAgLyoqXG4gICAqIERlc2NyaXB0b3IgZm9yIHRoZSBjb2xsYWJvcmF0aW5nIGFnZW50LlxuICAgKiBUaGlzIGNhbm5vdCBiZSB0aGUgVFNUQUxJQVNJRCAoYGFnZW50LnRlc3RBbGlhc2ApLlxuICAgKi9cbiAgcmVhZG9ubHkgYWdlbnRBbGlhczogSUFnZW50QWxpYXM7XG5cbiAgLyoqXG4gICAqIEluc3RydWN0aW9ucyBvbiBob3cgdGhpcyBhZ2VudCBzaG91bGQgY29sbGFib3JhdGUgd2l0aCB0aGUgbWFpbiBhZ2VudC5cbiAgICovXG4gIHJlYWRvbmx5IGNvbGxhYm9yYXRpb25JbnN0cnVjdGlvbjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBIGZyaWVuZGx5IG5hbWUgZm9yIHRoZSBjb2xsYWJvcmF0b3IuXG4gICAqL1xuICByZWFkb25seSBjb2xsYWJvcmF0b3JOYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgdG8gcmVsYXkgY29udmVyc2F0aW9uIGhpc3RvcnkgdG8gdGhpcyBjb2xsYWJvcmF0b3IuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdW5kZWZpbmVkICh1c2VzIHNlcnZpY2UgZGVmYXVsdClcbiAgICovXG4gIHJlYWRvbmx5IHJlbGF5Q29udmVyc2F0aW9uSGlzdG9yeT86IGJvb2xlYW47XG59XG5cbi8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKipcbiAqICAgICAgICAgICAgICAgICAgICAgICAgIEFnZW50IENvbGxhYm9yYXRvciBDbGFzc1xuICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqL1xuXG5leHBvcnQgY2xhc3MgQWdlbnRDb2xsYWJvcmF0b3Ige1xuICAvKipcbiAgICogVGhlIGFnZW50IGFsaWFzIHRoYXQgdGhpcyBjb2xsYWJvcmF0b3IgcmVwcmVzZW50cy5cbiAgICogVGhpcyBpcyB0aGUgYWdlbnQgdGhhdCB3aWxsIGJlIGNhbGxlZCB1cG9uIGZvciBjb2xsYWJvcmF0aW9uLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGFnZW50QWxpYXM6IElBZ2VudEFsaWFzO1xuXG4gIC8qKlxuICAgKiBJbnN0cnVjdGlvbnMgb24gaG93IHRoaXMgYWdlbnQgc2hvdWxkIGNvbGxhYm9yYXRlIHdpdGggdGhlIG1haW4gYWdlbnQuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgY29sbGFib3JhdGlvbkluc3RydWN0aW9uOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEEgZnJpZW5kbHkgbmFtZSBmb3IgdGhlIGNvbGxhYm9yYXRvci5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBjb2xsYWJvcmF0b3JOYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgdG8gcmVsYXkgY29udmVyc2F0aW9uIGhpc3RvcnkgdG8gdGhpcyBjb2xsYWJvcmF0b3IuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdW5kZWZpbmVkICh1c2VzIHNlcnZpY2UgZGVmYXVsdClcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSByZWxheUNvbnZlcnNhdGlvbkhpc3Rvcnk/OiBib29sZWFuO1xuXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcihwcm9wczogQWdlbnRDb2xsYWJvcmF0b3JQcm9wcykge1xuICAgIC8vIFZhbGlkYXRlIFByb3BzXG4gICAgdGhpcy52YWxpZGF0ZVByb3BzKHByb3BzKTtcblxuICAgIC8vIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLVxuICAgIC8vIFNldCBhdHRyaWJ1dGVzIG9yIGRlZmF1bHRzXG4gICAgLy8gLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tXG4gICAgdGhpcy5hZ2VudEFsaWFzID0gcHJvcHMuYWdlbnRBbGlhcztcbiAgICB0aGlzLmNvbGxhYm9yYXRpb25JbnN0cnVjdGlvbiA9IHByb3BzLmNvbGxhYm9yYXRpb25JbnN0cnVjdGlvbjtcbiAgICB0aGlzLmNvbGxhYm9yYXRvck5hbWUgPSBwcm9wcy5jb2xsYWJvcmF0b3JOYW1lO1xuICAgIHRoaXMucmVsYXlDb252ZXJzYXRpb25IaXN0b3J5ID0gcHJvcHMucmVsYXlDb252ZXJzYXRpb25IaXN0b3J5O1xuICB9XG5cbiAgcHJpdmF0ZSB2YWxpZGF0ZVByb3BzKHByb3BzOiBBZ2VudENvbGxhYm9yYXRvclByb3BzKSB7XG4gICAgaWYgKHByb3BzLmFnZW50QWxpYXMuYWxpYXNJZCA9PT0gJ1RTVEFMSUFTSUQnKSB7XG4gICAgICB0aHJvdyBuZXcgVmFsaWRhdGlvbkVycm9yKCdBZ2VudCBjYW5ub3QgY29sbGFib3JhdGUgd2l0aCBUU1RBTElBU0lEIGFsaWFzIG9mIGFub3RoZXIgYWdlbnQnKTtcbiAgICB9XG4gIH1cblxuICAvKipcbiAgICogRm9ybWF0IGFzIENGTiBwcm9wZXJ0aWVzXG4gICAqXG4gICAqIEBpbnRlcm5hbCBUaGlzIGlzIGFuIGludGVybmFsIGNvcmUgZnVuY3Rpb24gYW5kIHNob3VsZCBub3QgYmUgY2FsbGVkIGRpcmVjdGx5LlxuICAgKi9cbiAgcHVibGljIF9yZW5kZXIoKTogQ2ZuQWdlbnQuQWdlbnRDb2xsYWJvcmF0b3JQcm9wZXJ0eSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGFnZW50RGVzY3JpcHRvcjoge1xuICAgICAgICBhbGlhc0FybjogdGhpcy5hZ2VudEFsaWFzLmFsaWFzQXJuLFxuICAgICAgfSxcbiAgICAgIGNvbGxhYm9yYXRpb25JbnN0cnVjdGlvbjogdGhpcy5jb2xsYWJvcmF0aW9uSW5zdHJ1Y3Rpb24sXG4gICAgICBjb2xsYWJvcmF0b3JOYW1lOiB0aGlzLmNvbGxhYm9yYXRvck5hbWUsXG4gICAgICByZWxheUNvbnZlcnNhdGlvbkhpc3Rvcnk6IHRoaXMucmVsYXlDb252ZXJzYXRpb25IaXN0b3J5ID8gUmVsYXlDb252ZXJzYXRpb25IaXN0b3J5VHlwZS5UT19DT0xMQUJPUkFUT1IgOiBSZWxheUNvbnZlcnNhdGlvbkhpc3RvcnlUeXBlLkRJU0FCTEVELFxuICAgIH07XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHRoZSBnaXZlbiBpZGVudGl0eSBwZXJtaXNzaW9ucyB0byBjb2xsYWJvcmF0ZSB3aXRoIHRoZSBhZ2VudFxuICAgKiBAcGFyYW0gZ3JhbnRlZSBUaGUgcHJpbmNpcGFsIHRvIGdyYW50IHBlcm1pc3Npb25zIHRvXG4gICAqIEByZXR1cm5zIFRoZSBHcmFudCBvYmplY3RcbiAgICovXG4gIHB1YmxpYyBncmFudChncmFudGVlOiBJR3JhbnRhYmxlKTogR3JhbnQge1xuICAgIGNvbnN0IGdyYW50MSA9IHRoaXMuYWdlbnRBbGlhcy5ncmFudEludm9rZShncmFudGVlKTtcbiAgICBjb25zdCBjb21iaW5lZEdyYW50ID0gZ3JhbnQxLmNvbWJpbmUodGhpcy5hZ2VudEFsaWFzLmdyYW50R2V0KGdyYW50ZWUpKTtcbiAgICByZXR1cm4gY29tYmluZWRHcmFudDtcbiAgfVxufVxuIl19