import * as bedrock from 'aws-cdk-lib/aws-bedrock';
import { IFunction } from 'aws-cdk-lib/aws-lambda';
/**
 * The type of custom control for the action group executor.
 */
export declare enum CustomControl {
    /**
     * Returns the action group invocation results directly in the InvokeAgent response.
     */
    RETURN_CONTROL = "RETURN_CONTROL"
}
/******************************************************************************
 *                         Action Group Executor
 *****************************************************************************/
/**
 * Defines how fulfillment of the action group is handled after the necessary
 * information has been elicited from the user.
 * Valid executors are:
 * - Lambda function
 * - Return Control
 * @see https://docs.aws.amazon.com/bedrock/latest/userguide/action-handle.html
 */
export declare class ActionGroupExecutor {
    /**
     * Returns the action group invocation results directly in the InvokeAgent response.
     * The information and parameters can be sent to your own systems to yield results.
     * @see https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html
     */
    static readonly RETURN_CONTROL: ActionGroupExecutor;
    /**
     * Defines an action group with a Lambda function containing the business logic.
     * @param lambdaFunction - Lambda function to be called by the action group.
     * @see https://docs.aws.amazon.com/bedrock/latest/userguide/agents-lambda.html
     */
    static fromLambda(lambdaFunction: IFunction): ActionGroupExecutor;
    /**
     * The Lambda function that will be called by the action group.
     * Contains the business logic for handling the action group's invocation.
     */
    readonly lambdaFunction?: IFunction;
    /**
     * The custom control type for the action group executor.
     * Currently only supports 'RETURN_CONTROL' which returns results directly in the InvokeAgent response.
     */
    readonly customControl?: CustomControl;
    private constructor();
    /**
     * Format as CFN properties
     *
     * @internal This is an internal core function and should not be called directly.
     */
    _render(): bedrock.CfnAgent.ActionGroupExecutorProperty;
}
