"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionGroupExecutor = exports.CustomControl = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const validation_helpers_1 = require("./validation-helpers");
/**
 * The type of custom control for the action group executor.
 */
var CustomControl;
(function (CustomControl) {
    /**
     * Returns the action group invocation results directly in the InvokeAgent response.
     */
    CustomControl["RETURN_CONTROL"] = "RETURN_CONTROL";
})(CustomControl || (exports.CustomControl = CustomControl = {}));
/******************************************************************************
 *                         Action Group Executor
 *****************************************************************************/
/**
 * Defines how fulfillment of the action group is handled after the necessary
 * information has been elicited from the user.
 * Valid executors are:
 * - Lambda function
 * - Return Control
 * @see https://docs.aws.amazon.com/bedrock/latest/userguide/action-handle.html
 */
class ActionGroupExecutor {
    /**
     * Defines an action group with a Lambda function containing the business logic.
     * @param lambdaFunction - Lambda function to be called by the action group.
     * @see https://docs.aws.amazon.com/bedrock/latest/userguide/agents-lambda.html
     */
    static fromLambda(lambdaFunction) {
        return new ActionGroupExecutor(lambdaFunction, undefined);
    }
    constructor(lambdaFunction, customControl) {
        if (lambdaFunction && customControl) {
            throw new validation_helpers_1.ValidationError('ActionGroupExecutor cannot have both lambdaFunction and customControl defined - they are mutually exclusive.');
        }
        this.lambdaFunction = lambdaFunction;
        this.customControl = customControl;
    }
    /**
     * Format as CFN properties
     *
     * @internal This is an internal core function and should not be called directly.
     */
    _render() {
        return {
            customControl: this.customControl,
            lambda: this.lambdaFunction?.functionArn,
        };
    }
}
exports.ActionGroupExecutor = ActionGroupExecutor;
_a = JSII_RTTI_SYMBOL_1;
ActionGroupExecutor[_a] = { fqn: "@aws-cdk/aws-bedrock-alpha.ActionGroupExecutor", version: "2.206.0-alpha.0" };
/**
 * Returns the action group invocation results directly in the InvokeAgent response.
 * The information and parameters can be sent to your own systems to yield results.
 * @see https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html
 */
ActionGroupExecutor.RETURN_CONTROL = new ActionGroupExecutor(undefined, CustomControl.RETURN_CONTROL);
//# sourceMappingURL=data:application/json;base64,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